/* ps2mf.h */

typedef struct AFM_info
{
    struct AFM_info * next;
    int AFM_num, TeX_num, width;
    char * AFM_name;
    int bbox_llx, bbox_lly, bbox_urx, bbox_ury;
    struct lig * ligs;
    struct kern * kerns;
    struct pcc * pccs;
    bool in_MF_file;
} AFM_info_tp;
extern struct AFM_info * AFM_chars;

typedef struct configuration_info
{
    struct configuration_info * next;
    int TeX_num;
    char * AFM_name;
    struct lig * ligs;
} configuration_info_tp;
extern struct configuration_info * TeX_configuration;

typedef struct ignore_info
{
    struct ignore_info * next;
    char * AFM_name;
}  ignore_info_tp;
extern struct ignore_info * ignore_list;

typedef struct lig
{
    struct lig * next;
    char * succ, * sub;
} lig_tp;

typedef struct kern
{
    struct kern * next;
    char * succ;
    int delta;
} kern_tp;

typedef struct pcc
{
    struct pcc * next;
    char * part_name;
    int x_offset, y_offset;
} pcc_tp;

extern FILE * ps_file, * afm_file, * mf_file, * conf_file;
extern char font_name [255], coding_scheme [255];
extern float italic_angle;
extern bool fixed_pitch;
extern int x_height, font_space, font_quad;
extern bool x_height_is_defined;
extern float x_scale, y_scale;

int find_TeX_num __P((char * p));
FILE * my_open __P((char * name, char * extension, char * mode));
void parse_AFM __P((void));
void parse_PS __P((void));
void parse_config __P((void));
void process_ligatures_and_kerns __P((void));
void postamble __P((void));
void preamble __P((int argc, char ** argv));
void test_AFM_info __P((void));

#ifdef HAVE_NO_STRSTR
char * strstr __P((char * s, char * find));
#   endif
#ifdef HAVE_NO_ALLOCA
char * alloca __P((unsigned size));
#   endif
