/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.MathLibKt;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0019\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0016\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a8\u0006!"}, d2={"Lorg/luaj/vm2/lib/MathLib;", "Lorg/luaj/vm2/lib/TwoArgFunction;", "()V", "call", "Lorg/luaj/vm2/LuaValue;", "modname", "env", "dpow_lib", "", "a", "b", "BinaryOp", "Companion", "UnaryOp", "abs", "ceil", "cos", "deg", "exp", "floor", "fmod", "frexp", "ldexp", "max", "min", "modf", "pow", "rad", "random", "randomseed", "sin", "sqrt", "tan", "luak"})
public class MathLib
extends TwoArgFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MathLib() {
        Companion.setMATHLIB(this);
    }

    @Override
    @NotNull
    public LuaValue call(@NotNull LuaValue modname, @NotNull LuaValue env) {
        LuaTable math = new LuaTable(0, 30);
        math.set("abs", (LuaValue)new abs());
        math.set("ceil", (LuaValue)new ceil());
        math.set("cos", (LuaValue)new cos());
        math.set("deg", (LuaValue)new deg());
        math.set("exp", (LuaValue)new exp(this));
        math.set("floor", (LuaValue)new floor());
        math.set("fmod", (LuaValue)new fmod());
        math.set("frexp", (LuaValue)new frexp());
        math.set("huge", (LuaValue)LuaDouble.POSINF);
        math.set("ldexp", (LuaValue)new ldexp());
        math.set("max", (LuaValue)new max());
        math.set("min", (LuaValue)new min());
        math.set("modf", (LuaValue)new modf());
        math.set("pi", Math.PI);
        math.set("pow", (LuaValue)new pow());
        random r = new random();
        math.set("random", (LuaValue)r);
        math.set("randomseed", (LuaValue)new randomseed(r));
        math.set("rad", (LuaValue)new rad());
        math.set("sin", (LuaValue)new sin());
        math.set("sqrt", (LuaValue)new sqrt());
        math.set("tan", (LuaValue)new tan());
        env.set("math", (LuaValue)math);
        env.get("package").get("loaded").set("math", (LuaValue)math);
        return math;
    }

    public double dpow_lib(double a, double b) {
        return Companion.dpow_default(a, b);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H$J\u0010\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "Lorg/luaj/vm2/lib/OneArgFunction;", "()V", "call", "", "d", "Lorg/luaj/vm2/LuaValue;", "arg", "luak"})
    public static abstract class UnaryOp
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            return LuaValue.Companion.valueOf(this.call(arg.checkdouble()));
        }

        protected abstract double call(double var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H$J\u0018\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/luaj/vm2/lib/MathLib$BinaryOp;", "Lorg/luaj/vm2/lib/TwoArgFunction;", "()V", "call", "", "x", "y", "Lorg/luaj/vm2/LuaValue;", "luak"})
    public static abstract class BinaryOp
    extends TwoArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue x, @NotNull LuaValue y) {
            return LuaValue.Companion.valueOf(this.call(x.checkdouble(), y.checkdouble()));
        }

        protected abstract double call(double var1, double var3);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$abs;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class abs
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return Math.abs(d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$ceil;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class ceil
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return Math.ceil(d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$cos;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class cos
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return Math.cos(d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$deg;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class deg
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return d * 180.0 / Math.PI;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$floor;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class floor
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return Math.floor(d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$rad;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class rad
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return d / 180.0 * Math.PI;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$sin;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class sin
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return Math.sin(d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$sqrt;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class sqrt
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return Math.sqrt(d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$tan;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "()V", "call", "", "d", "luak"})
    public static final class tan
    extends UnaryOp {
        @Override
        protected double call(double d) {
            return Math.tan(d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/luaj/vm2/lib/MathLib$exp;", "Lorg/luaj/vm2/lib/MathLib$UnaryOp;", "mathlib", "Lorg/luaj/vm2/lib/MathLib;", "(Lorg/luaj/vm2/lib/MathLib;)V", "getMathlib", "()Lorg/luaj/vm2/lib/MathLib;", "call", "", "d", "luak"})
    public static final class exp
    extends UnaryOp {
        @NotNull
        private final MathLib mathlib;

        public exp(@NotNull MathLib mathlib) {
            this.mathlib = mathlib;
        }

        @NotNull
        public final MathLib getMathlib() {
            return this.mathlib;
        }

        @Override
        protected double call(double d) {
            return this.mathlib.dpow_lib(Math.E, d);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/luaj/vm2/lib/MathLib$fmod;", "Lorg/luaj/vm2/lib/MathLib$BinaryOp;", "()V", "call", "", "x", "y", "luak"})
    public static final class fmod
    extends BinaryOp {
        @Override
        protected double call(double x, double y) {
            double q = x / y;
            return x - y * (q >= 0.0 ? Math.floor(q) : Math.ceil(q));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/luaj/vm2/lib/MathLib$ldexp;", "Lorg/luaj/vm2/lib/MathLib$BinaryOp;", "()V", "call", "", "x", "y", "luak"})
    public static final class ldexp
    extends BinaryOp {
        @Override
        protected double call(double x, double y) {
            return x * Double.longBitsToDouble((long)y + (long)1023 << 52);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/luaj/vm2/lib/MathLib$pow;", "Lorg/luaj/vm2/lib/MathLib$BinaryOp;", "()V", "call", "", "x", "y", "luak"})
    public static final class pow
    extends BinaryOp {
        @Override
        protected double call(double x, double y) {
            return Companion.dpow_default(x, y);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$frexp;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class frexp
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            double x = args.checkdouble(1);
            if (x == 0.0) {
                return LuaValue.Companion.varargsOf(LuaValue.Companion.getZERO(), (Varargs)LuaValue.Companion.getZERO());
            }
            long bits = Double.doubleToRawLongBits(x);
            double m = (double)((bits & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (bits >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
            double e = ((int)(bits >> 52) & 0x7FF) - 1022;
            return LuaValue.Companion.varargsOf(LuaValue.Companion.valueOf(m), (Varargs)LuaValue.Companion.valueOf(e));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$max;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class max
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            double m = args.checkdouble(1);
            int n = args.narg();
            for (int i = 2; i <= n; ++i) {
                m = Math.max(m, args.checkdouble(i));
            }
            return LuaValue.Companion.valueOf(m);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$min;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class min
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            double m = args.checkdouble(1);
            int n = args.narg();
            for (int i = 2; i <= n; ++i) {
                m = Math.min(m, args.checkdouble(i));
            }
            return LuaValue.Companion.valueOf(m);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\u0006"}, d2={"Lorg/luaj/vm2/lib/MathLib$modf;", "Lorg/luaj/vm2/lib/VarArgFunction;", "()V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public static final class modf
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            double x = args.checkdouble(1);
            double intPart = x > 0.0 ? Math.floor(x) : Math.ceil(x);
            double fracPart = x - intPart;
            return LuaValue.Companion.varargsOf(LuaValue.Companion.valueOf(intPart), (Varargs)LuaValue.Companion.valueOf(fracPart));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/luaj/vm2/lib/MathLib$random;", "Lorg/luaj/vm2/lib/LibFunction;", "()V", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "setRandom", "(Lkotlin/random/Random;)V", "call", "Lorg/luaj/vm2/LuaValue;", "a", "b", "luak"})
    public static final class random
    extends LibFunction {
        @NotNull
        private Random random = Random.Default;

        @NotNull
        public final Random getRandom() {
            return this.random;
        }

        public final void setRandom(@NotNull Random random2) {
            this.random = random2;
        }

        @Override
        @NotNull
        public LuaValue call() {
            return LuaValue.Companion.valueOf(this.random.nextDouble());
        }

        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue a) {
            int m = a.checkint();
            if (m < 1) {
                LuaValue.Companion.argerror(1, "interval is empty");
                throw new KotlinNothingValueException();
            }
            return LuaValue.Companion.valueOf(1 + this.random.nextInt(m));
        }

        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue a, @NotNull LuaValue b) {
            int m = a.checkint();
            int n = b.checkint();
            if (n < m) {
                LuaValue.Companion.argerror(2, "interval is empty");
                throw new KotlinNothingValueException();
            }
            return LuaValue.Companion.valueOf(m + this.random.nextInt(n + 1 - m));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/luaj/vm2/lib/MathLib$randomseed;", "Lorg/luaj/vm2/lib/OneArgFunction;", "random", "Lorg/luaj/vm2/lib/MathLib$random;", "(Lorg/luaj/vm2/lib/MathLib$random;)V", "getRandom", "()Lorg/luaj/vm2/lib/MathLib$random;", "call", "Lorg/luaj/vm2/LuaValue;", "arg", "luak"})
    public static final class randomseed
    extends OneArgFunction {
        @NotNull
        private final random random;

        public randomseed(@NotNull random random2) {
            this.random = random2;
        }

        @NotNull
        public final random getRandom() {
            return this.random;
        }

        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            long seed = arg.checklong();
            this.random.setRandom(RandomKt.Random(seed));
            return LuaValue.Companion.getNONE();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0004R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/luaj/vm2/lib/MathLib$Companion;", "", "()V", "value", "Lorg/luaj/vm2/lib/MathLib;", "MATHLIB", "getMATHLIB", "()Lorg/luaj/vm2/lib/MathLib;", "setMATHLIB", "(Lorg/luaj/vm2/lib/MathLib;)V", "dpow", "Lorg/luaj/vm2/LuaValue;", "a", "", "b", "dpow_d", "dpow_default", "luak"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MathLib getMATHLIB() {
            return MathLibKt.access$getMathLib_MATHLIB$p();
        }

        public final void setMATHLIB(@Nullable MathLib value) {
            MathLibKt.access$setMathLib_MATHLIB$p(value);
        }

        @NotNull
        public final LuaValue dpow(double a, double b) {
            double d;
            if (this.getMATHLIB() != null) {
                MathLib mathLib = this.getMATHLIB();
                Intrinsics.checkNotNull(mathLib);
                d = mathLib.dpow_lib(a, b);
            } else {
                d = this.dpow_default(a, b);
            }
            return LuaDouble.Companion.valueOf2(d);
        }

        public final double dpow_d(double a, double b) {
            double d;
            if (this.getMATHLIB() != null) {
                MathLib mathLib = this.getMATHLIB();
                Intrinsics.checkNotNull(mathLib);
                d = mathLib.dpow_lib(a, b);
            } else {
                d = this.dpow_default(a, b);
            }
            return d;
        }

        protected final double dpow_default(double a, double b) {
            double a2 = a;
            double b2 = 0.0;
            b2 = b;
            if (b2 < 0.0) {
                return 1.0 / this.dpow_default(a2, -b2);
            }
            double p = 1.0;
            int whole = 0;
            whole = (int)b2;
            double v = a2;
            while (whole > 0) {
                if ((whole & 1) != 0) {
                    p *= v;
                }
                whole >>= 1;
                v *= v;
            }
            Companion $this$dpow_default_u24lambda_u240 = this;
            boolean bl = false;
            b2 -= (double)whole;
            if (b2 > 0.0) {
                int frac = (int)((double)65536 * b2);
                while ((frac & 0xFFFF) != 0) {
                    a2 = Math.sqrt(a2);
                    if ((frac & 0x8000) != 0) {
                        p *= a2;
                    }
                    frac <<= 1;
                }
            }
            return p;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

