/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.lpdg.datastructure;

import ch.bfh.lpdg.datastructure.DependencyType;
import java.util.ArrayList;
import java.util.List;

public class Dependency {
    public boolean IsUnused;
    public String Source;
    private DependencyType type;
    private String name;
    private List<Dependency> dependencyList;

    public Dependency(DependencyType type, String name, String source) {
        this.type = type;
        this.name = name;
        this.dependencyList = new ArrayList<Dependency>();
        this.Source = source;
    }

    public String toString() {
        return this.print(0);
    }

    private String print(int numTabs) {
        StringBuilder s = new StringBuilder(this.name + " (" + this.type.toString() + ")\n");
        for (Dependency d : this.dependencyList) {
            s.append("\t".repeat(numTabs + 1)).append(d.print(numTabs + 1));
        }
        return s.toString();
    }

    public String toLaTeXString() {
        return this.appendLine(0);
    }

    private String appendLine(int numTabs) {
        StringBuilder s = new StringBuilder(this.name + " (" + this.type.toString() + ")\n");
        for (Dependency d : this.dependencyList) {
            s.append("\t".repeat(numTabs + 1)).append(d.appendLine(numTabs + 1));
        }
        return s.toString();
    }

    public String toGraphString() {
        StringBuilder s = new StringBuilder();
        for (Dependency d : this.dependencyList) {
            String newStr = this.name.replace("\\", "").replace("@", "").replace(".", "").replace("-", "").replace("/", "");
            String newStrDep = d.name.replace("\\", "").replace("@", "").replace(".", "").replace("-", "").replace("/", "");
            s.append(newStr).append(" -> ").append(newStrDep).append(";\n");
            s.append(d.toGraphString());
        }
        return s.toString();
    }

    public boolean isIsUnused() {
        return this.IsUnused;
    }

    public String getSource() {
        return this.Source;
    }

    public DependencyType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<Dependency> getDependencyList() {
        return this.dependencyList;
    }

    public void setIsUnused(boolean IsUnused) {
        this.IsUnused = IsUnused;
    }

    public void setSource(String Source2) {
        this.Source = Source2;
    }

    public void setType(DependencyType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDependencyList(List<Dependency> dependencyList) {
        this.dependencyList = dependencyList;
    }
}

