/*
ͻ
 What's it called: EPMTeX-Keys v3.1   (texkeys.e)                           
                                                                            
 What does it do:  Defines the TeX keysets and syntax assist procedures.    
                   (linked in automatically by tex.e)                       
                                                                            
 Who and When:     Jo Koenen 7/94                                           
                   Jon Hacker 8/95                                          
                                                                            
ͼ
*/

/*
Ŀ
  Tex keysets are loaded during defload and defselect                       
  We put the keys statement in the defload/defselect so that we can check   
  to make sure it is a TeX file before we load the keyset.                  

*/
defproc setTeXKeySets
    universal tex_file_types,
              tex_debug,
              app_hini

    tex_userfiletypes = queryprofile( app_hini, 'EPMTeX', 'TEX_USERFILETYPES')
    tex_file_types= 'TEX STY LOG AUX '||translate(tex_userfiletypes)
    ext = filetype()
    if pos(leftstr(ext,3), tex_file_types) <> 0 then  -- if TeX file then

-- Load in activated keyset combo
        tex_syntax_enable = queryprofile( app_hini, 'EPMTeX', 'TEX_SYNTAXENABLE')
        tex_accelkeys = queryprofile( app_hini, 'EPMTeX', 'TEX_ACCELKEYS')
        tex_quickkeys = queryprofile( app_hini, 'EPMTeX', 'TEX_QUICKKEYS')

        tex_keyset = 100*tex_syntax_enable + 10*tex_accelkeys + tex_quickkeys

        if (tex_keyset = 100) then
            if translate(.keyset) <> 'TEXKEYSS' then keys TeXKeysS endif
            if tex_debug > 1 then sayerror'loaded texKeysS' endif
        elseif (tex_keyset = 110) then
            if translate(.keyset) <> 'TEXKEYSSA' then keys TeXKeysSA endif
            if tex_debug > 1 then sayerror'loaded texKeysSA' endif
        elseif (tex_keyset = 101) then
            if translate(.keyset) <> 'TEXKEYSSQ' then keys TeXKeysSQ endif
            if tex_debug > 1 then sayerror'loaded texKeysSQ' endif
        elseif (tex_keyset = 111) then
            if translate(.keyset) <> 'TEXKEYSSAQ' then keys TeXKeysSAQ endif
            if tex_debug > 1 then sayerror'loaded texKeysSAQ' endif
        elseif (tex_keyset = 001) then
            if translate(.keyset) <> 'TEXKEYSQ' then keys TeXKeysQ endif
            if tex_debug > 1 then sayerror'loaded texKeysQ' endif
        endif

    endif  -- TeX file loaded

/*
Ŀ
  Define the TeX syntax assist key set combos                               

*/

defkeys texKeysS
    define TEXQUICKKEYS = 'NO'
    define TEXSYNTAXASSIST = 'YES'
    define TEXACCELKEYS = 'NO'
    include 'texdefs.e'

defkeys texKeysSA
    define TEXQUICKKEYS = 'NO'
    define TEXSYNTAXASSIST = 'YES'
    define TEXACCELKEYS = 'YES'
    include 'texdefs.e'

defkeys texKeysSQ
    define TEXQUICKKEYS = 'YES'
    define TEXSYNTAXASSIST = 'YES'
    define TEXACCELKEYS = 'NO'
    include 'texdefs.e'

defkeys texKeysSAQ
    define TEXQUICKKEYS = 'YES'
    define TEXSYNTAXASSIST = 'YES'
    define TEXACCELKEYS = 'YES'
    include 'texdefs.e'

defkeys texKeysQ
    define TEXQUICKKEYS = 'YES'
    define TEXSYNTAXASSIST = 'NO'
    define TEXACCELKEYS = 'NO'
    include 'texdefs.e'



/*
ͻ
 TeX syntax assist procedure definitions.                                   
                                                                            
 What does it do:  The enter and space bar keys have been defined to have   
                   specific TeX editing features in this keyset.            
                                                                            
ͼ
*/


/*
Ŀ
  Define first TeX syntax expansion procedure for spacebar and enter        
    -- returns 1 if expansion performed                                     

*/
  defproc tex_first_expansion
    retc=1   -- default return code
  compile if EVERSION >= 5
    if .line then  -- current line number
  compile else
    if .line and (not command_state()) then
  compile endif
      getline line
      line=strip(line,'T') -- remove trailing spaces
      line_l=substr(line,1,.col-1) -- split line into two parts at cursor
      line_r=substr(line,.col)
      linelen=length(line_l)
      if linelen > 2 then
        wrd=substr(line_l,.col-3,3)
      else
        wrd=line_l
      endif
-- expand begin
      if wrd='\be' then
        replaceline line_l'gin{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+4
-- expand item
      elseif wrd='\it' then
        replaceline line_l'em 'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+3
-- expand cite
      elseif wrd='\ci' then
        replaceline line_l'te{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+3  -- reposition cursor
-- future expansions added here
      else  -- wrd =
        retc=0  -- didn't match wrd, no expansion performed
      endif
    else   -- .line  at top of file, abort expansion
      retc=0
    endif  -- .line = 0
  return retc

/*
Ŀ
  Define second TeX syntax expansion procedure for spacebar and enter       
    -- returns 1 if expansion performed                                     

*/
  defproc tex_second_expansion
    retc=1  -- default return value
    if .line then
      getline lin
      if (.col - 19) < 0 then
        b=1
      else
        b=.col-19+1
      endif
      line=substr(lin,b,.col-b+1)  -- get last 19 chars from line end
      parse value line with '\'wrd'{'texword'}'
-- add \end if find \begin keyword
      if wrd='begin' then
        if texword='tabular' then
          line_l=substr(lin,1,.col)
          line_r=substr(lin,.col+1)
          replaceline line_l'{|c|}'line_r
        endif
        insertline '\end{'texword'}',.line+1
        call einsert_line()  -- position cursor on a new line following \end
      else
        retc=0
      endif  -- wrd =
    else  -- .line =
      retc=0
    endif -- .line =
  return retc




