/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.XStore;
import edu.mit.broad.xbench.core.api.XStores;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaAppConf;
import xapps.gsea.GseaFileFilter;

public class FileManager {
    private static final Logger klog = LoggerFactory.getLogger(FileManager.class);
    private static final GseaFileFilter expressionFileFilter = new GseaFileFilter(new String[]{"gct", "res", "rnk", "txt"}, "Expression File");
    private XStore fRecentFilesStore_as_files;
    private XStore fRecentUrlsStore;
    private XStore fRecentDirsStore;
    private FileDialog fMacDirFileDialog;
    private JFileChooser fDirFileChooser;
    private FileDialog fLoadDataBrowseForFilesDialog;
    private FileDialog fEnrichmentMapFileDialog;
    private FileDialog fHeatMapSaveDatasetFileDialog;
    private FileDialog fHeatMapSaveJpgFileDialog;
    private FileDialog fHeatMapSavePngFileDialog;
    private FileDialog fHeatMapSaveSvgFileDialog;
    private FileDialog fSetAnnotatorFileDialog;

    public FileManager() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.fMacDirFileDialog = new FileDialog((Frame)Application.getWindowManager().getRootFrame(), "Open", 0);
        } else {
            this.fDirFileChooser = new JFileChooser();
            this.fDirFileChooser.setApproveButtonText("Select");
            this.fDirFileChooser.setFileSelectionMode(1);
            this.fDirFileChooser.setMultiSelectionEnabled(false);
            this.fDirFileChooser.setFileHidingEnabled(true);
        }
        this.fLoadDataBrowseForFilesDialog = new FileDialog((Frame)Application.getWindowManager().getRootFrame(), "Open", 0);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.fLoadDataBrowseForFilesDialog.setFile("*.res;*.gct;*.pcl;*.txt;*.grp;*.gmx;*.gmt;*.cls;*.rnk;*.chip;*.xml");
        }
        this.fLoadDataBrowseForFilesDialog.setFilenameFilter(GseaAppConf.createGseaFileFilter());
        this.fLoadDataBrowseForFilesDialog.setMultipleMode(true);
        this.fLoadDataBrowseForFilesDialog.setModal(true);
        this.fEnrichmentMapFileDialog = new FileDialog((Frame)Application.getWindowManager().getRootFrame(), "Open", 0);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.fEnrichmentMapFileDialog.setFile("*.gct;*.res;*.rnk;*.txt");
        }
        this.fEnrichmentMapFileDialog.setMultipleMode(false);
        this.fEnrichmentMapFileDialog.setModal(true);
        this.fEnrichmentMapFileDialog.setFilenameFilter(expressionFileFilter);
        this.fHeatMapSaveDatasetFileDialog = new FileDialog((Frame)Application.getWindowManager().getRootFrame(), "Save as expression file", 1);
        this.fHeatMapSaveDatasetFileDialog.setFilenameFilter(new GseaFileFilter(new String[]{"gct", "res", "txt"}, "Expression Files"));
        this.fHeatMapSaveJpgFileDialog = this.buildHeatMapSaveImageFileDialog("jpeg", "jpg");
        this.fHeatMapSavePngFileDialog = this.buildHeatMapSaveImageFileDialog("png");
        this.fHeatMapSaveSvgFileDialog = this.buildHeatMapSaveImageFileDialog("svg");
        this.fSetAnnotatorFileDialog = new FileDialog((Frame)Application.getWindowManager().getRootFrame(), "Set Annotator", 0);
        ParserFactory.getCache().addPathAdditionsListener(new MyPropertyChangeListener());
    }

    public FileDialog buildHeatMapSaveImageFileDialog(String ... formats) {
        FileDialog fileDialog = new FileDialog((Frame)Application.getWindowManager().getRootFrame(), "Save as " + formats[0], 1);
        fileDialog.setFilenameFilter(new GseaFileFilter(formats, formats[0] + " image files"));
        return fileDialog;
    }

    public void registerRecentlyOpenedDir(File dir) {
        XStore xstore;
        if (dir != null && dir.isDirectory() && dir.exists() && !(xstore = this.getRecentDirsStore()).contains(dir.getPath())) {
            xstore.addAndSave(dir.getPath());
        }
    }

    public void registerRecentlyOpenedFile(File file) {
        this.getRecentFilesStore().addAndSave(file.getPath());
    }

    public void registerRecentlyOpenedURL(String url) {
        this.getRecentUrlsStore().addAndSave(url);
    }

    private File getLastDirAccesessed() {
        XStore xs = this.getRecentDirsStore();
        if (xs.getSize() == 0) {
            return null;
        }
        String str = xs.getElementAt(xs.getSize() - 1);
        if (str != null) {
            return new File(str);
        }
        return null;
    }

    public FileDialog getLoadDataBrowseForFilesDialog() throws HeadlessException {
        return this.fLoadDataBrowseForFilesDialog;
    }

    public FileDialog getEnrichmentMapFileDialog() {
        return this.fEnrichmentMapFileDialog;
    }

    public FileDialog getHeatMapSaveDatasetFileDialog() {
        return this.fHeatMapSaveDatasetFileDialog;
    }

    public FileDialog getHeatMapSaveJpgFileDialog() {
        return this.fHeatMapSaveJpgFileDialog;
    }

    public FileDialog getHeatMapSavePngFileDialog() {
        return this.fHeatMapSavePngFileDialog;
    }

    public FileDialog getHeatMapSaveSvgFileDialog() {
        return this.fHeatMapSaveSvgFileDialog;
    }

    public FileDialog getSetAnnotatorFileDialog() {
        return this.fSetAnnotatorFileDialog;
    }

    public File chooseDirByDialog(String selectedDir) {
        if (StringUtils.isBlank((CharSequence)selectedDir)) {
            selectedDir = this.getLastDirAccesessed().getAbsolutePath();
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            this.fMacDirFileDialog.setDirectory(selectedDir);
            this.fMacDirFileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            File[] selection = this.fMacDirFileDialog.getFiles();
            if (selection != null && selection.length > 0) {
                this.registerRecentlyOpenedDir(selection[0]);
                return selection[0];
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        } else {
            this.fDirFileChooser.setCurrentDirectory(new File(selectedDir));
            if (this.fDirFileChooser.showOpenDialog(Application.getWindowManager().getRootFrame()) == 0) {
                File selectedFile = this.fDirFileChooser.getSelectedFile();
                this.registerRecentlyOpenedDir(selectedFile);
                return selectedFile;
            }
        }
        return null;
    }

    public XStore getRecentFilesStore() {
        if (this.fRecentFilesStore_as_files == null) {
            this.fRecentFilesStore_as_files = new XStores.FilePathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_files.txt"));
            try {
                ArrayList<String> rems = new ArrayList<String>();
                for (int i = 0; i < this.fRecentFilesStore_as_files.getSize(); ++i) {
                    String filePath = this.fRecentFilesStore_as_files.getElementAt(i);
                    File f = new File(filePath);
                    if (f.exists()) continue;
                    rems.add(filePath);
                }
                this.fRecentFilesStore_as_files.removeAndSave(rems);
                this.fRecentFilesStore_as_files.trim(30);
            }
            catch (Throwable t) {
                t.printStackTrace();
                klog.error("Recent file list initing error: {}", t);
            }
        }
        return this.fRecentFilesStore_as_files;
    }

    private XStore getRecentDirsStore() {
        if (this.fRecentDirsStore == null) {
            this.fRecentDirsStore = new XStores.DirPathStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_dirs.txt"));
            this.fRecentDirsStore.trim(50);
        }
        return this.fRecentDirsStore;
    }

    public XStore getRecentUrlsStore() {
        if (this.fRecentUrlsStore == null) {
            this.fRecentUrlsStore = new XStores.StringStore(new File(Application.getVdbManager().getRuntimeHomeDir(), "recent_urls.txt"));
            this.fRecentUrlsStore.trim(50);
        }
        return this.fRecentUrlsStore;
    }

    class MyPropertyChangeListener
    implements PropertyChangeListener {
        MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object obj;
            if (evt.getPropertyName().equals("path_added") && (obj = evt.getNewValue()) != null) {
                File f = new File(obj.toString());
                Application.getFileManager().registerRecentlyOpenedFile(f);
            }
        }
    }
}

