/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Collection;
import java.util.TreeMap;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Concatenation
extends AbstractObjectCalculation {
    private static final long serialVersionUID = -2428322597419645314L;
    private long[] positions = null;
    private long[] size = Coordinates.ZERO2D;
    private ValueType valueType = null;

    public Concatenation(int dimension, Matrix ... matrices) {
        super(dimension, matrices);
        Matrix m0;
        int i;
        for (i = 0; i < matrices.length - 1; ++i) {
            m0 = matrices[i];
            Matrix m1 = matrices[i + 1];
            VerifyUtil.verifyNotNull(m0, "matrix is null");
            VerifyUtil.verifyNotNull(m1, "matrix is null");
            VerifyUtil.verifyEquals(m0.getDimensionCount(), m1.getDimensionCount(), "matrices have different dimensionality");
        }
        if (dimension > matrices[0].getDimensionCount() + 1) {
            throw new IllegalArgumentException("too many dimensions");
        }
        if (dimension > matrices[0].getDimensionCount()) {
            long[] oldSize = matrices[0].getSize();
            long[] newSize = new long[oldSize.length + 1];
            System.arraycopy(oldSize, 0, newSize, 0, oldSize.length);
            newSize[newSize.length - 1] = 1L;
            for (int i2 = 0; i2 < matrices.length; ++i2) {
                matrices[i2] = matrices[i2].reshape(Calculation.Ret.LINK, newSize);
            }
        }
        for (i = 0; i < matrices.length - 1; ++i) {
            m0 = matrices[i];
            Matrix m1 = matrices[i + 1];
            long[] s0 = m0.getSize();
            long[] s1 = Coordinates.copyOf(m1.getSize());
            if (Coordinates.allEquals(s0, 0L) || Coordinates.allEquals(s1, 0L)) continue;
            s1[dimension] = s0[dimension];
            VerifyUtil.verifyEquals(s0, s1, "matrices have different sizes");
        }
        this.valueType = matrices[0].getValueType();
        this.positions = new long[matrices.length];
        long pos = 0L;
        for (int i3 = 0; i3 < matrices.length; ++i3) {
            Matrix m = matrices[i3];
            if (!this.valueType.equals((Object)m.getValueType())) {
                this.valueType = ValueType.OBJECT;
            }
            this.positions[i3] = pos;
            pos += m.getSize(dimension);
            this.size = Coordinates.max(this.size, m.getSize());
        }
        this.size[dimension] = pos;
        if (matrices[0].getLabelObject() != null) {
            DefaultMapMatrix<String, Object> annotation = new DefaultMapMatrix<String, Object>(new TreeMap());
            this.setMetaData(annotation);
            annotation.put("Label", matrices[0].getLabelObject());
            for (int d = 0; d < matrices[0].getDimensionCount(); ++d) {
                if (d == dimension) {
                    annotation.put("DimensionMetaData" + d, matrices[0].getMetaDataDimensionMatrix(d));
                    continue;
                }
                Matrix[] annotationMatrices = new Matrix[matrices.length];
                for (int i4 = 0; i4 < annotationMatrices.length; ++i4) {
                    long[] size;
                    MapMatrix<String, Object> a = matrices[i4].getMetaData();
                    Matrix am = null;
                    if (a == null) {
                        size = Coordinates.copyOf(matrices[i4].getSize());
                        size[d] = 1L;
                        am = new DefaultSparseObjectMatrix(size);
                    } else {
                        am = (Matrix)a.get("DimensionMetaData" + d);
                        if (am == null) {
                            size = Coordinates.copyOf(matrices[i4].getSize());
                            size[d] = 1L;
                            am = new DefaultSparseObjectMatrix(size);
                        }
                    }
                    annotationMatrices[i4] = am;
                }
                Matrix m = new Concatenation(dimension, annotationMatrices).calc(Calculation.Ret.NEW);
                annotation.put("DimensionMetaData" + d, m);
            }
        }
    }

    public Concatenation(int dimension, Collection<Matrix> matrices) {
        this(dimension, matrices.toArray(new Matrix[matrices.size()]));
    }

    @Override
    public Object getObject(long ... coordinates) {
        int i;
        for (i = 0; i < this.positions.length && this.positions[i] <= coordinates[this.getDimension()]; ++i) {
        }
        Matrix m = this.getSources()[--i];
        long[] c = Coordinates.copyOf(coordinates);
        c[this.getDimension()] = c[this.getDimension()] - this.positions[i];
        return m.getAsObject(c);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setObject(Object value, long ... coordinates) {
    }

    @Override
    public final ValueType getValueType() {
        return this.valueType;
    }
}

