/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import javax.vecmath.Vector2f;

public class RectDT {
    public float m_Left;
    public float m_Top;
    public float m_Right;
    public float m_Bottom;

    public RectDT() {
    }

    public RectDT(RectDT rectDT) {
        this.set(rectDT);
    }

    public void set(RectDT rectDT) {
        this.m_Left = rectDT.m_Left;
        this.m_Top = rectDT.m_Top;
        this.m_Right = rectDT.m_Right;
        this.m_Bottom = rectDT.m_Bottom;
    }

    public float Width() {
        return this.m_Right - this.m_Left;
    }

    public float Height() {
        return this.m_Bottom - this.m_Top;
    }

    public void NormalizeRect() {
        float f;
        if (this.m_Right < this.m_Left) {
            f = this.m_Right;
            this.m_Right = this.m_Left;
            this.m_Left = f;
        }
        if (this.m_Bottom < this.m_Top) {
            f = this.m_Bottom;
            this.m_Bottom = this.m_Top;
            this.m_Top = f;
        }
    }

    public void SetRect(Vector2f vector2f, Vector2f vector2f2) {
        this.m_Left = vector2f.x;
        this.m_Top = vector2f.y;
        this.m_Right = vector2f2.x;
        this.m_Bottom = vector2f2.y;
    }

    public void MakeEmpty() {
        this.m_Left = Float.MAX_VALUE;
        this.m_Top = Float.MAX_VALUE;
        this.m_Right = -3.4028235E38f;
        this.m_Bottom = -3.4028235E38f;
    }

    public void IncludePoint(Vector2f vector2f) {
        if (this.m_Left > vector2f.x) {
            this.m_Left = vector2f.x;
        }
        if (this.m_Right < vector2f.x) {
            this.m_Right = vector2f.x;
        }
        if (this.m_Top > vector2f.y) {
            this.m_Top = vector2f.y;
        }
        if (this.m_Bottom < vector2f.y) {
            this.m_Bottom = vector2f.y;
        }
    }

    public boolean PtInRect(Vector2f vector2f) {
        return this.m_Left <= vector2f.x && this.m_Right >= vector2f.x && this.m_Top <= vector2f.y && this.m_Bottom >= vector2f.y;
    }

    public static float _hypot(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public float Distance(Vector2f vector2f) {
        if (vector2f.y < this.m_Top) {
            if (vector2f.x < this.m_Left) {
                return RectDT._hypot(vector2f.x - this.m_Left, vector2f.y - this.m_Top);
            }
            if (vector2f.x > this.m_Right) {
                return RectDT._hypot(vector2f.x - this.m_Right, vector2f.y - this.m_Top);
            }
            return this.m_Top - vector2f.y;
        }
        if (vector2f.y > this.m_Bottom) {
            if (vector2f.x < this.m_Left) {
                return RectDT._hypot(vector2f.x - this.m_Left, vector2f.y - this.m_Bottom);
            }
            if (vector2f.x > this.m_Right) {
                return RectDT._hypot(vector2f.x - this.m_Right, vector2f.y - this.m_Bottom);
            }
            return vector2f.y - this.m_Bottom;
        }
        if (vector2f.x <= this.m_Left) {
            return this.m_Left - vector2f.x;
        }
        if (vector2f.x >= this.m_Right) {
            return vector2f.x - this.m_Right;
        }
        return 0.0f;
    }
}

