/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.calculation;

import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.intmatrix.DenseIntMatrix2D;
import org.ujmp.core.intmatrix.calculation.AbstractIntCalculation;

public class Magic
extends AbstractIntCalculation {
    private static final long serialVersionUID = -2372321035531662110L;
    private final DenseIntMatrix2D magic;

    public Magic(Matrix matrix, int size) {
        super(matrix);
        this.magic = Magic.magic(size);
    }

    public int getInt(long ... coordinates) {
        return this.magic.getAsInt(coordinates);
    }

    public static DenseIntMatrix2D magic(int n) {
        int[][] M = new int[n][n];
        if (n % 2 == 1) {
            int a = (n + 1) / 2;
            int b = n + 1;
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < n; ++i) {
                    M[i][j] = n * ((i + j + a) % n) + (i + 2 * j + b) % n + 1;
                }
            }
        } else if (n % 4 == 0) {
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < n; ++i) {
                    M[i][j] = (i + 1) / 2 % 2 == (j + 1) / 2 % 2 ? n * n - n * i - j : n * i + j + 1;
                }
            }
        } else {
            int p = n / 2;
            int k = (n - 2) / 4;
            DenseIntMatrix2D A = Magic.magic(p);
            for (int j = 0; j < p; ++j) {
                for (int i = 0; i < p; ++i) {
                    int aij;
                    M[i][j] = aij = A.getAsInt(i, j);
                    M[i][j + p] = aij + 2 * p * p;
                    M[i + p][j] = aij + 3 * p * p;
                    M[i + p][j + p] = aij + p * p;
                }
            }
            for (int i = 0; i < p; ++i) {
                int t;
                int j;
                for (j = 0; j < k; ++j) {
                    t = M[i][j];
                    M[i][j] = M[i + p][j];
                    M[i + p][j] = t;
                }
                for (j = n - k + 1; j < n; ++j) {
                    t = M[i][j];
                    M[i][j] = M[i + p][j];
                    M[i + p][j] = t;
                }
            }
            int t = M[k][0];
            M[k][0] = M[k + p][0];
            M[k + p][0] = t;
            t = M[k][k];
            M[k][k] = M[k + p][k];
            M[k + p][k] = t;
        }
        return DenseMatrix.Factory.linkToArray(M);
    }
}

