/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.TimerTask;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPTimer;

public class OperatingSystemMatrix
extends AbstractDenseObjectMatrix2D {
    private static final long serialVersionUID = 8686188406504918019L;
    private final Matrix matrix;
    private final UJMPTimer timer;
    private final OperatingSystemMXBean os;
    TimerTask task = new TimerTask(){
        double oldLoadAverage = Double.NaN;

        public void run() {
            double loadAverage = OperatingSystemMatrix.this.os.getSystemLoadAverage();
            if (loadAverage != this.oldLoadAverage) {
                OperatingSystemMatrix.this.matrix.fireValueChanged();
            }
            this.oldLoadAverage = loadAverage;
        }
    };

    public OperatingSystemMatrix() {
        super(6L, 1L);
        this.setLabel("Operating System");
        this.setRowLabel(0L, "Arch");
        this.setRowLabel(1L, "AvailableProcessors");
        this.setRowLabel(2L, "Name");
        this.setRowLabel(3L, "ObjectName");
        this.setRowLabel(4L, "SystemLoadAverage");
        this.setRowLabel(5L, "Version");
        this.matrix = this;
        this.os = ManagementFactory.getOperatingSystemMXBean();
        this.timer = UJMPTimer.newInstance(this.getClass().getSimpleName());
        this.timer.schedule(this.task, 1000L, 1000L);
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getObject(long row, long column) {
        switch (MathUtil.longToInt(row)) {
            case 0: {
                return this.os.getArch();
            }
            case 1: {
                return this.os.getAvailableProcessors();
            }
            case 2: {
                return this.os.getName();
            }
            case 3: {
                return this.os.getObjectName();
            }
            case 4: {
                return this.os.getSystemLoadAverage();
            }
            case 5: {
                return this.os.getVersion();
            }
        }
        return null;
    }

    public void setObject(Object value, long row, long column) {
    }
}

