/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ejml;

import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.ops.CommonOps;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.ejml.EJMLDenseDoubleMatrix2DFactory;
import org.ujmp.ejml.calculation.Inv;
import org.ujmp.ejml.calculation.InvSPD;
import org.ujmp.ejml.calculation.QR;
import org.ujmp.ejml.calculation.SVD;
import org.ujmp.ejml.calculation.Solve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJMLDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DenseMatrix64F>,
HasRowMajorDoubleArray1D {
    private static final long serialVersionUID = -3223474248020842822L;
    public static final EJMLDenseDoubleMatrix2DFactory Factory = new EJMLDenseDoubleMatrix2DFactory();
    private final DenseMatrix64F matrix;

    public EJMLDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new DenseMatrix64F(rows, columns);
    }

    public EJMLDenseDoubleMatrix2D(DenseMatrix64F m) {
        super((long)m.numRows, (long)m.numCols);
        this.matrix = m;
    }

    public EJMLDenseDoubleMatrix2D(Matrix source) {
        super(source.getRowCount(), source.getColumnCount());
        if (source instanceof HasRowMajorDoubleArray2D) {
            double[][] data = ((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D();
            this.matrix = new DenseMatrix64F(data);
        } else if (source instanceof DenseDoubleMatrix2D) {
            this.matrix = new DenseMatrix64F((int)source.getRowCount(), (int)source.getColumnCount());
            DenseDoubleMatrix2D m2 = (DenseDoubleMatrix2D)source;
            int r = (int)source.getRowCount();
            while (--r >= 0) {
                int c = (int)source.getColumnCount();
                while (--c >= 0) {
                    this.matrix.set(r, c, m2.getDouble(r, c));
                }
            }
        } else {
            this.matrix = new DenseMatrix64F((int)source.getRowCount(), (int)source.getColumnCount());
            for (long[] c : source.availableCoordinates()) {
                this.setDouble(source.getAsDouble(c), c);
            }
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get(MathUtil.longToInt(row), MathUtil.longToInt(column));
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.set(MathUtil.longToInt(row), MathUtil.longToInt(column), value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.set(row, column, value);
    }

    @Override
    public DenseMatrix64F getWrappedObject() {
        return this.matrix;
    }

    @Override
    public Matrix transpose() {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numCols, this.matrix.numRows);
        CommonOps.transpose((DenseMatrix64F)this.matrix, (DenseMatrix64F)ret);
        return new EJMLDenseDoubleMatrix2D(ret);
    }

    @Override
    public Matrix inv() {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSPD() {
        return InvSPD.INSTANCE.calc(this);
    }

    @Override
    public double det() {
        return CommonOps.det((DenseMatrix64F)this.matrix);
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix plus(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.add((D1Matrix64F)this.matrix, (double)value, (D1Matrix64F)ret);
        EJMLDenseDoubleMatrix2D result = new EJMLDenseDoubleMatrix2D(ret);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof EJMLDenseDoubleMatrix2D) {
            DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            CommonOps.add((D1Matrix64F)this.matrix, (D1Matrix64F)((EJMLDenseDoubleMatrix2D)m).matrix, (D1Matrix64F)ret);
            EJMLDenseDoubleMatrix2D result = new EJMLDenseDoubleMatrix2D(ret);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof EJMLDenseDoubleMatrix2D) {
            DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            CommonOps.subtract((D1Matrix64F)this.matrix, (D1Matrix64F)((EJMLDenseDoubleMatrix2D)m).matrix, (D1Matrix64F)ret);
            EJMLDenseDoubleMatrix2D result = new EJMLDenseDoubleMatrix2D(ret);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.minus(m);
    }

    @Override
    public Matrix minus(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.add((D1Matrix64F)this.matrix, (double)(-value), (D1Matrix64F)ret);
        EJMLDenseDoubleMatrix2D result = new EJMLDenseDoubleMatrix2D(ret);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix times(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.scale((double)value, (D1Matrix64F)this.matrix, (D1Matrix64F)ret);
        EJMLDenseDoubleMatrix2D result = new EJMLDenseDoubleMatrix2D(ret);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix divide(double value) {
        DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
        CommonOps.scale((double)(1.0 / value), (D1Matrix64F)this.matrix, (D1Matrix64F)ret);
        EJMLDenseDoubleMatrix2D result = new EJMLDenseDoubleMatrix2D(ret);
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof EJMLDenseDoubleMatrix2D) {
            DenseMatrix64F b = ((EJMLDenseDoubleMatrix2D)m).getWrappedObject();
            DenseMatrix64F ret = new DenseMatrix64F(this.matrix.numRows, b.numCols);
            CommonOps.mult((RowD1Matrix64F)this.matrix, (RowD1Matrix64F)b, (RowD1Matrix64F)ret);
            return new EJMLDenseDoubleMatrix2D(ret);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix[] svd() {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] qr() {
        return QR.INSTANCE.calc(this);
    }

    @Override
    public Matrix chol() {
        CholeskyDecomposition chol = DecompositionFactory.chol((int)this.matrix.numRows, (boolean)false);
        chol.decompose((Matrix64F)this.matrix);
        EJMLDenseDoubleMatrix2D l = new EJMLDenseDoubleMatrix2D((DenseMatrix64F)chol.getT(null));
        return l;
    }

    @Override
    public Matrix[] lu() {
        if (this.isSquare()) {
            LUDecomposition lu = DecompositionFactory.lu((int)this.matrix.numRows, (int)this.matrix.numCols);
            lu.decompose((Matrix64F)this.matrix);
            DenseMatrix64F lm = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            DenseMatrix64F um = new DenseMatrix64F(this.matrix.numRows, this.matrix.numCols);
            lu.getLower((Matrix64F)lm);
            lu.getUpper((Matrix64F)um);
            EJMLDenseDoubleMatrix2D l = new EJMLDenseDoubleMatrix2D(lm);
            EJMLDenseDoubleMatrix2D u = new EJMLDenseDoubleMatrix2D(um);
            EJMLDenseDoubleMatrix2D p = new EJMLDenseDoubleMatrix2D((DenseMatrix64F)lu.getPivot(null));
            return new Matrix[]{l, u, p};
        }
        return super.lu();
    }

    @Override
    public Matrix[] eig() {
        EigenDecomposition eig = DecompositionFactory.eig((int)this.matrix.numCols, (boolean)true);
        eig.decompose((Matrix64F)this.matrix);
        int N = this.matrix.numRows;
        DenseMatrix64F D = new DenseMatrix64F(N, N);
        DenseMatrix64F V = new DenseMatrix64F(N, N);
        for (int i = 0; i < N; ++i) {
            Complex64F c = eig.getEigenvalue(i);
            if (!c.isReal()) continue;
            D.set(i, i, c.real);
            Matrix64F v = eig.getEigenVector(i);
            if (v == null) continue;
            for (int j = 0; j < N; ++j) {
                V.set(j, i, v.get(j, 0));
            }
        }
        EJMLDenseDoubleMatrix2D v = new EJMLDenseDoubleMatrix2D(V);
        EJMLDenseDoubleMatrix2D d = new EJMLDenseDoubleMatrix2D(D);
        return new Matrix[]{v, d};
    }

    public Matrix copy() {
        EJMLDenseDoubleMatrix2D m = new EJMLDenseDoubleMatrix2D(this.matrix.copy());
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public double[] getRowMajorDoubleArray1D() {
        return this.matrix.getData();
    }

    public EJMLDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

