/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.elasticsearch;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.listmatrix.ListMatrix;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.elasticsearch.ElasticsearchSample;
import org.ujmp.elasticsearch.ElasticsearchUtil;
import org.ujmp.elasticsearch.KeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticsearchIndex
extends AbstractMapMatrix<String, MapMatrix<String, Object>>
implements Closeable {
    private static final long serialVersionUID = -7047080106649021619L;
    public static final int SCROLLTIMEOUT = 600000;
    public static final int SCROLLSIZE = 1000;
    public static final int DEFAULTPORT = 9300;
    public static final String ID = "_id";
    public static final String SCORE = "score";
    private final Client client;
    private final String index;
    private final String type;

    public ElasticsearchIndex(String hostname, String index, String type) {
        this(hostname, 9300, index, type);
    }

    public ElasticsearchIndex(String hostname, int port, String index, String type) {
        this((Client)ElasticsearchUtil.createTransportClient(hostname, port), index, type);
    }

    public ElasticsearchIndex(Client client, String index, String type) {
        this.client = client;
        this.index = index;
        this.type = type;
        if (!this.indexExists()) {
            this.createIndex();
        }
    }

    public void put(MapMatrix<String, Object> map) {
        Object id = map.get(ID);
        if (id != null && id instanceof String) {
            this.put((String)id, map);
        } else {
            this.put(MathUtil.guid(), map);
        }
    }

    private boolean indexExists() {
        IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{this.index})).actionGet();
        return response.isExists();
    }

    private synchronized void createIndex() {
        CreateIndexResponse response = (CreateIndexResponse)this.client.admin().indices().create(new CreateIndexRequest(this.index)).actionGet();
        if (!response.isAcknowledged()) {
            throw new RuntimeException("cannot create index " + this.index);
        }
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
    }

    public synchronized void deleteIndex() {
        DeleteIndexResponse response = (DeleteIndexResponse)this.client.admin().indices().delete(new DeleteIndexRequest(this.index)).actionGet();
        if (!response.isAcknowledged()) {
            throw new RuntimeException("cannot delete index " + this.index);
        }
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
    }

    public String getIndex() {
        return this.index;
    }

    @Override
    public int size() {
        MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
        CountResponse response = (CountResponse)this.client.prepareCount(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery((QueryBuilder)query).execute().actionGet();
        return MathUtil.longToInt(response.getCount());
    }

    @Override
    public ElasticsearchSample get(Object key) {
        GetResponse getResponse = (GetResponse)this.client.prepareGet(this.index, this.type, String.valueOf(key)).execute().actionGet();
        Map map = getResponse.getSource();
        if (map == null) {
            return null;
        }
        map.put(ID, getResponse.getId());
        return new ElasticsearchSample(this, map);
    }

    public ElasticsearchSample get(Object key, String ... fields) {
        GetResponse getResponse = (GetResponse)this.client.prepareGet(this.index, this.type, String.valueOf(key)).setFields(fields).execute().actionGet();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put(ID, getResponse.getId());
        for (String k : getResponse.getFields().keySet()) {
            map.put(k, getResponse.getField(k).getValue());
        }
        return new ElasticsearchSample(this, map);
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this);
    }

    @Override
    protected void clearMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MapMatrix<String, Object> removeFromMap(Object key) {
        ElasticsearchSample old = this.get(key);
        this.client.prepareDelete(this.index, this.type, String.valueOf(key)).execute().actionGet();
        return old;
    }

    @Override
    protected MapMatrix<String, Object> putIntoMap(String key, MapMatrix<String, Object> value) {
        if (value == null) {
            this.remove(key);
        } else {
            if (!value.containsKey(ID)) {
                value.put(ID, key);
            }
            this.client.prepareIndex(this.index, this.type, key).setSource(value).execute().actionGet();
        }
        return null;
    }

    public Client getClient() {
        return this.client;
    }

    public ListMatrix<ElasticsearchSample> search(String query) {
        SearchHit[] results;
        DefaultListMatrix<ElasticsearchSample> list = new DefaultListMatrix<ElasticsearchSample>();
        QueryStringQueryBuilder qb = QueryBuilders.queryString((String)query).defaultOperator(QueryStringQueryBuilder.Operator.AND);
        SearchResponse response = (SearchResponse)this.client.prepareSearch(new String[]{this.index}).setNoFields().setTypes(new String[]{this.type}).setSearchType(SearchType.QUERY_AND_FETCH).setQuery((QueryBuilder)qb).setFrom(0).setSize(10).setExplain(true).execute().actionGet();
        for (SearchHit hit : results = response.getHits().getHits()) {
            ElasticsearchSample sample = new ElasticsearchSample(this, hit);
            list.add(sample);
        }
        return list;
    }

    public int count(String string) {
        QueryStringQueryBuilder query = QueryBuilders.queryString((String)string).defaultOperator(QueryStringQueryBuilder.Operator.AND);
        CountResponse response = (CountResponse)this.client.prepareCount(new String[]{this.index}).setTypes(new String[]{this.type}).setQuery((QueryBuilder)query).execute().actionGet();
        return MathUtil.longToInt(response.getCount());
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    public String getType() {
        return this.type;
    }
}

