/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.elasticsearch;

import java.util.ArrayList;
import java.util.TreeSet;
import org.elasticsearch.action.admin.indices.status.IndicesStatusResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.ujmp.core.Matrix;
import org.ujmp.core.listmatrix.AbstractListMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticsearchIndexListMatrix
extends AbstractListMatrix<Matrix> {
    private static final long serialVersionUID = 6665231410976080744L;
    private final Client client;

    public ElasticsearchIndexListMatrix(String hostname) {
        this((Client)new TransportClient().addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, 9300)));
    }

    public ElasticsearchIndexListMatrix(String hostname, int port) {
        this((Client)new TransportClient().addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, port)));
    }

    public ElasticsearchIndexListMatrix(Client client) {
        this.client = client;
    }

    @Override
    public synchronized Matrix get(int index) {
        IndicesStatusResponse response = (IndicesStatusResponse)this.client.admin().indices().prepareStatus(new String[0]).execute().actionGet();
        TreeSet indexSet = new TreeSet(response.getIndices().keySet());
        ArrayList indexList = new ArrayList(indexSet);
        return Matrix.Factory.linkToValue((String)indexList.get(index));
    }

    public synchronized void addIndex(String indexName) {
        this.client.admin().indices().prepareCreate(indexName).execute().actionGet();
    }

    public synchronized void removeIndex(String ... indices) {
        this.client.admin().indices().prepareDelete(indices).execute().actionGet();
    }

    @Override
    public void add(int index, Matrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        IndicesStatusResponse response = (IndicesStatusResponse)this.client.admin().indices().prepareStatus(new String[0]).execute().actionGet();
        return response.getIndices().size();
    }

    @Override
    public boolean addToList(Matrix t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToList(int index, Matrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix removeFromList(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFromList(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix setToList(int index, Matrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearList() {
        throw new UnsupportedOperationException();
    }
}

