/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.utils.DateUtils;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.tui.ReportStub;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ReportModel {
    private Set fSessionReportNames = new HashSet();

    public DefaultMutableTreeNode createReportNode(DefaultTreeModel treeModelGroup) {
        if (treeModelGroup == null) {
            throw new IllegalArgumentException("Parameter treeModelGroup cannot be null");
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Reports", true);
        DefaultMutableTreeNode sessionNode = new DefaultMutableTreeNode("Current Session", true);
        List pobs = ParserFactory.getCache().getCachedObjectsL(Report.class);
        Collections.sort(pobs, new ReportHistoryNodeComparator());
        for (int i = 0; i < pobs.size(); ++i) {
            Report rpt = (Report)pobs.get(i);
            if (this.fSessionReportNames.contains(rpt.getName())) continue;
            sessionNode.add(new DefaultMutableTreeNode(rpt, false));
            this.fSessionReportNames.add(rpt.getName());
        }
        DefaultMutableTreeNode historyNode = new DefaultMutableTreeNode("History", true);
        DefaultMutableTreeNode[] histnodes = this.createCachedReportHistoryNodesByDay();
        for (int i = 0; i < histnodes.length; ++i) {
            historyNode.add(histnodes[i]);
        }
        rootNode.add(sessionNode);
        rootNode.add(historyNode);
        treeModelGroup.reload(sessionNode);
        treeModelGroup.reload(historyNode);
        ParserFactory.getCache().addReportAdditionsListener(new MySessionReportListener(treeModelGroup, sessionNode));
        return rootNode;
    }

    private DefaultMutableTreeNode[] createCachedReportHistoryNodesByDay() {
        ReportStub[] stubs = Application.getToolManager().getReportsInCache();
        HashMap dayStubsMap = new HashMap();
        for (int i = 0; i < stubs.length; ++i) {
            if (this.fSessionReportNames.contains(stubs[i].getName())) continue;
            DayTimestamp dts = new DayTimestamp(stubs[i].getTimestamp(), DateUtils.formatAsDayMonthYear(stubs[i].getDate()));
            Object list = dayStubsMap.get(dts);
            if (list == null) {
                list = new ArrayList();
            }
            ((ArrayList)list).add(stubs[i]);
            dayStubsMap.put(dts, list);
        }
        Iterator it = dayStubsMap.keySet().iterator();
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(dayStubsMap.size());
        while (it.hasNext()) {
            DayTimestamp dts = (DayTimestamp)it.next();
            List list = (List)dayStubsMap.get(dts);
            Collections.sort(list, new ReportHistoryNodeComparator());
            DefaultMutableTreeNode dayNode = new DefaultMutableTreeNode(dts, true);
            for (int i = 0; i < list.size(); ++i) {
                dayNode.add(new DefaultMutableTreeNode(list.get(i)));
            }
            nodes.add(dayNode);
        }
        Collections.sort(nodes, new ReportHistoryNodeComparator());
        return nodes.toArray(new DefaultMutableTreeNode[nodes.size()]);
    }

    class DayTimestamp {
        long ts;
        String day;

        DayTimestamp(long ts, String day) {
            this.ts = ts;
            this.day = day;
        }

        public int hashCode() {
            return this.day.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DayTimestamp) {
                return this.equals((DayTimestamp)obj);
            }
            return false;
        }

        public boolean equals(DayTimestamp dts) {
            return dts.day.equals(this.day);
        }

        public String toString() {
            return this.day;
        }
    }

    static class ReportHistoryNodeComparator
    implements Comparator {
        ReportHistoryNodeComparator() {
        }

        public int compare(Object pn1, Object pn2) {
            long ts2;
            long ts1;
            if (pn1 instanceof DefaultMutableTreeNode) {
                ts1 = ((DayTimestamp)((DefaultMutableTreeNode)pn1).getUserObject()).ts;
                ts2 = ((DayTimestamp)((DefaultMutableTreeNode)pn2).getUserObject()).ts;
            } else if (pn1 instanceof Report) {
                ts1 = ((Report)pn1).getTimestamp();
                ts2 = ((Report)pn2).getTimestamp();
            } else {
                ts1 = ((ReportStub)pn1).getTimestamp();
                ts2 = ((ReportStub)pn2).getTimestamp();
            }
            if (ts1 > ts2) {
                return -1;
            }
            if (ts1 == ts2) {
                return 0;
            }
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    private class MySessionReportListener
    implements PropertyChangeListener {
        private DefaultTreeModel model2Reload;
        private DefaultMutableTreeNode sessionNode;

        private MySessionReportListener(DefaultTreeModel model2Reload, DefaultMutableTreeNode sessionNode) {
            this.model2Reload = model2Reload;
            this.sessionNode = sessionNode;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object obj = evt.getNewValue();
            if (obj instanceof Report) {
                Report rpt = (Report)obj;
                if (!ReportModel.this.fSessionReportNames.contains(rpt.getName())) {
                    this.sessionNode.add(new DefaultMutableTreeNode(rpt, false));
                    this.model2Reload.reload(this.sessionNode);
                    ReportModel.this.fSessionReportNames.add(rpt.getName());
                }
            }
        }
    }
}

