/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.ParserFactory;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class DefaultDataset
extends AbstractObject
implements Dataset {
    private Matrix fMatrix;
    private List<String> fRowNames;
    private List<String> fColNames;
    private GeneSet rowNamesGeneSet;
    private Annot fAnn;
    private File dsFile;
    private String fQuickInfo;
    private APMMatrix fAPMMatrix = null;
    private TObjectIntHashMap fRowIndexNameHashMap;

    public APMMatrix getAPMMatrix() {
        return this.fAPMMatrix;
    }

    public DefaultDataset(String name, Matrix matrix, String[] rowNames, String[] colNames, Annot annOpt) {
        this(name, matrix, DefaultDataset.toList(rowNames), DefaultDataset.toList(colNames), annOpt);
    }

    public DefaultDataset(String name, Matrix matrix) {
        int numRow = matrix.getNumRow();
        ArrayList<String> rowNames = new ArrayList<String>(numRow);
        int numCol = matrix.getNumCol();
        ArrayList<String> colNames = new ArrayList<String>(numCol);
        for (int r = 0; r < numRow; ++r) {
            rowNames.add("row_" + r);
        }
        for (int c = 0; c < numCol; ++c) {
            colNames.add("col_" + c);
        }
        this.init_rows_and_cols(name, rowNames, colNames);
        this.initMatrix(matrix, numRow, numCol);
    }

    public DefaultDataset(String name, Matrix matrix, List<String> rowNames, List<String> colNames, Annot annOpt) {
        this(name, matrix, rowNames, colNames, annOpt, null);
    }

    public DefaultDataset(String name, Matrix matrix, List<String> rowNames, List<String> colNames, Annot annOpt, APMMatrix apm) {
        if (matrix == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (rowNames == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("Param colNames cant be null");
        }
        this.init_rows_and_cols(name, rowNames, colNames);
        this.initAnnot(annOpt);
        this.initMatrix(matrix, rowNames.size(), colNames.size());
        this.fAPMMatrix = apm;
    }

    private void initMatrix(Matrix matrix, int numRow, int numCol) {
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        if (matrix.getNumRow() != numRow) {
            throw new IllegalArgumentException("Matrix nrows: " + matrix.getNumRow() + " and rownames: " + numRow + " do not match in size");
        }
        if (matrix.getNumCol() != numCol) {
            throw new IllegalArgumentException("Matrix ncols: " + matrix.getNumCol() + " and colnames: " + numCol + " do not match in size");
        }
        this.fMatrix = matrix;
        this.fMatrix.setImmutable();
    }

    private void init_rows_and_cols(String dsName, List<String> rowNames, List<String> colNames) {
        super.initialize(dsName);
        if (rowNames == null) {
            throw new IllegalArgumentException("rowNames cannot be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("colNames cannot be null");
        }
        this.fRowNames = rowNames;
        this.fRowNames = Collections.unmodifiableList(this.fRowNames);
        this.fColNames = colNames;
        this.fColNames = Collections.unmodifiableList(this.fColNames);
        DefaultDataset.ensureAllUniqueValues(this.fColNames);
    }

    private void initAnnot(Annot annOpt) {
        if (annOpt != null) {
            FeatureAnnot fa = annOpt.getFeatureAnnot();
            if (fa.getNumFeatures() < this.fRowNames.size()) {
                throw new IllegalArgumentException("Annot features is less than dataset rowNames: " + fa.getNumFeatures() + " " + this.fRowNames.size());
            }
            if (fa.hasNativeDescriptions() && this.fRowNames.size() > 1) {
                fa.getNativeDesc(this.fRowNames.get(0));
            }
        }
        this.fAnn = annOpt;
    }

    private static void ensureAllUniqueValues(List<String> cols) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < cols.size(); ++i) {
            String item = cols.get(i);
            if (set.contains(item)) {
                throw new IllegalArgumentException("Duplicate COL names are NOT allowed in Datasets. The offending entry was: " + item + " at pos: " + i);
            }
            set.add(item);
        }
        set.clear();
    }

    @Override
    public Annot getAnnot() {
        if (this.fAnn == null) {
            FeatureAnnot fann = new FeatureAnnot(this.getName(), this.fRowNames, null);
            SampleAnnot sann = new SampleAnnot(this.getName(), this.getColumnNames());
            this.fAnn = new Annot(fann, sann);
        }
        return this.fAnn;
    }

    @Override
    public String getRowName(int rown) {
        return this.fRowNames.get(rown);
    }

    @Override
    public List<String> getRowNames() {
        return Collections.unmodifiableList(this.fRowNames);
    }

    @Override
    public int getRowIndex(String rowName) {
        int index;
        if (rowName == null) {
            throw new IllegalArgumentException("rowName cannot be null: " + rowName);
        }
        if (this.fRowIndexNameHashMap == null) {
            this.fRowIndexNameHashMap = new TObjectIntHashMap();
            for (int r = 0; r < this.fRowNames.size(); ++r) {
                this.fRowIndexNameHashMap.put((Object)this.fRowNames.get(r), r);
            }
        }
        if ((index = this.fRowIndexNameHashMap.get((Object)rowName)) == 0 && !this.fRowIndexNameHashMap.containsKey((Object)rowName)) {
            index = -1;
            return -1;
        }
        return index;
    }

    @Override
    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.fColNames);
    }

    @Override
    public GeneSet getRowNamesGeneSet() {
        if (this.rowNamesGeneSet == null) {
            this.rowNamesGeneSet = new GeneSet(this.getName(), new HashSet<String>(this.fRowNames));
        }
        return this.rowNamesGeneSet;
    }

    @Override
    public int getColumnIndex(String colName) {
        return this.fColNames.indexOf(colName);
    }

    @Override
    public String getColumnName(int coln) {
        return this.fColNames.get(coln);
    }

    @Override
    public int getNumRow() {
        return this.fRowNames.size();
    }

    @Override
    public int getNumCol() {
        return this.fColNames.size();
    }

    @Override
    public Vector getRow(String rowName) {
        return this.getRow(this.getRowIndex(rowName));
    }

    @Override
    public Vector[] getRows(GeneSet gset) {
        Vector[] vss = new Vector[gset.getNumMembers()];
        for (int i = 0; i < gset.getNumMembers(); ++i) {
            vss[i] = this.getRow(gset.getMember(i));
        }
        return vss;
    }

    @Override
    public float getElement(int rown, int coln) {
        return this._matrix().getElement(rown, coln);
    }

    @Override
    public Vector getRow(int rown) {
        return this._matrix().getRowV(rown);
    }

    @Override
    public Vector getColumn(int coln) {
        return this._matrix().getColumnV(coln);
    }

    @Override
    public int getDim() {
        return this._matrix().getDim();
    }

    @Override
    public Matrix getMatrix() {
        this._matrix().setImmutable();
        return this._matrix();
    }

    private Matrix _matrix() {
        if (this.fMatrix == null) {
            if (this.dsFile == null || !this.dsFile.exists()) {
                throw new IllegalStateException("ds file for lazy matrix loading is null or missing: " + this.dsFile);
            }
            try {
                this.log.debug("LAZY loading dataset from: {}", (Object)this.dsFile.getPath());
                Dataset ds = ParserFactory.readDataset(this.dsFile, true, true);
                this.initMatrix(((DefaultDataset)ds).fMatrix, this.fRowNames.size(), this.fColNames.size());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.fMatrix;
    }

    @Override
    public String getQuickInfo() {
        if (this.fQuickInfo == null) {
            this._setQuickInfo();
        }
        return this.fQuickInfo;
    }

    private void _setQuickInfo() {
        StringBuilder buf = new StringBuilder().append(this.getNumRow()).append('x').append(this.getNumCol());
        if (this.getAnnot() != null && this.getAnnot().getFeatureAnnot() != null && this.getAnnot().getSampleAnnot_global() != null) {
            FeatureAnnot fa = this.getAnnot().getFeatureAnnot();
            SampleAnnot sa = this.getAnnot().getSampleAnnot_global();
            buf.append(" (ann: ");
            if (fa != null) {
                buf.append(fa.getNumFeatures());
            } else {
                buf.append("na");
            }
            buf.append(",");
            if (sa != null) {
                buf.append(sa.getNumSamples());
            } else {
                buf.append("na");
            }
            buf.append(",");
            if (this.getAnnot().getChip() != null) {
                buf.append(this.getAnnot().getChip().getName());
            } else {
                buf.append("chip na");
            }
            buf.append(")");
        }
        this.fQuickInfo = buf.toString();
    }

    private static List<String> toList(String[] ss) {
        ArrayList<String> list = new ArrayList<String>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            list.add(ss[i]);
        }
        return list;
    }
}

