/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.esmatrix.db;

import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.gsea.EdbAlgs;
import edu.mit.broad.genome.alg.markers.PermutationTest;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.strucs.FdrStruc;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class EnrichmentDb
extends AbstractObject {
    private Metric fMetric;
    private Map<String, Boolean> fMetricParams;
    private SortMode fSortMode;
    private Order fOrder;
    private int fNumPerms;
    private File fEdbDir_opt;
    private PermutationTest fPermTest;
    private EnrichmentResult[] fResults;
    private Map<String, EnrichmentResult> fGeneSetNameResultMap;
    private RankedList fRankedList_shared;
    private Template fTemplate_opt_shared;
    private Dataset fDataset_shared;
    private FdrStruc[] fFdrPos;
    private FdrStruc[] fFdrNeg;

    public EnrichmentDb(String name, RankedList ranked_list_shared, Dataset ds_shared_opt, Template template_shared_opt, EnrichmentResult[] results, Metric metric, Map<String, Boolean> metricParams, SortMode sort, Order order, int numPerm, File edb_dir_opt, PermutationTest ptest_opt) {
        if (results == null) {
            throw new IllegalArgumentException("Param results cannot be null");
        }
        if (ranked_list_shared == null) {
            throw new IllegalArgumentException("Shared ranked list cannot be null");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Param metric cannot be null");
        }
        if (sort == null) {
            throw new IllegalArgumentException("Param sort cannot be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Param order cannot be null");
        }
        super.initialize(name);
        this.fResults = results;
        this.fRankedList_shared = ranked_list_shared;
        this.fTemplate_opt_shared = template_shared_opt;
        this.fDataset_shared = ds_shared_opt;
        this.fMetric = metric;
        this.fMetricParams = metricParams;
        this.fSortMode = sort;
        this.fOrder = order;
        this.fNumPerms = numPerm;
        this.fEdbDir_opt = edb_dir_opt;
        this.fPermTest = ptest_opt;
        this.fGeneSetNameResultMap = EdbAlgs.hashByGeneSetName(this.getResults());
    }

    public EnrichmentDb cloneDeep(EnrichmentResult[] results) {
        return new EnrichmentDb(this.getName(), this.getRankedList(), this.getDataset(), this.getTemplate(), results, this.getMetric(), this.getMetricParams(), this.getSortMode(), this.getOrder(), this.getNumPerm(), this.getEdbDir(), this.getPermutationTest());
    }

    public EnrichmentResult getResultForGeneSet(String gsetName_no_aux) {
        EnrichmentResult obj = this.fGeneSetNameResultMap.get(gsetName_no_aux);
        if (obj == null) {
            throw new IllegalArgumentException("No such gset result: " + gsetName_no_aux);
        }
        return obj;
    }

    public int getNumNominallySig(float npCutoffInclusive, boolean pos) {
        int cnt = 0;
        if (pos) {
            for (int i = 0; i < this.fResults.length; ++i) {
                EnrichmentResult res = this.fResults[i];
                if (!(res.getScore().getES() > 0.0f) || !(res.getScore().getNP() <= npCutoffInclusive)) continue;
                ++cnt;
            }
        } else {
            for (int i = 0; i < this.fResults.length; ++i) {
                EnrichmentResult res = this.fResults[i];
                if (!(res.getScore().getES() < 0.0f) || !(res.getScore().getNP() <= npCutoffInclusive)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public EnrichmentResult getResult(int i) {
        return this.fResults[i];
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    public GeneSet[] getGeneSets() {
        return EdbAlgs.getGeneSets(this.getResults());
    }

    public EnrichmentResult[] getResults(Comparator<EnrichmentResult> comp) {
        List<EnrichmentResult> list = Arrays.asList(this.fResults);
        Collections.sort(list, comp);
        return list.toArray(new EnrichmentResult[list.size()]);
    }

    public EnrichmentResult[] getResults(boolean pos) {
        ComparatorFactory.EnrichmentResultByNESComparator comp = pos ? new ComparatorFactory.EnrichmentResultByNESComparator(Order.DESCENDING) : new ComparatorFactory.EnrichmentResultByNESComparator(Order.ASCENDING);
        EnrichmentResult[] all = this.getResults(comp);
        ArrayList<EnrichmentResult> sub = new ArrayList<EnrichmentResult>();
        if (pos) {
            for (int i = 0; i < all.length; ++i) {
                float es = all[i].getScore().getES();
                if (!XMath.isPositive(es)) continue;
                sub.add(all[i]);
            }
        } else {
            for (int i = 0; i < all.length; ++i) {
                float es = all[i].getScore().getES();
                if (!XMath.isNegative(es)) continue;
                sub.add(all[i]);
            }
        }
        return sub.toArray(new EnrichmentResult[sub.size()]);
    }

    public int getNumResults() {
        return this.fResults.length;
    }

    public int getNumScores(boolean pos) {
        int cnt = 0;
        if (pos) {
            for (int i = 0; i < this.fResults.length; ++i) {
                if (!XMath.isPositive(this.fResults[i].getScore().getES())) continue;
                ++cnt;
            }
        } else {
            for (int i = 0; i < this.fResults.length; ++i) {
                if (!XMath.isNegative(this.fResults[i].getScore().getES())) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    private void initFDR() {
        if (this.fFdrPos != null) {
            return;
        }
        ArrayList<FdrStruc> pos = new ArrayList<FdrStruc>();
        ArrayList<FdrStruc> neg = new ArrayList<FdrStruc>();
        for (int i = 0; i < this.fResults.length; ++i) {
            FdrStruc fdr = this.fResults[i].getFDR();
            if (fdr == null) continue;
            if (XMath.isPositive(fdr.getRealScore())) {
                pos.add(fdr);
                continue;
            }
            neg.add(fdr);
        }
        this.fFdrPos = pos.toArray(new FdrStruc[pos.size()]);
        this.fFdrNeg = neg.toArray(new FdrStruc[neg.size()]);
    }

    public int getNumFDRSig(float fdrCutoffInclusive, boolean pos) {
        FdrStruc[] fdrs = this.getFDR(pos);
        ArrayList<FdrStruc> list = new ArrayList<FdrStruc>();
        for (int i = 0; i < fdrs.length; ++i) {
            if (!(fdrs[i].getFdr() <= fdrCutoffInclusive)) continue;
            list.add(fdrs[i]);
        }
        return list.toArray(new FdrStruc[list.size()]).length;
    }

    public FdrStruc[] getFDR(boolean pos) {
        this.initFDR();
        if (pos && this.fFdrPos == null) {
            throw new IllegalStateException("Fdrs not yet calculated: " + pos);
        }
        if (!pos && this.fFdrNeg == null) {
            throw new IllegalStateException("Fdrs not yet calculated: " + pos);
        }
        if (pos) {
            return this.fFdrPos;
        }
        return this.fFdrNeg;
    }

    public LabelledVector getESS_lv() {
        Vector ess = new Vector(this.fResults.length);
        for (int i = 0; i < this.fResults.length; ++i) {
            ess.setElement(i, this.fResults[i].getScore().getES());
        }
        String[] names = EdbAlgs.getGeneSetNames(this.fResults);
        return new LabelledVector(this.getName() + "_ess", names, ess);
    }

    public Vector getNESS() {
        Vector ness = new Vector(this.fResults.length);
        for (int i = 0; i < this.fResults.length; ++i) {
            ness.setElement(i, this.fResults[i].getScore().getNES());
        }
        return ness;
    }

    public Vector getNPs() {
        Vector nps = new Vector(this.fResults.length);
        for (int i = 0; i < this.fResults.length; ++i) {
            nps.setElement(i, this.fResults[i].getScore().getNP());
        }
        return nps;
    }

    public Vector getFDRs() {
        Vector fdrs = new Vector(this.fResults.length);
        for (int i = 0; i < this.fResults.length; ++i) {
            fdrs.setElement(i, this.fResults[i].getScore().getFDR());
        }
        return fdrs;
    }

    public Metric getMetric() {
        return this.fMetric;
    }

    public Map<String, Boolean> getMetricParams() {
        return this.fMetricParams;
    }

    public SortMode getSortMode() {
        return this.fSortMode;
    }

    public Order getOrder() {
        return this.fOrder;
    }

    public int getNumPerm() {
        return this.fNumPerms;
    }

    public File getEdbDir() {
        return this.fEdbDir_opt;
    }

    public Template getTemplate() {
        return this.fTemplate_opt_shared;
    }

    public Dataset getDataset() {
        return this.fDataset_shared;
    }

    public RankedList getRankedList() {
        return this.fRankedList_shared;
    }

    public EnrichmentResult[] getResults() {
        return this.fResults;
    }

    public PermutationTest getPermutationTest() {
        return this.fPermTest;
    }
}

