/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.strucs.Linked;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;

public class RichDataframe
extends AbstractObject
implements IDataframe {
    private IDataframe fIdf;
    private MetaData fMetaData;
    private Rich fRichColors;
    private Rich fRichLinks;

    public RichDataframe(StringDataframe sdf, MetaData metaData, TIntObjectHashMap cell_id_colorMap, TIntObjectHashMap cell_id_linkMap) {
        if (sdf == null) {
            throw new IllegalArgumentException("Parameter sdf cannot be null");
        }
        super.initialize(sdf.getName());
        this.fIdf = sdf;
        this.fMetaData = metaData;
        if (cell_id_colorMap != null && !cell_id_colorMap.isEmpty()) {
            this.fRichColors = new Rich();
            this.fRichColors.cell_id = cell_id_colorMap;
        }
        if (cell_id_linkMap != null && !cell_id_linkMap.isEmpty()) {
            this.fRichLinks = new Rich();
            this.fRichLinks.cell_id = cell_id_linkMap;
        }
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.fIdf.getNumRow()).append('x').append(this.fIdf.getNumCol());
        return buf.toString();
    }

    public IDataframe getDataframe() {
        return this.fIdf;
    }

    public MetaData getMetaData() {
        return this.fMetaData;
    }

    public String getElementColor(int row, int col) {
        Object obj;
        if (this.fRichColors != null && this.fRichColors.cell_id != null && (obj = this.fRichColors.cell_id.get(this._cell_id(row, col))) != null) {
            return obj.toString();
        }
        return null;
    }

    public Linked getElementLink(int row, int col) {
        Object obj;
        if (this.fRichLinks != null && this.fRichLinks.cell_id != null && (obj = this.fRichLinks.cell_id.get(this._cell_id(row, col))) != null) {
            return (Linked)obj;
        }
        return null;
    }

    private int _cell_id(int row, int col) {
        return row * this.fIdf.getNumCol() + col;
    }

    @Override
    public Object getElementObj(int rown, int coln) {
        return this.fIdf.getElementObj(rown, coln);
    }

    @Override
    public String getRowName(int rown) {
        return this.fIdf.getRowName(rown);
    }

    @Override
    public String getColumnName(int coln) {
        return this.fIdf.getColumnName(coln);
    }

    @Override
    public int getNumRow() {
        return this.fIdf.getNumRow();
    }

    @Override
    public int getNumCol() {
        return this.fIdf.getNumCol();
    }

    public static class MetaData {
        private TIntIntHashMap fColIndexFloatPrecisionMap;
        private String fTitle;
        boolean gotNfe = false;

        public MetaData(String title, TIntIntHashMap colIndexFloatPrecisionMap) {
            this.fTitle = title;
            this.fColIndexFloatPrecisionMap = colIndexFloatPrecisionMap;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public Object adjustPrecision(Object val, int coln) {
            if (val != null && val.toString().length() > 0 && !this.gotNfe && val != null && this.fColIndexFloatPrecisionMap != null && this.fColIndexFloatPrecisionMap.containsKey(coln)) {
                try {
                    Float f = new Float(val.toString());
                    int precision = this.fColIndexFloatPrecisionMap.get(coln);
                    return Printf.format(f.floatValue(), precision);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.gotNfe = true;
                }
            }
            return val;
        }
    }

    static class Rich {
        private TIntObjectHashMap cell_id;

        Rich() {
        }
    }
}

