/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.prefs;

import edu.mit.broad.xbench.prefs.Preference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPreference
implements Preference {
    private String fName;
    private String fDesc;
    private Object fDefault;
    private boolean fDebug;
    private boolean fNeedsRestart;
    protected static final Logger klog = LoggerFactory.getLogger(AbstractPreference.class);

    protected AbstractPreference() {
    }

    protected AbstractPreference(String name, String desc, Object def, boolean isDebug, boolean needsRestart) {
        this.init(name, desc, def, isDebug, needsRestart);
    }

    protected void init(String name, String desc, Object def, boolean isDebug, boolean needsRestart) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("Parameter desc cannot be null");
        }
        if (def == null) {
            throw new IllegalArgumentException("Parameter def cannot be null");
        }
        this.fName = name;
        this.fDesc = desc;
        this.fDefault = def;
        this.fDebug = isDebug;
        this.fNeedsRestart = needsRestart;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getDesc() {
        return this.fDesc;
    }

    public Object getDefault() {
        return this.fDefault;
    }

    protected void _setValueOfPref2SelectionComponentValue(Object value) {
        klog.debug("Saving pref: {} getValue: {}", (Object)this.getName(), value);
        if (value != null) {
            kPrefs.put(this.getName(), value.toString());
        }
    }
}

