/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.reports.EnrichmentReports;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.genepattern.gsea.HistogramDataset;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class GeneHistogram
extends JPanel {
    private JFreeChart geneHistChart = ChartFactory.createHistogram((String)"", (String)"Gene", (String)"Number Of Gene Sets", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
    private RankedList featureFrequency;
    private int selectedGeneIndex = -1;
    private ChartPanel geneHistPanel;
    private RankedList scores;

    public GeneHistogram() {
        XYPlot plot = this.geneHistChart.getXYPlot();
        plot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeZeroBaselineVisible(false);
        plot.setDomainZeroBaselineVisible(false);
        XYBarRenderer renderer = new XYBarRenderer(){

            public Paint getItemPaint(int series, int item) {
                if (item == GeneHistogram.this.selectedGeneIndex) {
                    return Color.YELLOW;
                }
                if (GeneHistogram.this.scores != null) {
                    float value = GeneHistogram.this.scores.getScore(GeneHistogram.this.featureFrequency.getRankName(item));
                    return value > 0.0f ? Color.RED : Color.BLUE;
                }
                return super.getItemPaint(series, item);
            }
        };
        renderer.setGradientPaintTransformer(null);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        renderer.setShadowVisible(false);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.getRangeAxis().setAxisLinePaint((Paint)Color.GRAY);
        plot.getRangeAxis().setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        plot.getRangeAxis().setTickMarkPaint((Paint)Color.GRAY);
        plot.getRangeAxis().setTickMarkStroke((Stroke)new BasicStroke(1.0f));
        this.geneHistPanel = new ChartPanel(this.geneHistChart, false, false, false, false, false){

            public String getToolTipText(MouseEvent e) {
                int index = GeneHistogram.this.getXIndex(e.getX(), e.getY());
                return index != -1 ? GeneHistogram.this.featureFrequency.getRankName(index) : null;
            }
        };
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.geneHistPanel);
        this.geneHistChart.setBackgroundPaint((Paint)EnrichmentReports.CHART_FRAME_COLOR);
        ChartMouseListener listener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                int mouseX = event.getTrigger().getX();
                int mouseY = event.getTrigger().getY();
                GeneHistogram.this.selectedGeneIndex = GeneHistogram.this.getXIndex(mouseX, mouseY);
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        };
        this.geneHistPanel.addChartMouseListener(listener);
        this.geneHistPanel.setMouseZoomable(true, false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.geneHistPanel, "Center");
    }

    public ChartPanel getChartPanel() {
        return this.geneHistPanel;
    }

    public String getGeneName(int index) {
        return this.featureFrequency.getRankName(index);
    }

    public int getXIndex(int mouseX, int mouseY) {
        Point p1 = new Point(mouseX, mouseY);
        XYPlot plot = (XYPlot)this.geneHistChart.getPlot();
        Rectangle2D plotArea = this.geneHistPanel.getScreenDataArea();
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        double chartX = domainAxis.java2DToValue(p1.getX(), plotArea, domainAxisEdge);
        double chartY = rangeAxis.java2DToValue(p1.getY(), plotArea, rangeAxisEdge);
        int index = (int)Math.round(chartX);
        if (index < 0) {
            index = 0;
        } else if (index >= this.featureFrequency.getSize()) {
            index = this.featureFrequency.getSize() - 1;
        }
        if (chartY <= (double)this.featureFrequency.getScore(index)) {
            return index;
        }
        return -1;
    }

    void updateGeneHist() {
        XYSeries series = new XYSeries((Comparable)((Object)"Histogram"));
        HistogramDataset coll = new HistogramDataset(0.0);
        coll.addSeries(series);
        for (int i = 0; i < this.featureFrequency.getSize(); ++i) {
            double score = this.featureFrequency.getScore(i);
            series.add((double)i, score);
        }
        SymbolAxis xAxis = new SymbolAxis("Gene", this.featureFrequency.getRankedNamesArray());
        xAxis.setVerticalTickLabels(true);
        xAxis.setTickLabelFont(new Font("SansSerif", 0, 9));
        xAxis.setTickMarkPaint((Paint)Color.GRAY);
        xAxis.setTickMarkStroke((Stroke)new BasicStroke(1.0f));
        xAxis.setAxisLinePaint((Paint)Color.GRAY);
        xAxis.setAxisLineStroke((Stroke)new BasicStroke(1.0f, 2, 0));
        this.geneHistChart.getXYPlot().setDomainAxis((ValueAxis)xAxis);
        this.geneHistChart.getXYPlot().setDataset((XYDataset)coll);
    }

    public void setFeatureFrequency(RankedList featureFrequency, RankedList scores) {
        this.featureFrequency = featureFrequency;
        this.scores = scores;
        this.updateGeneHist();
    }
}

