/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.genepattern.heatmap.RowColorScheme;

public class LegendPanel
extends JPanel {
    public static final NumberFormat ONE_FRACTION_FORMAT = NumberFormat.getInstance();
    public static final NumberFormat NO_FRACTION_FORMAT = NumberFormat.getInstance();

    final void setAbsoluteGrid(RowColorScheme converter) {
        double[] values = converter.getSlots();
        this.setDisplayValues(converter.getColorMap(), values, "", NO_FRACTION_FORMAT, 2);
    }

    final void setRelativeGrid(RowColorScheme converter) {
        double[] values = new double[converter.getColorCount()];
        converter.calculateSlots(-3.0, 3.0, 0.0, values);
        double[] new_values = new double[values.length + 1];
        new_values[0] = -3.0;
        System.arraycopy(values, 0, new_values, 1, values.length);
        this.setDisplayValues(converter.getColorMap(), new_values, "Normalized Expression", ONE_FRACTION_FORMAT, 2);
    }

    public void setDisplayValues(Color[] colors, double[] values, String comment, NumberFormat format, int alignment) {
        String[] sValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            sValues[i] = format.format(values[i]);
        }
        this.setDisplayValues(colors, sValues, comment, alignment);
    }

    public void setDisplayValues(Color[] colors, String[] values, String comment, int alignment) {
        this.removeAll();
        this.setBackground(Color.white);
        int num_colors = colors.length;
        StringBuffer colSpec = new StringBuffer();
        int width = 600;
        int widthPerLabel = width / num_colors;
        for (int j = 0; j < num_colors; ++j) {
            if (j > 0) {
                colSpec.append(", ");
            }
            colSpec.append(widthPerLabel + "px");
        }
        colSpec.append(", pref");
        JPanel colorPanel = new JPanel((LayoutManager)new FormLayout(colSpec.toString(), "pref, pref"));
        colorPanel.setBackground(Color.white);
        CellConstraints cc = new CellConstraints();
        for (int i = 0; i < num_colors; ++i) {
            JPanel p = new JPanel();
            p.setToolTipText(values[i]);
            p.setBackground(colors[i]);
            p.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            JLabel lab = new JLabel(values[i]);
            lab.setToolTipText(values[i]);
            lab.setHorizontalAlignment(alignment);
            colorPanel.add((Component)p, cc.xy(i + 1, 1));
            colorPanel.add((Component)lab, cc.xy(i + 1, 2));
        }
        if (values.length > colors.length) {
            JLabel lab = new JLabel(values[values.length - 1]);
            lab.setToolTipText(values[values.length - 1]);
            colorPanel.add((Component)lab, cc.xy(values.length, 2));
            lab.setHorizontalAlignment(alignment);
        }
        this.setLayout(new BorderLayout());
        JPanel temp = new JPanel();
        temp.setBackground(Color.white);
        temp.add(colorPanel);
        this.add(temp);
        JLabel commentLabel = new JLabel(comment, 0);
        JPanel temp2 = new JPanel();
        temp2.setBackground(Color.white);
        temp2.add(commentLabel);
        this.add((Component)temp2, "South");
    }

    static {
        ONE_FRACTION_FORMAT.setMaximumFractionDigits(1);
        ONE_FRACTION_FORMAT.setMinimumFractionDigits(1);
        NO_FRACTION_FORMAT.setMaximumFractionDigits(0);
        NO_FRACTION_FORMAT.setMinimumFractionDigits(0);
    }
}

