/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.vecmath;

import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.vecmath.VecMathDenseDoubleMatrix2DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VecMathDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<GMatrix> {
    private static final long serialVersionUID = 3792684800581150214L;
    public static final VecMathDenseDoubleMatrix2DFactory Factory = new VecMathDenseDoubleMatrix2DFactory();
    private final GMatrix matrix;

    public VecMathDenseDoubleMatrix2D(GMatrix m) {
        super((long)m.getNumRow(), (long)m.getNumCol());
        this.matrix = m;
    }

    public VecMathDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new GMatrix(rows, columns);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                this.setDouble(0.0, r, c);
            }
        }
    }

    public VecMathDenseDoubleMatrix2D(Matrix source) {
        this(MathUtil.longToInt(source.getRowCount()), MathUtil.longToInt(source.getColumnCount()));
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getElement((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getElement(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setElement((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setElement(row, column, value);
    }

    @Override
    public GMatrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public VecMathDenseDoubleMatrix2D transpose() {
        GMatrix m = (GMatrix)this.matrix.clone();
        m.transpose();
        return new VecMathDenseDoubleMatrix2D(m);
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof VecMathDenseDoubleMatrix2D) {
            GMatrix result = (GMatrix)this.matrix.clone();
            result.add(((VecMathDenseDoubleMatrix2D)m).matrix);
            VecMathDenseDoubleMatrix2D ret = new VecMathDenseDoubleMatrix2D(result);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                ret.setMetaData(a.clone());
            }
            return ret;
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof VecMathDenseDoubleMatrix2D) {
            GMatrix result = (GMatrix)this.matrix.clone();
            result.sub(((VecMathDenseDoubleMatrix2D)m).matrix);
            VecMathDenseDoubleMatrix2D ret = new VecMathDenseDoubleMatrix2D(result);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                ret.setMetaData(a.clone());
            }
            return ret;
        }
        return super.minus(m);
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof VecMathDenseDoubleMatrix2D) {
            GMatrix result = new GMatrix(this.matrix.getNumRow(), (int)m.getColumnCount());
            result.mul(this.matrix, ((VecMathDenseDoubleMatrix2D)m).matrix);
            VecMathDenseDoubleMatrix2D ret = new VecMathDenseDoubleMatrix2D(result);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                ret.setMetaData(a.clone());
            }
            return ret;
        }
        return super.mtimes(m);
    }

    @Override
    public DenseDoubleMatrix2D inv() {
        GMatrix m = (GMatrix)this.matrix.clone();
        m.invert();
        return new VecMathDenseDoubleMatrix2D(m);
    }

    @Override
    public Matrix[] svd() {
        GMatrix m = (GMatrix)this.matrix.clone();
        int nrows = (int)this.getRowCount();
        int ncols = (int)this.getColumnCount();
        GMatrix u = new GMatrix(nrows, nrows);
        GMatrix s = new GMatrix(nrows, ncols);
        GMatrix v = new GMatrix(ncols, ncols);
        m.SVD(u, s, v);
        VecMathDenseDoubleMatrix2D U = new VecMathDenseDoubleMatrix2D(u);
        VecMathDenseDoubleMatrix2D S = new VecMathDenseDoubleMatrix2D(s);
        VecMathDenseDoubleMatrix2D V = new VecMathDenseDoubleMatrix2D(v);
        return new Matrix[]{U, S, V};
    }

    @Override
    public Matrix[] lu() {
        if (this.isSquare()) {
            GMatrix m = (GMatrix)this.matrix.clone();
            GMatrix lu = (GMatrix)this.matrix.clone();
            GVector piv = new GVector(this.matrix.getNumCol());
            m.LUD(lu, piv);
            Matrix l = new VecMathDenseDoubleMatrix2D(lu).tril(Calculation.Ret.NEW, 0);
            for (int i = (int)l.getRowCount() - 1; i != -1; --i) {
                l.setAsDouble(1.0, i, i);
            }
            Matrix u = new VecMathDenseDoubleMatrix2D(lu).triu(Calculation.Ret.NEW, 0);
            VecMathDenseDoubleMatrix2D p = new VecMathDenseDoubleMatrix2D(MathUtil.longToInt(this.getRowCount()), MathUtil.longToInt(this.getColumnCount()));
            for (int i = piv.getSize() - 1; i != -1; --i) {
                p.setDouble(1.0, i, (int)piv.getElement(i));
            }
            return new Matrix[]{l, u, p};
        }
        throw new RuntimeException("only allowed for square matrices");
    }

    public VecMathDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

