/*  $Id: accguide2.inc 665732 2023-04-12 18:17:49Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Aaron Ucko
 *
 * File Description:
 *   Built-in copy of accguide2.txt.
 *
 */

/* time_t value corresponding to Tue Apr 11 14:56:20 EDT 2023; formally
 * expressed as unsigned long so output can stand fully on its own. */
static const unsigned long kBuiltInGuide_Timestamp = 1681239380UL;
static const char* const kBuiltInGuide[] = {
    "# $Id: accguide2.inc 665732 2023-04-12 18:17:49Z ivanov $",
    "version  2 # of file format",
    "",
    "# three-letter-prefix protein accessions (traditionally with five digits)",
    "3+5  AAE  gb_patent_prot",
    "3+5  ??_  unknown # Longer variants (6-9 digits as of June 2018) are RefSeq",
    "3+5  A??  gb_prot",
    "3+7  A??  gb_prot",
    "3+9  A??  gb_prot",
    "3+11 A??  gb_prot",
    "3+5  B??  ddbj_prot",
    "3+7  B??  ddbj_prot",
    "3+9  B??  ddbj_prot",
    "3+11 B??  ddbj_prot",
    "3+5  C??  embl_prot *",
    "3+7  C??  embl_prot *",
    "3+9  C??  embl_prot",
    "3+11 C??  embl_prot",
    "3+5  D??  gb_tpa_prot *",
    "3+7  D??  gb_tpa_prot",
    "3+9  D??  gb_tpa_prot",
    "3+11 D??  gb_tpa_prot",
    "3+5  E??  gb_wgs_prot",
    "3+7  E??  gb_wgsv_prot",
    "3+9  E??  gb_prot",
    "3+11 E??  gb_prot",
    "3+5  F??  ddbj_tpa_prot",
    "3+7  F??  ddbj_tpa_prot",
    "3+9  F??  ddbj_tpa_prot",
    "3+11 F??  ddbj_tpa_prot",
    "3+5  G??  ddbj_wgs_prot",
    "3+7  G??  ddbj_prot",
    "3+9  G??  ddbj_prot",
    "3+11 G??  ddbj_prot",
    "3+5  H??  gb_tpa_wgsv_prot",
    "3+7  H??  gb_tpa_wgsv_prot",
    "3+9  H??  gb_tpa_prot",
    "3+11 H??  gb_tpa_prot",
    "3+5  I??  ddbj_tpa_wgs_prot",
    "3+7  I??  ddbj_tpa_prot",
    "3+9  I??  ddbj_tpa_prot",
    "3+11 I??  ddbj_tpa_prot",
    "3+5  J??  gb_tsa_prot",
    "3+7  J??  gb_prot",
    "3+9  J??  gb_prot",
    "3+11 J??  gb_prot",
    "3+5  K??  gb_wgs_prot",
    "3+7  K??  gb_wgs_prot",
    "3+9  K??  gb_prot",
    "3+11 K??  gb_prot",
    "3+5  L??  ddbj_prot # mixed TSA and TLS",
    "3+7  L??  ddbj_prot",
    "3+9  L??  ddbj_prot",
    "3+11 L??  ddbj_prot",
    "3+5  M??  gb_wgsv_prot",
    "3+7  M??  gb_wgsv_prot",
    "3+9  M??  gb_prot",
    "3+11 M??  gb_prot",
    "3+5  N??  gb_wgsv_prot",
    "3+7  N??  gb_wgsv_prot",
    "3+9  N??  gb_prot",
    "3+11 N??  gb_prot",
    "3+5  O??  gb_wgs_prot",
    "3+7  O??  gb_prot",
    "3+9  O??  gb_prot",
    "3+11 O??  gb_prot",
    "3+5  P??  gb_wgs_prot",
    "3+7  P??  gb_prot",
    "3+9  P??  gb_prot",
    "3+11 P??  gb_prot",
    "3+5  Q??  gb_prot",
    "3+7  Q??  gb_prot",
    "3+9  Q??  gb_prot",
    "3+11 Q??  gb_prot",
    "3+5  R??  gb_wgs_prot",
    "3+7  R??  gb_prot",
    "3+9  R??  gb_prot",
    "3+11 R??  gb_prot",
    "3+5  S??  embl_prot *",
    "3+7  S??  embl_prot",
    "3+9  S??  embl_prot",
    "3+11 S??  embl_prot",
    "3+5  T??  gb_wgs_prot",
    "3+7  T??  gb_prot",
    "3+9  T??  gb_prot",
    "3+11 T??  gb_prot",
    "3+5  U??  gb_prot",
    "3+7  U??  gb_prot",
    "3+9  U??  gb_prot",
    "3+11 U??  gb_prot",
    "3+5  V??  embl_prot *",
    "3+7  V??  embl_prot",
    "3+9  V??  embl_prot",
    "3+11 V??  embl_prot",
    "3+5  W??  gb_prot",
    "3+7  W??  gb_prot",
    "3+9  W??  gb_prot",
    "3+11 W??  gb_prot",
    "3+5  ???  unreserved_prot",
    "3+7  ???  unreserved_prot",
    "3+9  ???  unreserved_prot",
    "3+11 ???  unreserved_prot",
    "",
    "# Genome pipeline accessions",
    "4+9  GPC_  gpipe_chromosome",
    "4+9  GPG_  gpipe_genomic",
    "4+9  GPM_  gpipe_mrna",
    "4+9  GPN_  gpipe_other_nuc",
    "4+9  GPP_  gpipe_prot",
    "4+9  GPR_  gpipe_ncrna",
    "4+9  GPS_  gpipe_scaffold",
    "4+9  ZPC_  gpipe_chromosome",
    "4+9  ZPG_  gpipe_genomic",
    "4+9  ZPM_  gpipe_mrna",
    "4+9  ZPN_  gpipe_other_nuc",
    "4+9  ZPP_  gpipe_prot",
    "4+9  ZPR_  gpipe_ncrna",
    "4+9  ZPS_  gpipe_scaffold",
    "4+9  GP?_  gpipe_unreserved",
    "4+9  ZP?_  gpipe_unreserved",
    "",
    "# whole genome shotgun accessions",
    "4+8   ???_    unknown",
    "4+9   ???_    unknown",
    "4+10  ???_    unknown",
    "4+8   A???    gb_wgs_nuc",
    "4+9   A???    gb_wgs_nuc",
    "4+10  A???    gb_wgs_nuc",
    "4+8   B???    ddbj_wgs_nuc",
    "4+9   B???    ddbj_wgs_nuc",
    "4+10  B???    ddbj_wgs_nuc",
    "4+8   C???    embl_wgs_nuc",
    "4+9   C???    embl_wgs_nuc",
    "4+10  C???    embl_wgs_nuc",
    "4+8   D???    gb_tpa_wgs_nuc",
    "4+9   D???    gb_tpa_wgs_nuc",
    "4+10  D???    gb_tpa_wgs_nuc",
    "4+8   E???    ddbj_tpa_wgs_nuc",
    "4+9   E???    ddbj_tpa_wgs_nuc",
    "4+10  E???    ddbj_tpa_wgs_nuc",
    "4+8   F???    embl_wgs_nuc",
    "4+9   F???    embl_wgs_nuc",
    "4+10  F???    embl_wgs_nuc",
    "4+8   G???    gb_tsa_nuc",
    "4+9   G???    gb_tsa_nuc",
    "4+10  G???    gb_tsa_nuc",
    "4+8   H???    embl_tsa_nuc *",
    "4+9   H???    embl_tsa_nuc",
    "4+10  H???    embl_tsa_nuc",
    "4+8   I???    ddbj_tsa_nuc",
    "4+9   I???    ddbj_tsa_nuc",
    "4+10  I???    ddbj_tsa_nuc",
    "4+8   J???    gb_wgs_nuc",
    "4+9   J???    gb_wgs_nuc",
    "4+10  J???    gb_wgs_nuc",
    "4+8   K???    gb_targeted_nuc",
    "4+9   K???    gb_targeted_nuc",
    "4+10  K???    gb_targeted_nuc",
    "4+8   L???    gb_wgs_nuc",
    "4+9   L???    gb_wgs_nuc",
    "4+10  L???    gb_wgs_nuc",
    "4+8   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   O???    embl_wgs_nuc",
    "4+9   O???    embl_wgs_nuc",
    "4+10  O???    embl_wgs_nuc",
    "4+8   P???    gb_wgs_nuc",
    "4+9   P???    gb_wgs_nuc",
    "4+10  P???    gb_wgs_nuc",
    "4+8   Q???    gb_wgs_nuc",
    "4+9   Q???    gb_wgs_nuc",
    "4+10  Q???    gb_wgs_nuc",
    "4+8   R???    gb_wgs_nuc",
    "4+9   R???    gb_wgs_nuc",
    "4+10  R???    gb_wgs_nuc",
    "4+8   S???    gb_wgs_nuc",
    "4+9   S???    gb_wgs_nuc",
    "4+10  S???    gb_wgs_nuc",
    "4+8   T???    ddbj_targeted_nuc",
    "4+9   T???    ddbj_targeted_nuc",
    "4+10  T???    ddbj_targeted_nuc",
    "4+8   U???    embl_wgs_nuc",
    "4+9   U???    embl_wgs_nuc",
    "4+10  U???    embl_wgs_nuc",
    "4+8   V???    gb_wgs_nuc",
    "4+9   V???    gb_wgs_nuc",
    "4+10  V???    gb_wgs_nuc",
    "4+8   W???    gb_wgs_nuc",
    "4+9   W???    gb_wgs_nuc",
    "4+10  W???    gb_wgs_nuc",
    "4+8   X???    gb_wgs_nuc",
    "4+9   X???    gb_wgs_nuc",
    "4+10  X???    gb_wgs_nuc",
    "4+8   Y???    ddbj_tpa_tsa_nuc",
    "4+9   Y???    ddbj_tpa_tsa_nuc",
    "4+10  Y???    ddbj_tpa_tsa_nuc",
    "4+8   Z???    ddbj_tpa_targeted_nuc",
    "4+9   Z???    ddbj_tpa_targeted_nuc",
    "4+10  Z???    ddbj_tpa_targeted_nuc",
    "4+8   ????    unreserved_nuc",
    "4+9   ????    unreserved_nuc",
    "4+10  ????    unreserved_nuc",
    "6+9   ?????_  unknown",
    "6+10  ?????_  unknown",
    "6+11  ?????_  unknown",
    "6+9   A?????  gb_wgs_nuc",
    "6+10  A?????  gb_wgs_nuc",
    "6+11  A?????  gb_wgs_nuc",
    "6+9   B?????  ddbj_wgs_nuc",
    "6+10  B?????  ddbj_wgs_nuc",
    "6+11  B?????  ddbj_wgs_nuc",
    "6+9   C?????  embl_wgs_nuc *",
    "6+10  C?????  embl_wgs_nuc",
    "6+11  C?????  embl_wgs_nuc",
    "6+9   D?????  gb_tpa_wgs_nuc",
    "6+10  D?????  gb_tpa_wgs_nuc",
    "6+11  D?????  gb_tpa_wgs_nuc",
    "6+9   J?????  gb_wgs_nuc",
    "6+10  J?????  gb_wgs_nuc",
    "6+11  J?????  gb_wgs_nuc",
    "6+9   ??????  unreserved_nuc",
    "6+10  ??????  unreserved_nuc",
    "6+11  ??????  unreserved_nuc",
    "",
    "# Mass sequence Genome for Annotation",
    "5+7   A???? ddbj_other_nuc",
    "5+7   A???? ddbj_mga",
    "",
    "# Named annotation track (new as of September 2008)",
    "3+9  AT_  named_annot_track",
    "",
    "# NCBI reference sequence accessions",
    "3+6  AC_      refseq_chromosome",
    "3+6  AP_      refseq_prot",
    "3+6  NC_      refseq_chromosome",
    "3+6  NG_      refseq_genomic",
    "3+6  NM_      refseq_mrna",
    "3+9  NM_      refseq_mrna",
    "3+6  NP_      refseq_prot",
    "3+9  NP_      refseq_prot",
    "3+6  NR_      refseq_ncrna",
    "3+6  NS_      refseq_genome",
    "3+6  NT_      refseq_contig",
    "3+6  NW_      refseq_wgs_intermed",
    "3+9  NW_      refseq_wgs_intermed",
    "4+5  NZ_?     refseq_contig",
    "5+6  NZ_??    refseq_contig",
    "7+8  NZ_????  refseq_wgs_nuc",
    "7+9  NZ_????  refseq_wgs_nuc",
    "7+10 NZ_????  refseq_wgs_nuc",
    "9+9  NZ_?????? refseq_wgs_nuc",
    "9+10 NZ_?????? refseq_wgs_nuc",
    "9+11 NZ_?????? refseq_wgs_nuc",
    "3+9  WC_      refseq_chromosome_ncbo",
    "3+9  WP_      refseq_unique_prot",
    "3+9  WT_      refseq_contig_ncbo",
    "3+6  XM_      refseq_mrna_predicted",
    "3+9  XM_      refseq_mrna_predicted",
    "3+6  XP_      refseq_prot_predicted",
    "3+9  XP_      refseq_prot_predicted",
    "3+6  XR_      refseq_ncrna_predicted",
    "3+9  XR_      refseq_ncrna_predicted",
    "3+6  YP_      refseq_prot_predicted",
    "3+9  YP_      refseq_prot_predicted",
    "3+8  ZP_      refseq_wgs_prot",
    "3+6  ??_      refseq_unreserved",
    "3+7  ??_      refseq_unreserved",
    "3+8  ??_      refseq_unreserved",
    "3+9  ??_      refseq_unreserved",
    "",
    "# Unusually structured GenBank accessions",
    "4+6  MAP_  gb_optical_map",
    "",
    "# 6-character accessions (mixed, but generally nucleotide)",
    "1+5  A  embl_patent",
    "1+5  B  gb_gss",
    "1+5  C  ddbj_est *",
    "1+5  D  ddbj_dirsub *",
    "1+5  E  ddbj_patent",
    "1+5  F  embl_est *",
    "1+5  G  gb_sts",
    "1+5  H  gb_est",
    "1+5  I  gb_patent",
    "1+5  J  gsdb_dirsub",
    "1+5  K  gsdb_dirsub",
    "1+5  L  gsdb_dirsub *",
    "1+5  M  gsdb_dirsub *",
    "1+5  N  unreserved_nuc *",
    "1+5  O  swissprot",
    "1+5  P  swissprot",
    "1+5  Q  swissprot",
    "1+5  R  gb_est",
    "1+5  S  gb_backbone",
    "1+5  T  gb_est *",
    "1+5  U  gb_dirsub *",
    "1+5  V  embl_dirsub",
    "1+5  W  gb_est",
    "1+5  X  embl_dirsub *",
    "1+5  Y  embl_dirsub *",
    "1+5  Z  embl_dirsub *",
    "1+5  ?  unreserved_nuc",
    "",
    "# two-letter-prefix nucleotide accessions (traditionally with six digits)",
    "2+6  AA  gb_est",
    "2+8  AA  gb_other_nuc",
    "2+10 AA  gb_other_nuc",
    "2+6  AB  ddbj_dirsub *",
    "2+8  AB  ddbj_other_nuc",
    "2+10 AB  ddbj_other_nuc",
    "2+6  AC  gb_htgs",
    "2+8  AC  gb_other_nuc",
    "2+10 AC  gb_other_nuc",
    "2+6  AD  gb_gsdb",
    "2+8  AD  gb_other_nuc",
    "2+10 AD  gb_other_nuc",
    "2+6  AE  gb_genome",
    "2+8  AE  gb_other_nuc",
    "2+10 AE  gb_other_nuc",
    "2+6  AF  gb_dirsub *",
    "2+8  AF  gb_other_nuc",
    "2+10 AF  gb_other_nuc",
    "2+6  AG  ddbj_gss *",
    "2+8  AG  ddbj_other_nuc",
    "2+10 AG  ddbj_other_nuc",
    "2+6  AH  gb_segset",
    "2+8  AH  gb_other_nuc",
    "2+10 AH  gb_other_nuc",
    "2+6  AI  gb_est",
    "2+8  AI  gb_other_nuc",
    "2+10 AI  gb_other_nuc",
    "2+6  AJ  embl_dirsub *",
    "2+8  AJ  embl_other_nuc",
    "2+10 AJ  embl_other_nuc",
    "2+6  AK  ddbj_mrna",
    "2+8  AK  ddbj_other_nuc",
    "2+10 AK  ddbj_other_nuc",
    "2+6  AL  embl_dirsub *",
    "2+8  AL  embl_other_nuc",
    "2+10 AL  embl_other_nuc",
    "2+6  AM  embl_dirsub *",
    "2+8  AM  embl_other_nuc",
    "2+10 AM  embl_other_nuc",
    "2+6  AN  embl_con",
    "2+8  AN  embl_other_nuc",
    "2+10 AN  embl_other_nuc",
    "2+6  AO  unreserved_nuc",
    "2+8  AO  unreserved_nuc",
    "2+10 AO  unreserved_nuc",
    "2+6  AP  ddbj_genome",
    "2+8  AP  ddbj_other_nuc",
    "2+10 AP  ddbj_other_nuc",
    "2+6  AQ  gb_gss",
    "2+8  AQ  gb_other_nuc",
    "2+10 AQ  gb_other_nuc",
    "2+6  AR  gb_patent",
    "2+8  AR  gb_other_nuc",
    "2+10 AR  gb_other_nuc",
    "2+6  AS  gb_other_nuc",
    "2+8  AS  gb_other_nuc",
    "2+10 AS  gb_other_nuc",
    "2+6  AT  ddbj_est",
    "2+8  AT  ddbj_other_nuc",
    "2+10 AT  ddbj_other_nuc",
    "2+6  AU  ddbj_est *",
    "2+8  AU  ddbj_other_nuc",
    "2+10 AU  ddbj_other_nuc",
    "2+6  AV  ddbj_est",
    "2+8  AV  ddbj_other_nuc",
    "2+10 AV  ddbj_other_nuc",
    "2+6  AW  gb_est",
    "2+8  AW  gb_other_nuc",
    "2+10 AW  gb_other_nuc",
    "2+6  AX  embl_patent *",
    "2+8  AX  embl_other_nuc",
    "2+10 AX  embl_other_nuc",
    "2+6  AY  gb_dirsub *",
    "2+8  AY  gb_other_nuc",
    "2+10 AY  gb_other_nuc",
    "2+6  AZ  gb_gss",
    "2+8  AZ  gb_other_nuc",
    "2+10 AZ  gb_other_nuc",
    "2+6  BA  ddbj_con",
    "2+8  BA  ddbj_other_nuc",
    "2+10 BA  ddbj_other_nuc",
    "2+6  BB  ddbj_est",
    "2+8  BB  ddbj_other_nuc",
    "2+10 BB  ddbj_other_nuc",
    "2+6  BC  gb_cdna",
    "2+8  BC  gb_other_nuc",
    "2+10 BC  gb_other_nuc",
    "2+6  BD  ddbj_patent",
    "2+8  BD  ddbj_other_nuc",
    "2+10 BD  ddbj_other_nuc",
    "2+6  BE  gb_est",
    "2+8  BE  gb_other_nuc",
    "2+10 BE  gb_other_nuc",
    "2+6  BF  gb_est",
    "2+8  BF  gb_other_nuc",
    "2+10 BF  gb_other_nuc",
    "2+6  BG  gb_est",
    "2+8  BG  gb_other_nuc",
    "2+10 BG  gb_other_nuc",
    "2+6  BH  gb_gss",
    "2+8  BH  gb_other_nuc",
    "2+10 BH  gb_other_nuc",
    "2+6  BI  gb_est",
    "2+8  BI  gb_other_nuc",
    "2+10 BI  gb_other_nuc",
    "2+6  BJ  ddbj_est",
    "2+8  BJ  ddbj_other_nuc",
    "2+10 BJ  ddbj_other_nuc",
    "2+6  BK  gb_tpa_nuc",
    "2+8  BK  gb_tpa_nuc",
    "2+10 BK  gb_tpa_nuc",
    "2+6  BL  gb_tpa_segset # Formally CON but not necessarily genomic",
    "2+8  BL  gb_tpa_nuc",
    "2+10 BL  gb_tpa_nuc",
    "2+6  BM  gb_est",
    "2+8  BM  gb_other_nuc",
    "2+10 BM  gb_other_nuc",
    "2+6  BN  embl_tpa_nuc",
    "2+8  BN  embl_tpa_nuc",
    "2+10 BN  embl_tpa_nuc",
    "2+6  BO  unreserved_nuc",
    "2+8  BO  unreserved_nuc",
    "2+10 BO  unreserved_nuc",
    "2+6  BP  ddbj_est",
    "2+8  BP  ddbj_other_nuc",
    "2+10 BP  ddbj_other_nuc",
    "2+6  BQ  gb_est",
    "2+8  BQ  gb_other_nuc",
    "2+10 BQ  gb_other_nuc",
    "2+6  BR  ddbj_tpa_nuc",
    "2+8  BR  ddbj_tpa_nuc",
    "2+10 BR  ddbj_tpa_nuc",
    "2+6  BS  ddbj_genome # chimp genomes, specifically",
    "2+8  BS  ddbj_other_nuc",
    "2+10 BS  ddbj_other_nuc",
    "2+6  BT  gb_cdna",
    "2+8  BT  gb_other_nuc",
    "2+10 BT  gb_other_nuc",
    "2+6  BU  gb_est",
    "2+8  BU  gb_other_nuc",
    "2+10 BU  gb_other_nuc",
    "2+6  BV  gb_sts",
    "2+8  BV  gb_other_nuc",
    "2+10 BV  gb_other_nuc",
    "2+6  BW  ddbj_est",
    "2+8  BW  ddbj_other_nuc",
    "2+10 BW  ddbj_other_nuc",
    "2+6  BX  embl_dirsub *",
    "2+8  BX  embl_other_nuc",
    "2+10 BX  embl_other_nuc",
    "2+6  BY  ddbj_est",
    "2+8  BY  ddbj_other_nuc",
    "2+10 BY  ddbj_other_nuc",
    "2+6  BZ  gb_gss",
    "2+8  BZ  gb_other_nuc",
    "2+10 BZ  gb_other_nuc",
    "2+6  CA  gb_est",
    "2+8  CA  gb_other_nuc",
    "2+10 CA  gb_other_nuc",
    "2+6  CB  gb_est",
    "2+8  CB  gb_other_nuc",
    "2+10 CB  gb_other_nuc",
    "2+6  CC  gb_gss",
    "2+8  CC  gb_other_nuc",
    "2+10 CC  gb_other_nuc",
    "2+6  CD  gb_est",
    "2+8  CD  gb_other_nuc",
    "2+10 CD  gb_other_nuc",
    "2+6  CE  gb_gss",
    "2+8  CE  gb_other_nuc",
    "2+10 CE  gb_other_nuc",
    "2+6  CF  gb_est",
    "2+8  CF  gb_other_nuc",
    "2+10 CF  gb_other_nuc",
    "2+6  CG  gb_gss",
    "2+8  CG  gb_other_nuc",
    "2+10 CG  gb_other_nuc",
    "2+6  CH  gb_con",
    "2+8  CH  gb_other_nuc",
    "2+10 CH  gb_other_nuc",
    "2+6  CI  ddbj_est",
    "2+8  CI  ddbj_other_nuc",
    "2+10 CI  ddbj_other_nuc",
    "2+6  CJ  ddbj_est",
    "2+8  CJ  ddbj_other_nuc",
    "2+10 CJ  ddbj_other_nuc",
    "2+6  CK  gb_est",
    "2+8  CK  gb_other_nuc",
    "2+10 CK  gb_other_nuc",
    "2+6  CL  gb_gss",
    "2+8  CL  gb_other_nuc",
    "2+10 CL  gb_other_nuc",
    "2+6  CM  gb_chromosome",
    "2+8  CM  gb_other_nuc",
    "2+10 CM  gb_other_nuc",
    "2+6  CN  gb_est",
    "2+8  CN  gb_other_nuc",
    "2+10 CN  gb_other_nuc",
    "2+6  CO  gb_est",
    "2+8  CO  gb_other_nuc",
    "2+10 CO  gb_other_nuc",
    "2+6  CP  gb_genome *",
    "2+8  CP  gb_other_nuc",
    "2+10 CP  gb_other_nuc",
    "2+6  CQ  embl_patent",
    "2+8  CQ  embl_other_nuc",
    "2+10 CQ  embl_other_nuc",
    "2+6  CR  embl_dirsub *",
    "2+8  CR  embl_other_nuc",
    "2+10 CR  embl_other_nuc",
    "2+6  CS  embl_patent",
    "2+8  CS  embl_other_nuc",
    "2+10 CS  embl_other_nuc",
    "2+6  CT  embl_dirsub *",
    "2+8  CT  embl_other_nuc",
    "2+10 CT  embl_other_nuc",
    "2+6  CU  embl_dirsub *",
    "2+8  CU  embl_other_nuc",
    "2+10 CU  embl_other_nuc",
    "2+6  CV  gb_est",
    "2+8  CV  gb_other_nuc",
    "2+10 CV  gb_other_nuc",
    "2+6  CW  gb_gss",
    "2+8  CW  gb_other_nuc",
    "2+10 CW  gb_other_nuc",
    "2+6  CX  gb_est",
    "2+8  CX  gb_other_nuc",
    "2+10 CX  gb_other_nuc",
    "2+6  CY  gb_genome",
    "2+8  CY  gb_other_nuc",
    "2+10 CY  gb_other_nuc",
    "2+6  CZ  gb_gss",
    "2+8  CZ  gb_other_nuc",
    "2+10 CZ  gb_other_nuc",
    "2+6  DA  ddbj_est",
    "2+8  DA  ddbj_other_nuc",
    "2+10 DA  ddbj_other_nuc",
    "2+6  DB  ddbj_est",
    "2+8  DB  ddbj_other_nuc",
    "2+10 DB  ddbj_other_nuc",
    "2+6  DC  ddbj_est",
    "2+8  DC  ddbj_other_nuc",
    "2+10 DC  ddbj_other_nuc",
    "2+6  DD  ddbj_patent",
    "2+8  DD  ddbj_other_nuc",
    "2+10 DD  ddbj_other_nuc",
    "2+6  DE  ddbj_gss *",
    "2+8  DE  ddbj_other_nuc",
    "2+10 DE  ddbj_other_nuc",
    "2+6  DF  ddbj_con",
    "2+8  DF  ddbj_other_nuc",
    "2+10 DF  ddbj_other_nuc",
    "2+6  DG  ddbj_con",
    "2+8  DG  ddbj_other_nuc",
    "2+10 DG  ddbj_other_nuc",
    "2+6  DH  ddbj_gss",
    "2+8  DH  ddbj_other_nuc",
    "2+10 DH  ddbj_other_nuc",
    "2+6  DI  ddbj_patent # from Korea",
    "2+8  DI  ddbj_other_nuc",
    "2+10 DI  ddbj_other_nuc",
    "2+6  DJ  ddbj_patent",
    "2+8  DJ  ddbj_other_nuc",
    "2+10 DJ  ddbj_other_nuc",
    "2+6  DK  ddbj_est",
    "2+8  DK  ddbj_other_nuc",
    "2+10 DK  ddbj_other_nuc",
    "2+6  DL  ddbj_patent",
    "2+8  DL  ddbj_other_nuc",
    "2+10 DL  ddbj_other_nuc",
    "2+6  DM  ddbj_patent",
    "2+8  DM  ddbj_other_nuc",
    "2+10 DM  ddbj_other_nuc",
    "2+6  DN  gb_est",
    "2+8  DN  gb_other_nuc",
    "2+10 DN  gb_other_nuc",
    "2+6  DO  unreserved_nuc",
    "2+8  DO  unreserved_nuc",
    "2+10 DO  unreserved_nuc",
    "2+6  DP  gb_htgs # HTG scaffolds; look like gb_con, but built on htgs parts",
    "2+8  DP  gb_other_nuc",
    "2+10 DP  gb_other_nuc",
    "2+6  DQ  gb_dirsub *",
    "2+8  DQ  gb_other_nuc",
    "2+10 DQ  gb_other_nuc",
    "2+6  DR  gb_est",
    "2+8  DR  gb_other_nuc",
    "2+10 DR  gb_other_nuc",
    "2+6  DS  gb_con *",
    "2+8  DS  gb_other_nuc",
    "2+10 DS  gb_other_nuc",
    "2+6  DT  gb_est",
    "2+8  DT  gb_other_nuc",
    "2+10 DT  gb_other_nuc",
    "2+6  DU  gb_gss",
    "2+8  DU  gb_other_nuc",
    "2+10 DU  gb_other_nuc",
    "2+6  DV  gb_est",
    "2+8  DV  gb_other_nuc",
    "2+10 DV  gb_other_nuc",
    "2+6  DW  gb_est",
    "2+8  DW  gb_other_nuc",
    "2+10 DW  gb_other_nuc",
    "2+6  DX  gb_gss",
    "2+8  DX  gb_other_nuc",
    "2+10 DX  gb_other_nuc",
    "2+6  DY  gb_est",
    "2+8  DY  gb_other_nuc",
    "2+10 DY  gb_other_nuc",
    "2+6  DZ  gb_patent",
    "2+8  DZ  gb_other_nuc",
    "2+10 DZ  gb_other_nuc",
    "2+6  EA  gb_patent",
    "2+8  EA  gb_other_nuc",
    "2+10 EA  gb_other_nuc",
    "2+6  EB  gb_est",
    "2+8  EB  gb_other_nuc",
    "2+10 EB  gb_other_nuc",
    "2+6  EC  gb_est",
    "2+8  EC  gb_other_nuc",
    "2+10 EC  gb_other_nuc",
    "2+6  ED  gb_gss",
    "2+8  ED  gb_other_nuc",
    "2+10 ED  gb_other_nuc",
    "2+6  EE  gb_est",
    "2+8  EE  gb_other_nuc",
    "2+10 EE  gb_other_nuc",
    "2+6  EF  gb_dirsub *",
    "2+8  EF  gb_other_nuc",
    "2+10 EF  gb_other_nuc",
    "2+6  EG  gb_est",
    "2+8  EG  gb_other_nuc",
    "2+10 EG  gb_other_nuc",
    "2+6  EH  gb_est",
    "2+8  EH  gb_other_nuc",
    "2+10 EH  gb_other_nuc",
    "2+6  EI  gb_gss",
    "2+8  EI  gb_other_nuc",
    "2+10 EI  gb_other_nuc",
    "2+6  EJ  gb_gss",
    "2+8  EJ  gb_other_nuc",
    "2+10 EJ  gb_other_nuc",
    "2+6  EK  gb_gss",
    "2+8  EK  gb_other_nuc",
    "2+10 EK  gb_other_nuc",
    "2+6  EL  gb_est",
    "2+8  EL  gb_other_nuc",
    "2+10 EL  gb_other_nuc",
    "2+6  EM  gb_con",
    "2+8  EM  gb_other_nuc",
    "2+10 EM  gb_other_nuc",
    "2+6  EN  gb_con",
    "2+8  EN  gb_other_nuc",
    "2+10 EN  gb_other_nuc",
    "2+6  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+8  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+10 EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+6  EP  gb_con",
    "2+8  EP  gb_other_nuc",
    "2+10 EP  gb_other_nuc",
    "2+6  EQ  gb_con",
    "2+8  EQ  gb_other_nuc",
    "2+10 EQ  gb_other_nuc",
    "2+6  ER  gb_gss",
    "2+8  ER  gb_other_nuc",
    "2+10 ER  gb_other_nuc",
    "2+6  ES  gb_est",
    "2+8  ES  gb_other_nuc",
    "2+10 ES  gb_other_nuc",
    "2+6  ET  gb_gss",
    "2+8  ET  gb_other_nuc",
    "2+10 ET  gb_other_nuc",
    "2+6  EU  gb_dirsub *",
    "2+8  EU  gb_other_nuc",
    "2+10 EU  gb_other_nuc",
    "2+6  EV  gb_est",
    "2+8  EV  gb_other_nuc",
    "2+10 EV  gb_other_nuc",
    "2+6  EW  gb_est",
    "2+8  EW  gb_other_nuc",
    "2+10 EW  gb_other_nuc",
    "2+6  EX  gb_est",
    "2+8  EX  gb_other_nuc",
    "2+10 EX  gb_other_nuc",
    "2+6  EY  gb_est",
    "2+8  EY  gb_other_nuc",
    "2+10 EY  gb_other_nuc",
    "2+6  EZ  gb_tsa_nuc",
    "2+8  EZ  gb_other_nuc",
    "2+10 EZ  gb_other_nuc",
    "2+6  FA  gb_con",
    "2+8  FA  gb_other_nuc",
    "2+10 FA  gb_other_nuc",
    "2+6  FB  embl_patent",
    "2+8  FB  embl_other_nuc",
    "2+10 FB  embl_other_nuc",
    "2+6  FC  gb_est",
    "2+8  FC  gb_other_nuc",
    "2+10 FC  gb_other_nuc",
    "2+6  FD  gb_est",
    "2+8  FD  gb_other_nuc",
    "2+10 FD  gb_other_nuc",
    "2+6  FE  gb_est",
    "2+8  FE  gb_other_nuc",
    "2+10 FE  gb_other_nuc",
    "2+6  FF  gb_est",
    "2+8  FF  gb_other_nuc",
    "2+10 FF  gb_other_nuc",
    "2+6  FG  gb_est",
    "2+8  FG  gb_other_nuc",
    "2+10 FG  gb_other_nuc",
    "2+6  FH  gb_gss",
    "2+8  FH  gb_other_nuc",
    "2+10 FH  gb_other_nuc",
    "2+6  FI  gb_gss",
    "2+8  FI  gb_other_nuc",
    "2+10 FI  gb_other_nuc",
    "2+6  FJ  gb_dirsub *",
    "2+8  FJ  gb_other_nuc",
    "2+10 FJ  gb_other_nuc",
    "2+6  FK  gb_est",
    "2+8  FK  gb_other_nuc",
    "2+10 FK  gb_other_nuc",
    "2+6  FL  gb_est",
    "2+8  FL  gb_other_nuc",
    "2+10 FL  gb_other_nuc",
    "2+6  FM  embl_dirsub *",
    "2+8  FM  embl_other_nuc",
    "2+10 FM  embl_other_nuc",
    "2+6  FN  embl_dirsub *",
    "2+8  FN  embl_other_nuc",
    "2+10 FN  embl_other_nuc",
    "2+6  FO  embl_dirsub *",
    "2+8  FO  embl_other_nuc",
    "2+10 FO  embl_other_nuc",
    "2+6  FP  embl_dirsub *",
    "2+8  FP  embl_other_nuc",
    "2+10 FP  embl_other_nuc",
    "2+6  FQ  embl_dirsub *",
    "2+8  FQ  embl_other_nuc",
    "2+10 FQ  embl_other_nuc",
    "2+6  FR  embl_dirsub *",
    "2+8  FR  embl_other_nuc",
    "2+10 FR  embl_other_nuc",
    "2+6  FS  ddbj_est",
    "2+8  FS  ddbj_other_nuc",
    "2+10 FS  ddbj_other_nuc",
    "2+6  FT  ddbj_gss",
    "2+8  FT  ddbj_other_nuc",
    "2+10 FT  ddbj_other_nuc",
    "2+6  FU  ddbj_patent",
    "2+8  FU  ddbj_other_nuc",
    "2+10 FU  ddbj_other_nuc",
    "2+6  FV  ddbj_patent",
    "2+8  FV  ddbj_other_nuc",
    "2+10 FV  ddbj_other_nuc",
    "2+6  FW  ddbj_patent",
    "2+8  FW  ddbj_other_nuc",
    "2+10 FW  ddbj_other_nuc",
    "2+6  FX  ddbj_tsa_nuc",
    "2+8  FX  ddbj_other_nuc",
    "2+10 FX  ddbj_other_nuc",
    "2+6  FY  ddbj_est",
    "2+8  FY  ddbj_other_nuc",
    "2+10 FY  ddbj_other_nuc",
    "2+6  FZ  ddbj_patent",
    "2+8  FZ  ddbj_other_nuc",
    "2+10 FZ  ddbj_other_nuc",
    "2+6  GA  ddbj_gss",
    "2+8  GA  ddbj_other_nuc",
    "2+10 GA  ddbj_other_nuc",
    "2+6  GB  ddbj_patent",
    "2+8  GB  ddbj_other_nuc",
    "2+10 GB  ddbj_other_nuc",
    "2+6  GC  gb_patent",
    "2+8  GC  gb_other_nuc",
    "2+10 GC  gb_other_nuc",
    "2+6  GD  gb_est",
    "2+8  GD  gb_other_nuc",
    "2+10 GD  gb_other_nuc",
    "2+6  GE  gb_est",
    "2+8  GE  gb_other_nuc",
    "2+10 GE  gb_other_nuc",
    "2+6  GF  gb_sts",
    "2+8  GF  gb_other_nuc",
    "2+10 GF  gb_other_nuc",
    "2+6  GG  gb_con",
    "2+8  GG  gb_other_nuc",
    "2+10 GG  gb_other_nuc",
    "2+6  GH  gb_est",
    "2+8  GH  gb_other_nuc",
    "2+10 GH  gb_other_nuc",
    "2+6  GI  unreserved_nuc # deliberately skipped",
    "2+8  GI  unreserved_nuc # deliberately skipped",
    "2+10 GI  unreserved_nuc # deliberately skipped",
    "2+6  GJ  gb_tpa_con",
    "2+8  GJ  gb_tpa_nuc",
    "2+10 GJ  gb_tpa_nuc",
    "2+6  GK  gb_tpa_chromosome",
    "2+8  GK  gb_tpa_nuc",
    "2+10 GK  gb_tpa_nuc",
    "2+6  GL  gb_con",
    "2+8  GL  gb_other_nuc",
    "2+10 GL  gb_other_nuc",
    "2+6  GM  embl_patent",
    "2+8  GM  embl_other_nuc",
    "2+10 GM  embl_other_nuc",
    "2+6  GN  embl_patent",
    "2+8  GN  embl_other_nuc",
    "2+10 GN  embl_other_nuc",
    "2+6  GO  gb_est",
    "2+8  GO  gb_other_nuc",
    "2+10 GO  gb_other_nuc",
    "2+6  GP  gb_patent",
    "2+8  GP  gb_other_nuc",
    "2+10 GP  gb_other_nuc",
    "2+6  GQ  gb_dirsub *",
    "2+8  GQ  gb_other_nuc",
    "2+10 GQ  gb_other_nuc",
    "2+6  GR  gb_est",
    "2+8  GR  gb_other_nuc",
    "2+10 GR  gb_other_nuc",
    "2+6  GS  gb_gss",
    "2+8  GS  gb_other_nuc",
    "2+10 GS  gb_other_nuc",
    "2+6  GT  gb_est",
    "2+8  GT  gb_other_nuc",
    "2+10 GT  gb_other_nuc",
    "2+6  GU  gb_dirsub *",
    "2+8  GU  gb_other_nuc",
    "2+10 GU  gb_other_nuc",
    "2+6  GV  gb_patent",
    "2+8  GV  gb_other_nuc",
    "2+10 GV  gb_other_nuc",
    "2+6  GW  gb_est",
    "2+8  GW  gb_other_nuc",
    "2+10 GW  gb_other_nuc",
    "2+6  GX  gb_patent",
    "2+8  GX  gb_other_nuc",
    "2+10 GX  gb_other_nuc",
    "2+6  GY  gb_patent",
    "2+8  GY  gb_other_nuc",
    "2+10 GY  gb_other_nuc",
    "2+6  GZ  gb_patent",
    "2+8  GZ  gb_other_nuc",
    "2+10 GZ  gb_other_nuc",
    "2+6  HA  embl_patent",
    "2+8  HA  embl_other_nuc",
    "2+10 HA  embl_other_nuc",
    "2+6  HB  embl_patent",
    "2+8  HB  embl_other_nuc",
    "2+10 HB  embl_other_nuc",
    "2+6  HC  embl_patent",
    "2+8  HC  embl_other_nuc",
    "2+10 HC  embl_other_nuc",
    "2+6  HD  embl_patent",
    "2+8  HD  embl_other_nuc",
    "2+10 HD  embl_other_nuc",
    "2+6  HE  embl_dirsub *",
    "2+8  HE  embl_other_nuc",
    "2+10 HE  embl_other_nuc",
    "2+6  HF  embl_dirsub *",
    "2+8  HF  embl_other_nuc",
    "2+10 HF  embl_other_nuc",
    "2+6  HG  embl_dirsub *",
    "2+8  HG  embl_other_nuc",
    "2+10 HG  embl_other_nuc",
    "2+6  HH  embl_patent",
    "2+8  HH  embl_other_nuc",
    "2+10 HH  embl_other_nuc",
    "2+6  HI  embl_patent",
    "2+8  HI  embl_other_nuc",
    "2+10 HI  embl_other_nuc",
    "2+6  HJ  gb_patent",
    "2+8  HJ  gb_other_nuc",
    "2+10 HJ  gb_other_nuc",
    "2+6  HK  gb_patent",
    "2+8  HK  gb_other_nuc",
    "2+10 HK  gb_other_nuc",
    "2+6  HL  gb_patent",
    "2+8  HL  gb_other_nuc",
    "2+10 HL  gb_other_nuc",
    "2+6  HM  gb_dirsub *",
    "2+8  HM  gb_other_nuc",
    "2+10 HM  gb_other_nuc",
    "2+6  HN  gb_gss",
    "2+8  HN  gb_other_nuc",
    "2+10 HN  gb_other_nuc",
    "2+6  HO  gb_est",
    "2+8  HO  gb_other_nuc",
    "2+10 HO  gb_other_nuc",
    "2+6  HP  gb_tsa_nuc",
    "2+8  HP  gb_other_nuc",
    "2+10 HP  gb_other_nuc",
    "2+6  HQ  gb_dirsub *",
    "2+8  HQ  gb_other_nuc",
    "2+10 HQ  gb_other_nuc",
    "2+6  HR  gb_gss",
    "2+8  HR  gb_other_nuc",
    "2+10 HR  gb_other_nuc",
    "2+6  HS  gb_est",
    "2+8  HS  gb_other_nuc",
    "2+10 HS  gb_other_nuc",
    "2+6  HT  ddbj_tpa_con",
    "2+8  HT  ddbj_tpa_nuc",
    "2+10 HT  ddbj_tpa_nuc",
    "2+6  HU  ddbj_tpa_chromosome",
    "2+8  HU  ddbj_tpa_nuc",
    "2+10 HU  ddbj_tpa_nuc",
    "2+6  HV  ddbj_patent",
    "2+8  HV  ddbj_other_nuc",
    "2+10 HV  ddbj_other_nuc",
    "2+6  HW  ddbj_patent",
    "2+8  HW  ddbj_other_nuc",
    "2+10 HW  ddbj_other_nuc",
    "2+6  HX  ddbj_est",
    "2+8  HX  ddbj_other_nuc",
    "2+10 HX  ddbj_other_nuc",
    "2+6  HY  ddbj_est",
    "2+8  HY  ddbj_other_nuc",
    "2+10 HY  ddbj_other_nuc",
    "2+6  HZ  ddbj_patent",
    "2+8  HZ  ddbj_other_nuc",
    "2+10 HZ  ddbj_other_nuc",
    "2+6  JA  embl_patent",
    "2+8  JA  embl_other_nuc",
    "2+10 JA  embl_other_nuc",
    "2+6  JB  embl_patent",
    "2+8  JB  embl_other_nuc",
    "2+10 JB  embl_other_nuc",
    "2+6  JC  embl_patent",
    "2+8  JC  embl_other_nuc",
    "2+10 JC  embl_other_nuc",
    "2+6  JD  embl_patent",
    "2+8  JD  embl_other_nuc",
    "2+10 JD  embl_other_nuc",
    "2+6  JE  embl_patent",
    "2+8  JE  embl_other_nuc",
    "2+10 JE  embl_other_nuc",
    "2+6  JF  gb_dirsub",
    "2+8  JF  gb_other_nuc",
    "2+10 JF  gb_other_nuc",
    "2+6  JG  gb_est",
    "2+8  JG  gb_other_nuc",
    "2+10 JG  gb_other_nuc",
    "2+6  JH  gb_con",
    "2+8  JH  gb_other_nuc",
    "2+10 JH  gb_other_nuc",
    "2+6  JI  gb_tsa_nuc",
    "2+8  JI  gb_other_nuc",
    "2+10 JI  gb_other_nuc",
    "2+6  JJ  gb_gss",
    "2+8  JJ  gb_other_nuc",
    "2+10 JJ  gb_other_nuc",
    "2+6  JK  gb_est",
    "2+8  JK  gb_other_nuc",
    "2+10 JK  gb_other_nuc",
    "2+6  JL  gb_tsa_nuc",
    "2+8  JL  gb_other_nuc",
    "2+10 JL  gb_other_nuc",
    "2+6  JM  gb_gss",
    "2+8  JM  gb_other_nuc",
    "2+10 JM  gb_other_nuc",
    "2+6  JN  gb_dirsub *",
    "2+8  JN  gb_other_nuc",
    "2+10 JN  gb_other_nuc",
    "2+6  JO  gb_tsa_nuc",
    "2+8  JO  gb_other_nuc",
    "2+10 JO  gb_other_nuc",
    "2+6  JP  gb_tsa_nuc",
    "2+8  JP  gb_other_nuc",
    "2+10 JP  gb_other_nuc",
    "2+6  JQ  gb_dirsub",
    "2+8  JQ  gb_other_nuc",
    "2+10 JQ  gb_other_nuc",
    "2+6  JR  gb_tsa_nuc",
    "2+8  JR  gb_other_nuc",
    "2+10 JR  gb_other_nuc",
    "2+6  JS  gb_gss",
    "2+8  JS  gb_other_nuc",
    "2+10 JS  gb_other_nuc",
    "2+6  JT  gb_tsa_nuc",
    "2+8  JT  gb_other_nuc",
    "2+10 JT  gb_other_nuc",
    "2+6  JU  gb_tsa_nuc",
    "2+8  JU  gb_other_nuc",
    "2+10 JU  gb_other_nuc",
    "2+6  JV  gb_tsa_nuc",
    "2+8  JV  gb_other_nuc",
    "2+10 JV  gb_other_nuc",
    "2+6  JW  gb_tsa_nuc",
    "2+8  JW  gb_other_nuc",
    "2+10 JW  gb_other_nuc",
    "2+6  JX  gb_dirsub",
    "2+8  JX  gb_other_nuc",
    "2+10 JX  gb_other_nuc",
    "2+6  JY  gb_gss",
    "2+8  JY  gb_other_nuc",
    "2+10 JY  gb_other_nuc",
    "2+6  JZ  gb_est",
    "2+8  JZ  gb_other_nuc",
    "2+10 JZ  gb_other_nuc",
    "2+6  KA  gb_tsa_nuc",
    "2+8  KA  gb_other_nuc",
    "2+10 KA  gb_other_nuc",
    "2+6  KB  gb_con",
    "2+8  KB  gb_other_nuc",
    "2+10 KB  gb_other_nuc",
    "2+6  KC  gb_dirsub",
    "2+8  KC  gb_other_nuc",
    "2+10 KC  gb_other_nuc",
    "2+6  KD  gb_con",
    "2+8  KD  gb_other_nuc",
    "2+10 KD  gb_other_nuc",
    "2+6  KE  gb_con",
    "2+8  KE  gb_other_nuc",
    "2+10 KE  gb_other_nuc",
    "2+6  KF  gb_dirsub *",
    "2+8  KF  gb_other_nuc",
    "2+10 KF  gb_other_nuc",
    "2+6  KG  gb_gss",
    "2+8  KG  gb_other_nuc",
    "2+10 KG  gb_other_nuc",
    "2+6  KH  gb_patent",
    "2+8  KH  gb_other_nuc",
    "2+10 KH  gb_other_nuc",
    "2+6  KI  gb_con",
    "2+8  KI  gb_other_nuc",
    "2+10 KI  gb_other_nuc",
    "2+6  KJ  gb_dirsub *",
    "2+8  KJ  gb_other_nuc",
    "2+10 KJ  gb_other_nuc",
    "2+6  KK  gb_con",
    "2+8  KK  gb_other_nuc",
    "2+10 KK  gb_other_nuc",
    "2+6  KL  gb_con",
    "2+8  KL  gb_other_nuc",
    "2+10 KL  gb_other_nuc",
    "2+6  KM  gb_dirsub *",
    "2+8  KM  gb_other_nuc",
    "2+10 KM  gb_other_nuc",
    "2+6  KN  gb_con",
    "2+8  KN  gb_other_nuc",
    "2+10 KN  gb_other_nuc",
    "2+6  KO  gb_gss",
    "2+8  KO  gb_other_nuc",
    "2+10 KO  gb_other_nuc",
    "2+6  KP  gb_dirsub",
    "2+8  KP  gb_other_nuc",
    "2+10 KP  gb_other_nuc",
    "2+6  KQ  gb_con",
    "2+8  KQ  gb_other_nuc",
    "2+10 KQ  gb_other_nuc",
    "2+6  KR  gb_dirsub",
    "2+8  KR  gb_other_nuc",
    "2+10 KR  gb_other_nuc",
    "2+6  KS  gb_gss",
    "2+8  KS  gb_other_nuc",
    "2+10 KS  gb_other_nuc",
    "2+6  KT  gb_dirsub",
    "2+8  KT  gb_other_nuc",
    "2+10 KT  gb_other_nuc",
    "2+6  KU  gb_dirsub",
    "2+8  KU  gb_other_nuc",
    "2+10 KU  gb_other_nuc",
    "2+6  KV  gb_con",
    "2+8  KV  gb_other_nuc",
    "2+10 KV  gb_other_nuc",
    "2+6  KW  gb_other_nuc",
    "2+8  KW  gb_other_nuc",
    "2+10 KW  gb_other_nuc",
    "2+6  KX  gb_dirsub",
    "2+8  KX  gb_other_nuc",
    "2+10 KX  gb_other_nuc",
    "2+6  KY  gb_dirsub",
    "2+8  KY  gb_other_nuc",
    "2+10 KY  gb_other_nuc",
    "2+6  KZ  gb_con",
    "2+8  KZ  gb_other_nuc",
    "2+10 KZ  gb_other_nuc",
    "2+6  LA  ddbj_tsa_nuc",
    "2+8  LA  ddbj_other_nuc",
    "2+10 LA  ddbj_other_nuc",
    "2+6  LB  ddbj_gss",
    "2+8  LB  ddbj_other_nuc",
    "2+10 LB  ddbj_other_nuc",
    "2+6  LC  ddbj_dirsub",
    "2+8  LC  ddbj_other_nuc",
    "2+10 LC  ddbj_other_nuc",
    "2+6  LD  ddbj_con",
    "2+8  LD  ddbj_other_nuc",
    "2+10 LD  ddbj_other_nuc",
    "2+6  LE  ddbj_tsa_nuc",
    "2+8  LE  ddbj_other_nuc",
    "2+10 LE  ddbj_other_nuc",
    "2+6  LF  ddbj_patent",
    "2+8  LF  ddbj_other_nuc",
    "2+10 LF  ddbj_other_nuc",
    "2+6  LG  ddbj_patent # from Korea",
    "2+8  LG  ddbj_other_nuc",
    "2+10 LG  ddbj_other_nuc",
    "2+6  LH  ddbj_tsa_nuc",
    "2+8  LH  ddbj_other_nuc",
    "2+10 LH  ddbj_other_nuc",
    "2+6  LI  ddbj_tsa_nuc",
    "2+8  LI  ddbj_other_nuc",
    "2+10 LI  ddbj_other_nuc",
    "2+6  LJ  ddbj_tsa_nuc",
    "2+8  LJ  ddbj_other_nuc",
    "2+10 LJ  ddbj_other_nuc",
    "2+6  LK  embl_dirsub *",
    "2+8  LK  embl_other_nuc",
    "2+10 LK  embl_other_nuc",
    "2+6  LL  embl_dirsub",
    "2+8  LL  embl_other_nuc",
    "2+10 LL  embl_other_nuc",
    "2+6  LM  embl_dirsub *",
    "2+8  LM  embl_other_nuc",
    "2+10 LM  embl_other_nuc",
    "2+6  LN  embl_dirsub *",
    "2+8  LN  embl_other_nuc",
    "2+10 LN  embl_other_nuc",
    "2+6  LO  embl_dirsub *",
    "2+8  LO  embl_other_nuc",
    "2+10 LO  embl_other_nuc",
    "2+6  LP  embl_patent",
    "2+8  LP  embl_other_nuc",
    "2+10 LP  embl_other_nuc",
    "2+6  LQ  embl_patent",
    "2+8  LQ  embl_other_nuc",
    "2+10 LQ  embl_other_nuc",
    "2+6  LR  embl_dirsub * # embl_patent?",
    "2+8  LR  embl_other_nuc",
    "2+10 LR  embl_other_nuc",
    "2+6  LS  embl_dirsub # embl_patent?",
    "2+8  LS  embl_other_nuc",
    "2+10 LS  embl_other_nuc",
    "2+6  LT  embl_dirsub *",
    "2+8  LT  embl_other_nuc",
    "2+10 LT  embl_other_nuc",
    "2+6  LU  ddbj_est",
    "2+8  LU  ddbj_other_nuc",
    "2+10 LU  ddbj_other_nuc",
    "2+6  LV  ddbj_patent",
    "2+8  LV  ddbj_other_nuc",
    "2+10 LV  ddbj_other_nuc",
    "2+6  LW  ddbj_other_nuc",
    "2+8  LW  ddbj_other_nuc",
    "2+10 LW  ddbj_other_nuc",
    "2+6  LX  ddbj_patent",
    "2+8  LX  ddbj_other_nuc",
    "2+10 LX  ddbj_other_nuc",
    "2+6  LY  ddbj_patent # from Korea",
    "2+8  LY  ddbj_other_nuc",
    "2+10 LY  ddbj_other_nuc",
    "2+6  LZ  ddbj_patent",
    "2+8  LZ  ddbj_other_nuc",
    "2+10 LZ  ddbj_other_nuc",
    "2+6  MA  ddbj_patent",
    "2+8  MA  ddbj_other_nuc",
    "2+10 MA  ddbj_other_nuc",
    "2+6  MB  ddbj_patent",
    "2+8  MB  ddbj_other_nuc",
    "2+10 MB  ddbj_other_nuc",
    "2+6  MC  ddbj_patent",
    "2+8  MC  ddbj_other_nuc",
    "2+10 MC  ddbj_other_nuc",
    "2+6  MD  ddbj_patent",
    "2+8  MD  ddbj_other_nuc",
    "2+10 MD  ddbj_other_nuc",
    "2+6  ME  ddbj_patent",
    "2+8  ME  ddbj_other_nuc",
    "2+10 ME  ddbj_other_nuc",
    "2+6  MF  gb_dirsub",
    "2+8  MF  gb_other_nuc",
    "2+10 MF  gb_other_nuc",
    "2+6  MG  gb_dirsub",
    "2+8  MG  gb_other_nuc",
    "2+10 MG  gb_other_nuc",
    "2+6  MH  gb_dirsub",
    "2+8  MH  gb_other_nuc",
    "2+10 MH  gb_other_nuc",
    "2+6  MI  gb_patent",
    "2+8  MI  gb_other_nuc",
    "2+10 MI  gb_other_nuc",
    "2+6  MJ  gb_gss",
    "2+8  MJ  gb_other_nuc",
    "2+10 MJ  gb_other_nuc",
    "2+6  MK  gb_dirsub",
    "2+8  MK  gb_other_nuc",
    "2+10 MK  gb_other_nuc",
    "2+6  ML  gb_con",
    "2+8  ML  gb_other_nuc",
    "2+10 ML  gb_other_nuc",
    "2+6  MM  gb_patent",
    "2+8  MM  gb_other_nuc",
    "2+10 MM  gb_other_nuc",
    "2+6  MN  gb_dirsub",
    "2+8  MN  gb_other_nuc",
    "2+10 MN  gb_other_nuc",
    "2+6  MO  gb_patent",
    "2+8  MO  gb_other_nuc",
    "2+10 MO  gb_other_nuc",
    "2+6  MP  embl_patent",
    "2+8  MP  embl_other_nuc",
    "2+10 MP  embl_other_nuc",
    "2+6  MQ  embl_patent",
    "2+8  MQ  embl_other_nuc",
    "2+10 MQ  embl_other_nuc",
    "2+6  MR  embl_patent",
    "2+8  MR  embl_other_nuc",
    "2+10 MR  embl_other_nuc",
    "2+6  MS  embl_patent",
    "2+8  MS  embl_other_nuc",
    "2+10 MS  embl_other_nuc",
    "2+6  MT  gb_dirsub",
    "2+8  MT  gb_other_nuc",
    "2+10 MT  gb_other_nuc",
    "2+6  MU  gb_con",
    "2+8  MU  gb_other_nuc",
    "2+10 MU  gb_other_nuc",
    "2+6  MV  gb_patent",
    "2+8  MV  gb_other_nuc",
    "2+10 MV  gb_other_nuc",
    "2+6  MW  gb_dirsub",
    "2+8  MW  gb_other_nuc",
    "2+10 MW  gb_other_nuc",
    "2+6  MX  gb_patent",
    "2+8  MX  gb_other_nuc",
    "2+10 MX  gb_other_nuc",
    "2+6  MY  gb_patent",
    "2+8  MY  gb_other_nuc",
    "2+10 MY  gb_other_nuc",
    "2+6  MZ  gb_dirsub",
    "2+8  MZ  gb_other_nuc",
    "2+10 MZ  gb_other_nuc",
    "2+6  NC  unreserved_nuc # deliberately skipped",
    "2+8  NC  unreserved_nuc # deliberately skipped",
    "2+10 NC  unreserved_nuc # deliberately skipped",
    "2+6  NG  unreserved_nuc # deliberately skipped",
    "2+8  NG  unreserved_nuc # deliberately skipped",
    "2+10 NG  unreserved_nuc # deliberately skipped",
    "2+6  NM  unreserved_nuc # deliberately skipped",
    "2+8  NM  unreserved_nuc # deliberately skipped",
    "2+10 NM  unreserved_nuc # deliberately skipped",
    "2+6  NP  unreserved_nuc # deliberately skipped",
    "2+8  NP  unreserved_nuc # deliberately skipped",
    "2+10 NP  unreserved_nuc # deliberately skipped",
    "2+6  NR  unreserved_nuc # deliberately skipped",
    "2+8  NR  unreserved_nuc # deliberately skipped",
    "2+10 NR  unreserved_nuc # deliberately skipped",
    "2+6  NS  unreserved_nuc # deliberately skipped",
    "2+8  NS  unreserved_nuc # deliberately skipped",
    "2+10 NS  unreserved_nuc # deliberately skipped",
    "2+6  NT  unreserved_nuc # deliberately skipped",
    "2+8  NT  unreserved_nuc # deliberately skipped",
    "2+10 NT  unreserved_nuc # deliberately skipped",
    "2+6  NW  unreserved_nuc # deliberately skipped",
    "2+8  NW  unreserved_nuc # deliberately skipped",
    "2+10 NW  unreserved_nuc # deliberately skipped",
    "2+6  NZ  unreserved_nuc # deliberately skipped",
    "2+8  NZ  unreserved_nuc # deliberately skipped",
    "2+10 NZ  unreserved_nuc # deliberately skipped",
    "2+6  OA  embl_other_nuc",
    "2+8  OA  embl_other_nuc",
    "2+10 OA  embl_other_nuc",
    "2+6  OB  embl_other_nuc *",
    "2+8  OB  embl_other_nuc",
    "2+10 OB  embl_other_nuc",
    "2+6  OC  embl_other_nuc",
    "2+8  OC  embl_other_nuc",
    "2+10 OC  embl_other_nuc",
    "2+6  OD  embl_other_nuc",
    "2+8  OD  embl_other_nuc",
    "2+10 OD  embl_other_nuc",
    "2+6  OE  embl_other_nuc",
    "2+8  OE  embl_other_nuc",
    "2+10 OE  embl_other_nuc",
    "2+6  OF  ddbj_patent # from Korea",
    "2+8  OF  ddbj_other_nuc",
    "2+10 OF  ddbj_other_nuc",
    "2+6  OG  ddbj_patent",
    "2+8  OG  ddbj_other_nuc",
    "2+10 OG  ddbj_other_nuc",
    "2+6  OH  ddbj_est",
    "2+8  OH  ddbj_other_nuc",
    "2+10 OH  ddbj_other_nuc",
    "2+6  OI  ddbj_patent",
    "2+8  OI  ddbj_other_nuc",
    "2+10 OI  ddbj_other_nuc",
    "2+6  OJ  ddbj_patent",
    "2+8  OJ  ddbj_other_nuc",
    "2+10 OJ  ddbj_other_nuc",
    "2+6  OK  gb_dirsub",
    "2+8  OK  gb_other_nuc",
    "2+10 OK  gb_other_nuc",
    "2+6  OL  gb_dirsub",
    "2+8  OL  gb_other_nuc",
    "2+10 OL  gb_other_nuc",
    "2+6  OM  gb_dirsub",
    "2+8  OM  gb_other_nuc",
    "2+10 OM  gb_other_nuc",
    "2+6  ON  gb_dirsub",
    "2+8  ON  gb_other_nuc",
    "2+10 ON  gb_other_nuc",
    "2+6  OO  gb_patent",
    "2+8  OO  gb_other_nuc",
    "2+10 OO  gb_other_nuc",
    "2+6  OP  gb_dirsub",
    "2+8  OP  gb_other_nuc",
    "2+10 OP  gb_other_nuc",
    "2+6  OQ  gb_dirsub",
    "2+8  OQ  gb_other_nuc",
    "2+10 OQ  gb_other_nuc",
    "2+6  OR  gb_other_nuc",
    "2+8  OR  gb_other_nuc",
    "2+10 OR  gb_other_nuc",
    "2+6  OS  gb_other_nuc",
    "2+8  OS  gb_other_nuc",
    "2+10 OS  gb_other_nuc",
    "2+6  OT  gb_other_nuc",
    "2+8  OT  gb_other_nuc",
    "2+10 OT  gb_other_nuc",
    "2+6  O?  embl_other_nuc",
    "2+8  O?  embl_other_nuc",
    "2+10 O?  embl_other_nuc",
    "2+6  PA  ddbj_patent",
    "2+8  PA  ddbj_other_nuc",
    "2+10 PA  ddbj_other_nuc",
    "2+6  PB  ddbj_patent",
    "2+8  PB  ddbj_other_nuc",
    "2+10 PB  ddbj_other_nuc",
    "2+6  PC  ddbj_patent",
    "2+8  PC  ddbj_other_nuc",
    "2+10 PC  ddbj_other_nuc",
    "2+6  PD  ddbj_patent",
    "2+8  PD  ddbj_other_nuc",
    "2+10 PD  ddbj_other_nuc",
    "2+6  PE  ddbj_patent # from Korea",
    "2+8  PE  ddbj_other_nuc",
    "2+10 PE  ddbj_other_nuc",
    "2+6  TI  unreserved_nuc # deliberately skipped",
    "2+8  TI  unreserved_nuc # deliberately skipped",
    "2+10 TI  unreserved_nuc # deliberately skipped",
    "2+6  WP  unreserved_nuc # deliberately skipped",
    "2+8  WP  unreserved_nuc # deliberately skipped",
    "2+10 WP  unreserved_nuc # deliberately skipped",
    "2+6  XM  unreserved_nuc # deliberately skipped",
    "2+8  XM  unreserved_nuc # deliberately skipped",
    "2+10 XM  unreserved_nuc # deliberately skipped",
    "2+6  XP  unreserved_nuc # deliberately skipped",
    "2+8  XP  unreserved_nuc # deliberately skipped",
    "2+10 XP  unreserved_nuc # deliberately skipped",
    "2+6  XR  unreserved_nuc # deliberately skipped",
    "2+8  XR  unreserved_nuc # deliberately skipped",
    "2+10 XR  unreserved_nuc # deliberately skipped",
    "2+6  YP  unreserved_nuc # deliberately skipped",
    "2+8  YP  unreserved_nuc # deliberately skipped",
    "2+10 YP  unreserved_nuc # deliberately skipped",
    "2+6  ZP  unreserved_nuc # deliberately skipped",
    "2+8  ZP  unreserved_nuc # deliberately skipped",
    "2+10 ZP  unreserved_nuc # deliberately skipped",
    "2+6  ??  unreserved_nuc",
    "2+8  ??  unreserved_nuc",
    "2+10 ??  unreserved_nuc",
    "",
    "# Specially handled type-general Dbtag names; commented out for now in",
    "# favor of a hard-coded list.  (Uncommenting them will override it.)",
    "",
    "#gnl  SRA         general_nuc",
    "#gnl  ti          general_nuc",
    "#gnl  TR_ASSM_CH  general_nuc",
    "#gnl  TRACE_ASSM  general_nuc",
    "#gnl  TRACE_CHGR  general_nuc",
    "",
    "# SPECIAL CASES",
    "# Mostly in the same order as baseline assignments, but embl_tpa_prot",
    "# specials are at the very end because there are so many of them.  To",
    "# keep to a rough limit of 100 ranges per prefix, resort to *_other_nuc",
    "# for some heavily mixed ranges.",
    "",
    "# Some GenBank \"TPA\" 8-character protein accessions are really native.",
    "special2 DAA+5 gb_prot",
    ": 00001 2110-6 34794-5",
    "",
    "# Nominally ddbj_est.",
    "special2 C+5 ddbj_dirsub",
    ": 21595-827 2715-62 83-911 4689-767 75685-936 95573-642 9933-76",
    "",
    "# Nominally ddbj_dirsub.  Split out EST ranges, and give the benefit",
    "# of the doubt to sequences that look like ddbj_con, ddbj_genome,",
    "# ddbj_mrna, or ddbj_other_nuc.",
    "special2 D+5 ddbj_est",
    ": 00922 11487-2469 7812-21053",
    ": 6771-8109 70-83 5-96 8 200 3 5-6 8-15 7-24 7 9 32 4 81-8 90-310 2-8 20-6",
    ": 603-744 9018-624 993-30029 816-1599 2304-958 60-3769 71-4214 6-410 2-589",
    ": 640-5674 6-6684 42187-3617 60143-1376 420-685 708-2388",
    ": 90-3133 71-317 9-24 30 746-58 4179-5034 6-241 3-978 80-6873",
    ": 7099-8048 50-323 5-600 2-9603 5-70813 6447-7996",
    "# EST range counts: 62, 118, 101, 70, 1208, 45, and 91 respectively.",
    "special2 D+5 ddbj_other_nuc",
    ": 15075-7289 21355-6768 36686-42011 4612-9352 50936-60141 70900-6413 8209-89649",
    "",
    "special  F38006         embl_dirsub # Nominally embl_est.",
    "",
    "# Nominally gsdb_dirsub.  Split out EST, GSS, and STS ranges, and",
    "# give the benefit of the doubt to sequences that look like gb_cdna,",
    "# gb_con, gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special2 L+5 gb_est",
    ": 18857-8 9032-41 143-55 60 202-14 20451-61 5173-249 344-5 7 417-20 49-525",
    ": 6606-848 7444 30148 1968-2015 28-65 3494-675 4957-5007 773-843",
    ": 7453-515 607-59 974-8013 26-243 525-43 741 50-60 3 74 87 40420-4 3576-7 9-80",
    ": 4279-576 6401-582 914-7098 842-965 8818-73 9057-120 76101-31 81201-60",
    "special2 L+5 gb_sts",
    ": 00738-844 6-50 2-91 3-916 94-1014 996-2021 80-91 4198-215 7331-2 863",
    ": 17188-290 8193-255 23479-93 992 7 4693 826 5137 888 8178-418 20-2",
    ": 31430-7 40-89 4798-802 5580-1 6534 7208-88 9872-3 40034 40-1 351-2 1967",
    ": 7214-5 542 54-68 8016 76151 7669-70 4-83 5-6 9 878-83 993",
    "special  L48736-L48796  gb_gss",
    "special  L08881-L15794  gb_other_nuc # 6 EST ranges and 23 STS ranges",
    "",
    "# Nominally gsdb_dirsub.  Split out EST and STS ranges, and give the",
    "# benefit of the doubt to sequences that look like gb_cdna, gb_con,",
    "# gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special2 M+5 gb_est",
    ": 61953-2300",
    ": 75734-848 50-2 4-5 7 9-63 8-9 72 4 6-81 5 90 2-902 4-5 12 5 7-43 5-6 51 5",
    ": 64-5 88 6111-22 7851-9278 465-80184 5308-6179 8774-9469",
    ": 91216-22 387-403 80-511 2283-4 935 6605-21",
    "special2 M+5 gb_sts",
    ": 23606-10 80369-76 3631-9 4924-34 43 94585-622 35-43 55-62 5212-80 301-23",
    ": 8979-96",
    "",
    "# Early N accessions were assigned haphazardly, and sometimes ambiguously.",
    "# (These are all secondary accessions nowadays, though.)  \"*\" denotes what,",
    "# if anything, N????? (and usually also N?????.1) immediately resolves to.",
    "# Some unambiguous accessions don't resolve, and some ambiguous ones do.",
    "special  N00001  gb_embl        # (L29187+L00109+L00110 / AH005313.2) / X04516.1",
    "special  N00002  gb_embl_ddbj   # M31027.1 / X04469.1 = D00002",
    "special  N00003  gb_ddbj        # L29169.1 / D00003.1",
    "special  N00004  gb_ddbj        # *L29170.1 / D00004.1",
    "special  N00005  gb_embl_ddbj   # L29171.1 / V01385.1 / D00005.1",
    "special  N00006  gb_ddbj        # (M31028.1 / AH002572.2) / D00006.1",
    "special  N00007  gb_ddbj        # (M31029.1 / AH002572.2) / D00007.1",
    "special  N00008  gb_other_nuc   # *L29172.1",
    "special  N00009  gb_embl_ddbj   # M13655.1 / *X00532.1 / D00009.1 (= M13655.1)",
    "special  N00010  gb_embl_ddbj   # *L29174.1 / X04067.1 = D00010.1",
    "special  N00011  gb_embl        # *L29175.1 = V00749.1",
    "special  N00012  gb_embl_ddbj   # L29176.1 = V00751.1 / D00012.1",
    "special  N00013  gb_other_nuc   # L29177.1 / AH002712.2",
    "special  N00014  gb_ddbj        # (L29178.1 / AH005322.2) / D00014.1",
    "special  N00015  gb_ddbj        # (L29187.1 / AH005313.2) / D00015.1",
    "special  N00016  gb_ddbj        # (L29188.1 / AH005313.2) / D00016.1",
    "special  N00017  gb_ddbj        # *L29190.1 / (M14043 =) D00017.1",
    "special  N00018  gb_other_nuc   # *L29191.1 / AH002172.2; only unversioned",
    "special  N00019  gb_other_nuc   # *L29197.1",
    "special  N00020  gb_embl_ddbj   # (L29198.1 / AH002320.2) / X03632.1 = D00020.1",
    "special  N00021  gb_ddbj        # (L29199.1 / AH002320.2) / D00021.1",
    "special  N00022  gb_embl_ddbj   # L29390.1 / V01168.1 / D00022.1",
    "special  N00023  gb_ddbj        # (L29391.1 / AH000963.2) / D00023.1",
    "special  N00024  gb_ddbj        # *L29392.1 / (M13071.1 =) D00024.1",
    "special  N00025  gb_embl_ddbj   # L29393.1 / X00626.1 / D00025.1",
    "special  N00026  gb_ddbj        # L29394.1 (= *X00442.1) / D00026.1",
    "special  N00027  gb_other_nuc   # *L29395.1",
    "special  N00028  ddbj_other_nuc # D00028.1",
    "special  N00029  gb_ddbj        # *L29397.1 / D00029.1",
    "special  N00030  gb_ddbj        # M10126.1 / D00030.1",
    "special  N00031  gb_ddbj        # (*L29400.1 / AH002739.2) / D00031.1; unvers.",
    "special  N00032  gb_ddbj        # (L?????.1 / AH??????.2) / D00032.1",
    "special  N00033  gb_ddbj        # (L29401.1 / AH002776.2) / D00033.1",
    "special  N00034  gb_ddbj        # (L29424.1 / AH001823.2) / D00034.1",
    "special  N00035  ddbj_other_nuc # D00035.1",
    "special  N00036  gb_ddbj        # M31030.1 / D00036.1",
    "special  N00037  ddbj_other_nuc # D00037.1",
    "special  N00038  gb_ddbj        # M31031.1 / D00038.1",
    "special  N00039  gb_ddbj        # *L29427.1 / D00039.1",
    "special  N00040  gb_ddbj        # L29428.1 / D00040.1",
    "special  N00041  gb_other_nuc   # L29429.1 / *M13756.1 (= D00041)",
    "special  N00042  gb_ddbj        # (L29430.1 / AH002209.2) / (M13752 =) D00042.1",
    "special  N00043  gb_ddbj        # (L29431.1 / AH005585.2) / (M13753 =) D00043.1",
    "special  N00044  gb_ddbj        # L29432.1 / D00044.1",
    "special  N00045  gb_other_nuc   # (*L29433.1/AH002727.2); once also DDBJ?",
    "special  N00046  gb_other_nuc   # *L29434.1",
    "special  N00047  gb_ddbj        # (*L29435.1 / AH002481.2) / D00047.1",
    "special  N00048  gb_other_nuc   # *L29436.1",
    "special  N00049  gb_ddbj        # M31032.1 / D00049.1",
    "special  N00050  gb_ddbj        # (L29399.1 / AH002739.2) / D00050.1",
    "special  N00051  gb_ddbj        # (L?????.1 / AH??????.2) / D00051.1",
    "special  N00052  gb_other_nuc   # L29472.1 / *M14909.1 (= D00052.1)",
    "special  N00053  ddbj_other_nuc # D00053.1",
    "special  N00054  gb_other_nuc   # M31033.1",
    "special  N00055  gb_ddbj        # (L?????.1 / AH??????.2) / D00055.1",
    "special  N00056  gb_ddbj        # L39908.1 / D00056.1",
    "special  N00057  gb_embl        # M31034.1 / X05532.1",
    "special  N00058  gb_embl_ddbj   # M31035.1 (= X05163.1) / (X05537.1 =) D00058.1",
    "special  N00059  gb_ddbj        # M22232.1 / (X05538.1 =) D00059.1",
    "special  N00060  embl_other_nuc # X05541.1 (= D00060.1)",
    "special  N00061  ddbj_other_nuc # (X05531.1 =) D00061.1",
    "special  N00062  ddbj_other_nuc # (X05530.1 =) D00062.1",
    "special  N00063  ddbj_other_nuc # (X05529.1 =) D00063.1",
    "special  N00064  embl_other_nuc # X05528.1 (= D00064.1 = D10030.1)",
    "special  N00065  ddbj_other_nuc # (X05527.1 =) D00065.1 = D10031.1",
    "special  N00066  ddbj_other_nuc # D00066.1",
    "special  N00067  ddbj_other_nuc # (M20207.1 =) D00067.1",
    "special  N00068  ddbj_other_nuc # D00068.1",
    "special  N00069  ddbj_other_nuc # D00069.1",
    "special  N00070  embl_ddbj      # X04036.1 = D00070.1",
    "special  N00078  ddbj_other_nuc # D00078.1",
    "special  N00079  ddbj_other_nuc # D00079.1",
    "special  N00083  ddbj_other_nuc # D00083.1",
    "special  N00088  ddbj_other_nuc # (M16550.1 =) D00088.1 = D10032.1",
    "special  N00090  ddbj_other_nuc # (X05597.1 =) D00090.1",
    "special  N00091  ddbj_other_nuc # (M15807.1 =) D00091.1",
    "special  N00092  ddbj_other_nuc # D00092.1",
    "special  N00093  ddbj_other_nuc # (M34437.1 = X04797.1 =) D00093.1",
    "special  N00094  ddbj_other_nuc # (X05040.1 =) D00094.1",
    "special  N18624  gb_other_nuc   # *L29496.1 / M23263.1",
    "special  N20001-N97317  gb_est",
    "special  N97318-N97531  gb_gss",
    "special  N97532-N99999  gb_est",
    "",
    "# Nominally gb_est.",
    "special2 T+5 gb_gss",
    ": 02634-808 9496-993",
    "",
    "# Nominally gb_dirsub.",
    "special2 U+5 gb_est",
    ": 01537-51 921 13686 4111-4 71 5041-7 988 7154 513-64 82-4 905-9 76-7",
    ": 99-8008 10-7 9036 135-41 512-5 678-93 732 72 823 21073-81 3-5 457-70 33921",
    ": 4233-44 396-400 5429 6594-6 7151-64 229 31-4 913-35 7-8174 9396 407-8 588-607",
    ": 40055 140-3 53 589 629 1133-61 297 2490-1 570-9 751 3146",
    ": 4093-102 35-377 981-90 54592-607 706-33 5-9 79 5034 777 962-91 6653-60 7844",
    ": 8051-82 979 9417 9 755-6 60299-311 799 2909 3519 22-8 4597 679 965-6",
    ": 5082 383-9 438-9 740 917 6423 576-7 693-7 718",
    "special2 U+5 gb_gss",
    ": 19502-10 21493-545 37588 60606-38 1299-300 522-5 5903-5 6210-3 5 97486 8 90 3",
    "# Respective (EST, GSS, STS) range counts:",
    "# (21, 1, 0); (18, 1, 0); (30, 5, 0); (13, 5, 0); (103, 35, 1)",
    "special2 U+5 gb_other_nuc",
    ": 23049-6690 7989-31698 46160-53560 67850-70383 2041-95639",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST ranges.",
    "special2 X+5 embl_est",
    ": 61801-99 2402 5268-75 374-93 71637-41 3-52 3542-8 704-804 6318 487 8018-28",
    ": 82204 3032-4 304-66 4313 711-21 5546-725 6144-6 218-20 7300-5 9987-96",
    ": 90532-45 1308-35 672-734 2440 790-803",
    ": 3012-4 79 227-300 413-60 811-67 915-9 88-9 4486-532 5581 686 6619-25",
    ": 7503-19 896-7 8134-40 98-204 425-8 548-54 9272",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special2 Y+5 embl_est",
    ": 07823 8464-83 705-14",
    ": 9139 316-20 59-64 75-7 459-64 519-23 43-5 726-32 875 981-6",
    ": 10008-10 37-42 56-60 217-20 671-2 1191 308 615 4396-402 6130-1 971-4 8366",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special2 Z+5 embl_est",
    ": 24464-546 760-6",
    ": 9-5279 83-392 400-17 86-508 10-8 46-86 8-733 76-94 9-801 5-8 25-6 32-50",
    ": 89-6039 45-132 84-235 7-8 43-4 323-30 42-480 95-517 25-79 658-752 4-64 72-823",
    ": 68-74 952-66 71-7066 95-104 240 9-303",
    ": 38136-46221 43-8 91-8 428-30 510-20 6-94 677-718 813-22 30-2 974-80",
    ": 7057-65 278-348 50-1 82-408 575-720 801-2 985",
    ": 8368-427 45-8 53-67 545-60 608-11 37 9229-32 744-5 54295-305 9-11",
    ": 69578-84 945-72 4-5 83-4 71789-924 2392-421 4621-61 8280-408 81149-290",
    ": 2016-7 913-35 3019-66 980-4196 92674-705 3025-38 725-63 4848-63",
    ": 7038-47 731-830 62-72 8057-138 443-527 764-819 21-45 9067-89 348-435",
    "# 69 and 84 EST ranges, respectively.",
    "special2 Z+5 embl_other_nuc",
    ": 12653-23155 8355-38124",
    "",
    "# Nominally ddbj_dirsub.",
    "special2 AB+6 ddbj_est",
    ": 158145 279-87 432 9214-7 736-9 63429 31 6724 327169 31173-92 734-46 927-49",
    ": 4239 53143 4879 61047-52 241-4 92-358 4678-9 71430-572 2866-75",
    ": 3997-4042 263-5 5019-60 433981 4937-50 7321-44 46243-391 7894-981 8953-9020",
    ": 50689-761 8260-300 688-789 61364-72 71888-91 4609-19 21-714 6-21 6-39 41-8",
    ": 80784-824 5714-5 64-70 960-92 92065-83 505865-73 9259 16772-956 7053-143 5",
    ": 29438-45 35102-4 7328-9 42429-50 52736-841 3313-5 68279-90 71597-602 2918-21",
    ": 3693-709 5970-8 6812-50 85974-96 94978-5127 602400-24 13266 7526 26803 40724",
    ": 6299-300 21-45 68572-7 9437-64 709967-10073 34662-75 8045-62 42236-51",
    ": 57677-705 811436 23195-214 7265-7 62603-877 3290-461 99003-14 922020-116",
    "# 197 and 80 EST ranges, respectively.",
    "special2 AB+6 ddbj_other_nuc",
    ": 001540-128048 78168-308274",
    "",
    "# Nominally gb_dirsub.",
    "special2 AF+6 gb_est",
    ": 390017 858 1795 801-4 6-7 6868 405213-30 8415-6 11092-9 20231 5300 36075",
    ": 9734 6 961-72 41178-82 4-7 8511-2 51165-81 3-9 3446 4762 6411 61771 8668-72",
    ": 9688-92 86818-9 7314-25 7-9 92356 503187-9 588 6703-6 7053 8 60 10188-90",
    ": 6758-66 20437-9 964 1978-2027 5702 7684-733 33598-600 8926-7",
    "special2 AF+6 gb_gss",
    ": 384864-5 7113-21 96672 7194 400792-848 1241-71 16103-38 35833-7 40734",
    ": 1725 60-9 7921 9707-12 55790-802 65471-4 72511 92012-4 272 4494-5 509571",
    ": 15664-5 21604 4047-260 2-826 5774-5 9172 34530-3 7199-202 42503",
    "special  AF000235-AF373213  gb_other_nuc # 585 EST ranges and 303 GSS ranges",
    "",
    "special  AG266800-AG266855  ddbj_dirsub # Nominally ddbj_gss.",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST and",
    "# GSS ranges.",
    "special2 AJ+6 embl_est",
    ": 131530-1 4 640 743 2447-53 743-4 6-7 68 70 3279-310 423 627-30 823-32 87-91",
    ": 344568-620 5961-6853 7704-8 8845-907 441341-56950 7094-5 215-787 97-801",
    ": 995-8180 9102-5 60001-86853 646897-97608 763-4 8954 9509-703791 4820 66-927",
    ": 5105-15323 6425-7291 9195-266 21139-44704 5200-660 6228-32 346 581-7913",
    ": 9659-68 50001-67053 69-80913 1008-24 3757 4436-774 5005-280 96-566 755",
    ": 6842-809161 10177-8 2737-21279 81-793 924-9440 31476-83 580-6 846-2104",
    ": 3020-569 920420-36931 7840-2 4-6 8-51 3-4 6 8183-64871 6338 532-70 7011-5",
    ": 8963-85 70155-60 2495-503 3481-591",
    "# Respective (EST, GSS) range counts:",
    "# (37, 0); (106, 0); (46, 0); (41, 0); (46, 0); (55, 0); (63, 2).",
    "special2 AJ+6 embl_other_nuc",
    ": 003249-13072 223808-52067 69829-320073 88667-441054 87042-519345 32915-83526",
    ": 601557-46868 843898-920257",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST and GSS ranges.",
    "special2 AL+6 embl_est",
    ": 022607-715 30-3086 993-4449 59-60 33283-374 42366-3422 79357-851 3-77",
    ": 9-80030 2-55 110302-468 7695-8492 560-21566",
    ": 32634 45-7 95-706 81-90 802-17 29-37 910-42 3667-5743 7939-8463 519 57506-686",
    ": 62087-101",
    ": 3072-135 54 96 331-480 93-504 13-22 614-35 43 92-701 12-59 61-2 73-84 892-901",
    ": 352973-5 94-3006 958-85 4617-21 5193-214 755-64 890-912 4-5 7-8 60374-5136",
    ": 523-89869 91923-74 2063-7 441606-20 2-3 9467-917 50491-982 99630-500520",
    ": 42-12267 40321-1353 83964-9147 204-622 96479-603622",
    ": 63683-6314 6-416 8-705 7-821 3-7261 4-371 3-8474 6-875",
    ": 7-9016 8-138 40-810 2 90 994-7 91524-713628 805-37 4032-31499 899-2289 97-307",
    ": 49534-9 41-50301 3-1363 808211-23461 4717-31324 4580-7504 29-40622 45-932",
    ": 1430-4138 226-479 901610-28536 9474-90 609-35024 73-113",
    "special  AL160494-AL161251  embl_gss",
    "# Respective EST range counts:",
    "# 182, 72, 490, 393, 251, 3583, 1244, 3341, 5767, 638.",
    "special2 AL+6 embl_other_nuc",
    ": 034585-42364 3424-9170 513551-40319 1355-83950 93862-6018 627462-63681",
    ": 71927-83797 773605-805894 45558-901606 54873-73407",
    "",
    "# Nominally embl_dirsub.",
    "special2 AM+6 embl_est",
    ": 003907-39430 41272-897 9-928 2018-538 715-8613 9439-915 51087-9 366-5585",
    ": 6504-62638 766-3038 43-71350 401-5 8 10-1 520-2286 430-44 5249-607 83343-946",
    ": 5154-297 8777-109845 10258-692 1128-305 50-1 76-3422 870 5672-94 7760-79",
    ": 37442-56757 7797-8083 9647-60600 1052-90 647-2203 5128-7516 8256-69 526-76418",
    ": 7644-9408 80191-250 4308-228715 9723-30448 1596-607 751-2 2089-226",
    ": 3524 688-739 7575-81 631-802 8-28 59062-6 60753-90 1635-51 893-919",
    ": 3561-5360 78-89 633-7 7321-478 8883-94 79675 83547-4142 5455-649 6691",
    ": 7291-91980 2305 925-6 3570-88 624 5342-5 6550-384871 493773-867 5471-722",
    ": 6020-68 70-7466 8769-500636 8 2267-86 3942-52 4150-600638 95771-6203 311-688",
    ": 713476-43079 50062-65799 6003-73228 4151 9939-849033 823-50054 1127-82506",
    ": 950553-80446 1402-2512 822-3454 577-8621 91118-27 2040-7 256-457",
    "# 21, 23, and 183 EST ranges, respectively.",
    "special2 AM+6 embl_other_nuc",
    ": 384993-422606 743198-8699 894321-950290",
    "",
    "# Nominally ddbj_est.",
    "special2 AU+6 ddbj_dirsub",
    ": 024804-9241 46301-50022 808-15 62283-350",
    ": 6497-8 500 4 6 11-2 4-5 21-4 7-9 35 40-2 4 6 8-53 5 7-8 78429-598 90535",
    ": 279339 78",
    "special  AU036596-AU036726  ddbj_gss",
    "",
    "special  AX114121           embl_dirsub # Nominally embl_patent.",
    "",
    "# Nominally gb_dirsub.",
    "special2 AY+6 gb_est",
    ": 007260 30235-6 2615-6 902 79 3289 42532 8753 63513 93804-17 6240 120880",
    ": 5856-90 39011-23 60682 6588 8429-39 89691-2 5 96929-33 243511 5441 311391",
    ": 21461-2 5801-2 6073 45126 7477 56158-311 7293-5 77860-4 95905 449735-46",
    ": 57064-5 60108-11 5830-2 94600-4 517518 8259-64 47439-57 53914 60545-6 8-50",
    ": 77286-7 89693-4 700-1 4 8-10 651316 78444-9 9774-8 86735-47 8838-40 714068-71",
    ": 36327 40678 50901-4 88904 96341 803125-65 31429 79586-91 85220-1 922984-8",
    ": 8802-5 52968-70 66462-85 87852 94354-6",
    "special2 AY+6 gb_gss",
    ": 026952-7433 38985-7 9709-12 55854 79522-80585 123938 7080-557 56078-82",
    ": 60080-2 6650-1 74766-78 98434-201593 5-640 2-91 3-3610 44458 65801-4 70178-81",
    ": 82782-5 352272-3 66892-9 91730-44 489065-6 91396-8 580990-4 3837 648006-7",
    ": 65687 85649-61 758600-60022 98-631 40-1013 822675-7 31657-67 8273-7 57201",
    ": 66420-4 70328 2191-255 390-3704 98612 993980-4",
    "",
    "# Nominally embl_dirsub.",
    "special2 BX+6 embl_est",
    ": 000562-687 710-59 976-9 88730-119313 401-900 248593 783-982 6-9708 63-51408",
    ": 14-5275 9-804 79530-83066 8-4108 94120-1 98-232 5243-348 50-8 60-78 80-516 8",
    ": 318044-558 466087-922 7129-9883 70269-510298 1045-7 314-23 33-26833 5-30014",
    ": 48257-69683 601649-29297 361-40397 1173-7061 63509 77677-8768 77-9656",
    ": 76-81414 9-2226 40-527 59-952 6-769172 7-84021 33 44-278 81-385 834112-41509",
    ": 61004-521 3-681 3-2186 7358-914 72508-3028 9625-80165",
    ": 9494-90135 7-88 90-8 200-2 4-24 6-32 4-308 10-94 6-483 5-537 7754-9178",
    ": 82-901874 27416-8738 59-9267 50875-7214 366-7",
    "# Respective EST range counts:",
    "# 403, 815, 309, 42, 5821, 79, 573, 596, 51, 66, 76, 119, 343.",
    "special2 BX+6 embl_other_nuc",
    ": 072585-88684 255991-79521 96570-318042 560-21855 3813-465182 540327-980",
    ": 664722-77662 842705-61002 2188-7356 916-72506 3030-9623 80167-9492",
    ": 908815-27274",
    "",
    "# Nominally gb_genome.",
    "special2 CP+6 gb_dirsub",
    ": 000925 2027 6698 10455-6 3186 4940 92 6816",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special2 CR+6 embl_est",
    ": 278161-93495 407721-50243 7485-77643 502047 59947-89873 627501-8310 421-31118",
    ": 735161-49142 881-51205 41-527 621-2637 62-728 30-981",
    ": 3-3092 4-178 80-308 10-27 9-416 8-20 2-508 10-608 10-33 5-50 2-793 5-802 4-11",
    ": 907-9280 2-423 5-701 3-31 62499-4089 98-7811 22-9762 70518-4176 201-5849",
    ": 86583-8225 341-90347 90-2412 926157 498-878 80-6 8-910",
    ": 2-7049 51-214 6-367 9-455 7-78 80-552 4-31631 8765-40296 2245-70 5 825-4659",
    ": 74421 599-99998",
    "# 315, 307, 134, and 70 EST ranges, respectively.",
    "special2 CR+6 embl_other_nuc",
    ": 354614-94505 450855-7481 513801-59927 848861-57055",
    "",
    "# Nominally embl_dirsub.",
    "special2 CT+6 embl_est",
    ": 000001-5229 9777-10161 409-25 25916-7 485799-989 563249-71240 79-2707",
    ": 4594-83622 731-737118 258 62376-504 6185-353 73820-949 51-4143 912-5059",
    ": 7272-416 80757-877 1913-2070 2-90 2-100 2-10 2-24 6-50 2-83 5-7 9-321",
    ": 6112-237 92226-352 3397-519 4724-853",
    ": 842009-118 20-1 3-30 2-47 9-58 60-78 80-1 3-516 8-28 30-1 3-40 2-63709 15-33",
    ": 8744-928681 3-38375 43670-50687 62514-3069 97-104 71504-71",
    ": 8604 6-46 8-9 51-2 4 6-77 9 81 3 5-926 8-56 8-89251 8-90465 74-86 90-531",
    "# Respective EST range counts:",
    "# 1381, 153, 322, 37, 84, 137, 39, 147, 219, 36, 48, 2036, 367",
    "special2 CT+6 embl_other_nuc",
    ": 737431-62374 507-6183 355-73818 4146-910 5061-7270 418-80755 879-1911",
    ": 2323-6110 239-92224 354-3395 521-4722 855-823556 938377-40347",
    "",
    "# Nominally embl_dirsub.",
    "special2 CU+6 embl_est",
    ": 062670-842 4-6 8-74269 339-82 423-5311 931-6039 234182-94 302207 9-16 324",
    ": 6818-10069 76-1182 67886-8379 81-441 3-521 3-6 8-600 2-745 7-50",
    ": 2-9046 8-187 9-553 5-65 7-72896 931-92058 4257-405559 15883-24422 74 96-42700",
    ": 64-57374 87231-98825 9388-524144 6-85 7-607 9-47",
    ": 9-5008 10-305 7-17 9-433 5-727 9-806 8-920 2-30337 421-8870 9140-50647",
    ": 735-65320 96016-606845 7105-11033 62-8304 43-27974 8007-33156 7754-8663",
    ": 9489-40365 490-880 60014-72219 81473-818",
    ": 2012-338 67-456 8-575 7-600 2-3 5-21 3-39 41-61 3-763 5-6 8-76 8-9 81-810",
    ": 2-3823 8-64 4056-6587 93503-4195 5349-740080 862081-96531 700-905499",
    ": 513-14123 83906-4539 6307-93795 823-9999",
    "# Respective (EST, GSS) range counts: (81, 1); (43, 0); (231, 0); (41, 0).",
    "special2 CU+6 embl_other_nuc",
    ": 457503-87206 98835-9386 565322-96014 651679-60012",
    "",
    "# Nominally ddbj_gss.",
    "special2 DE+6 ddbj_dirsub",
    ": 990447-894 7363-8419",
    "",
    "# Nominally gb_dirsub.",
    "special2 DQ+6 gb_est",
    ": 000203-5 3271-4 5448-52 6915-21 8074-87 9493 10056 23561-96 54537 6320-36",
    ": 62432 8265-7 71657-67 9655-7 82731 90495-9 118389-93 9294 38061-9 59946-7",
    ": 72857-99 90447-9 205195-9 7956 11055-83 697 7772 25105-7 38007-10 56365-8",
    ": 86755-9 96475-80 301872-6 6698-705 41431-41 9205-6 51838-40 4361 94888-90",
    ": 672588 821447-72 2605-89 58157-64 73299-317 83824-4159 6384-9 999011-23",
    "special2 DQ+6 gb_gss",
    ": 072281-378 3526-30 92578-99 3275-84 103519-23 14785 5593-640 24861-7 31496",
    ": 7423-5 56350-63 60233-40 76001-2 8992-4 219385-92 323032-5 9527-9 34866",
    ": 51716-21 99337-8 530238 641039 866805 988883-928",
    "",
    "# Nominally gb_con.",
    "special2 DS+6 gb_dirsub",
    ": 483562 659",
    ": 4496-515 8-35 8-50 2-3 5-74 6-611 4-23 5-6 8-33 5-7 9 41-54 6-75 7-86 8-703",
    ": 6-7 9-10 2-6 8-42",
    ": 5148-67 9 72-4 6-8 81-2 4 6 9-90 2 4-5 8-201 3-5 8-9 11 5-6 8-21 3-30 3 5-6",
    ": 8-40 2-3 5-7 9-68 70-1 3 5 7-8 80-1 3-5 7-8 90-2 4 6-306 9-11 3-6 8-20 2-6",
    ": 8-31 3-43 5 9 51 3-4 6-65 8 70-1 4-6 8-9 81-90 2-3 5 7-401 3 7 9-11 5-6 8-30",
    ": 3-4 6-43 8 50-4 6-7 9-62 4-73 5-8 81-3 8 90-2 4-8 500-1 3-6 9 12 4-5 7-8 20-3",
    ": 5-45",
    "# 159, 80, and 95 dirsub ranges, respectively.",
    "special2 DS+6 gb_other_nuc",
    ": 483744-4493 745-5146 547-6008",
    "",
    "# Nominally gb_dirsub.",
    "special2 EF+6 gb_est",
    ": 063001 189906-16 377525-37 422869 73211-5 94771-3 552376",
    "special2 EF+6 gb_gss",
    ": 053039-49 95769 165098 82756-8 204530-3 8191 10438-53 578434-635 92824-944",
    "",
    "# Nominally gb_dirsub.",
    "special2 EU+6 gb_est",
    ": 152056-79 239816 364506-7 8044 9669 420034 597223-8",
    "special  EU306364-EU306386  gb_gss",
    "",
    "# Nominally gb_dirsub.",
    "special2 FJ+6 gb_est",
    ": 710154-5 842632-42",
    "",
    "# Nominally embl_dirsub.",
    "special2 FM+6 embl_est",
    ": 000001-160408 4769 940 5392 707-72746 8562-778 80579-96445 205236-493 777-831",
    ": 7878-900 8280-711 851 900 12937 5048-42054 6886-51871 3361 6-8 72 8 864313-44",
    ": 7-5295 8295-72275 9143-81767 2258-3162 5959-6821 7038-96881 7212-3",
    ": 377-945301 441-999 6183-54971 7013-79 8532-85957 92847-50 9776-87",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special2 FN+6 embl_est",
    ": 000001-177896 9489-82188 288-5725 6135-90445 7-252183 460-789 63376-92969",
    ": 377870-86264 93571-732 830-49 424437-8571 30839-1219 34-660",
    ": 2032-41 154-328 729-75 3834-7 5336-50 539079-43092 51261-733 2552-91 699-705",
    ": 5710-987 7216-23 61898-924 2175-396 4151-8 5576-6839 88437-94512 600697",
    ": 1407-10843 1035-40462 581-1653 925-3079 6764-7626 51825-6 2903-4 61971-2351",
    ": 4012-5290 9777-73545 9295-86775 91927 2044-706436 565-73062 104-70 96618-723",
    ": 987-806772 826-48 11794-851 944-2314 3225-6 467-9 4310-20203 2244-743 3242-54",
    ": 68597 902-29 9177-376 70962-907899 8254-302 85040 644-93914 7680-8838",
    ": 9023-906",
    "",
    "# Nominally embl_dirsub.",
    "special2 FO+6 embl_est",
    ": 000003-76577 82887-117570 633-81358 544-203352 528-393391 680693-1285",
    ": 704924-22023 981374-99999",
    "",
    "# Nominally embl_dirsub.",
    "special2 FP+6 embl_est",
    ": 000001-3579 602-9753 5-8 60-1 3-4 6-12228",
    ": 24615-57328 30-70 456-62 562-6 704-9",
    ": 8162-3 5 7 9 71-2 4 6-7 80 3-90 282 4 6 526-7 9 31-2 4 7 9 42-3 5 7-53 708-13",
    ": 9328 30-2 4 7 9 41 3 5 8-52 87-93 60212-7 1764-9 2315-21",
    ": 3036-40 449-53 804-12 900-4 5159-7333 453-74848 89705-949 90914-1223",
    ": 101920-50 4570-236120 870-43270 5546-312611 8637-25096 31359-9571",
    ": 630-40170 462-88 50355-60034 6-458874 6-75875 89021-539727 30-65142 937-78983",
    ": 9010-83343 56-628470 2-71119 40-80548 607-90338 50-700052 189-10243 58-91398",
    ": 400-884219 35-5524 45-822 927-93245 7-924936 7985-8978 90-5 9145-99998",
    "# Respective EST range counts: 33, 43, 39, 16, 141, 45, 33, 95, 44, 15, 248,",
    "# 14, 187, 22, 136, 104, 552, 234, 246, 39, 11, 166, 154, 35, 74, 208, 251.",
    "special2 FP+6 embl_other_nuc",
    ": 057373-454 65-560 8-656 64-702 11-8036 42-155 92-271 93-514 56-658 73-706",
    ": 15-9322 54-85 95-833 41-87 95-60210 9-469 77-1762 71-2313 24-896 906-99",
    ": 3008-34 43-447 55-802 14-98 906-4076 82-562 9-5157",
    "",
    "# Nominally embl_dirsub.",
    "special2 FQ+6 embl_est",
    ": 000001 5-14216 36-32656 836-73829 967-116746 8-209379 35350-42479",
    ": 312199-23093 164-61146 9-77486 8-516 98062-439981 3-40019 21-2 4 6 8 30-2",
    ": 4-56868 75-82045 8-71 660554-70147 790408-828345 8-57191 9091-175 87-65452",
    ": 7-908260 7-58209 13-76554 923-99999",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con or embl_genome, but split out EST and TPA(!)",
    "# ranges.",
    "special2 FR+6 embl_est",
    ": 595163-647444 60151-6602 8536 9245-6 86584 963-5 8150-9535 91564 7056-714330",
    ": 9326-692 26163-5 8240-1 9927-31105 4407-44448 6042-4 111-7822 8230-9648",
    ": 53167-4317 554-71822 3977 5966 819721-44 28827-31799 6483-7532 42-92",
    ": 9767-45655 6456-60 537-887 7124-45 228-840 88-943 8368-71 50135-57 1958",
    ": 2768 894-904 4398-6581 63689-4978 9720-95 73995-4005 7779-8008 32-40",
    "special2 FR+6 embl_tpa_nuc",
    ": 734011-74 49997 821738-54 2741 72817 7768-77",
    "",
    "special  GQ162211-GQ162212  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special2 GU+6 gb_est",
    ": 357827-40 85812",
    "",
    "# Nominally embl_dirsub.",
    "special2 HE+6 embl_est",
    ": 575663-7 8177-80 289-716 80226-8 600073-122 2495-530 12182 7969-46283",
    ": 81861-82 775617-92769 5538-641 9315-645 802076-106 58615-9937 62417-958",
    ": 957083-61812 2539 7924-57 81808-3324 5332-93548",
    "special2 HE+6 embl_tpa_nuc",
    ": 580237-8 3424-588 613800 804769-72 963851-4756 7761",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST, TPA(!), and WGS ranges.",
    "special2 HF+6 embl_est",
    ": 546137-200 978 66097-123 7775-843 952730-71 3988-4002",
    "special2 HF+6 embl_tpa_nuc",
    ": 564658-815 933207-30",
    "special  HF913790-HF920632  embl_wgs_nuc",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST and TPA(!) ranges.",
    "special2 HG+6 embl_est",
    ": 000495-664 1312-9 314154-951 26529-98 421036-67 4982-5075 516089-8058",
    ": 792878-996 8530-3 964498-527 5112-28 70048-64",
    "special2 HG+6 embl_tpa_nuc",
    ": 313979-4002 22958-3812 8835-9089 425120-3 6065-183 91497-512884 8794-28968",
    ": 31973-2008 780872-92014 931734-849 75377-438 7712-83278 548-6399",
    "",
    "special  HM042681           gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special2 HQ+6 gb_est",
    ": 385980-98 436350 596498-504 603829-54 16895-912 34394-477",
    "",
    "special  JN376805-JN377341  gb_est # Nominally gb_dirsub.",
    "",
    "special  KF487514           gb_est # Nominally gb_dirsub.",
    "",
    "special  KJ472321-KJ472336  gb_est # Nominally gb_dirsub.",
    "",
    "special  KM673248-KM673271  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally embl_dirsub.",
    "special2 LK+6 embl_tpa_nuc",
    ": 000001-20668 937705-9125",
    "special  LK985528-LK995307  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special2 LM+6 embl_tpa_nuc",
    ": 378690-83429 608092-11902 44135-234",
    "special  LM994684-LM994695  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, but split out EST and TPA(!) ranges.",
    "special2 LN+6 embl_est",
    ": 624403-4 51082-92 553-78462 80257-71 879549-837 901386-412",
    "special2 LN+6 embl_tpa_nuc",
    ": 607841-8991 714474-514 94245-6 809256-883 46618-9 7449-8230 9001 71971-2940",
    ": 4312-522 85135-43 5-62 4-70 2-202 4-36 98187-98 901194-210",
    "",
    "# Nominally embl_dirsub.",
    "special2 LR+6 embl_tpa_nuc",
    ": 130242-508 594708-9 760818-1312",
    "",
    "# Nominally embl_dirsub.",
    "special2 LT+6 embl_est",
    ": 159851-65 556286-8089",
    "special2 LT+6 embl_tpa_nuc",
    ": 548096-244 71433-5 605004 31550-670 906301-58 62964-3174 90249-597",
    "",
    "# Nominally (conservatively) embl_other_nuc.",
    "special  OB000001-OB660024  embl_con",
    "",
    "# Some \"EMBL\" WGS nucleotide accessions are really third-party annotations.",
    "special2 CAADSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAADSM000000000-CAAGJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKD000000000-CAAGKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKS000000000-CAAGRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGRK000000000-CAAGSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAAHDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAAHDO000000000-CAAHFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CABPVU000000000-CABUTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CABUTU000000000-CABVEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CABVEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CABVEX000000000-CABVGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEPO000000000-CADEVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEVJ000000000-CADFGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFHD000000000-CADFHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFIN000000000-CADFIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFIS000000000-CADFIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFJH000000000-CADFJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFJU000000000-CADFJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFKF000000000-CADFKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFLF000000000-CADFLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFMR000000000-CADFMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFNR000000000-CADFNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFNW000000000-CADFNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFOI000000000-CADFOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFOT000000000-CADFOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFOX000000000-CADFOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPF000000000-CADFPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPM000000000-CADFPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPX000000000-CADFPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFQP000000000-CADFQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFRV000000000-CADFRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFRY000000000-CADFSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFSS000000000-CADFST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFTF000000000-CADFTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFTJ000000000-CADFTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFTU000000000-CADFTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFUE000000000-CADFUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUH000000000-CADFUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUM000000000-CADFUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUQ000000000-CADFUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADKUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJJIC000000000-CAJJID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJJIG000000000-CAJJIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJJIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJJIQ000000000-CAJJJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJJJM000000000-CAJMTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJSFZ000000000-CAJSGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTIX000000000-CAJTJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTJE000000000-CAJTJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTJS000000000-CAJTJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTJY000000000-CAJTKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTKG000000000-CAJTKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTKU000000000-CAJTXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTXK000000000-CAJURP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJURR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJURT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJURV000000000-CAJUSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJUSD000000000-CAJUSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUSZ000000000-CAJUTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJUTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUTJ000000000-CAJUTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJUTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUTV000000000-CAJUTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJUTY000000000-CAJUUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJVVG000000000-CAJVVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJVVR000000000-CAJVVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJVVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJVWG000000000-CAJYBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJYCH000000000-CAJYCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJYLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJZDA000000000-CAJZFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZFU000000000-CAJZHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZHD000000000-CAJZHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJZHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJZHR000000000-CAJZHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZHV000000000-CAJZHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZIB000000000-CAJZJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZKB000000000-CAJZLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZLC000000000-CAJZLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZLJ000000000-CAJZLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJZLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJZLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJZLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKAEN000000000-CAKAIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKAOQ000000000-CAKASD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKMHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKMHW000000000-CAKMJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMKY000000000-CAKMLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMLJ000000000-CAKMLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMLM000000000-CAKMME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMMH000000000-CAKMMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKMMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKMMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKMMU000000000-CAKMMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMMX000000000-CAKMMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNB000000000-CAKMNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNH000000000-CAKMNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNX000000000-CAKMRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMRL000000000-CAKMRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKNFQ000000000-CAKNSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZFW000000000-CAKZJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZJV000000000-CAKZRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZSL000000000-CAKZSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZSR000000000-CAKZST999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZSW000000000-CAKZTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZTH000000000-CAKZTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKZTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZTR000000000-CAKZTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZTU000000000-CAKZTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZUC000000000-CAKZUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZUH000000000-CAKZUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZUW000000000-CAKZUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKZVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZVO000000000-CAKZVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZVV000000000-CAKZWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZWG000000000-CAKZWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZWR000000000-CAKZWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZXB000000000-CAKZYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZZB000000000-CALAHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAHT000000000-CALAIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIG000000000-CALAII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIK000000000-CALAIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIP000000000-CALAIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALAJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAJI000000000-CALAJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAJW000000000-CALAJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKA000000000-CALAKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKF000000000-CALAKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKI000000000-CALAKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKN000000000-CALAKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKS000000000-CALAKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKV000000000-CALAKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALALA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALALC000000000-CALAMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAMJ000000000-CALAMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAMR000000000-CALAMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAMY000000000-CALAMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALANB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALANE000000000-CALANI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALANK000000000-CALANX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOA000000000-CALAOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOD000000000-CALAOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOG000000000-CALAOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAPC000000000-CALBAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBAE000000000-CALBAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBAL000000000-CALBBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBBI000000000-CALBBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBBR000000000-CALBCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBCP000000000-CALBCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALBDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALBDC000000000-CALBDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBDH000000000-CALBDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBDP000000000-CALBDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBEH000000000-CALBEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBEM000000000-CALBUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBUJ000000000-CALBUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBUR000000000-CALBUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBVB000000000-CALBVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALBVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALBWE000000000-CALBWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBWL000000000-CALBWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBWT000000000-CALCDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCDE000000000-CALCIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCIP000000000-CALCJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALCJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALCJW000000000-CALCKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCKH000000000-CALCKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCKS000000000-CALCKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALCKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALCKZ000000000-CALCLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCLM000000000-CALCLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCLQ000000000-CALCMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCMF000000000-CALCMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCML000000000-CALCMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCMW000000000-CALCRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCRJ000000000-CALCUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCUX000000000-CALDAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDBA000000000-CALDBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDBI000000000-CALDCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCD000000000-CALDCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCM000000000-CALDCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCP000000000-CALDCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCU000000000-CALDDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDJ000000000-CALDDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDS000000000-CALDDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDW000000000-CALDDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDZ000000000-CALDEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEC000000000-CALDEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEQ000000000-CALDEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEX000000000-CALDEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDFC000000000-CALDFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDGB000000000-CALDGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGG000000000-CALDGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGO000000000-CALDGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGR000000000-CALDHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDHN000000000-CALDHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDIA000000000-CALDKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDKW000000000-CALDSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDUU000000000-CALDUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDUZ000000000-CALDVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVD000000000-CALDVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVQ000000000-CALDVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVX000000000-CALDVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWB000000000-CALDWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWH000000000-CALDWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWS000000000-CALDWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWX000000000-CALDWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXA000000000-CALDXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXK000000000-CALDXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXZ000000000-CALDYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDYD000000000-CALDYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDZM000000000-CALDZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEAA000000000-CALEAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAH000000000-CALEAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAR000000000-CALEAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAW000000000-CALEBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEBL000000000-CALEBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEBU000000000-CALECA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECC000000000-CALECD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECG000000000-CALECO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECR000000000-CALECS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECU000000000-CALECY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEDA000000000-CALEDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALEDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALEDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEDO000000000-CALEDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEDX000000000-CALEEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEED000000000-CALEPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEPF000000000-CALEPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEPL000000000-CALETK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETM000000000-CALETT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETV000000000-CALETW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETY000000000-CALEUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEUH000000000-CALEUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALEUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEUR000000000-CALEUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEUZ000000000-CALEVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEVS000000000-CALEVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWA000000000-CALEWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWG000000000-CALEWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWK000000000-CALEWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWZ000000000-CALEXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEXQ000000000-CALEXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYB000000000-CALEYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYE000000000-CALEYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYL000000000-CALFAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFAN000000000-CALFAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFAW000000000-CALFAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALFBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALFCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFCC000000000-CALFCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFCJ000000000-CALFCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFCW000000000-CALFCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDB000000000-CALFDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDJ000000000-CALFDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDO000000000-CALFDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDV000000000-CALFDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFEC000000000-CALFED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFEF000000000-CALFFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFFF000000000-CALFFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFFL000000000-CALFSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFSK000000000-CALFUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFUY000000000-CALFVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFXA000000000-CALGAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGAX000000000-CALGJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGKF000000000-CALGKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGKO000000000-CALGKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGKW000000000-CALGLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGLF000000000-CALGLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGLK000000000-CALGLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMG000000000-CALGMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMK000000000-CALGML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGMP000000000-CALGMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMU000000000-CALGMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGNB000000000-CALGNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGNL000000000-CALGNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGNQ000000000-CALGNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGOH000000000-CALGPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGPP000000000-CALGPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGQD000000000-CALGQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGQM000000000-CALGQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGQY000000000-CALGVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGVQ000000000-CALGVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWA000000000-CALGWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWI000000000-CALGWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWO000000000-CALGWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGWZ000000000-CALGXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGXC000000000-CALGXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGXO000000000-CALGXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGXW000000000-CALGXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGYC000000000-CALGYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGZE000000000-CALGZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGZP000000000-CALHAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHAC000000000-CALHAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHBG000000000-CALHBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHBM000000000-CALHBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHBS000000000-CALHBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHBX000000000-CALHCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHCR000000000-CALHDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHDH000000000-CALHDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHDZ000000000-CALHED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEF000000000-CALHEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEL000000000-CALHEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEP000000000-CALHFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHFH000000000-CALHFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHFR000000000-CALHGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHGF000000000-CALHGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHGK000000000-CALHGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHGR000000000-CALHGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHHA000000000-CALHHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHD000000000-CALHHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHI000000000-CALHHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHHR000000000-CALHHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHZ000000000-CALHIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHIC000000000-CALHIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHIM000000000-CALHIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHIY000000000-CALHJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJG000000000-CALHJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJL000000000-CALHJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJP000000000-CALHKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHKL000000000-CALHKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHKR000000000-CALHLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHLG000000000-CALHLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHLX000000000-CALHMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMD000000000-CALHMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMH000000000-CALHML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMN000000000-CALHMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMW000000000-CALHMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHND000000000-CALHNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHNL000000000-CALHNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHNT000000000-CALHNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHNY000000000-CALHOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOJ000000000-CALHOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOV000000000-CALHOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOY000000000-CALHPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHPL000000000-CALHPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHPV000000000-CALHQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHQD000000000-CALHQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHQZ000000000-CALHRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHRE000000000-CALHRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHRK000000000-CALHRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHRR000000000-CALHRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHRX000000000-CALHRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHSC000000000-CALHSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHSW000000000-CALHSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHTC000000000-CALHTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHTG000000000-CALHTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHTS000000000-CALHTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHUB000000000-CALHUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHUJ000000000-CALHUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHUN000000000-CALHUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHVE000000000-CALHVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVI000000000-CALHVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVQ000000000-CALHVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVY000000000-CALHWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHWL000000000-CALHWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHWP000000000-CALHXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHXD000000000-CALHXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHXJ000000000-CALHXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHXX000000000-CALHYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYF000000000-CALHYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYN000000000-CALHYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYZ000000000-CALHZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHZQ000000000-CALHZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHZW000000000-CALIAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIAH000000000-CALIAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIAV000000000-CALIBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIBS000000000-CALICB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALICD000000000-CALICL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALICN000000000-CALIDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDJ000000000-CALIDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDM000000000-CALIDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDS000000000-CALIEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEC000000000-CALIED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEF000000000-CALIEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEJ000000000-CALIEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEO000000000-CALIEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIES000000000-CALIFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIFN000000000-CALIFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIFZ000000000-CALIGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIGJ000000000-CALIGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIGS000000000-CALIHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHC000000000-CALIHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHG000000000-CALIHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHM000000000-CALIHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIHX000000000-CALIHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIID000000000-CALIIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIIM000000000-CALIIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIIQ000000000-CALIIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIIZ000000000-CALIJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIJF000000000-CALIJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIJK000000000-CALIJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIJN000000000-CALIJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIKA000000000-CALIKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIKY000000000-CALILA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALILC000000000-CALILO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALILQ000000000-CALIMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIMM000000000-CALIMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIMY000000000-CALINA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALINC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALING000000000-CALINI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALINK000000000-CALINL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALINN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALINR000000000-CALIOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIOF000000000-CALIOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOM000000000-CALIOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOU000000000-CALIOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOY000000000-CALIPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIPD000000000-CALIQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIQF000000000-CALIQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIQP000000000-CALIRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIRE000000000-CALIRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIRT000000000-CALISA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALISC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALISE000000000-CALISJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALISL000000000-CALISN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALISQ000000000-CALIST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALISV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALISX000000000-CALITB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITD000000000-CALITI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITK000000000-CALITL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITQ000000000-CALITU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITW000000000-CALIUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIUC000000000-CALIUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIUP000000000-CALIUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIUZ000000000-CALIVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVF000000000-CALIVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVO000000000-CALIVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVU000000000-CALIWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIWU000000000-CALIWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXB000000000-CALIXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXL000000000-CALIXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXO000000000-CALIXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXV000000000-CALIYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZC000000000-CALIZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZG000000000-CALIZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZJ000000000-CALIZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJAB000000000-CALJAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJAF000000000-CALJAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJAR000000000-CALJAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBA000000000-CALJBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBI000000000-CALJBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBO000000000-CALJBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBR000000000-CALJBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBU000000000-CALJBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCA000000000-CALJCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCG000000000-CALJCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCZ000000000-CALJDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJDI000000000-CALJDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDL000000000-CALJDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDP000000000-CALJDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDV000000000-CALJED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJIE000000000-CALJIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJII000000000-CALJIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIO000000000-CALJIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIR000000000-CALJIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIV000000000-CALJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJJA000000000-CALJJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJJD000000000-CALJJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJJS000000000-CALJJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJKA000000000-CALJMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJME000000000-CALJMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJMJ000000000-CALJMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJMV000000000-CALJMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJNF000000000-CALJNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNK000000000-CALJNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNS000000000-CALJNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNW000000000-CALJNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJON000000000-CALJPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJPK000000000-CALJPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJPR000000000-CALJPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJPU000000000-CALJQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJQL000000000-CALJQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJQY000000000-CALJRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJRX000000000-CALJSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSC000000000-CALJSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSR000000000-CALJSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSW000000000-CALJTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJTQ000000000-CALJTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJTW000000000-CALJVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJWM000000000-CALJWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJWP000000000-CALJWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJWU000000000-CALJWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJXC000000000-CALJXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXF000000000-CALJXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXP000000000-CALJXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXV000000000-CALJYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYD000000000-CALJYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYI000000000-CALJYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYS000000000-CALJYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYX000000000-CALJZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJZV000000000-CALKBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKBJ000000000-CALKBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKHJ000000000-CALKIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKC000000000-CALKKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKO000000000-CALKKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKW000000000-CALKLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKLG000000000-CALKLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLQ000000000-CALKLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLT000000000-CALKLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLY000000000-CALKMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKMD000000000-CALKME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKMG000000000-CALKMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALKMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKPG000000000-CALKPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKPN000000000-CALKPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKPZ000000000-CALKQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKQX000000000-CALKRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRL000000000-CALKRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRO000000000-CALKRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRV000000000-CALKRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKSA000000000-CALKTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKTI000000000-CALKTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKTV000000000-CALKUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKUX000000000-CALKUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKVB000000000-CALKVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKVQ000000000-CALKXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKYE000000000-CALKZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKZI000000000-CALKZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKZO000000000-CALKZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLAX000000000-CALLAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLBP000000000-CALLBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLBS000000000-CALLBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLBV000000000-CALLCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLCI000000000-CALLCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLCP000000000-CALLCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDB000000000-CALLDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDI000000000-CALLDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDM000000000-CALLDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDQ000000000-CALLDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEA000000000-CALLEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEJ000000000-CALLEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEO000000000-CALLEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLES000000000-CALLEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEY000000000-CALLEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFB000000000-CALLFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFI000000000-CALLFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFN000000000-CALLFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGB000000000-CALLGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGE000000000-CALLGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGL000000000-CALLGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGQ000000000-CALLGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGT000000000-CALLHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHJ000000000-CALLHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHM000000000-CALLHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHV000000000-CALLIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLIR000000000-CALLJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLJV000000000-CALLKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLMO000000000-CALLMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLMW000000000-CALLND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLNF000000000-CALLNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLNU000000000-CALLNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLOC000000000-CALLOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLOT000000000-CALLPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLPF000000000-CALLPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLQD000000000-CALLQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLQS000000000-CALLQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLRA000000000-CALLRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLRS000000000-CALLRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLRV000000000-CALLTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLTY000000000-CALLUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLUC000000000-CALLUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLVJ000000000-CALLVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLVZ000000000-CALLWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWC000000000-CALLWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWP000000000-CALLWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWW000000000-CALLXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLXL000000000-CALLYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLYJ000000000-CALMEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMEZ000000000-CALMHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMHR000000000-CALMKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMKR000000000-CALMRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMRJ000000000-CALMVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMVE000000000-CALMWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMWD000000000-CALNCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALNEE000000000-CALNHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALNPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALNRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPDC000000000-CAMPDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPDW000000000-CAMPDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPGF000000000-CAMPKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPLK000000000-CAMPOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPTU000000000-CAMPTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPTY000000000-CAMPUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPUE000000000-CAMPUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPUH000000000-CAMPUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPUW000000000-CAMPUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVA000000000-CAMPVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPVO000000000-CAMPVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVV000000000-CAMPVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVY000000000-CAMPWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPWN000000000-CAMPWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPWQ000000000-CAMPWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPWY000000000-CAMPXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPXG000000000-CAMPXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYB000000000-CAMPYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYS000000000-CAMPYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYX000000000-CAMPYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPZA000000000-CAMPZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPZD000000000-CAMPZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQAO000000000-CAMQAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQAT000000000-CAMQAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQAW000000000-CAMQBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQBG000000000-CAMQBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQBP000000000-CAMQBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQCD000000000-CAMQCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQCK000000000-CAMQCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQCR000000000-CAMQCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQDC000000000-CAMQDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMQDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQEN000000000-CAMQEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQEQ000000000-CAMQET999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQFA000000000-CAMQFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMQFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQFR000000000-CAMQFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQGL000000000-CAMQPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQQL000000000-CAMQTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQTS000000000-CAMQTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQTX000000000-CAMQUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQUF000000000-CAMQUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVB000000000-CAMQVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVF000000000-CAMQVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVW000000000-CAMQWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWL000000000-CAMQWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWR000000000-CAMQWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWU000000000-CAMQWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWZ000000000-CAMQZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQZN000000000-CAMQZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRAA000000000-CAMRAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRAT000000000-CAMRAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRBA000000000-CAMREN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMREP000000000-CAMRFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMRGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMRSF000000000-CAMRXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSBO000000000-CAMSEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSEM000000000-CAMSLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSLO000000000-CAMSTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSTY000000000-CAMTCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMTDX000000000-CAMTSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMTZD000000000-CAMUPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUPX000000000-CAMUSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUSG000000000-CAMUSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUSS000000000-CAMWBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWBP000000000-CAMWCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWCU000000000-CAMWEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWEC000000000-CAMXAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMXAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMXAS000000000-CAMXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXAX000000000-CAMXAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXBB000000000-CAMXBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMXBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMXCV000000000-CAMXCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXHZ000000000-CAMXUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXVC000000000-CAMYGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYGH000000000-CAMYGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYGS000000000-CAMYHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYHI000000000-CAMYIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYOQ000000000-CAMYPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMYPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMYPF000000000-CAMYTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYTY000000000-CAMZJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMZXK000000000-CANACM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANACO000000000-CANAFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAFJ000000000-CANAHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAIF000000000-CANAKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAMA000000000-CANASN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANASP000000000-CANATP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANATR000000000-CANATX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANATZ000000000-CANAUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAUM000000000-CANAZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAZJ000000000-CANAZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBAB000000000-CANBAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBAL000000000-CANBCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBCM000000000-CANBKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBKY000000000-CANBMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANCXK000000000-CANDNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANDOE000000000-CANDWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANDYS000000000-CANERT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNOB000000000-CANNPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNVC000000000-CANNWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNYW000000000-CANNZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOAG000000000-CANOAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOBF000000000-CANOOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOOR000000000-CANOQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOQQ000000000-CANPDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPDG000000000-CANPDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPDN000000000-CANPDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPDW000000000-CANPDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEA000000000-CANPEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEG000000000-CANPEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEK000000000-CANPEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPEQ000000000-CANPER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPET000000000-CANPEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEW000000000-CANPFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPFO000000000-CANPFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPFT000000000-CANPFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPFY000000000-CANPFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGB000000000-CANPGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGH000000000-CANPGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGK000000000-CANPGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPHE000000000-CANPIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPIX000000000-CANPJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPJF000000000-CANPJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJK000000000-CANPJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJP000000000-CANPJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJS000000000-CANPJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPKB000000000-CANPKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPKT000000000-CANPKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPKW000000000-CANPKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPLB000000000-CANPLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPMR000000000-CANPMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPMV000000000-CANPMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPMZ000000000-CANPNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPNS000000000-CANPNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPOC000000000-CANPOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPOH000000000-CANPOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPOS000000000-CANPOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPPA000000000-CANPPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPPE000000000-CANPPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPRF000000000-CANPRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPTS000000000-CANPTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPUC000000000-CANPUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPUG000000000-CANPUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANRQJ000000000-CANSGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSGE000000000-CANSNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSOA000000000-CANSTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSTO000000000-CANSXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSXC000000000-CANSXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSXI000000000-CANSZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSZE000000000-CANTAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTAM000000000-CANTDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTDX000000000-CANTFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTFN000000000-CANTKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJBL000000000-CAOJBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJBO000000000-CAOJBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOJBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOJBX000000000-CAOJBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJCC000000000-CAOJCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJCT000000000-CAOJWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJWM000000000-CAOJZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJZG000000000-CAOKAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKAG000000000-CAOKEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKEH000000000-CAOKFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKFG000000000-CAOKNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKNN000000000-CAOKRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKRM000000000-CAOKRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKRP000000000-CAOKSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKSU000000000-CAOKTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKTU000000000-CAOKTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKTX000000000-CAOKXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKXC000000000-CAOKXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOKXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOKXT000000000-CAOKXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKYC000000000-CAOKYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOKYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOKYK000000000-CAOKYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKYN000000000-CAOKYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKYX000000000-CAOKZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOKZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOKZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOKZM000000000-CAOKZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKZU000000000-CAOKZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOKZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLAE000000000-CAOLAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLAJ000000000-CAOLAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLAV000000000-CAOLAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLBB000000000-CAOLBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLBI000000000-CAOLBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLBL000000000-CAOLBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLBT000000000-CAOLBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLBW000000000-CAOLBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLCF000000000-CAOLCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLCJ000000000-CAOLCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLCR000000000-CAOLCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLCW000000000-CAOLCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLDA000000000-CAOLDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLDF000000000-CAOLDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLDO000000000-CAOLDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLEA000000000-CAOLEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLED000000000-CAOLEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLEL000000000-CAOLEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLEO000000000-CAOLEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLEX000000000-CAOLEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLFE000000000-CAOLFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLFK000000000-CAOLFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLFO000000000-CAOLFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLGO000000000-CAOLGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLGX000000000-CAOLGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLHA000000000-CAOLHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLHJ000000000-CAOLHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLHR000000000-CAOLHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLHV000000000-CAOLHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLIB000000000-CAOLIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLIH000000000-CAOLII999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLIZ000000000-CAOLJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLJI000000000-CAOLJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLJT000000000-CAOLJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLJZ000000000-CAOLKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLKD000000000-CAOLKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLKG000000000-CAOLKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLKL000000000-CAOLKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLLE000000000-CAOLLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLLI000000000-CAOLLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLLU000000000-CAOLLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLLX000000000-CAOLLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLMC000000000-CAOLMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLMF000000000-CAOLMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLML000000000-CAOLMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLMP000000000-CAOLMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLMU000000000-CAOLMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLND000000000-CAOLNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLNJ000000000-CAOLNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLNS000000000-CAOLNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLOA000000000-CAOLOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLOE000000000-CAOLOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLOK000000000-CAOLOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLOZ000000000-CAOLPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLPN000000000-CAOLPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLPV000000000-CAOLPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLQC000000000-CAOLQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLQI000000000-CAOLQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLQL000000000-CAOLQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLQT000000000-CAOLQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLQZ000000000-CAOLRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLRC000000000-CAOLRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLRF000000000-CAOLRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLRL000000000-CAOLRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLRP000000000-CAOLRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLSB000000000-CAOLSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLSH000000000-CAOLSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLSL000000000-CAOLSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLSS000000000-CAOLST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLTB000000000-CAOLTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLTE000000000-CAOLTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLTW000000000-CAOLTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLUF000000000-CAOLUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLUI000000000-CAOLUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLUO000000000-CAOLUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLUR000000000-CAOLUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLUU000000000-CAOLUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLUY000000000-CAOLUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLVH000000000-CAOLVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLVO000000000-CAOLVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLVR000000000-CAOLVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLVW000000000-CAOLVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLWD000000000-CAOLWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLWI000000000-CAOLWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLWU000000000-CAOLWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLXA000000000-CAOLXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLXF000000000-CAOLXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLXU000000000-CAOLXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOLYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLYM000000000-CAOLYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLYU000000000-CAOLZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLZE000000000-CAOLZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLZI000000000-CAOLZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOLZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOLZR000000000-CAOLZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLZV000000000-CAOLZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMAA000000000-CAOMAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMAN000000000-CAOMAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMAQ000000000-CAOMAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMAY000000000-CAOMBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBD000000000-CAOMBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBK000000000-CAOMBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBO000000000-CAOMBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMBV000000000-CAOMBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBZ000000000-CAOMCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMCG000000000-CAOMCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMCS000000000-CAOMCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMDA000000000-CAOMDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMDH000000000-CAOMDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMDS000000000-CAOMDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMDZ000000000-CAOMEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMEC000000000-CAOMEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMEH000000000-CAOMEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMEL000000000-CAOMEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMES000000000-CAOMEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMFD000000000-CAOMFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMFH000000000-CAOMFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMFX000000000-CAOMGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMGM000000000-CAOMGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMGV000000000-CAOMHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMHD000000000-CAOMHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMHJ000000000-CAOMHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMHP000000000-CAOMHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMHW000000000-CAOMHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMIH000000000-CAOMII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMIL000000000-CAOMIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMIP000000000-CAOMIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMIT000000000-CAOMIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMJC000000000-CAOMJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMJH000000000-CAOMJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMJN000000000-CAOMKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMKH000000000-CAOMKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMKN000000000-CAOMKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMKW000000000-CAOMKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMLA000000000-CAOMLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMLD000000000-CAOMLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMLM000000000-CAOMLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMLQ000000000-CAOMLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMLW000000000-CAOMLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMMA000000000-CAOMME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMMH000000000-CAOMMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMMP000000000-CAOMMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMMU000000000-CAOMMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMMZ000000000-CAOMNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMNC000000000-CAOMNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMNH000000000-CAOMNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMNP000000000-CAOMNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMOD000000000-CAOMOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMOG000000000-CAOMOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMOU000000000-CAOMOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMOX000000000-CAOMPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMPD000000000-CAOMPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMPH000000000-CAOMPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMPR000000000-CAOMPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMQH000000000-CAOMQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMQL000000000-CAOMQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMQV000000000-CAOMQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMQY000000000-CAOMRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMRF000000000-CAOMRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMRI000000000-CAOMRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMRT000000000-CAOMRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMSA000000000-CAOMSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMSE000000000-CAOMSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMSJ000000000-CAOMSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMSQ000000000-CAOMSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMSV000000000-CAOMSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMTA000000000-CAOMTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMTG000000000-CAOMTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMTN000000000-CAOMTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMTT000000000-CAOMTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMUB000000000-CAOMUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMUP000000000-CAOMUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMUX000000000-CAOMVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMVD000000000-CAOMVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMVH000000000-CAOMVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMVQ000000000-CAOMVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMVT000000000-CAOMVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMVZ000000000-CAOMWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMWE000000000-CAOMWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMWJ000000000-CAOMWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMWP000000000-CAOMWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMXE000000000-CAOMXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMXN000000000-CAOMXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMXT000000000-CAOMXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMXZ000000000-CAOMYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMYL000000000-CAOMYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMYS000000000-CAOMYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMYV000000000-CAOMZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMZD000000000-CAOMZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOMZJ000000000-CAOMZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMZN000000000-CAOMZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOMZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOMZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONAH000000000-CAONAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONAN000000000-CAONAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONAS000000000-CAONAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONBE000000000-CAONBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONBU000000000-CAONBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONBY000000000-CAONCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONCE000000000-CAONCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONCL000000000-CAONCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONCO000000000-CAONCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONCR000000000-CAONCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONDF000000000-CAONDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONDK000000000-CAONDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONDO000000000-CAONDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONDZ000000000-CAONEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONEJ000000000-CAONEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONES000000000-CAONEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONFA000000000-CAONFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONFJ000000000-CAONFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONFO000000000-CAONFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONFZ000000000-CAONGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONGJ000000000-CAONGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONGS000000000-CAONGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONGV000000000-CAONGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONHG000000000-CAONHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONHK000000000-CAONHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONHT000000000-CAONHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONHY000000000-CAONIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONIC000000000-CAONIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONIL000000000-CAONIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONIV000000000-CAONIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONIZ000000000-CAONJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONJD000000000-CAONJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONJG000000000-CAONJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONJP000000000-CAONJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONJZ000000000-CAONKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONKR000000000-CAONKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONKU000000000-CAONKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONKY000000000-CAONLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONLE000000000-CAONLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONLN000000000-CAONLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONLR000000000-CAONLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONLU000000000-CAONMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONMI000000000-CAONMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONMR000000000-CAONMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONMV000000000-CAONMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONNX000000000-CAONNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONOH000000000-CAONOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONOK000000000-CAONOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONOO000000000-CAONOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONPQ000000000-CAONPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONPX000000000-CAONPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONQM000000000-CAONQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONRA000000000-CAONRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONRN000000000-CAONRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONRR000000000-CAONRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONRX000000000-CAONRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONSF000000000-CAONSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONSJ000000000-CAONSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONSM000000000-CAONSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONSS000000000-CAONSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONSY000000000-CAONTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONTV000000000-CAONTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONUB000000000-CAONUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONUI000000000-CAONUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONUS000000000-CAONUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONUY000000000-CAONVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONVE000000000-CAONVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONVH000000000-CAONVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONVK000000000-CAONVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONVU000000000-CAONVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONWD000000000-CAONWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONWH000000000-CAONWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONWP000000000-CAONWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONWU000000000-CAONXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONXF000000000-CAONXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONYB000000000-CAONYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONYE000000000-CAONYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONYK000000000-CAONYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONYQ000000000-CAONYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONZC000000000-CAONZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONZG000000000-CAONZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAONZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAONZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAONZR000000000-CAONZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOAE000000000-CAOOAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOAJ000000000-CAOOAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOAM000000000-CAOOAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOAT000000000-CAOOAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOAX000000000-CAOOAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOBB000000000-CAOOBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOBG000000000-CAOOBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOBJ000000000-CAOOBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOBO000000000-CAOOBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOBS000000000-CAOOBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOBX000000000-CAOOBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOCH000000000-CAOOCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOCN000000000-CAOOCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOCT000000000-CAOOCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOCY000000000-CAOOCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOODB000000000-CAOODD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOODK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOODM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOODQ000000000-CAOODR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOODX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOEA000000000-CAOOED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOEK000000000-CAOOEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOEW000000000-CAOOEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOFL000000000-CAOOFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOFR000000000-CAOOFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOGC000000000-CAOOGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOGP000000000-CAOOGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOGV000000000-CAOOGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOGZ000000000-CAOOHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOHD000000000-CAOOHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOHJ000000000-CAOOHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOHZ000000000-CAOOIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOID000000000-CAOOIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOIN000000000-CAOOIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOIR000000000-CAOOIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOIY000000000-CAOOJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOJS000000000-CAOOJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOKA000000000-CAOOKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOKD000000000-CAOOKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOKI000000000-CAOOKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOKO000000000-CAOOKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOLA000000000-CAOOLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOLD000000000-CAOOLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOLK000000000-CAOOLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOLO000000000-CAOOLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOLZ000000000-CAOOMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOMG000000000-CAOOML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOMQ000000000-CAOOMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOMT000000000-CAOOMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOMW000000000-CAOONA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOONG000000000-CAOONM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOONO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOONQ000000000-CAOONR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOONT000000000-CAOONU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOONZ000000000-CAOOOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOOK000000000-CAOOOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOOQ000000000-CAOOOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOOY000000000-CAOOPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOPH000000000-CAOOPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOPM000000000-CAOOPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOPT000000000-CAOOPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOPZ000000000-CAOOQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOQC000000000-CAOOQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOQJ000000000-CAOOQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOQP000000000-CAOOQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOORD000000000-CAOORE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOORG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOORJ000000000-CAOORK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOORM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOORO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOORQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOORT000000000-CAOORU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOORW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOSF000000000-CAOOSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOSK000000000-CAOOSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOSR000000000-CAOOSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOSU000000000-CAOOSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOTA000000000-CAOOTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOTX000000000-CAOOTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOUD000000000-CAOOUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOUG000000000-CAOOUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOUQ000000000-CAOOUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOUY000000000-CAOOUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOVD000000000-CAOOVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOVL000000000-CAOOVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOVO000000000-CAOOVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOVR000000000-CAOOVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOVZ000000000-CAOOWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOWM000000000-CAOOWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOWQ000000000-CAOOWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOXC000000000-CAOOXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOXJ000000000-CAOOXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOYC000000000-CAOOYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOYH000000000-CAOOYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOYR000000000-CAOOYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOYW000000000-CAOOYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOZA000000000-CAOOZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOZF000000000-CAOOZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOZI000000000-CAOOZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOZO000000000-CAOOZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOOZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOOZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOOZW000000000-CAOPAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPBA000000000-CAOPBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPBH000000000-CAOPBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPBR000000000-CAOPBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPBV000000000-CAOPCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPCD000000000-CAOPCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPCI000000000-CAOPCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPDE000000000-CAOPDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPDK000000000-CAOPDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPDP000000000-CAOPDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPDT000000000-CAOPDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPEI000000000-CAOPEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPEP000000000-CAOPES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPEX000000000-CAOPEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPFC000000000-CAOPFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPFI000000000-CAOPFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPFU000000000-CAOPFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPFX000000000-CAOPFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPGB000000000-CAOPGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPGG000000000-CAOPGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPGQ000000000-CAOPGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPGU000000000-CAOPGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPHA000000000-CAOPHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPHG000000000-CAOPHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPHM000000000-CAOPHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPHP000000000-CAOPHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPIG000000000-CAOPII999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPIN000000000-CAOPIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPIT000000000-CAOPIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPJA000000000-CAOPJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPJF000000000-CAOPJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPJM000000000-CAOPJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPJQ000000000-CAOPJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPKD000000000-CAOPKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPKM000000000-CAOPKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPKV000000000-CAOPKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPLB000000000-CAOPLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPLJ000000000-CAOPLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPLS000000000-CAOPLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPLV000000000-CAOPLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPLY000000000-CAOPLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPMB000000000-CAOPMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPMJ000000000-CAOPMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPMP000000000-CAOPMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPMX000000000-CAOPNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPNE000000000-CAOPNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPNH000000000-CAOPNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPNM000000000-CAOPNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPNU000000000-CAOPNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPNZ000000000-CAOPOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPOF000000000-CAOPOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPOT000000000-CAOPOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPPC000000000-CAOPPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPPG000000000-CAOPPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPPM000000000-CAOPPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPPP000000000-CAOPPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPPV000000000-CAOPPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPPY000000000-CAOPPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPQG000000000-CAOPQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPQN000000000-CAOPQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPQZ000000000-CAOPRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPRF000000000-CAOPRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPRI000000000-CAOPRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPRN000000000-CAOPRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPSE000000000-CAOPSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPSV000000000-CAOPSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPSZ000000000-CAOPTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPTJ000000000-CAOPTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPTU000000000-CAOPTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPTX000000000-CAOPTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPUA000000000-CAOPUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPUF000000000-CAOPUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPUZ000000000-CAOPVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPVC000000000-CAOPVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPVL000000000-CAOPVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPVS000000000-CAOPVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPWG000000000-CAOPWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPWO000000000-CAOPWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPWR000000000-CAOPWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPWW000000000-CAOPWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPXA000000000-CAOPXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPXI000000000-CAOPXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPXV000000000-CAOPXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPYE000000000-CAOPYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPYK000000000-CAOPYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOPZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPZQ000000000-CAOPZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPZT000000000-CAOPZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOPZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOPZY000000000-CAOQAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQAD000000000-CAOQAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQAK000000000-CAOQAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQAS000000000-CAOQAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQBB000000000-CAOQBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQBO000000000-CAOQBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQBY000000000-CAOQCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQCG000000000-CAOQCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQCJ000000000-CAOQCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQCQ000000000-CAOQCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQCW000000000-CAOQCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQDA000000000-CAOQDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQDO000000000-CAOQDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQDS000000000-CAOQDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQDW000000000-CAOQDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQDZ000000000-CAOQEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQEG000000000-CAOQEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQEQ000000000-CAOQER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQEV000000000-CAOQEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQFD000000000-CAOQFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQFJ000000000-CAOQFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQFR000000000-CAOQFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQGB000000000-CAOQGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQGI000000000-CAOQGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQGQ000000000-CAOQGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQGV000000000-CAOQHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQHH000000000-CAOQHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQHL000000000-CAOQHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQHV000000000-CAOQHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQHZ000000000-CAOQIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQIC000000000-CAOQIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQII000000000-CAOQIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQIO000000000-CAOQIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQIW000000000-CAOQIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQJA000000000-CAOQJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQJG000000000-CAOQJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQJM000000000-CAOQJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQJV000000000-CAOQJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQJZ000000000-CAOQKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQKE000000000-CAOQKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQKH000000000-CAOQKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQKO000000000-CAOQKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQKU000000000-CAOQKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQLO000000000-CAOQLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQLU000000000-CAOQLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQMA000000000-CAOQMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQMD000000000-CAOQMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQMR000000000-CAOQMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQMX000000000-CAOQNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQNI000000000-CAOQNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQNN000000000-CAOQNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQNY000000000-CAOQOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQOE000000000-CAOQOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQOJ000000000-CAOQOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQOO000000000-CAOQOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQOX000000000-CAOQOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQPC000000000-CAOQPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQPG000000000-CAOQPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQPM000000000-CAOQPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQPQ000000000-CAOQPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQPU000000000-CAOQPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQPX000000000-CAOQQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQQF000000000-CAOQQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQQI000000000-CAOQQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQQM000000000-CAOQQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQQQ000000000-CAOQQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQQU000000000-CAOQQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQQZ000000000-CAOQRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQRD000000000-CAOQRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQRW000000000-CAOQRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQSA000000000-CAOQSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQSH000000000-CAOQSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQSM000000000-CAOQSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQTB000000000-CAOQTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQTP000000000-CAOQTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQTU000000000-CAOQTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQTZ000000000-CAOQUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQUD000000000-CAOQUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQUT000000000-CAOQVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQVE000000000-CAOQVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQVM000000000-CAOQVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQVU000000000-CAOQVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQVZ000000000-CAOQWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQWJ000000000-CAOQWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQWW000000000-CAOQWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQXB000000000-CAOQXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQXG000000000-CAOQXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQXM000000000-CAOQXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQXU000000000-CAOQXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOQYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQYE000000000-CAOQYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQYH000000000-CAOQYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQYL000000000-CAOQYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQYP000000000-CAOQYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQYV000000000-CAOQYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQZA000000000-CAOQZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQZE000000000-CAOQZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQZJ000000000-CAOQZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOQZU000000000-CAOQZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOQZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORAE000000000-CAORAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORAJ000000000-CAORAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORAR000000000-CAORAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORAY000000000-CAORAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORBC000000000-CAORBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORBJ000000000-CAORBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORCA000000000-CAORCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORCJ000000000-CAORCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORCQ000000000-CAORCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORCZ000000000-CAORDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORDL000000000-CAORDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOREC000000000-CAOREM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOREO000000000-CAOREP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORER000000000-CAORES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOREV000000000-CAOREZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORFD000000000-CAORFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORFT000000000-CAORFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORFW000000000-CAORFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORFZ000000000-CAORGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORGC000000000-CAORGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORGJ000000000-CAORGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORGP000000000-CAORGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORGW000000000-CAORGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORHD000000000-CAORHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORHK000000000-CAORHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORHU000000000-CAORHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORIA000000000-CAORIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORIF000000000-CAORIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORIL000000000-CAORIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORIT000000000-CAORJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORJC000000000-CAORJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORJI000000000-CAORJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORJL000000000-CAORJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORJT000000000-CAORJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORJZ000000000-CAORKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORKE000000000-CAORKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORKP000000000-CAORKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORKY000000000-CAORLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORLJ000000000-CAORLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORLP000000000-CAORLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORMB000000000-CAORMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORMI000000000-CAORMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORMM000000000-CAORMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORMT000000000-CAORMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORND000000000-CAORNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORNL000000000-CAORNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORNO000000000-CAORNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORNV000000000-CAORNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOROC000000000-CAOROD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOROH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOROK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOROM000000000-CAOROO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOROQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOROS000000000-CAOROU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOROX000000000-CAORPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORPO000000000-CAORPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORPW000000000-CAORPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORQD000000000-CAORQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORQN000000000-CAORQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORQR000000000-CAORQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORQZ000000000-CAORRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORRI000000000-CAORRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORRL000000000-CAORRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORRO000000000-CAORRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORRS000000000-CAORRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORRY000000000-CAORSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORSC000000000-CAORSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORSJ000000000-CAORSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORSR000000000-CAORSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORSU000000000-CAORSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORSZ000000000-CAORTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORTG000000000-CAORTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORTP000000000-CAORTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORUA000000000-CAORUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORUE000000000-CAORUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORUO000000000-CAORUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORUS000000000-CAORUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORUX000000000-CAORUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORVA000000000-CAORVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORVE000000000-CAORVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORVV000000000-CAORVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORWE000000000-CAORWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORWJ000000000-CAORWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORWS000000000-CAORWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORXA000000000-CAORXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORXI000000000-CAORXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORYB000000000-CAORYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORYE000000000-CAORYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORYI000000000-CAORYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORYP000000000-CAORYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORYS000000000-CAORYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAORZE000000000-CAORZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORZJ000000000-CAORZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORZO000000000-CAORZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORZS000000000-CAORZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAORZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAORZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSAA000000000-CAOSAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSAE000000000-CAOSAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSAH000000000-CAOSAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSAO000000000-CAOSAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSAR000000000-CAOSAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSBB000000000-CAOSBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSBQ000000000-CAOSBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSBV000000000-CAOSBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSBY000000000-CAOSCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSCG000000000-CAOSCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSCJ000000000-CAOSCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSCS000000000-CAOSCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSCX000000000-CAOSCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSDE000000000-CAOSDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSDI000000000-CAOSDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSDQ000000000-CAOSEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSEJ000000000-CAOSEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSET000000000-CAOSEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSFB000000000-CAOSFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSFO000000000-CAOSFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSGG000000000-CAOSGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSGJ000000000-CAOSGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSGP000000000-CAOSGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSHB000000000-CAOSHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSHJ000000000-CAOSHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSHP000000000-CAOSHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSHZ000000000-CAOSIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSIE000000000-CAOSIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSII000000000-CAOSIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSIM000000000-CAOSIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSIP000000000-CAOSIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSIY000000000-CAOSIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSJI000000000-CAOSJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSKA000000000-CAOSKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSKH000000000-CAOSKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSKO000000000-CAOSKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSKR000000000-CAOSKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSKV000000000-CAOSLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSLH000000000-CAOSLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSLW000000000-CAOSLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSMD000000000-CAOSME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSMJ000000000-CAOSMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSMN000000000-CAOSMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSMU000000000-CAOSMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSNC000000000-CAOSNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSNO000000000-CAOSNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSNU000000000-CAOSNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSNZ000000000-CAOSOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSOE000000000-CAOSOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSON000000000-CAOSOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSPA000000000-CAOSPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSPH000000000-CAOSPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSPO000000000-CAOSPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSPV000000000-CAOSPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSQB000000000-CAOSQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSQE000000000-CAOSQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSQH000000000-CAOSQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSQL000000000-CAOSQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSRB000000000-CAOSRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSRS000000000-CAOSRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSSF000000000-CAOSSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSSK000000000-CAOSSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSSN000000000-CAOSSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSSQ000000000-CAOSSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSSW000000000-CAOSSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSTE000000000-CAOSTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSTH000000000-CAOSTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSTV000000000-CAOSTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSUH000000000-CAOSUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSUO000000000-CAOSUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSUZ000000000-CAOSVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSVC000000000-CAOSVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSVI000000000-CAOSVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSVR000000000-CAOSVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSWB000000000-CAOSWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSWN000000000-CAOSWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSWV000000000-CAOSWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSWY000000000-CAOSWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSXS000000000-CAOSXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSXW000000000-CAOSXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSYC000000000-CAOSYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSYI000000000-CAOSYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSYO000000000-CAOSYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSZB000000000-CAOSZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSZE000000000-CAOSZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSZH000000000-CAOSZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOSZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSZS000000000-CAOSZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOSZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOSZY000000000-CAOSZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTAG000000000-CAOTAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTAL000000000-CAOTAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTBF000000000-CAOTBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTBI000000000-CAOTBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTBL000000000-CAOTBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTBS000000000-CAOTBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTCC000000000-CAOTCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTCI000000000-CAOTCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTCM000000000-CAOTCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTCV000000000-CAOTCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTCY000000000-CAOTDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTDK000000000-CAOTDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTDS000000000-CAOTDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTED000000000-CAOTEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTEK000000000-CAOTEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTEO000000000-CAOTEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTEW000000000-CAOTFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTFI000000000-CAOTFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTFL000000000-CAOTFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTFU000000000-CAOTFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTFZ000000000-CAOTGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTGC000000000-CAOTGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTGK000000000-CAOTGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTGO000000000-CAOTGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTGY000000000-CAOTHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTHH000000000-CAOTHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTHM000000000-CAOTHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTIA000000000-CAOTIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTIM000000000-CAOTIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTIQ000000000-CAOTIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTIV000000000-CAOTIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTJD000000000-CAOTJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTJM000000000-CAOTJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTKG000000000-CAOTKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTKQ000000000-CAOTKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTKT000000000-CAOTKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTLC000000000-CAOTLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTLH000000000-CAOTLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTLY000000000-CAOTLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTMC000000000-CAOTMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTMI000000000-CAOTMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTMX000000000-CAOTMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTNG000000000-CAOTNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTNQ000000000-CAOTNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTNW000000000-CAOTNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTOA000000000-CAOTOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTOD000000000-CAOTOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTOQ000000000-CAOTOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTOV000000000-CAOTOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTPA000000000-CAOTPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTPK000000000-CAOTPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTPO000000000-CAOTPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTPW000000000-CAOTPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTQG000000000-CAOTQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTQJ000000000-CAOTQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTQS000000000-CAOTQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTQV000000000-CAOTQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTRJ000000000-CAOTRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTRM000000000-CAOTRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTRP000000000-CAOTRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTRX000000000-CAOTRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTSB000000000-CAOTSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTSG000000000-CAOTSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTSM000000000-CAOTSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTSR000000000-CAOTSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTSW000000000-CAOTSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTTE000000000-CAOTTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTTM000000000-CAOTTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTTP000000000-CAOTTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTTV000000000-CAOTTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTUC000000000-CAOTUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTUZ000000000-CAOTVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTVD000000000-CAOTVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTVI000000000-CAOTVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTVQ000000000-CAOTVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTVT000000000-CAOTWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTWD000000000-CAOTWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTWR000000000-CAOTWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTWY000000000-CAOTWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTXB000000000-CAOTXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTXI000000000-CAOTXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTXR000000000-CAOTXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTXZ000000000-CAOTYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTYI000000000-CAOTYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTYQ000000000-CAOTYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTZE000000000-CAOTZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTZM000000000-CAOTZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOTZT000000000-CAOTZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOTZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOTZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUAB000000000-CAOUAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUAI000000000-CAOUAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUAL000000000-CAOUAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUAP000000000-CAOUAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUAX000000000-CAOUAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUBA000000000-CAOUBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUBK000000000-CAOUBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUBP000000000-CAOUBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUBT000000000-CAOUBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUCD000000000-CAOUCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUCI000000000-CAOUCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUCX000000000-CAOUCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUDD000000000-CAOUDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUDG000000000-CAOUDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUDL000000000-CAOUDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUDO000000000-CAOUDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUDZ000000000-CAOUEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUEO000000000-CAOUES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUEZ000000000-CAOUFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUFH000000000-CAOUFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUFT000000000-CAOUFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUFW000000000-CAOUFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGA000000000-CAOUGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGD000000000-CAOUGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGI000000000-CAOUGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGN000000000-CAOUGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGR000000000-CAOUGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUGV000000000-CAOUGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUHB000000000-CAOUHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUHF000000000-CAOUHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUHK000000000-CAOUHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUHU000000000-CAOUHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUHX000000000-CAOUHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUIA000000000-CAOUIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUID000000000-CAOUIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUIG000000000-CAOUIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUIP000000000-CAOUIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUIV000000000-CAOUIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUJE000000000-CAOUJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUJJ000000000-CAOUJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUJU000000000-CAOUJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUKF000000000-CAOUKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUKL000000000-CAOUKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUKV000000000-CAOUKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOULA000000000-CAOULD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOULI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOULK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOULQ000000000-CAOULR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOULY000000000-CAOUMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUME000000000-CAOUMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUMJ000000000-CAOUMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUMO000000000-CAOUMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUMV000000000-CAOUMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUMZ000000000-CAOUNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUNE000000000-CAOUNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUNJ000000000-CAOUNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUNM000000000-CAOUNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUNT000000000-CAOUNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUOB000000000-CAOUOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUOF000000000-CAOUOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUOQ000000000-CAOUOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUOZ000000000-CAOUPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUPF000000000-CAOUPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUPP000000000-CAOUPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUPT000000000-CAOUPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUQC000000000-CAOUQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUQH000000000-CAOUQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUQO000000000-CAOUQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUQR000000000-CAOUQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUQW000000000-CAOUQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOURB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOURE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOURJ000000000-CAOURL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOURO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOURQ000000000-CAOURR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOURU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOURZ000000000-CAOUSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUSC000000000-CAOUSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUSQ000000000-CAOUST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUSZ000000000-CAOUTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUTE000000000-CAOUTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUTP000000000-CAOUTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUTY000000000-CAOUUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUUE000000000-CAOUUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUUM000000000-CAOUUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUVD000000000-CAOUVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUVI000000000-CAOUVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUVM000000000-CAOUVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUVV000000000-CAOUVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUVY000000000-CAOUVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUWD000000000-CAOUWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUWO000000000-CAOUWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUWS000000000-CAOUWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUWZ000000000-CAOUXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUXE000000000-CAOUXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUXQ000000000-CAOUXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUYA000000000-CAOUYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUYE000000000-CAOUYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUYH000000000-CAOUYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUYM000000000-CAOUYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOUYZ000000000-CAOUZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUZE000000000-CAOUZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUZI000000000-CAOUZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUZM000000000-CAOUZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOUZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOUZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVAB000000000-CAOVAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVAE000000000-CAOVAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVAH000000000-CAOVAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVAP000000000-CAOVAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVAW000000000-CAOVBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVBI000000000-CAOVBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVBQ000000000-CAOVBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVBW000000000-CAOVCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVCG000000000-CAOVCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVCL000000000-CAOVCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVCP000000000-CAOVCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVCS000000000-CAOVCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVDG000000000-CAOVDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVDP000000000-CAOVDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVDY000000000-CAOVEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVEE000000000-CAOVEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVEI000000000-CAOVEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVEQ000000000-CAOVET999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVFA000000000-CAOVFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVFD000000000-CAOVFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVFM000000000-CAOVFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVFS000000000-CAOVFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVFZ000000000-CAOVGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVGH000000000-CAOVGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVHD000000000-CAOVHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVHK000000000-CAOVHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVHS000000000-CAOVHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVHW000000000-CAOVHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVID000000000-CAOVIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVIJ000000000-CAOVIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVIN000000000-CAOVIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVIU000000000-CAOVIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVIZ000000000-CAOVJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVJF000000000-CAOVJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVJI000000000-CAOVJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVJP000000000-CAOVJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVJT000000000-CAOVJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVJZ000000000-CAOVKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVKE000000000-CAOVKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVKM000000000-CAOVKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVKQ000000000-CAOVKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVKV000000000-CAOVKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVLC000000000-CAOVLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVLL000000000-CAOVLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVLQ000000000-CAOVLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVLW000000000-CAOVLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVMF000000000-CAOVMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVNB000000000-CAOVNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVNF000000000-CAOVNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVNI000000000-CAOVNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVNM000000000-CAOVNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVNS000000000-CAOVNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVNZ000000000-CAOVOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVOE000000000-CAOVOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVOM000000000-CAOVOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVOV000000000-CAOVOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVPB000000000-CAOVPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVPH000000000-CAOVPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVPK000000000-CAOVPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVPP000000000-CAOVPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVPS000000000-CAOVPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVQA000000000-CAOVQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVQH000000000-CAOVQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVQQ000000000-CAOVQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVQZ000000000-CAOVRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVRH000000000-CAOVRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVRX000000000-CAOVSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVSE000000000-CAOVSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVSM000000000-CAOVSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVSP000000000-CAOVSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVSU000000000-CAOVSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVTA000000000-CAOVTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVTF000000000-CAOVTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVTM000000000-CAOVTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVTT000000000-CAOVTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVUA000000000-CAOVUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVUG000000000-CAOVUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVUL000000000-CAOVUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVUV000000000-CAOVUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVUZ000000000-CAOVVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVVE000000000-CAOVVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVVK000000000-CAOVVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVVO000000000-CAOVVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVVY000000000-CAOVVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVWI000000000-CAOVWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVWQ000000000-CAOVWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVWW000000000-CAOVWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVWZ000000000-CAOVXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVXL000000000-CAOVXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVXP000000000-CAOVXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVYA000000000-CAOVYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOVYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVYN000000000-CAOVYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVYQ000000000-CAOVYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVYT000000000-CAOVYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVZA000000000-CAOVZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVZD000000000-CAOVZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOVZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOVZL000000000-CAOVZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVZX000000000-CAOWAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWAG000000000-CAOWAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWAL000000000-CAOWAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWAW000000000-CAOWAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWAZ000000000-CAOWBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWBJ000000000-CAOWBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWBR000000000-CAOWBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWCF000000000-CAOWCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWCP000000000-CAOWCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWCU000000000-CAOWCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWDB000000000-CAOWDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWDO000000000-CAOWDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWDX000000000-CAOWDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWEA000000000-CAOWEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWED000000000-CAOWEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWEK000000000-CAOWEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWEY000000000-CAOWFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWFI000000000-CAOWFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWFM000000000-CAOWFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWFS000000000-CAOWFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWGC000000000-CAOWGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWGJ000000000-CAOWGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWGP000000000-CAOWGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWGS000000000-CAOWGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWHC000000000-CAOWHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWHF000000000-CAOWHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWHQ000000000-CAOWHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWIE000000000-CAOWIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWII000000000-CAOWIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWIO000000000-CAOWIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWIR000000000-CAOWIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWJA000000000-CAOWJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWJG000000000-CAOWJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWJJ000000000-CAOWJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWJP000000000-CAOWJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWJU000000000-CAOWJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWJX000000000-CAOWJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWKF000000000-CAOWKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWKI000000000-CAOWKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWKM000000000-CAOWKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWKR000000000-CAOWKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWKZ000000000-CAOWLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWLJ000000000-CAOWLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWLQ000000000-CAOWLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWLW000000000-CAOWLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWLZ000000000-CAOWMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWMK000000000-CAOWMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWMT000000000-CAOWMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWMZ000000000-CAOWNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWNC000000000-CAOWNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWNH000000000-CAOWNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWNN000000000-CAOWNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWOO000000000-CAOWOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWOR000000000-CAOWOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWOU000000000-CAOWOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWPD000000000-CAOWPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWPH000000000-CAOWPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWPR000000000-CAOWPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWPV000000000-CAOWPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWQF000000000-CAOWQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWQK000000000-CAOWQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWQR000000000-CAOWQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWQV000000000-CAOWQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWRK000000000-CAOWRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWRU000000000-CAOWRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWRZ000000000-CAOWSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWSH000000000-CAOWSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWSX000000000-CAOWTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWTI000000000-CAOWTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWTM000000000-CAOWTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWTP000000000-CAOWTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWUB000000000-CAOWUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWUK000000000-CAOWUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWUO000000000-CAOWUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWUV000000000-CAOWUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWVF000000000-CAOWVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWVJ000000000-CAOWVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWVQ000000000-CAOWVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWVU000000000-CAOWVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWVX000000000-CAOWWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWWI000000000-CAOWWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWWQ000000000-CAOWWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWWY000000000-CAOWXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWXG000000000-CAOWXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWXL000000000-CAOWXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWXQ000000000-CAOWXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWYG000000000-CAOWYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWYL000000000-CAOWYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOWZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWZG000000000-CAOWZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWZL000000000-CAOWZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOWZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOWZX000000000-CAOWZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXAB000000000-CAOXAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXAG000000000-CAOXAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXAL000000000-CAOXAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXAQ000000000-CAOXAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXBE000000000-CAOXBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXBI000000000-CAOXBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXBP000000000-CAOXBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXBX000000000-CAOXCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXCF000000000-CAOXCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXCZ000000000-CAOXDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDG000000000-CAOXDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDJ000000000-CAOXDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDN000000000-CAOXDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDS000000000-CAOXDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDW000000000-CAOXDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXEB000000000-CAOXED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXEL000000000-CAOXEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXET000000000-CAOXEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXFA000000000-CAOXFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXFF000000000-CAOXFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXFV000000000-CAOXFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXFY000000000-CAOXFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXGB000000000-CAOXGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXGG000000000-CAOXGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXGM000000000-CAOXGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXGR000000000-CAOXGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXGZ000000000-CAOXHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXHG000000000-CAOXHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXHR000000000-CAOXHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXHV000000000-CAOXHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXHZ000000000-CAOXIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXIL000000000-CAOXIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXIP000000000-CAOXIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXIV000000000-CAOXIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXJB000000000-CAOXJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXJK000000000-CAOXJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXJO000000000-CAOXJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXJU000000000-CAOXJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXJX000000000-CAOXJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXKC000000000-CAOXKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXKF000000000-CAOXKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXKJ000000000-CAOXKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXKN000000000-CAOXKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXKR000000000-CAOXKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXKV000000000-CAOXKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXLD000000000-CAOXLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXLL000000000-CAOXLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXLV000000000-CAOXLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXMD000000000-CAOXMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXMH000000000-CAOXMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXMR000000000-CAOXMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXMU000000000-CAOXMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXMZ000000000-CAOXNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXNE000000000-CAOXNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXNL000000000-CAOXNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXNW000000000-CAOXNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXNZ000000000-CAOXOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXOD000000000-CAOXOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXOQ000000000-CAOXOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXPC000000000-CAOXPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXPJ000000000-CAOXPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXPM000000000-CAOXPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXPS000000000-CAOXQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXQG000000000-CAOXQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXQM000000000-CAOXQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXQR000000000-CAOXQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXRC000000000-CAOXRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXRM000000000-CAOXRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXRT000000000-CAOXRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXRZ000000000-CAOXSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXSJ000000000-CAOXSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXSP000000000-CAOXTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXTD000000000-CAOXTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXTG000000000-CAOXTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXTM000000000-CAOXTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXTQ000000000-CAOXTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXTT000000000-CAOXTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXUC000000000-CAOXUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXUH000000000-CAOXUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXUO000000000-CAOXUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXUV000000000-CAOXVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXVM000000000-CAOXVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXVP000000000-CAOXVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXWA000000000-CAOXWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXWH000000000-CAOXWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXWO000000000-CAOXWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXXH000000000-CAOXXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXXS000000000-CAOXXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXXV000000000-CAOXXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXXZ000000000-CAOXYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXYE000000000-CAOXYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXYH000000000-CAOXYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXYO000000000-CAOXYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXYZ000000000-CAOXZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXZE000000000-CAOXZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXZL000000000-CAOXZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXZS000000000-CAOXZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOXZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOXZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOXZZ000000000-CAOYAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYAF000000000-CAOYAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYAL000000000-CAOYAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYAQ000000000-CAOYAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYBC000000000-CAOYBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYBL000000000-CAOYBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYBQ000000000-CAOYBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYBT000000000-CAOYBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYBY000000000-CAOYBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYCC000000000-CAOYCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYCP000000000-CAOYCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYCY000000000-CAOYDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYDG000000000-CAOYDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYDL000000000-CAOYDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYDP000000000-CAOYDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYDU000000000-CAOYDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYDY000000000-CAOYEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYED000000000-CAOYEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYEG000000000-CAOYEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYEL000000000-CAOYEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYEQ000000000-CAOYER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYFB000000000-CAOYFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYFP000000000-CAOYFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYGD000000000-CAOYGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYGX000000000-CAOYHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYHI000000000-CAOYHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYHP000000000-CAOYHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYHX000000000-CAOYIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYIE000000000-CAOYIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYIJ000000000-CAOYIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYIX000000000-CAOYIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYJA000000000-CAOYJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYJE000000000-CAOYJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYJM000000000-CAOYJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYJT000000000-CAOYJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYJX000000000-CAOYKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYKI000000000-CAOYKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYKR000000000-CAOYKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYKV000000000-CAOYKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYLM000000000-CAOYLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYLS000000000-CAOYLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYLW000000000-CAOYLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYMA000000000-CAOYMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYMK000000000-CAOYMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYMW000000000-CAOYMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYMZ000000000-CAOYNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYNE000000000-CAOYNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYNP000000000-CAOYNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYNW000000000-CAOYOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYOE000000000-CAOYOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYOO000000000-CAOYOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYOT000000000-CAOYOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYOX000000000-CAOYPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYPF000000000-CAOYPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYPO000000000-CAOYPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYPV000000000-CAOYPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYQA000000000-CAOYQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYQE000000000-CAOYQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYQU000000000-CAOYQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYRB000000000-CAOYRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYRE000000000-CAOYRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYRJ000000000-CAOYRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYRS000000000-CAOYRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYRY000000000-CAOYSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYSH000000000-CAOYSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYSR000000000-CAOYST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYTC000000000-CAOYTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYTI000000000-CAOYTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYTP000000000-CAOYTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYTU000000000-CAOYTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYUE000000000-CAOYUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYUN000000000-CAOYUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYUU000000000-CAOYUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYVD000000000-CAOYVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYVM000000000-CAOYVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYVT000000000-CAOYVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYVW000000000-CAOYVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYWB000000000-CAOYWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYWG000000000-CAOYWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYWQ000000000-CAOYWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYWV000000000-CAOYWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYWZ000000000-CAOYXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYXK000000000-CAOYXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYXO000000000-CAOYXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYXT000000000-CAOYXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYXZ000000000-CAOYYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYYC000000000-CAOYYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYYF000000000-CAOYYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYYL000000000-CAOYYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYYS000000000-CAOYYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYZN000000000-CAOYZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOYZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOYZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOYZY000000000-CAOZAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZAH000000000-CAOZAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZAN000000000-CAOZAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZAR000000000-CAOZAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZAW000000000-CAOZBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZBF000000000-CAOZBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZBU000000000-CAOZCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZCD000000000-CAOZCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZCJ000000000-CAOZCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZCT000000000-CAOZCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZCW000000000-CAOZCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZDC000000000-CAOZDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZDL000000000-CAOZDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZEE000000000-CAOZEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZEL000000000-CAOZEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZET000000000-CAOZEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZEW000000000-CAOZEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZEZ000000000-CAOZFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZFJ000000000-CAOZFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZFM000000000-CAOZFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZFR000000000-CAOZFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZGB000000000-CAOZGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZGI000000000-CAOZGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZGR000000000-CAOZGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZGV000000000-CAOZHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZHH000000000-CAOZHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZHM000000000-CAOZHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZHP000000000-CAOZHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZHS000000000-CAOZHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZIA000000000-CAOZIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZID000000000-CAOZIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZII000000000-CAOZIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZIL000000000-CAOZIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZIS000000000-CAOZIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZJJ000000000-CAOZJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZJQ000000000-CAOZJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZJX000000000-CAOZJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKB000000000-CAOZKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKL000000000-CAOZKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKQ000000000-CAOZKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKT000000000-CAOZKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZKX000000000-CAOZKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZLE000000000-CAOZLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZLI000000000-CAOZLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZLV000000000-CAOZLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZMI000000000-CAOZMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZML000000000-CAOZMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZMU000000000-CAOZMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNA000000000-CAOZNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNF000000000-CAOZNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNI000000000-CAOZNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNN000000000-CAOZNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZNW000000000-CAOZNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZOA000000000-CAOZOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZOI000000000-CAOZOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZOR000000000-CAOZOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZOW000000000-CAOZOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZPD000000000-CAOZPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZPM000000000-CAOZPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZPW000000000-CAOZPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZQB000000000-CAOZQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZQI000000000-CAOZQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZQQ000000000-CAOZQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZQV000000000-CAOZQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZRB000000000-CAOZRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZRE000000000-CAOZRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZRL000000000-CAOZRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZRT000000000-CAOZRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZRX000000000-CAOZRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZSC000000000-CAOZSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZSL000000000-CAOZSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZSS000000000-CAOZSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZSY000000000-CAOZSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZTE000000000-CAOZTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZTM000000000-CAOZTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZUD000000000-CAOZUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZUH000000000-CAOZUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZUL000000000-CAOZUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZUV000000000-CAOZUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZVC000000000-CAOZVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZVG000000000-CAOZVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZVP000000000-CAOZVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZWE000000000-CAOZWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZWH000000000-CAOZWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZWK000000000-CAOZWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZWQ000000000-CAOZWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZXB000000000-CAOZXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZXE000000000-CAOZXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZXM000000000-CAOZXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZXR000000000-CAOZXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZXV000000000-CAOZXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZXY000000000-CAOZYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZYH000000000-CAOZYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZYK000000000-CAOZYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZYP000000000-CAOZYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZYU000000000-CAOZYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZZB000000000-CAOZZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAOZZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZZJ000000000-CAOZZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAAB000000000-CAPAAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAAI000000000-CAPAAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAAP000000000-CAPAAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAAS000000000-CAPAAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAAY000000000-CAPABD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPABF000000000-CAPABK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPABM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPABO000000000-CAPABP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPABR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPABT000000000-CAPABV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPACA000000000-CAPACC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPACF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPACI000000000-CAPACJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPACL000000000-CAPACM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPACO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPACQ000000000-CAPACR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPACV000000000-CAPACW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPACY000000000-CAPADB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPADD000000000-CAPADF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPADH000000000-CAPADI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPADK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPADO000000000-CAPADS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPADU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPADX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAEA000000000-CAPAEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAEG000000000-CAPAEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAEJ000000000-CAPAEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAES000000000-CAPAET999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAEV000000000-CAPAEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAFN000000000-CAPAFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAFR000000000-CAPAFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAFZ000000000-CAPAGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAGN000000000-CAPAGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAGR000000000-CAPAGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAGU000000000-CAPAHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAHG000000000-CAPAHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAHK000000000-CAPAHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAHQ000000000-CAPAHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAHX000000000-CAPAHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAID000000000-CAPAIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAIG000000000-CAPAII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAIK000000000-CAPAIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAIO000000000-CAPAIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAIT000000000-CAPAIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAIW000000000-CAPAIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAJE000000000-CAPAJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAJR000000000-CAPAJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAJW000000000-CAPAJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAKA000000000-CAPAKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAKQ000000000-CAPAKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAKW000000000-CAPAKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPALB000000000-CAPALD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPALF000000000-CAPALG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPALI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPALK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPALM000000000-CAPALO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPALQ000000000-CAPALS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPALW000000000-CAPALX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPALZ000000000-CAPAMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAMF000000000-CAPAMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAMW000000000-CAPAMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPANB000000000-CAPANI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPANM000000000-CAPANN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPANR000000000-CAPANS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPANV000000000-CAPANX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPANZ000000000-CAPAOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAOO000000000-CAPAOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAOY000000000-CAPAOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAPC000000000-CAPAPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAPI000000000-CAPAPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAPM000000000-CAPAPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAPP000000000-CAPAPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAPU000000000-CAPAPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAQC000000000-CAPAQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAQL000000000-CAPAQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAQQ000000000-CAPAQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAQX000000000-CAPARD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPARG000000000-CAPARJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPARL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPARN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPARQ000000000-CAPARS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPARY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPASA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPASE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPASG000000000-CAPASI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPASK000000000-CAPASM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPASO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPASQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPASS000000000-CAPAST999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPASV000000000-CAPASX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPASZ000000000-CAPATB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPATD000000000-CAPATE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPATL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPATO000000000-CAPATR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPATU000000000-CAPATW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPATY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAUA000000000-CAPAUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAUM000000000-CAPAUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAUP000000000-CAPAUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAUV000000000-CAPAUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAVC000000000-CAPAVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAVJ000000000-CAPAVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAVU000000000-CAPAVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAVZ000000000-CAPAWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAWL000000000-CAPAWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAWQ000000000-CAPAWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAWX000000000-CAPAWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAXC000000000-CAPAXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAXK000000000-CAPAXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAXO000000000-CAPAXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAXY000000000-CAPAYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAYD000000000-CAPAYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAYY000000000-CAPAYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAZC000000000-CAPAZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPAZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAZM000000000-CAPAZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPAZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPAZV000000000-CAPBAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBAF000000000-CAPBAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBAQ000000000-CAPBAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBBG000000000-CAPBBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBBR000000000-CAPBBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBCD000000000-CAPBCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBCH000000000-CAPBCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBCL000000000-CAPBCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBCP000000000-CAPBCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBDA000000000-CAPBDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBDF000000000-CAPBDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBDM000000000-CAPBDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBDP000000000-CAPBDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBDX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBEB000000000-CAPBEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBEF000000000-CAPBEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBEI000000000-CAPBEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBEN000000000-CAPBEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBEU000000000-CAPBEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBFH000000000-CAPBFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBFM000000000-CAPBFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBFT000000000-CAPBFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBFZ000000000-CAPBGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBGL000000000-CAPBGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBGT000000000-CAPBGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBGW000000000-CAPBGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBHG000000000-CAPBHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBHK000000000-CAPBHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBHN000000000-CAPBHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBHT000000000-CAPBHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBHZ000000000-CAPBIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBIG000000000-CAPBII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBIO000000000-CAPBIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBIS000000000-CAPBIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBJF000000000-CAPBJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBJN000000000-CAPBJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBJR000000000-CAPBJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBKA000000000-CAPBKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBKD000000000-CAPBKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBKH000000000-CAPBKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBKM000000000-CAPBKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBKR000000000-CAPBKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBLC000000000-CAPBLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBLF000000000-CAPBLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBLI000000000-CAPBLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBLU000000000-CAPBLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBMA000000000-CAPBMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBMM000000000-CAPBMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBMR000000000-CAPBMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBMY000000000-CAPBMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBNE000000000-CAPBNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBNK000000000-CAPBNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBNO000000000-CAPBNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBNU000000000-CAPBNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBNX000000000-CAPBNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBOI000000000-CAPBOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBOM000000000-CAPBOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBOS000000000-CAPBOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBOY000000000-CAPBPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBPD000000000-CAPBPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBPH000000000-CAPBPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBPK000000000-CAPBPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBPT000000000-CAPBPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBPY000000000-CAPBPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBQK000000000-CAPBQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBQO000000000-CAPBQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBQV000000000-CAPBQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBRA000000000-CAPBRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBRF000000000-CAPBRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBRS000000000-CAPBRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBRX000000000-CAPBRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBSB000000000-CAPBSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBSH000000000-CAPBSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBSN000000000-CAPBSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBST000000000-CAPBSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBSY000000000-CAPBTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBTG000000000-CAPBTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBTW000000000-CAPBTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBUE000000000-CAPBUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBUK000000000-CAPBUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBUR000000000-CAPBUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBUY000000000-CAPBVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBVD000000000-CAPBVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBVG000000000-CAPBVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBVJ000000000-CAPBVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBVS000000000-CAPBVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBVX000000000-CAPBVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBWG000000000-CAPBWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBWM000000000-CAPBWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBWT000000000-CAPBWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBWW000000000-CAPBWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBXA000000000-CAPBXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBXF000000000-CAPBXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBXJ000000000-CAPBXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBXM000000000-CAPBXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBXR000000000-CAPBXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBXV000000000-CAPBXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBYA000000000-CAPBYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBYN000000000-CAPBYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBYS000000000-CAPBYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBZE000000000-CAPBZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPBZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBZM000000000-CAPBZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPBZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPBZU000000000-CAPCAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCAF000000000-CAPCAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAP000000000-CAPCAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAS000000000-CAPCAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCAY000000000-CAPCBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCBD000000000-CAPCBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCBS000000000-CAPCBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCBX000000000-CAPCCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCCF000000000-CAPCCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCCL000000000-CAPCCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCCU000000000-CAPCCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCDB000000000-CAPCDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCDI000000000-CAPCDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCDT000000000-CAPCDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCED000000000-CAPCEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCER000000000-CAPCEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCFB000000000-CAPCFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCFG000000000-CAPCFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCFJ000000000-CAPCFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCFO000000000-CAPCFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCFX000000000-CAPCGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCGG000000000-CAPCGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCGO000000000-CAPCGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCGZ000000000-CAPCHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCHD000000000-CAPCHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCHO000000000-CAPCHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCHY000000000-CAPCHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCIH000000000-CAPCIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCIO000000000-CAPCIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCJG000000000-CAPCJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCJN000000000-CAPCJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCJU000000000-CAPCJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCJX000000000-CAPCJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCKB000000000-CAPCKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCKX000000000-CAPCLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCLM000000000-CAPCLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCLR000000000-CAPCLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCMF000000000-CAPCMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCMP000000000-CAPCMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCMU000000000-CAPCMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCMY000000000-CAPCMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCNH000000000-CAPCNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCOA000000000-CAPCOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCOK000000000-CAPCOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCOO000000000-CAPCOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCPC000000000-CAPCPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCPG000000000-CAPCPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCPK000000000-CAPCPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCPW000000000-CAPCPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCQB000000000-CAPCQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCQO000000000-CAPCQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCQS000000000-CAPCQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCQW000000000-CAPCQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCRF000000000-CAPCRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCRJ000000000-CAPCRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCRN000000000-CAPCRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCRX000000000-CAPCRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPCSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCSO000000000-CAPCSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCSS000000000-CAPCST999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCSV000000000-CAPCSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCSY000000000-CAPCSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCTB000000000-CAPCTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCTE000000000-CAPCTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCTH000000000-CAPCTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCTU000000000-CAPCTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCUA000000000-CAPCUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCUI000000000-CAPCUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCUN000000000-CAPCUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCUR000000000-CAPCUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCUZ000000000-CAPCVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCVF000000000-CAPCVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCVN000000000-CAPCVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCVW000000000-CAPCVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCVZ000000000-CAPCWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCWC000000000-CAPCWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCWM000000000-CAPCWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCWQ000000000-CAPCWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCWW000000000-CAPCXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCXF000000000-CAPCXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCXI000000000-CAPCXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCXL000000000-CAPCXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCXQ000000000-CAPCXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCYA000000000-CAPCYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCYK000000000-CAPCYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPCYP000000000-CAPCYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCYV000000000-CAPCYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCYY000000000-CAPCYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCZB000000000-CAPCZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCZF000000000-CAPCZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCZM000000000-CAPCZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPCZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDAB000000000-CAPDAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDAE000000000-CAPDAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDAM000000000-CAPDAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDAW000000000-CAPDAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDBD000000000-CAPDBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDBK000000000-CAPDBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDBP000000000-CAPDBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDBW000000000-CAPDBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDCA000000000-CAPDCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDCF000000000-CAPDCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDCK000000000-CAPDCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDCR000000000-CAPDCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDCX000000000-CAPDDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDDD000000000-CAPDDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDDJ000000000-CAPDDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDDU000000000-CAPDDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDDX000000000-CAPDEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDEE000000000-CAPDEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDEH000000000-CAPDEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDEM000000000-CAPDEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDET000000000-CAPDEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDEX000000000-CAPDEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDFD000000000-CAPDFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDFG000000000-CAPDFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDFY000000000-CAPDFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDGB000000000-CAPDGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDGG000000000-CAPDGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDGV000000000-CAPDGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDHB000000000-CAPDHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDHI000000000-CAPDHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDHM000000000-CAPDHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDHQ000000000-CAPDHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDHT000000000-CAPDHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDIA000000000-CAPDIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDIL000000000-CAPDIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDIR000000000-CAPDIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDIV000000000-CAPDIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDJB000000000-CAPDJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDJJ000000000-CAPDJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDJP000000000-CAPDJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDJU000000000-CAPDJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDJZ000000000-CAPDKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDKE000000000-CAPDKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDKS000000000-CAPDKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDLF000000000-CAPDLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDLK000000000-CAPDLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDLP000000000-CAPDLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDLW000000000-CAPDMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDMD000000000-CAPDME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDMK000000000-CAPDMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDMP000000000-CAPDMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDNC000000000-CAPDND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDNF000000000-CAPDNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDNM000000000-CAPDNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDNS000000000-CAPDNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDNZ000000000-CAPDOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDOE000000000-CAPDOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDOJ000000000-CAPDOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDOO000000000-CAPDOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDOW000000000-CAPDOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDPE000000000-CAPDPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDPH000000000-CAPDPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDPO000000000-CAPDPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDQE000000000-CAPDQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDQI000000000-CAPDQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDQN000000000-CAPDQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDQW000000000-CAPDQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDRC000000000-CAPDRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDRL000000000-CAPDRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDRU000000000-CAPDRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDSE000000000-CAPDSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDSH000000000-CAPDSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDSN000000000-CAPDSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDTA000000000-CAPDTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDTF000000000-CAPDTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDTJ000000000-CAPDTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDTQ000000000-CAPDTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDUA000000000-CAPDUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDUG000000000-CAPDUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDUQ000000000-CAPDUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDVA000000000-CAPDVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDVM000000000-CAPDVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDVS000000000-CAPDVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDVW000000000-CAPDVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDWC000000000-CAPDWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDWM000000000-CAPDWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDWR000000000-CAPDWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDWY000000000-CAPDXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDXC000000000-CAPDXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPDXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDXL000000000-CAPDXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDXU000000000-CAPDXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDXZ000000000-CAPDYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDYE000000000-CAPDYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPDYQ000000000-CAPDYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDYU000000000-CAPDZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDZC000000000-CAPDZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDZH000000000-CAPDZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDZM000000000-CAPDZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDZT000000000-CAPDZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPDZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEAE000000000-CAPEAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEAH000000000-CAPEAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEAL000000000-CAPEAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEAU000000000-CAPEAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEAX000000000-CAPEBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEBF000000000-CAPEBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEBV000000000-CAPECA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPECC000000000-CAPECD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPECG000000000-CAPECH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPECJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPECN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPECP000000000-CAPECS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPECV000000000-CAPECX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEDB000000000-CAPEDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEDK000000000-CAPEDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEDT000000000-CAPEDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEDY000000000-CAPEEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEEL000000000-CAPEEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEFI000000000-CAPEFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEFV000000000-CAPEFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEGD000000000-CAPEGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEGV000000000-CAPEGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEHC000000000-CAPEHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEHL000000000-CAPEHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEHP000000000-CAPEHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEHV000000000-CAPEHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEHY000000000-CAPEIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEIZ000000000-CAPEJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEJD000000000-CAPEJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEJH000000000-CAPEJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEJV000000000-CAPEJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEKA000000000-CAPEKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEKE000000000-CAPEKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEKH000000000-CAPEKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPELD000000000-CAPELE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPELH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPELJ000000000-CAPELK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPELM000000000-CAPELN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPELR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPELU000000000-CAPELV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPELX000000000-CAPELY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEMA000000000-CAPEMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEML000000000-CAPEMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEMR000000000-CAPEMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEMW000000000-CAPEMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPENB000000000-CAPENC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPENJ000000000-CAPENM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPENY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEOA000000000-CAPEOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEON000000000-CAPEOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEPB000000000-CAPEPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEPI000000000-CAPEPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEPU000000000-CAPEPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEQH000000000-CAPEQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPERB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPERD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPERG000000000-CAPERH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPERK000000000-CAPERL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPERQ000000000-CAPERT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPERV000000000-CAPERX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPESA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPESC000000000-CAPESE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPESK000000000-CAPESM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPESP000000000-CAPESX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPESZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPETC000000000-CAPETD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPETG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPETI000000000-CAPETL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPETR000000000-CAPETT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPETV000000000-CAPETW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPETY000000000-CAPETZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEUB000000000-CAPEUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEUG000000000-CAPEUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEUQ000000000-CAPEUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEUW000000000-CAPEUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEVD000000000-CAPEVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEVM000000000-CAPEVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEVP000000000-CAPEVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEVV000000000-CAPEVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEVY000000000-CAPEWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEWF000000000-CAPEWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEWK000000000-CAPEWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEWV000000000-CAPEWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEXJ000000000-CAPEXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEXS000000000-CAPEXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEXX000000000-CAPEXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEYB000000000-CAPEYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEYH000000000-CAPEYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEYK000000000-CAPEYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEYQ000000000-CAPEYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEZA000000000-CAPEZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEZF000000000-CAPEZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEZI000000000-CAPEZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPEZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPEZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPEZZ000000000-CAPFAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFAN000000000-CAPFAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFAX000000000-CAPFAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFBF000000000-CAPFBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFBQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFBS000000000-CAPFBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFBV000000000-CAPFBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFBZ000000000-CAPFCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFCI000000000-CAPFCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFCN000000000-CAPFCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFCY000000000-CAPFDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFDL000000000-CAPFDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFDO000000000-CAPFDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFDU000000000-CAPFEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFEE000000000-CAPFEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFFG000000000-CAPFFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFFM000000000-CAPFFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFGC000000000-CAPFGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFGM000000000-CAPFGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFGS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFGV000000000-CAPFHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFHH000000000-CAPFHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFHR000000000-CAPFHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFHX000000000-CAPFHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFIF000000000-CAPFIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFIO000000000-CAPFIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFIS000000000-CAPFIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFIW000000000-CAPFIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFJA000000000-CAPFJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFJK000000000-CAPFJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFJP000000000-CAPFJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFJW000000000-CAPFKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFKE000000000-CAPFKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFKO000000000-CAPFKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFKT000000000-CAPFKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFLD000000000-CAPFLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFLM000000000-CAPFLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFLS000000000-CAPFLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFMI000000000-CAPFMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFMS000000000-CAPFMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFNA000000000-CAPFND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFNO000000000-CAPFNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFNU000000000-CAPFNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFOC000000000-CAPFOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFOF000000000-CAPFOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFOP000000000-CAPFOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFPA000000000-CAPFPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFPH000000000-CAPFPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFPM000000000-CAPFPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFPS000000000-CAPFPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFQG000000000-CAPFQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFQM000000000-CAPFQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFQQ000000000-CAPFQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFRA000000000-CAPFRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFRH000000000-CAPFRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFRM000000000-CAPFRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFRR000000000-CAPFRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFSA000000000-CAPFSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFSJ000000000-CAPFSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFST000000000-CAPFSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFSZ000000000-CAPFTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFTG000000000-CAPFTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFTL000000000-CAPFTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFTO000000000-CAPFTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFTV000000000-CAPFTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFUE000000000-CAPFUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFUH000000000-CAPFUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFUU000000000-CAPFUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFUZ000000000-CAPFVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFVJ000000000-CAPFVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFVQ000000000-CAPFVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFWD000000000-CAPFWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFWL000000000-CAPFWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFWQ000000000-CAPFWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFWT000000000-CAPFWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFWZ000000000-CAPFXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFXE000000000-CAPFXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFXI000000000-CAPFXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFXM000000000-CAPFXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFXR000000000-CAPFXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFYD000000000-CAPFYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFYG000000000-CAPFYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFYL000000000-CAPFYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPFYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFYT000000000-CAPFYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFZA000000000-CAPFZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPFZH000000000-CAPFZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFZK000000000-CAPFZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFZT000000000-CAPFZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPFZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGAF000000000-CAPGAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGAI000000000-CAPGAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGBA000000000-CAPGBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGBH000000000-CAPGBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGBQ000000000-CAPGBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGBW000000000-CAPGCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGCG000000000-CAPGCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGCK000000000-CAPGCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGCN000000000-CAPGCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGCR000000000-CAPGCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGCV000000000-CAPGCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGCZ000000000-CAPGDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGDD000000000-CAPGDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGDJ000000000-CAPGDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGDN000000000-CAPGDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGDS000000000-CAPGDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGED000000000-CAPGEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGEL000000000-CAPGEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGEX000000000-CAPGEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGFF000000000-CAPGFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGFP000000000-CAPGFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGFU000000000-CAPGFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGGA000000000-CAPGGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGGI000000000-CAPGGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGGL000000000-CAPGGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGGX000000000-CAPGGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGHH000000000-CAPGHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGHM000000000-CAPGHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGHW000000000-CAPGHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGID000000000-CAPGIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGIM000000000-CAPGIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGIS000000000-CAPGIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGIV000000000-CAPGJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGJF000000000-CAPGJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGJJ000000000-CAPGJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGJU000000000-CAPGJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGKC000000000-CAPGKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGKM000000000-CAPGKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGKS000000000-CAPGKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGKV000000000-CAPGKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGLE000000000-CAPGLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGLI000000000-CAPGLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGLQ000000000-CAPGLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGLV000000000-CAPGLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGLY000000000-CAPGMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGMN000000000-CAPGMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGMT000000000-CAPGMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGNB000000000-CAPGNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGNK000000000-CAPGNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGNU000000000-CAPGNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGOI000000000-CAPGOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGON000000000-CAPGOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGOS000000000-CAPGOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGOY000000000-CAPGOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGPG000000000-CAPGPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGPL000000000-CAPGPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGPR000000000-CAPGPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGPZ000000000-CAPGQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGQG000000000-CAPGQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGQK000000000-CAPGQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGQS000000000-CAPGQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGRG000000000-CAPGRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGRP000000000-CAPGRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGRU000000000-CAPGRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGSM000000000-CAPGSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGST000000000-CAPGSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGTA000000000-CAPGTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGTG000000000-CAPGTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGTM000000000-CAPGTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGTT000000000-CAPGTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGUD000000000-CAPGUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGUJ000000000-CAPGUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGUR000000000-CAPGUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGVE000000000-CAPGVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGVQ000000000-CAPGVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGVT000000000-CAPGVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGVX000000000-CAPGVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGWA000000000-CAPGWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGWK000000000-CAPGWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGWQ000000000-CAPGWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGWX000000000-CAPGWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGXA000000000-CAPGXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGXM000000000-CAPGXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGXR000000000-CAPGXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGXZ000000000-CAPGYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGYG000000000-CAPGYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGYM000000000-CAPGYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPGYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGZA000000000-CAPGZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGZI000000000-CAPGZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPGZQ000000000-CAPGZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPGZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHAA000000000-CAPHAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHAD000000000-CAPHAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHAM000000000-CAPHAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHAR000000000-CAPHAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHAZ000000000-CAPHBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHBF000000000-CAPHBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHBQ000000000-CAPHBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHBW000000000-CAPHBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHBZ000000000-CAPHCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHCI000000000-CAPHCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHCL000000000-CAPHCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHCO000000000-CAPHCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHCW000000000-CAPHCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHDI000000000-CAPHDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHDO000000000-CAPHDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHDT000000000-CAPHDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHEJ000000000-CAPHEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHEP000000000-CAPHER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHEU000000000-CAPHEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHFC000000000-CAPHFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHFH000000000-CAPHFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHFM000000000-CAPHFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHFU000000000-CAPHFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHGD000000000-CAPHGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHGO000000000-CAPHGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHGT000000000-CAPHGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHHE000000000-CAPHHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHHI000000000-CAPHHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHHX000000000-CAPHHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHIC000000000-CAPHIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHIP000000000-CAPHIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHJC000000000-CAPHJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHJJ000000000-CAPHJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHJS000000000-CAPHJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHJY000000000-CAPHJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHKB000000000-CAPHKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHKH000000000-CAPHKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHKO000000000-CAPHKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHKX000000000-CAPHKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHLB000000000-CAPHLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHLF000000000-CAPHLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHLT000000000-CAPHLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHMA000000000-CAPHMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHMF000000000-CAPHMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHMO000000000-CAPHMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHMS000000000-CAPHMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHNA000000000-CAPHNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHNH000000000-CAPHNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHNN000000000-CAPHNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHNT000000000-CAPHNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHOF000000000-CAPHOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHOK000000000-CAPHOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHOP000000000-CAPHOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHOZ000000000-CAPHPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHPG000000000-CAPHPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHPP000000000-CAPHPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHPU000000000-CAPHPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHQC000000000-CAPHQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHQN000000000-CAPHQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHQT000000000-CAPHQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHQX000000000-CAPHQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHRA000000000-CAPHRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHRF000000000-CAPHRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHRP000000000-CAPHRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHRT000000000-CAPHRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHRW000000000-CAPHSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHSJ000000000-CAPHSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHSO000000000-CAPHSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHSU000000000-CAPHSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHSZ000000000-CAPHTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHTH000000000-CAPHTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHTK000000000-CAPHTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHTT000000000-CAPHTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHTX000000000-CAPHTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHUE000000000-CAPHUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHUM000000000-CAPHUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHUR000000000-CAPHUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHVA000000000-CAPHVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHVJ000000000-CAPHVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHVS000000000-CAPHVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHWF000000000-CAPHWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHWL000000000-CAPHWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHWU000000000-CAPHWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHWX000000000-CAPHWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHXH000000000-CAPHXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHXK000000000-CAPHXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHXR000000000-CAPHXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHXY000000000-CAPHXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHYB000000000-CAPHYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHYE000000000-CAPHYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHYM000000000-CAPHYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPHYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHYV000000000-CAPHYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHZB000000000-CAPHZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHZG000000000-CAPHZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPHZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPHZO000000000-CAPHZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHZW000000000-CAPHZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIAB000000000-CAPIAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIAM000000000-CAPIAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIAX000000000-CAPIBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIBG000000000-CAPIBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIBK000000000-CAPIBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIBS000000000-CAPIBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPICA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPICC000000000-CAPICD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPICF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPICH000000000-CAPICK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPICO000000000-CAPICR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPICT000000000-CAPICU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPICW000000000-CAPICY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIDE000000000-CAPIDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIDH000000000-CAPIDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIDP000000000-CAPIDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIDU000000000-CAPIEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIEE000000000-CAPIEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIES000000000-CAPIEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIEY000000000-CAPIEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIFI000000000-CAPIFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIFN000000000-CAPIFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIFR000000000-CAPIFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIFV000000000-CAPIFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIGD000000000-CAPIGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIGJ000000000-CAPIGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIGT000000000-CAPIGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIHA000000000-CAPIHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIHL000000000-CAPIHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIIC000000000-CAPIIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIIH000000000-CAPIIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIIR000000000-CAPIIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIIW000000000-CAPIIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIIZ000000000-CAPIJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIJC000000000-CAPIJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIJY000000000-CAPIJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIKJ000000000-CAPIKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIKO000000000-CAPIKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIKU000000000-CAPIKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPILB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPILD000000000-CAPILH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPILJ000000000-CAPILK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPILN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPILP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPILS000000000-CAPILU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPILW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPILY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIMF000000000-CAPIMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIML+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIMW000000000-CAPIMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPINB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPING+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPINR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPINT000000000-CAPINV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPINZ000000000-CAPIOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIOF000000000-CAPIOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIOL000000000-CAPION999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIOR000000000-CAPIOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIOW000000000-CAPIOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIOZ000000000-CAPIPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIPE000000000-CAPIPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIPY000000000-CAPIQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIQF000000000-CAPIQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIQQ000000000-CAPIQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIQU000000000-CAPIQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIRK000000000-CAPIRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIRS000000000-CAPIRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIRW000000000-CAPISA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPISC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPISE000000000-CAPISH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPISJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPISR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPISV000000000-CAPISW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPISY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPITA000000000-CAPITF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPITH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPITJ000000000-CAPITK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPITM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPITY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIUD000000000-CAPIUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIUI000000000-CAPIUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIUO000000000-CAPIUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIUT000000000-CAPIUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIVD000000000-CAPIVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIVQ000000000-CAPIVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIWD000000000-CAPIWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIWN000000000-CAPIWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIWY000000000-CAPIXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIXG000000000-CAPIXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIYB000000000-CAPIYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIYH000000000-CAPIYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIYK000000000-CAPIYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIYQ000000000-CAPIYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIYV000000000-CAPIYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIZD000000000-CAPIZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIZJ000000000-CAPIZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPIZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPIZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPIZV000000000-CAPIZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJAC000000000-CAPJAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJAI000000000-CAPJAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJAQ000000000-CAPJAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJAX000000000-CAPJBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJBD000000000-CAPJBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJBI000000000-CAPJBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJBP000000000-CAPJBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJBV000000000-CAPJCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJCE000000000-CAPJCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJCK000000000-CAPJCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJCN000000000-CAPJCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJCR000000000-CAPJCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJCU000000000-CAPJCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJDC000000000-CAPJDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJDI000000000-CAPJDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJDT000000000-CAPJDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJDW000000000-CAPJDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJEC000000000-CAPJED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJEF000000000-CAPJEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJEN000000000-CAPJEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJET000000000-CAPJEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJFE000000000-CAPJFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJFL000000000-CAPJFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJFR000000000-CAPJFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJFU000000000-CAPJFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJFY000000000-CAPJFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJGC000000000-CAPJGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJGM000000000-CAPJGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJGS000000000-CAPJGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJHA000000000-CAPJHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJHH000000000-CAPJHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJHL000000000-CAPJHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJHV000000000-CAPJHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJIF000000000-CAPJIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJIP000000000-CAPJIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJIS000000000-CAPJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJJD000000000-CAPJJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJJM000000000-CAPJJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJJQ000000000-CAPJJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJKI000000000-CAPJKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJKN000000000-CAPJKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJLA000000000-CAPJLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJLM000000000-CAPJLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJLT000000000-CAPJLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJLY000000000-CAPJMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJMF000000000-CAPJMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJMM000000000-CAPJMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJMP000000000-CAPJMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJMS000000000-CAPJMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJMY000000000-CAPJMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJNH000000000-CAPJNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJNM000000000-CAPJNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJOB000000000-CAPJOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJOE000000000-CAPJOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJOI000000000-CAPJOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJOL000000000-CAPJOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJOQ000000000-CAPJOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJPB000000000-CAPJPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJPQ000000000-CAPJPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJPW000000000-CAPJPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJPZ000000000-CAPJQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJQC000000000-CAPJQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJQP000000000-CAPJQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJQS000000000-CAPJQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJQY000000000-CAPJQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJRB000000000-CAPJRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJRF000000000-CAPJRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJRK000000000-CAPJRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJRP000000000-CAPJRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJSA000000000-CAPJSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJSZ000000000-CAPJTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJTE000000000-CAPJTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJTS000000000-CAPJTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJTV000000000-CAPJTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJUO000000000-CAPJUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJUS000000000-CAPJUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJUY000000000-CAPJUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJVH000000000-CAPJVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJVV000000000-CAPJVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJWI000000000-CAPJWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJWQ000000000-CAPJWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJXA000000000-CAPJXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJXE000000000-CAPJXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJXJ000000000-CAPJXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJXP000000000-CAPJXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJYF000000000-CAPJYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJYI000000000-CAPJYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJYR000000000-CAPJYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJZC000000000-CAPJZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPJZN000000000-CAPJZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJZQ000000000-CAPJZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPJZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPJZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKAA000000000-CAPKAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKAK000000000-CAPKAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKAP000000000-CAPKAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKAU000000000-CAPKAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKBE000000000-CAPKBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKBK000000000-CAPKBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKBO000000000-CAPKBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKBT000000000-CAPKBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKBY000000000-CAPKBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKCB000000000-CAPKCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKCK000000000-CAPKCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKCN000000000-CAPKCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKCV000000000-CAPKCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKDA000000000-CAPKDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKDE000000000-CAPKDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKDU000000000-CAPKDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKDX000000000-CAPKDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKEB000000000-CAPKEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKER000000000-CAPKET999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKEY000000000-CAPKFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKFI000000000-CAPKFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKFP000000000-CAPKFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKFS000000000-CAPKFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKFX000000000-CAPKFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKGC000000000-CAPKGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKGK000000000-CAPKGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKGR000000000-CAPKGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKHC000000000-CAPKHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKHR000000000-CAPKHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKIA000000000-CAPKIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKIE000000000-CAPKIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKIL000000000-CAPKIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKIP000000000-CAPKIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKIX000000000-CAPKJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKJF000000000-CAPKJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKJS000000000-CAPKJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKKC000000000-CAPKKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKKM000000000-CAPKKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKKX000000000-CAPKKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKLB000000000-CAPKLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKLH000000000-CAPKLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKLL000000000-CAPKLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKLS000000000-CAPKLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKLV000000000-CAPKLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKMF000000000-CAPKMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKMJ000000000-CAPKML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKMV000000000-CAPKMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKMY000000000-CAPKNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKNE000000000-CAPKNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKNK000000000-CAPKNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKNS000000000-CAPKNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKOB000000000-CAPKOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKOM000000000-CAPKOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKOZ000000000-CAPKPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKPJ000000000-CAPKPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKPM000000000-CAPKPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKQB000000000-CAPKQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKQG000000000-CAPKQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKQK000000000-CAPKQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKQO000000000-CAPKQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKRK000000000-CAPKRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKSJ000000000-CAPKSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKSR000000000-CAPKSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKSW000000000-CAPKSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKTB000000000-CAPKTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKTE000000000-CAPKTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKTJ000000000-CAPKTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKTM000000000-CAPKTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKTV000000000-CAPKTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKUL000000000-CAPKUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKUO000000000-CAPKUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKUU000000000-CAPKUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKUY000000000-CAPKVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKVG000000000-CAPKVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKVJ000000000-CAPKVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKVN000000000-CAPKVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKWA000000000-CAPKWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKWJ000000000-CAPKWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKWM000000000-CAPKWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKWS000000000-CAPKWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPKWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKWZ000000000-CAPKXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPKXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPKXE000000000-CAPKXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKXH000000000-CAPKXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKXM000000000-CAPKXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKXQ000000000-CAPKXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKXX000000000-CAPKYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKYL000000000-CAPKYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKYT000000000-CAPKYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKYW000000000-CAPKYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKZA000000000-CAPKZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKZH000000000-CAPKZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKZL000000000-CAPKZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKZO000000000-CAPKZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLAA000000000-CAPLAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLAI000000000-CAPLAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLAM000000000-CAPLAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLAU000000000-CAPLAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLAZ000000000-CAPLBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLBC000000000-CAPLBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLBF000000000-CAPLBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLBN000000000-CAPLBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLBW000000000-CAPLBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLCI000000000-CAPLCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLCS000000000-CAPLCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLDB000000000-CAPLDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLDJ000000000-CAPLDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLDM000000000-CAPLDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLDQ000000000-CAPLDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLDU000000000-CAPLDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLDX000000000-CAPLDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLEC000000000-CAPLEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLEL000000000-CAPLEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLER000000000-CAPLEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLFA000000000-CAPLFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLFG000000000-CAPLFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLFM000000000-CAPLFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLFR000000000-CAPLFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLFZ000000000-CAPLGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLGE000000000-CAPLGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLGN000000000-CAPLGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLGS000000000-CAPLGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLGY000000000-CAPLHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLHE000000000-CAPLHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLHJ000000000-CAPLHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLHQ000000000-CAPLHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLHW000000000-CAPLHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLIJ000000000-CAPLIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLIM000000000-CAPLIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLIX000000000-CAPLIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLJB000000000-CAPLJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLJO000000000-CAPLJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLJW000000000-CAPLKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLKQ000000000-CAPLKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLKZ000000000-CAPLLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLLD000000000-CAPLLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLLK000000000-CAPLLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLLN000000000-CAPLLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLLV000000000-CAPLLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLMB000000000-CAPLMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLMI000000000-CAPLMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLMN000000000-CAPLMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLMX000000000-CAPLNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLND000000000-CAPLNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLNG000000000-CAPLNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLNK000000000-CAPLNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLNT000000000-CAPLNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLOE000000000-CAPLOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLOK000000000-CAPLOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLOO000000000-CAPLOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLPB000000000-CAPLPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLPG000000000-CAPLPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLPJ000000000-CAPLPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLPX000000000-CAPLQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLQF000000000-CAPLQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLQQ000000000-CAPLQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLQY000000000-CAPLQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLRB000000000-CAPLRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLRF000000000-CAPLRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLRM000000000-CAPLRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLRS000000000-CAPLRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLSA000000000-CAPLSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLSG000000000-CAPLSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLSP000000000-CAPLSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLTD000000000-CAPLTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLTG000000000-CAPLTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLTT000000000-CAPLTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLTW000000000-CAPLTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLUD000000000-CAPLUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLUN000000000-CAPLUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLUR000000000-CAPLUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLUY000000000-CAPLVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLVG000000000-CAPLVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLVK000000000-CAPLVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLVS000000000-CAPLVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLWA000000000-CAPLWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLWL000000000-CAPLWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLWS000000000-CAPLWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLWX000000000-CAPLWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLXA000000000-CAPLXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLXJ000000000-CAPLXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLXO000000000-CAPLXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLXZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPLYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLYL000000000-CAPLYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLYS000000000-CAPLYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLYW000000000-CAPLZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLZD000000000-CAPLZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPLZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPLZK000000000-CAPLZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLZQ000000000-CAPLZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLZV000000000-CAPMAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMAD000000000-CAPMAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMAQ000000000-CAPMAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMBA000000000-CAPMBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMBN000000000-CAPMBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMBU000000000-CAPMBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMBY000000000-CAPMBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMCC000000000-CAPMCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMCI000000000-CAPMCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMCP000000000-CAPMCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMCU000000000-CAPMCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMCX000000000-CAPMCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMDA000000000-CAPMDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMDJ000000000-CAPMDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMDO000000000-CAPMDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMEA000000000-CAPMEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMEF000000000-CAPMEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMEQ000000000-CAPMEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMFC000000000-CAPMFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMFK000000000-CAPMFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMFN000000000-CAPMFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMFT000000000-CAPMFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMFY000000000-CAPMFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMGD000000000-CAPMGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMGJ000000000-CAPMGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMGR000000000-CAPMGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMGY000000000-CAPMGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMHB000000000-CAPMHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMHL000000000-CAPMHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMHU000000000-CAPMHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMIB000000000-CAPMIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMIL000000000-CAPMIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMIT000000000-CAPMJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJF000000000-CAPMJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJI000000000-CAPMJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJL000000000-CAPMJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJR000000000-CAPMJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJU000000000-CAPMJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMJY000000000-CAPMKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMKE000000000-CAPMKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMKL000000000-CAPMKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMKQ000000000-CAPMKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMLA000000000-CAPMLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMLE000000000-CAPMLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMLP000000000-CAPMLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMLW000000000-CAPMLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMMB000000000-CAPMMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMMG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMMY000000000-CAPMMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMNC000000000-CAPMNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMNI000000000-CAPMNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMNM000000000-CAPMNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMOI000000000-CAPMOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMOL000000000-CAPMOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMOP000000000-CAPMOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMOW000000000-CAPMOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMPV000000000-CAPMPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMQC000000000-CAPMQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMQF000000000-CAPMQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMQS000000000-CAPMQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMRH000000000-CAPMRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMRR000000000-CAPMRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMRU000000000-CAPMRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMRZ000000000-CAPMSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMSR000000000-CAPMSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMSY000000000-CAPMTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMTH000000000-CAPMTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMTO000000000-CAPMTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMTV000000000-CAPMTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMUC000000000-CAPMUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMUH000000000-CAPMUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMUR000000000-CAPMUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMUU000000000-CAPMUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMVE000000000-CAPMVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMVI000000000-CAPMVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMVM000000000-CAPMVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMWO000000000-CAPMWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMWX000000000-CAPMXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMXC000000000-CAPMXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMXJ000000000-CAPMXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMXT000000000-CAPMYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMYF000000000-CAPMYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPMYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPMYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPMYO000000000-CAPMYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMYU000000000-CAPMYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMYY000000000-CAPMZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMZJ000000000-CAPMZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMZQ000000000-CAPMZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMZV000000000-CAPNAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNAC000000000-CAPNAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNAH000000000-CAPNAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNAN000000000-CAPNAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNAV000000000-CAPNAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNBG000000000-CAPNBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNBK000000000-CAPNBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNBS000000000-CAPNBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNBY000000000-CAPNCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNCG000000000-CAPNCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNCM000000000-CAPNCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNDA000000000-CAPNDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNDG000000000-CAPNDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNDN000000000-CAPNDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNDU000000000-CAPNDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNEB000000000-CAPNEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNEI000000000-CAPNEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNEM000000000-CAPNEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNEY000000000-CAPNFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNFP000000000-CAPNFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNFX000000000-CAPNFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNGD000000000-CAPNGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNGH000000000-CAPNGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNGM000000000-CAPNGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNGX000000000-CAPNHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNHC000000000-CAPNHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNHK000000000-CAPNHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNHT000000000-CAPNHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNHY000000000-CAPNHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNID000000000-CAPNIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNIQ000000000-CAPNIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNIZ000000000-CAPNJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNJG000000000-CAPNJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNJJ000000000-CAPNJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNJQ000000000-CAPNJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNJZ000000000-CAPNKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNKI000000000-CAPNKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNKQ000000000-CAPNKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNLD000000000-CAPNLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNLN000000000-CAPNLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNLT000000000-CAPNLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNLW000000000-CAPNLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNMC000000000-CAPNMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNMJ000000000-CAPNMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNMQ000000000-CAPNMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNMW000000000-CAPNNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNNE000000000-CAPNNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNNN000000000-CAPNNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNNW000000000-CAPNNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNOC000000000-CAPNOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNOH000000000-CAPNOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNOU000000000-CAPNOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNPD000000000-CAPNPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNPJ000000000-CAPNPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNPV000000000-CAPNPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNQD000000000-CAPNQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNQW000000000-CAPNQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNRC000000000-CAPNRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNRJ000000000-CAPNRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNRN000000000-CAPNRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNSB000000000-CAPNSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNSG000000000-CAPNSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNSN000000000-CAPNSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNTC000000000-CAPNTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNTJ000000000-CAPNTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNUB000000000-CAPNUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNUH000000000-CAPNUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNUL000000000-CAPNUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNUQ000000000-CAPNUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNUT000000000-CAPNUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNUY000000000-CAPNVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNVE000000000-CAPNVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNVQ000000000-CAPNVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNVW000000000-CAPNVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNWB000000000-CAPNWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNWG000000000-CAPNWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNWR000000000-CAPNWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNWU000000000-CAPNWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNXA000000000-CAPNXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNXM000000000-CAPNXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNXR000000000-CAPNXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNXU000000000-CAPNYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNYP000000000-CAPNYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNYV000000000-CAPNYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNYY000000000-CAPNZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNZK000000000-CAPNZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPNZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPNZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPNZU000000000-CAPNZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNZZ000000000-CAPOAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOAD000000000-CAPOAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOAP000000000-CAPOAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOAS000000000-CAPOAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOAZ000000000-CAPOBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOBH000000000-CAPOBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOBN000000000-CAPOBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOBY000000000-CAPOBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOCE000000000-CAPOCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOCH000000000-CAPOCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOCP000000000-CAPOCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOCW000000000-CAPODF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPODI000000000-CAPODJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPODO000000000-CAPODP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPODS000000000-CAPODU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPODW000000000-CAPODX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPODZ000000000-CAPOEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOED000000000-CAPOEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOEI000000000-CAPOEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOEL000000000-CAPOEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOEQ000000000-CAPOER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOET000000000-CAPOEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOEZ000000000-CAPOFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOFF000000000-CAPOFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOFQ000000000-CAPOFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOFW000000000-CAPOGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOGI000000000-CAPOGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOGQ000000000-CAPOGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOHB000000000-CAPOHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOHI000000000-CAPOHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOHO000000000-CAPOHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOHW000000000-CAPOHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOHZ000000000-CAPOIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOIC000000000-CAPOIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOIG000000000-CAPOIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOIJ000000000-CAPOIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOIN000000000-CAPOIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOIS000000000-CAPOIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOJH000000000-CAPOJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOJQ000000000-CAPOJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOJZ000000000-CAPOKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOKF000000000-CAPOKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOKO000000000-CAPOKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOKR000000000-CAPOKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOLE000000000-CAPOLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOLI000000000-CAPOLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOLN000000000-CAPOLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOLT000000000-CAPOLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOLW000000000-CAPOMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOMK000000000-CAPOMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOMR000000000-CAPOMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOMU000000000-CAPOMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOMZ000000000-CAPOND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPONF000000000-CAPONI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPONK000000000-CAPONL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPONN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPONR000000000-CAPONW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPONY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOOD000000000-CAPOOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOOL000000000-CAPOOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOOT000000000-CAPOOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOPA000000000-CAPOPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOPM000000000-CAPOPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOPT000000000-CAPOPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOQA000000000-CAPOQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOQI000000000-CAPOQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOQL000000000-CAPOQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOQQ000000000-CAPORA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORC000000000-CAPORD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORF000000000-CAPORG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORK000000000-CAPORM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORO000000000-CAPORR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPORW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPORY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOSE000000000-CAPOSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOSJ000000000-CAPOSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOSN000000000-CAPOSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOSQ000000000-CAPOSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOSW000000000-CAPOSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOTC000000000-CAPOTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOTM000000000-CAPOTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOUC000000000-CAPOUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOUN000000000-CAPOUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOUT000000000-CAPOUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOUX000000000-CAPOVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOVL000000000-CAPOVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOVW000000000-CAPOVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOWF000000000-CAPOWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOWK000000000-CAPOWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOWO000000000-CAPOWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOWU000000000-CAPOWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOWZ000000000-CAPOXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOXC000000000-CAPOXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOXJ000000000-CAPOXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOXN000000000-CAPOXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOXQ000000000-CAPOXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOYC000000000-CAPOYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOYO000000000-CAPOYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOYV000000000-CAPOYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPOYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPOZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPOZE000000000-CAPOZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOZR000000000-CAPOZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOZW000000000-CAPOZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPAD000000000-CAPPAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPAM000000000-CAPPAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPAP000000000-CAPPAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPAT000000000-CAPPAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPBI000000000-CAPPBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPBO000000000-CAPPBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPBZ000000000-CAPPCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPCG000000000-CAPPCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPCM000000000-CAPPCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPCP000000000-CAPPCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPCT000000000-CAPPCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPCZ000000000-CAPPDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPDK000000000-CAPPDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPDT000000000-CAPPDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPEA000000000-CAPPEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPEH000000000-CAPPEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPEN000000000-CAPPEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPES000000000-CAPPEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPFB000000000-CAPPFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPFI000000000-CAPPFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPFM000000000-CAPPFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPFR000000000-CAPPFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPGB000000000-CAPPGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPGE000000000-CAPPGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPGM000000000-CAPPGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPGR000000000-CAPPGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPHC000000000-CAPPHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPHI000000000-CAPPHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPHM000000000-CAPPHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPHU000000000-CAPPHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPIE000000000-CAPPIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPIQ000000000-CAPPIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPIT000000000-CAPPIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPJB000000000-CAPPJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPJK000000000-CAPPJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPJN000000000-CAPPJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPJT000000000-CAPPJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPJX000000000-CAPPKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPKL000000000-CAPPKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPKS000000000-CAPPKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPKY000000000-CAPPKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPLB000000000-CAPPLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPLF000000000-CAPPLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPLK000000000-CAPPLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPLO000000000-CAPPLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPLS000000000-CAPPLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPLW000000000-CAPPMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPMH000000000-CAPPMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPMM000000000-CAPPMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPMQ000000000-CAPPMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPMU000000000-CAPPMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPNB000000000-CAPPNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPNH000000000-CAPPNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPNL000000000-CAPPNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPNP000000000-CAPPNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPNX000000000-CAPPNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPOA000000000-CAPPOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPOM000000000-CAPPOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPOW000000000-CAPPOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPPA000000000-CAPPPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPPW000000000-CAPPPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPQE000000000-CAPPQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPQJ000000000-CAPPQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPQR000000000-CAPPQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPQX000000000-CAPPRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPRE000000000-CAPPRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPRM000000000-CAPPRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPRT000000000-CAPPRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPRW000000000-CAPPRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPSA000000000-CAPPSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPSH000000000-CAPPSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPSL000000000-CAPPSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPSV000000000-CAPPSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPTA000000000-CAPPTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPTG000000000-CAPPTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPTX000000000-CAPPTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPUB000000000-CAPPUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPUH000000000-CAPPUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPUO000000000-CAPPUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPUW000000000-CAPPUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPVC000000000-CAPPVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPVH000000000-CAPPVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPVU000000000-CAPPVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPWA000000000-CAPPWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPWF000000000-CAPPWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPWI000000000-CAPPWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPWP000000000-CAPPWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPWZ000000000-CAPPXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPXJ000000000-CAPPXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPXM000000000-CAPPXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPXX000000000-CAPPYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPYE000000000-CAPPYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPYL000000000-CAPPYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPYW000000000-CAPPYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPZI000000000-CAPPZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPPZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPPZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPPZY000000000-CAPPZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQAD000000000-CAPQAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQAL000000000-CAPQAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQBC000000000-CAPQBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQBK000000000-CAPQBO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQBW000000000-CAPQBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQCA000000000-CAPQCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQCF000000000-CAPQCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQCM000000000-CAPQCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQCU000000000-CAPQCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQCY000000000-CAPQCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQDD000000000-CAPQDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQDO000000000-CAPQDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQDR000000000-CAPQDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQDY000000000-CAPQDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQEC000000000-CAPQEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQEM000000000-CAPQEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQFB000000000-CAPQFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQFJ000000000-CAPQFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQFN000000000-CAPQFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQFS000000000-CAPQFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQFX000000000-CAPQGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQGC000000000-CAPQGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQGP000000000-CAPQGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQHB000000000-CAPQHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQHF000000000-CAPQHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQHL000000000-CAPQHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQHR000000000-CAPQHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQIA000000000-CAPQIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQIE000000000-CAPQIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQIY000000000-CAPQIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQJI000000000-CAPQJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQJS000000000-CAPQJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQKI000000000-CAPQKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQKM000000000-CAPQKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQKP000000000-CAPQKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQLA000000000-CAPQLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQLF000000000-CAPQLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQLK000000000-CAPQLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQLN000000000-CAPQLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQLQ000000000-CAPQLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQLW000000000-CAPQLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQME000000000-CAPQMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQML000000000-CAPQMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQMS000000000-CAPQMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQMX000000000-CAPQNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQNN000000000-CAPQNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQNW000000000-CAPQNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQNZ000000000-CAPQOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQOE000000000-CAPQOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQOK000000000-CAPQON999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQOP000000000-CAPQOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQOU000000000-CAPQOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQOZ000000000-CAPQPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQPD000000000-CAPQPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQPH000000000-CAPQPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQPM000000000-CAPQPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQPP000000000-CAPQPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQPT000000000-CAPQPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQPX000000000-CAPQPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQQE000000000-CAPQQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQQR000000000-CAPQQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQQZ000000000-CAPQRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQRF000000000-CAPQRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQRK000000000-CAPQRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQRO000000000-CAPQRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQRR000000000-CAPQRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQRZ000000000-CAPQSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQSF000000000-CAPQSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQSL000000000-CAPQSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQSP000000000-CAPQSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQSY000000000-CAPQTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQTH000000000-CAPQTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQTS000000000-CAPQTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQTY000000000-CAPQUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQUF000000000-CAPQUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQUN000000000-CAPQUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQUS000000000-CAPQUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQUV000000000-CAPQUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQVK000000000-CAPQVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQVV000000000-CAPQVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQWD000000000-CAPQWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQWJ000000000-CAPQWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQWS000000000-CAPQXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQXN000000000-CAPQXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQXS000000000-CAPQXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQYA000000000-CAPQYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQYE000000000-CAPQYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPQYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQYM000000000-CAPQYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQYS000000000-CAPQYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQYV000000000-CAPQYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQYY000000000-CAPQZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQZG000000000-CAPQZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQZL000000000-CAPQZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQZU000000000-CAPQZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRAD000000000-CAPRAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRAH000000000-CAPRAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRBE000000000-CAPRBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRBI000000000-CAPRBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRBP000000000-CAPRBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRBT000000000-CAPRBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRBZ000000000-CAPRCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRCH000000000-CAPRCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRCQ000000000-CAPRCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRDD000000000-CAPRDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRDL000000000-CAPRDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRDR000000000-CAPRDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPREA000000000-CAPREC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPREE000000000-CAPREG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPREI000000000-CAPREP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRER000000000-CAPRET999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPREV000000000-CAPREX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPREZ000000000-CAPRFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRFG000000000-CAPRFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRFM000000000-CAPRFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRFV000000000-CAPRFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRGG000000000-CAPRGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRGQ000000000-CAPRGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRGV000000000-CAPRGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRHC000000000-CAPRHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRHJ000000000-CAPRHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRHS000000000-CAPRHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRHX000000000-CAPRHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRIJ000000000-CAPRIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRIM000000000-CAPRIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRIS000000000-CAPRIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRIV000000000-CAPRIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRJF000000000-CAPRJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRJI000000000-CAPRJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRJQ000000000-CAPRJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRJV000000000-CAPRJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRJY000000000-CAPRKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRKG000000000-CAPRKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRKS000000000-CAPRKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRKW000000000-CAPRKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRLB000000000-CAPRLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRLG000000000-CAPRLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRLJ000000000-CAPRLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRLO000000000-CAPRLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRLS000000000-CAPRLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRLY000000000-CAPRMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRMC000000000-CAPRMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRMP000000000-CAPRMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRMV000000000-CAPRMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRNA000000000-CAPRND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRNJ000000000-CAPRNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRNN000000000-CAPRNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRNZ000000000-CAPROB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPROD000000000-CAPROE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPROG000000000-CAPROL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPROO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPROQ000000000-CAPROR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPROT000000000-CAPROV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPROX000000000-CAPROZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRPE000000000-CAPRPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRPJ000000000-CAPRPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRPP000000000-CAPRPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRPU000000000-CAPRPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRQB000000000-CAPRQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRQH000000000-CAPRQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRQL000000000-CAPRQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRQP000000000-CAPRQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRQW000000000-CAPRQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRRB000000000-CAPRRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRRF000000000-CAPRRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRRL000000000-CAPRRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRRW000000000-CAPRRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRSB000000000-CAPRSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRSE000000000-CAPRSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRSJ000000000-CAPRSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRSR000000000-CAPRSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRTA000000000-CAPRTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRTJ000000000-CAPRTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRTO000000000-CAPRTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRTS000000000-CAPRTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRTV000000000-CAPRTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRUA000000000-CAPRUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRUD000000000-CAPRUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRUP000000000-CAPRUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRVE000000000-CAPRVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRVO000000000-CAPRVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRVS000000000-CAPRVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRVY000000000-CAPRVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRWC000000000-CAPRWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRWP000000000-CAPRWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRWT000000000-CAPRWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRWX000000000-CAPRWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRXL000000000-CAPRXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRXT000000000-CAPRXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRYB000000000-CAPRYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRYN000000000-CAPRYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRYQ000000000-CAPRYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRZA000000000-CAPRZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPRZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRZJ000000000-CAPRZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPRZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPRZR000000000-CAPRZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRZY000000000-CAPSAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSAK000000000-CAPSAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSAR000000000-CAPSAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSAU000000000-CAPSAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSBM000000000-CAPSBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSBQ000000000-CAPSBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSCG000000000-CAPSCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSCR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSCT000000000-CAPSCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSDG000000000-CAPSDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSDL000000000-CAPSDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSDQ000000000-CAPSDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSDV000000000-CAPSDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSDY000000000-CAPSEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSEJ000000000-CAPSEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSER000000000-CAPSES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSFA000000000-CAPSFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSFI000000000-CAPSFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSFR000000000-CAPSFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSGC000000000-CAPSGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSGH000000000-CAPSGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSGO000000000-CAPSGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSGT000000000-CAPSGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSGY000000000-CAPSHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSHO000000000-CAPSHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSHU000000000-CAPSHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSIA000000000-CAPSIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSIH000000000-CAPSII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSIK000000000-CAPSIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSIN000000000-CAPSIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSIU000000000-CAPSIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSJG000000000-CAPSJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSJL000000000-CAPSJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSJO000000000-CAPSJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSJZ000000000-CAPSKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSKL000000000-CAPSKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSKS000000000-CAPSKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSKY000000000-CAPSKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSLD000000000-CAPSLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSLL000000000-CAPSLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSLS000000000-CAPSLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSME000000000-CAPSMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSML000000000-CAPSMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSMO000000000-CAPSMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSMR000000000-CAPSMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSMU000000000-CAPSMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSNF000000000-CAPSNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSNL000000000-CAPSNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSNT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSNX000000000-CAPSOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSOO000000000-CAPSOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSOV000000000-CAPSOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSOY000000000-CAPSOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSPB000000000-CAPSPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSPG000000000-CAPSPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSPS000000000-CAPSPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSPW000000000-CAPSQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSQC000000000-CAPSQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSQH000000000-CAPSQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSQK000000000-CAPSQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSQP000000000-CAPSQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSQV000000000-CAPSQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSQY000000000-CAPSQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSRN000000000-CAPSRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSSA000000000-CAPSSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSSD000000000-CAPSSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSSI000000000-CAPSSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSSO000000000-CAPSSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSST000000000-CAPSSV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSSX000000000-CAPSSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSTB000000000-CAPSTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSTI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSTK000000000-CAPSTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSTN000000000-CAPSTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSTT000000000-CAPSTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSTY000000000-CAPSUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSUG000000000-CAPSUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSUK000000000-CAPSUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSUN000000000-CAPSUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSUZ000000000-CAPSVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSVC000000000-CAPSVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSVI000000000-CAPSVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSVS000000000-CAPSVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSVY000000000-CAPSWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWF000000000-CAPSWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWI000000000-CAPSWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSWN000000000-CAPSWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWU000000000-CAPSWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSWZ000000000-CAPSXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSXC000000000-CAPSXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPSXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSXN000000000-CAPSXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSXT000000000-CAPSXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSYD000000000-CAPSYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSYK000000000-CAPSYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSYO000000000-CAPSYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSYZ000000000-CAPSZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSZH000000000-CAPSZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPSZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPSZP000000000-CAPSZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSZV000000000-CAPSZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSZZ000000000-CAPTAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTAD000000000-CAPTAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTAM000000000-CAPTAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTAU000000000-CAPTAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTBA000000000-CAPTBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTBF000000000-CAPTBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTBO000000000-CAPTBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTBR000000000-CAPTBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTBW000000000-CAPTBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTCB000000000-CAPTCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTCF000000000-CAPTCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTCQ000000000-CAPTCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTCY000000000-CAPTDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTDI000000000-CAPTDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTEK000000000-CAPTEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTEP000000000-CAPTER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTEW000000000-CAPTFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTFG000000000-CAPTFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTFK000000000-CAPTFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTFQ000000000-CAPTFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTFZ000000000-CAPTGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTGF000000000-CAPTGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTGN000000000-CAPTGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTGQ000000000-CAPTGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTGX000000000-CAPTHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTHF000000000-CAPTHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTHR000000000-CAPTHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTII000000000-CAPTIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTIO000000000-CAPTIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTIR000000000-CAPTIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTIW000000000-CAPTIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTJG000000000-CAPTJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTJK000000000-CAPTJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTJV000000000-CAPTJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTJY000000000-CAPTJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTKJ000000000-CAPTKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTKQ000000000-CAPTKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTKY000000000-CAPTLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTLH000000000-CAPTLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTLV000000000-CAPTLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTMG000000000-CAPTMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTMJ000000000-CAPTMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTMR000000000-CAPTMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTMV000000000-CAPTMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTMZ000000000-CAPTNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTNH000000000-CAPTNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTNK000000000-CAPTNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTNO000000000-CAPTNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTNV000000000-CAPTNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTOI000000000-CAPTOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTOQ000000000-CAPTOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTOZ000000000-CAPTPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTPD000000000-CAPTPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTPN000000000-CAPTPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTPW000000000-CAPTPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTQH000000000-CAPTQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTQQ000000000-CAPTQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTQT000000000-CAPTQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTQZ000000000-CAPTRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTRF000000000-CAPTRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTRK000000000-CAPTRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTRU000000000-CAPTRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTRY000000000-CAPTSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTSG000000000-CAPTSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTSN000000000-CAPTSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTTK000000000-CAPTTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTTR000000000-CAPTTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTUI000000000-CAPTUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTUM000000000-CAPTUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTUP000000000-CAPTUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTUS000000000-CAPTUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTUW000000000-CAPTUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTUZ000000000-CAPTVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTVH000000000-CAPTVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTVM000000000-CAPTVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTVS000000000-CAPTVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTWC000000000-CAPTWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTWG000000000-CAPTWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTWJ000000000-CAPTWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPTWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTWY000000000-CAPTXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPTXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPTXO000000000-CAPTXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTXS000000000-CAPTXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTXZ000000000-CAPTYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTYD000000000-CAPTYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTYI000000000-CAPTYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTYQ000000000-CAPTYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTYT000000000-CAPTYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTZC000000000-CAPTZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTZG000000000-CAPTZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTZL000000000-CAPTZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTZO000000000-CAPTZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTZS000000000-CAPTZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUAB000000000-CAPUAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUAH000000000-CAPUAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUAM000000000-CAPUAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUAR000000000-CAPUAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUBF000000000-CAPUBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUBK000000000-CAPUBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUBQ000000000-CAPUBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUBU000000000-CAPUBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUCE000000000-CAPUCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUCL000000000-CAPUCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUCP000000000-CAPUCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUCT000000000-CAPUCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUDE000000000-CAPUDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUDL000000000-CAPUDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUDW000000000-CAPUDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUEC000000000-CAPUEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUEN000000000-CAPUEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUER000000000-CAPUES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUEW000000000-CAPUEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUFL000000000-CAPUFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUFQ000000000-CAPUFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUFT000000000-CAPUFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUFX000000000-CAPUFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUGE000000000-CAPUGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUGJ000000000-CAPUGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUGM000000000-CAPUGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUGQ000000000-CAPUGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUGW000000000-CAPUGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUHC000000000-CAPUHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUHJ000000000-CAPUHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUHR000000000-CAPUHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUHV000000000-CAPUHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUHZ000000000-CAPUIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUIG000000000-CAPUIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUIN000000000-CAPUIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUJC000000000-CAPUJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUJL000000000-CAPUJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUJV000000000-CAPUJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUKA000000000-CAPUKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUKI000000000-CAPUKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUKO000000000-CAPUKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUKT000000000-CAPUKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPULB000000000-CAPULC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPULE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPULG000000000-CAPULH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPULJ000000000-CAPULK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPULO000000000-CAPULP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPULR000000000-CAPULS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPULU000000000-CAPULW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPULY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUMC000000000-CAPUME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUMH000000000-CAPUMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUMM000000000-CAPUMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUMP000000000-CAPUMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUMT000000000-CAPUMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUNB000000000-CAPUNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUNE000000000-CAPUNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUNJ000000000-CAPUNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUOC000000000-CAPUOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUOM000000000-CAPUOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUOS000000000-CAPUOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUPI000000000-CAPUPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUPM000000000-CAPUPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUPR000000000-CAPUPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUPW000000000-CAPUPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUPZ000000000-CAPUQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUQD000000000-CAPUQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUQI000000000-CAPUQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUQP000000000-CAPUQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUQT000000000-CAPUQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUQZ000000000-CAPURE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPURI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPURK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPURM000000000-CAPURO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPURR000000000-CAPURV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPURY000000000-CAPUSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUSC000000000-CAPUSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUSK000000000-CAPUSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUSO000000000-CAPUSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUST000000000-CAPUTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUTD000000000-CAPUTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUTJ000000000-CAPUTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUTV000000000-CAPUUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUUJ000000000-CAPUUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUUR000000000-CAPUUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUUY000000000-CAPUVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUVC000000000-CAPUVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUVN000000000-CAPUVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUVQ000000000-CAPUVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUVY000000000-CAPUWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUWD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUWQ000000000-CAPUWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUXC000000000-CAPUXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUXI000000000-CAPUXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUXM000000000-CAPUXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUXW000000000-CAPUYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUYJ000000000-CAPUYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUYO000000000-CAPUYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUZD000000000-CAPUZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUZG000000000-CAPUZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUZK000000000-CAPUZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPUZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPUZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPUZV000000000-CAPUZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVAC000000000-CAPVAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVAG000000000-CAPVAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVAN000000000-CAPVAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVAV000000000-CAPVAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVBC000000000-CAPVBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVBF000000000-CAPVBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVBQ000000000-CAPVBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVBY000000000-CAPVBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVCE000000000-CAPVCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVCL000000000-CAPVCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVCV000000000-CAPVCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVDG000000000-CAPVDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVDN000000000-CAPVDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVDT000000000-CAPVDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVDX000000000-CAPVDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVEA000000000-CAPVEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVEI000000000-CAPVEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVEO000000000-CAPVEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVET000000000-CAPVEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVEX000000000-CAPVEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVFB000000000-CAPVFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVFK000000000-CAPVFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVFT000000000-CAPVGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVGC000000000-CAPVGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVGM000000000-CAPVGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVGP000000000-CAPVGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVGX000000000-CAPVGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVHD000000000-CAPVHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVHI000000000-CAPVHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVHL000000000-CAPVHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVHQ000000000-CAPVHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVIC000000000-CAPVII999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVIR000000000-CAPVIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVIW000000000-CAPVIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVJF000000000-CAPVJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVJI000000000-CAPVJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVJN000000000-CAPVJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVJQ000000000-CAPVJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVJU000000000-CAPVJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVJY000000000-CAPVKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVKJ000000000-CAPVKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVKR000000000-CAPVKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVKZ000000000-CAPVLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVLC000000000-CAPVLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVMB000000000-CAPVMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVMH000000000-CAPVMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVMK000000000-CAPVMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVMP000000000-CAPVMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVMS000000000-CAPVMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVMX000000000-CAPVMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVNM000000000-CAPVNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVNP000000000-CAPVNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVNZ000000000-CAPVOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVOO000000000-CAPVOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVOR000000000-CAPVOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVOY000000000-CAPVPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVPJ000000000-CAPVPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVPQ000000000-CAPVPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVPV000000000-CAPVQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVQF000000000-CAPVQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVQP000000000-CAPVQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVQW000000000-CAPVQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVRB000000000-CAPVRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVRK000000000-CAPVRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVRP000000000-CAPVRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVSH000000000-CAPVSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVSK000000000-CAPVSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVSW000000000-CAPVSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVTJ000000000-CAPVTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVTN000000000-CAPVTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVTQ000000000-CAPVTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVTX000000000-CAPVUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVUC000000000-CAPVUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVUJ000000000-CAPVUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVUN000000000-CAPVUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVUX000000000-CAPVUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVVJ000000000-CAPVVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVVN000000000-CAPVVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVVV000000000-CAPVVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVWA000000000-CAPVWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVWT000000000-CAPVWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVXE000000000-CAPVXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVXH000000000-CAPVXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVXN000000000-CAPVXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVXR000000000-CAPVXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVXZ000000000-CAPVYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVYC000000000-CAPVYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVYM000000000-CAPVYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVYR000000000-CAPVYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVZF000000000-CAPVZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVZL000000000-CAPVZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPVZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPVZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPVZV000000000-CAPVZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWAD000000000-CAPWAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWAK000000000-CAPWAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWAX000000000-CAPWAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWBA000000000-CAPWBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWBL000000000-CAPWBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWCC000000000-CAPWCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWCJ000000000-CAPWCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWCP000000000-CAPWCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWCW000000000-CAPWCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWDA000000000-CAPWDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWDJ000000000-CAPWDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWDW000000000-CAPWDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWDZ000000000-CAPWEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWEC000000000-CAPWEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWEQ000000000-CAPWES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWEX000000000-CAPWEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWFB000000000-CAPWFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWFI000000000-CAPWFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWFQ000000000-CAPWFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWGF000000000-CAPWGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWGI000000000-CAPWGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWGN000000000-CAPWGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWGS000000000-CAPWGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWHD000000000-CAPWHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWHJ000000000-CAPWHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWHN000000000-CAPWHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWHQ000000000-CAPWHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWHT000000000-CAPWHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWIA000000000-CAPWID999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWII000000000-CAPWIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWIO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWIT000000000-CAPWIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWJC000000000-CAPWJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWJG000000000-CAPWJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWJL000000000-CAPWJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWJO000000000-CAPWJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWJR000000000-CAPWJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWJX000000000-CAPWKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWKJ000000000-CAPWKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWKQ000000000-CAPWKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWKW000000000-CAPWKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWKZ000000000-CAPWLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWLC000000000-CAPWLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWLJ000000000-CAPWLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWLO000000000-CAPWLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWLT000000000-CAPWLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWMB000000000-CAPWMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWMG000000000-CAPWMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWMM000000000-CAPWMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWMP000000000-CAPWMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWMT000000000-CAPWMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWNH000000000-CAPWNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWNL000000000-CAPWNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWNP000000000-CAPWNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWNW000000000-CAPWNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWNZ000000000-CAPWOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWOD000000000-CAPWOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWOK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWOO000000000-CAPWOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWOS000000000-CAPWOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWPG000000000-CAPWPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWPQ000000000-CAPWPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWPV000000000-CAPWPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWQA000000000-CAPWQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWQI000000000-CAPWQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWQL000000000-CAPWQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWQQ000000000-CAPWQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWQT000000000-CAPWQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWRB000000000-CAPWRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWRE000000000-CAPWRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWRL000000000-CAPWRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWRO000000000-CAPWRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWRS000000000-CAPWRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWRY000000000-CAPWRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWSC000000000-CAPWSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWSI000000000-CAPWSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWSO000000000-CAPWSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWSU000000000-CAPWSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWTC000000000-CAPWTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWTI000000000-CAPWTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWTN000000000-CAPWTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWTX000000000-CAPWTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWUD000000000-CAPWUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWUN000000000-CAPWUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWUQ000000000-CAPWUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWUX000000000-CAPWVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWVM000000000-CAPWVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWVW000000000-CAPWWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWWH000000000-CAPWWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWWN000000000-CAPWWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWWQ000000000-CAPWWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWWV000000000-CAPWWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWXB000000000-CAPWXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWXL000000000-CAPWXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWXR000000000-CAPWXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWXV000000000-CAPWXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWXY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWYA000000000-CAPWYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWYF000000000-CAPWYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPWYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWZB000000000-CAPWZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWZF000000000-CAPWZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWZN000000000-CAPWZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPWZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPWZT000000000-CAPWZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWZW000000000-CAPWZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXAB000000000-CAPXAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXAM000000000-CAPXAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXAQ000000000-CAPXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXAX000000000-CAPXBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXBC000000000-CAPXBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXBG000000000-CAPXBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXBR000000000-CAPXBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXBW000000000-CAPXBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXCF000000000-CAPXCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXCK000000000-CAPXCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXCQ000000000-CAPXCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXCY000000000-CAPXCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXDD000000000-CAPXDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXDK000000000-CAPXDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXDQ000000000-CAPXDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXDV000000000-CAPXDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXEA000000000-CAPXEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXED000000000-CAPXEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXEL000000000-CAPXEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXEO000000000-CAPXER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXEX000000000-CAPXFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXFJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXFR000000000-CAPXFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXFX000000000-CAPXFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXGB000000000-CAPXGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXGK000000000-CAPXGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXGO000000000-CAPXGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXGS000000000-CAPXGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXHA000000000-CAPXHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXHD000000000-CAPXHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXHK000000000-CAPXHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXHO000000000-CAPXHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXHR000000000-CAPXHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXIF000000000-CAPXIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXIK000000000-CAPXIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXIO000000000-CAPXIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXIT000000000-CAPXIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXJG000000000-CAPXJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXJK000000000-CAPXJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXJS000000000-CAPXJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXKA000000000-CAPXKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXKE000000000-CAPXKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXKM000000000-CAPXKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXKQ000000000-CAPXKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXLG000000000-CAPXLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXLN000000000-CAPXLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXLW000000000-CAPXLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXMB000000000-CAPXMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXMF000000000-CAPXMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXMP000000000-CAPXMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXNB000000000-CAPXNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXNF000000000-CAPXNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXNN000000000-CAPXNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXOR000000000-CAPXOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXOV000000000-CAPXOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXOZ000000000-CAPXPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXPN000000000-CAPXPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXPU000000000-CAPXPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXPZ000000000-CAPXQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXQG000000000-CAPXQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXQK000000000-CAPXQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXQX000000000-CAPXRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXRE000000000-CAPXRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXRM000000000-CAPXRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXRS000000000-CAPXRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXRV000000000-CAPXRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXRY000000000-CAPXSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXSD000000000-CAPXSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXSI000000000-CAPXSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXSR000000000-CAPXST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXTE000000000-CAPXTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXTP000000000-CAPXTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXUB000000000-CAPXUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXUH000000000-CAPXUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXUK000000000-CAPXUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXUS000000000-CAPXUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXUZ000000000-CAPXVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXVC000000000-CAPXVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPXVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXVN000000000-CAPXVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXVR000000000-CAPXVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXVW000000000-CAPXVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXWC000000000-CAPXWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXWF000000000-CAPXWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXWL000000000-CAPXWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXWT000000000-CAPXWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXWY000000000-CAPXXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXXF000000000-CAPXXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXXK000000000-CAPXXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXXN000000000-CAPXXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXXR000000000-CAPXXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXXV000000000-CAPXXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXYD000000000-CAPXYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXYH000000000-CAPXYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXYK000000000-CAPXYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXYS000000000-CAPXYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXYV000000000-CAPXYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPXZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPXZD000000000-CAPXZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXZI000000000-CAPXZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXZL000000000-CAPXZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXZQ000000000-CAPXZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXZW000000000-CAPXZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYAC000000000-CAPYAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYAK000000000-CAPYAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYAR000000000-CAPYAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYAZ000000000-CAPYBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYBJ000000000-CAPYBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYBO000000000-CAPYBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYBU000000000-CAPYBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYCA000000000-CAPYCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYCH000000000-CAPYCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYCM000000000-CAPYCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYCP000000000-CAPYCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYCU000000000-CAPYCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYDA000000000-CAPYDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYDJ000000000-CAPYDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYDR000000000-CAPYDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYDU000000000-CAPYDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYDY000000000-CAPYEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYEG000000000-CAPYEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYER000000000-CAPYES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYEX000000000-CAPYEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYFC000000000-CAPYFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYFH000000000-CAPYFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYFY000000000-CAPYFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYGC000000000-CAPYGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYGP000000000-CAPYGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYGW000000000-CAPYGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYHE000000000-CAPYHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYHO000000000-CAPYHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYHW000000000-CAPYIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYIG000000000-CAPYIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYIM000000000-CAPYIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYIU000000000-CAPYIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYIX000000000-CAPYJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYJD000000000-CAPYJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYJJ000000000-CAPYJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYJM000000000-CAPYJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYKB000000000-CAPYKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYKL000000000-CAPYKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYKU000000000-CAPYKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYLB000000000-CAPYLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYLF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYLI000000000-CAPYLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYLR000000000-CAPYLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYLY000000000-CAPYLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYMB000000000-CAPYMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYMI000000000-CAPYMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYML000000000-CAPYMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYMO000000000-CAPYMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYMW000000000-CAPYMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYNA000000000-CAPYNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYND000000000-CAPYNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYNI000000000-CAPYNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYNR000000000-CAPYNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYNW000000000-CAPYNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYOE000000000-CAPYOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYOI000000000-CAPYOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYOO000000000-CAPYOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYOS000000000-CAPYOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYOZ000000000-CAPYPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYPC000000000-CAPYPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYPG000000000-CAPYPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYPO000000000-CAPYPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYPY000000000-CAPYPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYQB000000000-CAPYQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYQM000000000-CAPYQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYQT000000000-CAPYQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYQY000000000-CAPYQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYRC000000000-CAPYRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYRH000000000-CAPYRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYRM000000000-CAPYRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYRZ000000000-CAPYSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYSD000000000-CAPYSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYSM000000000-CAPYSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYST000000000-CAPYSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYTG000000000-CAPYTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYTL000000000-CAPYTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYTT000000000-CAPYTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYUB000000000-CAPYUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYUH000000000-CAPYUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYUR000000000-CAPYUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYUW000000000-CAPYUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYVG000000000-CAPYVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYVK000000000-CAPYVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYVO000000000-CAPYVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYVX000000000-CAPYVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYWD000000000-CAPYWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYWP000000000-CAPYWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYWU000000000-CAPYWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYWZ000000000-CAPYXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYXC000000000-CAPYXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYXI000000000-CAPYXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYXM000000000-CAPYXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYXZ000000000-CAPYYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYYE000000000-CAPYYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYYI000000000-CAPYYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYYQ000000000-CAPYYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYYY000000000-CAPYZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYZD000000000-CAPYZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYZM000000000-CAPYZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPYZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPYZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPYZV000000000-CAPZAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZAF000000000-CAPZAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZAN000000000-CAPZAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZAS000000000-CAPZAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZAZ000000000-CAPZBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZBF000000000-CAPZBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZBL000000000-CAPZBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZBO000000000-CAPZBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZBT000000000-CAPZBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZCD000000000-CAPZCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZCQ000000000-CAPZCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZCU000000000-CAPZCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZCY000000000-CAPZDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZDL000000000-CAPZDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZDQ000000000-CAPZDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZDU000000000-CAPZDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZDX000000000-CAPZEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZEP000000000-CAPZEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZEU000000000-CAPZEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZFA000000000-CAPZFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZFI000000000-CAPZFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZFM000000000-CAPZFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZFV000000000-CAPZFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZGD000000000-CAPZGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZGK000000000-CAPZGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZGP000000000-CAPZGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZHB000000000-CAPZHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZHL000000000-CAPZHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZHT000000000-CAPZHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZHW000000000-CAPZHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZIA000000000-CAPZIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZID000000000-CAPZIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZIS000000000-CAPZIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZIW000000000-CAPZJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZJF000000000-CAPZJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZJI000000000-CAPZJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZJM000000000-CAPZJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZJP000000000-CAPZJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZJV000000000-CAPZJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZJZ000000000-CAPZKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZKD000000000-CAPZKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZKI000000000-CAPZKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZKO000000000-CAPZKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZKW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZLI000000000-CAPZLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZLL000000000-CAPZLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZLU000000000-CAPZMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZMG000000000-CAPZMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZMN000000000-CAPZMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZMR000000000-CAPZMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZMU000000000-CAPZMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZNA000000000-CAPZNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZNF000000000-CAPZNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZNT000000000-CAPZNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZOA000000000-CAPZOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZOI000000000-CAPZOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZOQ000000000-CAPZOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZOV000000000-CAPZOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZPC000000000-CAPZPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZPM000000000-CAPZPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZPU000000000-CAPZQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZQH000000000-CAPZQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZQN000000000-CAPZQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZQS000000000-CAPZQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZRB000000000-CAPZRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZRF000000000-CAPZRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZRJ000000000-CAPZRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZRY000000000-CAPZRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZSB000000000-CAPZSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZSI000000000-CAPZSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZSS000000000-CAPZST999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZSW000000000-CAPZSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZTD000000000-CAPZTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZTJ000000000-CAPZTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZTN000000000-CAPZTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZTV000000000-CAPZTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZUC000000000-CAPZUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZUO000000000-CAPZUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZUT000000000-CAPZUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZUY000000000-CAPZUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZVC000000000-CAPZVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZVL000000000-CAPZVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZVR000000000-CAPZVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZVU000000000-CAPZVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZWC000000000-CAPZWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZWK000000000-CAPZWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZWQ000000000-CAPZWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZWV000000000-CAPZWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZWZ000000000-CAPZXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZXC000000000-CAPZXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZXI000000000-CAPZXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZYE000000000-CAPZYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZYL000000000-CAPZYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZYQ000000000-CAPZYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZYU000000000-CAPZYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZYY000000000-CAPZZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZZC000000000-CAPZZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAPZZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZZN000000000-CAPZZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZZX000000000-CAQAAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAAM000000000-CAQAAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAAP000000000-CAQAAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAAV000000000-CAQAAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQABA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQABD000000000-CAQABH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQABK000000000-CAQABL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQABU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQABW000000000-CAQABX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQABZ000000000-CAQACB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQACD000000000-CAQACG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQACJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQACL000000000-CAQACN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQACT000000000-CAQACW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQACY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQADA000000000-CAQADC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQADF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQADI000000000-CAQADK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQADO000000000-CAQADR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQADT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQADV000000000-CAQADZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAEB000000000-CAQAEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAEN000000000-CAQAEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAER000000000-CAQAET999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAEV000000000-CAQAEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAFH000000000-CAQAFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAFS000000000-CAQAFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAGE000000000-CAQAGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAGI000000000-CAQAGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAGM000000000-CAQAGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAGV000000000-CAQAGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAHB000000000-CAQAHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAHG000000000-CAQAHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAHM000000000-CAQAHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAIH000000000-CAQAII999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAIO000000000-CAQAIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAIR000000000-CAQAIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAIW000000000-CAQAIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAJA000000000-CAQAJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAJE000000000-CAQAJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAJZ000000000-CAQAKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAKG000000000-CAQAKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAKN000000000-CAQAKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAKS000000000-CAQAKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAKV000000000-CAQALA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQALC000000000-CAQALF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQALI000000000-CAQALL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQALN000000000-CAQALQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQALU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQALW000000000-CAQALX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAMG000000000-CAQAMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAMJ000000000-CAQAML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAMT000000000-CAQAMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQANB000000000-CAQANC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQANF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQANH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQANJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQANL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQANP000000000-CAQANQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQANT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQANV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAOE000000000-CAQAOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAOK000000000-CAQAON999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAOP000000000-CAQAOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAOW000000000-CAQAOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAPJ000000000-CAQAPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAPO000000000-CAQAPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAPT000000000-CAQAPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAPZ000000000-CAQAQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAQF000000000-CAQAQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAQL000000000-CAQAQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAQT000000000-CAQAQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAQX000000000-CAQAQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQARC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQARF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQARJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQARL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQARS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQARV000000000-CAQARW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQARY000000000-CAQARZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQASC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQASH000000000-CAQASJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQASM000000000-CAQASN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQASP000000000-CAQASQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQASZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQATE000000000-CAQATF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQATI000000000-CAQATP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQATR000000000-CAQATS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQATU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQATY000000000-CAQATZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAUB000000000-CAQAUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAUJ000000000-CAQAUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAUQ000000000-CAQAUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAVA000000000-CAQAVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAVJ000000000-CAQAVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAVN000000000-CAQAVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAVT000000000-CAQAVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAWB000000000-CAQAWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAWI000000000-CAQAWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAWN000000000-CAQAWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAWW000000000-CAQAXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAXL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAXT000000000-CAQAXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAYI000000000-CAQAYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAYL000000000-CAQAYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAYO000000000-CAQAYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAYZ000000000-CAQAZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAZD000000000-CAQAZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQAZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQAZU000000000-CAQAZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQAZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBAA000000000-CAQBAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBAM000000000-CAQBAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBAV000000000-CAQBAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBBJ000000000-CAQBBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBBP000000000-CAQBBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBBU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBCC000000000-CAQBCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBCR000000000-CAQBCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBCX000000000-CAQBCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBDA000000000-CAQBDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBDE000000000-CAQBDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBDQ000000000-CAQBDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBEA000000000-CAQBEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBEG000000000-CAQBEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBEM000000000-CAQBEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBEV000000000-CAQBEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBEY000000000-CAQBEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBFB000000000-CAQBFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBFK000000000-CAQBFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBFW000000000-CAQBFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBGA000000000-CAQBGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBGG000000000-CAQBGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBGP000000000-CAQBGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBGT000000000-CAQBGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBGW000000000-CAQBGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBHB000000000-CAQBHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBHH000000000-CAQBHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBHN000000000-CAQBHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBHR000000000-CAQBHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBHZ000000000-CAQBIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBIH000000000-CAQBIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBIL000000000-CAQBIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBIO000000000-CAQBIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBIV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBJB000000000-CAQBJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBJO000000000-CAQBJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBJY000000000-CAQBJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBKF000000000-CAQBKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBKM000000000-CAQBKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBKU000000000-CAQBKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBKZ000000000-CAQBLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBLG000000000-CAQBLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBLS000000000-CAQBLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBLV000000000-CAQBLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBMH000000000-CAQBMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBMM000000000-CAQBMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBMV000000000-CAQBMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBMY000000000-CAQBNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBNE000000000-CAQBNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBNL000000000-CAQBNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBNR000000000-CAQBNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBNX000000000-CAQBOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBOC000000000-CAQBOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBOJ000000000-CAQBOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBOM000000000-CAQBOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBOT000000000-CAQBOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBPS000000000-CAQBPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBPX000000000-CAQBQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBQH000000000-CAQBQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBQS000000000-CAQBQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBQW000000000-CAQBQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBRA000000000-CAQBRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBRE000000000-CAQBRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBRJ000000000-CAQBRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBRO000000000-CAQBRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBRR000000000-CAQBRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBSA000000000-CAQBSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBSK000000000-CAQBSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBSO000000000-CAQBSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBSW000000000-CAQBSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBTI000000000-CAQBTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBTQ000000000-CAQBTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBUD000000000-CAQBUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBUH000000000-CAQBUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBUP000000000-CAQBUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBUV000000000-CAQBVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBVH000000000-CAQBVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBVM000000000-CAQBVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBVP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBVU000000000-CAQBVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBWB000000000-CAQBWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBWH000000000-CAQBWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBWT000000000-CAQBWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBWY000000000-CAQBXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBXK000000000-CAQBXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBXV000000000-CAQBXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBXY000000000-CAQBXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBYB000000000-CAQBYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBYF000000000-CAQBYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBYP000000000-CAQBYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBYW000000000-CAQBYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBYZ000000000-CAQBZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBZF000000000-CAQBZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQBZL000000000-CAQBZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQBZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQBZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCAC000000000-CAQCAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCAG000000000-CAQCAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCAM000000000-CAQCAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCAQ000000000-CAQCAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCAX000000000-CAQCBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCBU000000000-CAQCBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCCB000000000-CAQCCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCCG000000000-CAQCCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCCL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCDF000000000-CAQCDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCDM000000000-CAQCDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCDP000000000-CAQCDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCDT000000000-CAQCDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCEA000000000-CAQCEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCEN000000000-CAQCEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCEX000000000-CAQCEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCFA000000000-CAQCFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCFF000000000-CAQCFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCFI000000000-CAQCFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCFP000000000-CAQCFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCFV000000000-CAQCFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCGF000000000-CAQCGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCGP000000000-CAQCGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCGT000000000-CAQCGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCGZ000000000-CAQCHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCHL000000000-CAQCHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCHW000000000-CAQCIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCIH000000000-CAQCIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCIL000000000-CAQCIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCIR000000000-CAQCIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCJA000000000-CAQCJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCJF000000000-CAQCJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCJL000000000-CAQCJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCJP000000000-CAQCJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCJV000000000-CAQCJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCJZ000000000-CAQCKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCKC000000000-CAQCKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCKH000000000-CAQCKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCKS000000000-CAQCKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCKX000000000-CAQCKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCLL000000000-CAQCLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCLP000000000-CAQCLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCLV000000000-CAQCLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCMD000000000-CAQCME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCMH000000000-CAQCMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCMN000000000-CAQCMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCMS000000000-CAQCMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCMX000000000-CAQCNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCNM000000000-CAQCNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCNV000000000-CAQCOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCOF000000000-CAQCOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCOL000000000-CAQCOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCOO000000000-CAQCOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCOR000000000-CAQCOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCPA000000000-CAQCPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCPG000000000-CAQCPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCPU000000000-CAQCPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCQO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCQS000000000-CAQCQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCQV000000000-CAQCQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCQZ000000000-CAQCRD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCRH000000000-CAQCRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCRM000000000-CAQCRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCRQ000000000-CAQCRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCRX000000000-CAQCRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCSH000000000-CAQCSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCST000000000-CAQCSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCTB000000000-CAQCTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCTH000000000-CAQCTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCTR000000000-CAQCTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCTV000000000-CAQCTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCUH000000000-CAQCUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCUQ000000000-CAQCUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCUU000000000-CAQCUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCVJ000000000-CAQCVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCVQ000000000-CAQCVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCVW000000000-CAQCVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCWC000000000-CAQCWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCWO000000000-CAQCWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCWW000000000-CAQCWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCXB000000000-CAQCXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCXI000000000-CAQCXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCXN000000000-CAQCXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCXT000000000-CAQCYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCYI000000000-CAQCYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQCYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCYQ000000000-CAQCYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCYW000000000-CAQCYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCZA000000000-CAQCZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCZF000000000-CAQCZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCZP000000000-CAQCZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCZS000000000-CAQCZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCZX000000000-CAQDAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDAE000000000-CAQDAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDAI000000000-CAQDAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDAM000000000-CAQDAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDAR000000000-CAQDAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDBM000000000-CAQDBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDBR000000000-CAQDBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDBU000000000-CAQDBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDCF000000000-CAQDCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDCL000000000-CAQDCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDCP000000000-CAQDCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDCS000000000-CAQDCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDDA000000000-CAQDDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDDH000000000-CAQDDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDDW000000000-CAQDDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDEA000000000-CAQDEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDEE000000000-CAQDEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDEJ000000000-CAQDEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDEW000000000-CAQDEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDEZ000000000-CAQDFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDFK000000000-CAQDFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDFP000000000-CAQDFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDFT000000000-CAQDFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDGB000000000-CAQDGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDGF000000000-CAQDGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDGK000000000-CAQDGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDHD000000000-CAQDHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDHH000000000-CAQDHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDHL000000000-CAQDHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDHO000000000-CAQDHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDIB000000000-CAQDID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDIG000000000-CAQDIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDIM000000000-CAQDIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDIQ000000000-CAQDIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDIX000000000-CAQDIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDJA000000000-CAQDJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDJH000000000-CAQDJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDJK000000000-CAQDJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDJP000000000-CAQDJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDJX000000000-CAQDJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDKA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDKT000000000-CAQDKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDLC000000000-CAQDLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDLK000000000-CAQDLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDLN000000000-CAQDLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDLT000000000-CAQDLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDLW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDMA000000000-CAQDMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDME000000000-CAQDMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDMK000000000-CAQDMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDMU000000000-CAQDNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDNC000000000-CAQDNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDNH000000000-CAQDNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDNL000000000-CAQDNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDNR000000000-CAQDNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDOA000000000-CAQDOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDOS000000000-CAQDOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDOY000000000-CAQDOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDPF000000000-CAQDPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDPN000000000-CAQDPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDPR000000000-CAQDPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDPW000000000-CAQDQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDQE000000000-CAQDQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDQL000000000-CAQDQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDQP000000000-CAQDQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDRE000000000-CAQDRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDRH000000000-CAQDRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDRK000000000-CAQDRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDRP000000000-CAQDRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDRW000000000-CAQDRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDSB000000000-CAQDSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDSE000000000-CAQDSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDSO000000000-CAQDSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDSU000000000-CAQDSV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDTG000000000-CAQDTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDTM000000000-CAQDTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDTR000000000-CAQDTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDTW000000000-CAQDTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDUI000000000-CAQDUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDUL000000000-CAQDUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDUQ000000000-CAQDUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDUX000000000-CAQDUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDVB000000000-CAQDVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDVF000000000-CAQDVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDVK000000000-CAQDVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDVN000000000-CAQDVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDVW000000000-CAQDVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDWC000000000-CAQDWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDWM000000000-CAQDWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDWU000000000-CAQDWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDXA000000000-CAQDXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDXI000000000-CAQDXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQDXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDXR000000000-CAQDXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDXU000000000-CAQDXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDXX000000000-CAQDXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDYB000000000-CAQDYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDYH000000000-CAQDYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDYM000000000-CAQDYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDYU000000000-CAQDYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQDZA000000000-CAQDZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDZG000000000-CAQDZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDZK000000000-CAQDZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDZQ000000000-CAQDZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDZT000000000-CAQDZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQDZY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEAA000000000-CAQEAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEAG000000000-CAQEAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEAL000000000-CAQEAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEAU000000000-CAQEBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEBI000000000-CAQEBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEBS000000000-CAQEBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEBW000000000-CAQECA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQECC000000000-CAQECD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQECG000000000-CAQECH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQECL000000000-CAQECM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQECO000000000-CAQECQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQECS000000000-CAQECT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQECW000000000-CAQEDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEDK000000000-CAQEDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEDN000000000-CAQEDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEDU000000000-CAQEDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEEO000000000-CAQEEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEEV000000000-CAQEEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEEZ000000000-CAQEFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEFF000000000-CAQEFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEFP000000000-CAQEFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEFV000000000-CAQEFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEFY000000000-CAQEGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEGE000000000-CAQEGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEGK000000000-CAQEGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEGT000000000-CAQEGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEGX000000000-CAQEGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEHB000000000-CAQEHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEHI000000000-CAQEHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEHQ000000000-CAQEHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEHT000000000-CAQEHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEHY000000000-CAQEHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEIB000000000-CAQEIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEII000000000-CAQEIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEIO000000000-CAQEIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEIZ000000000-CAQEJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEJF000000000-CAQEJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEJM000000000-CAQEJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEJP000000000-CAQEJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEJT000000000-CAQEJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEJZ000000000-CAQEKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEKF000000000-CAQEKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEKI000000000-CAQEKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEKU000000000-CAQEKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQELG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQELI000000000-CAQELJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQELM000000000-CAQELN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQELP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQELR000000000-CAQELS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQELW000000000-CAQELX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQELZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEMD000000000-CAQEMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEML000000000-CAQEMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEMO000000000-CAQEMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEMT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQENA000000000-CAQEND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQENG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQENK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQENM000000000-CAQENO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQENS000000000-CAQENY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEOD000000000-CAQEOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEOJ000000000-CAQEOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEOT000000000-CAQEOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEOW000000000-CAQEOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEPB000000000-CAQEPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEPI000000000-CAQEPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEPP000000000-CAQEPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEPW000000000-CAQEPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEQA000000000-CAQEQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEQJ000000000-CAQEQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEQP000000000-CAQEQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEQS000000000-CAQEQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQERA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQERG000000000-CAQERH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQERJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQERO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQERR000000000-CAQERV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQERX000000000-CAQERZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQESD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQESF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQESH000000000-CAQESO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQESS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQESU000000000-CAQESW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQESZ000000000-CAQETA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQETC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQETE000000000-CAQETF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQETH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQETK000000000-CAQETO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQETQ000000000-CAQETR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQETU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQETW000000000-CAQETX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEUA000000000-CAQEUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEUE000000000-CAQEUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEUM000000000-CAQEUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEVA000000000-CAQEVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEVF000000000-CAQEVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEVK000000000-CAQEVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEVQ000000000-CAQEVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEVT000000000-CAQEVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEWA000000000-CAQEWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEWG000000000-CAQEWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEWK000000000-CAQEWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEWN000000000-CAQEWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEWZ000000000-CAQEXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEXI000000000-CAQEXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEXM000000000-CAQEXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEXR000000000-CAQEXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEYA000000000-CAQEYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEYD000000000-CAQEYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEYK000000000-CAQEYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEYQ000000000-CAQEYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEZD000000000-CAQEZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEZI000000000-CAQEZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEZM000000000-CAQEZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQEZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEZZ000000000-CAQFAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFAC000000000-CAQFAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFAJ000000000-CAQFAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFAO000000000-CAQFAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFAX000000000-CAQFBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFBC000000000-CAQFBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFBL000000000-CAQFBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFBV000000000-CAQFBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFBZ000000000-CAQFCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFCK000000000-CAQFCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFCN000000000-CAQFCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFCT000000000-CAQFCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFCY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFDG000000000-CAQFDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFDQ000000000-CAQFDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFDX000000000-CAQFEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFEE000000000-CAQFEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFEH000000000-CAQFEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFEM000000000-CAQFEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFEU000000000-CAQFEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFFC000000000-CAQFFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFFR000000000-CAQFFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFGC000000000-CAQFGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFGF000000000-CAQFGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFGP000000000-CAQFGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFGZ000000000-CAQFHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFHI000000000-CAQFHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFHT000000000-CAQFHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFIA000000000-CAQFIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFIL000000000-CAQFIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFIX000000000-CAQFIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFJA000000000-CAQFJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFJD000000000-CAQFJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFJT000000000-CAQFJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFKA000000000-CAQFKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFKM000000000-CAQFKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFKQ000000000-CAQFKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFKV000000000-CAQFKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFLB000000000-CAQFLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFLE000000000-CAQFLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFLL000000000-CAQFLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFLU000000000-CAQFLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFLY000000000-CAQFMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFMD000000000-CAQFME999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFMJ000000000-CAQFML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFMQ000000000-CAQFMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFMT000000000-CAQFMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFMW000000000-CAQFMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFNC000000000-CAQFND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFNF000000000-CAQFNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFNU000000000-CAQFOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFOJ000000000-CAQFOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFOQ000000000-CAQFOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFPD000000000-CAQFPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFPK000000000-CAQFPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFPT000000000-CAQFPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFQD000000000-CAQFQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFQI000000000-CAQFQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFQL000000000-CAQFQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFQT000000000-CAQFQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFQX000000000-CAQFRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFRK000000000-CAQFRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFRO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFRQ000000000-CAQFRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFRW000000000-CAQFRX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFSF000000000-CAQFSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFSP000000000-CAQFSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFSS000000000-CAQFSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFTA000000000-CAQFTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFTI000000000-CAQFTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFTQ000000000-CAQFTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFTW000000000-CAQFTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFUC000000000-CAQFUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFUF000000000-CAQFUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFUK000000000-CAQFUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFUP000000000-CAQFUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFUT000000000-CAQFUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFUX000000000-CAQFUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFVD000000000-CAQFVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFVI000000000-CAQFVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFVP000000000-CAQFVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFVS000000000-CAQFVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFWB000000000-CAQFWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFWH000000000-CAQFWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFWS000000000-CAQFWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFWX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFXA000000000-CAQFXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFXG000000000-CAQFXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFXM000000000-CAQFXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFXS000000000-CAQFXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFYA000000000-CAQFYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFYI000000000-CAQFYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFYP000000000-CAQFYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFYT000000000-CAQFYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFYX000000000-CAQFYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQFZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQFZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQFZL000000000-CAQFZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFZV000000000-CAQFZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFZY000000000-CAQGAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGAD000000000-CAQGAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGAJ000000000-CAQGAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGAR000000000-CAQGAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGAU000000000-CAQGAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGAY000000000-CAQGBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGBE000000000-CAQGBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGBH000000000-CAQGBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGBS000000000-CAQGBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGBY000000000-CAQGCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGCF000000000-CAQGCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGCJ000000000-CAQGCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGCM000000000-CAQGCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGCT000000000-CAQGCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGDC000000000-CAQGDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGDF000000000-CAQGDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGDM000000000-CAQGDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGDV000000000-CAQGDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGEA000000000-CAQGEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGED000000000-CAQGEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGEH000000000-CAQGEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGEP000000000-CAQGEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGET+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGFA000000000-CAQGFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGFH000000000-CAQGFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGFN000000000-CAQGFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGFS000000000-CAQGFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGFW000000000-CAQGFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGGB000000000-CAQGGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGGE000000000-CAQGGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGGI000000000-CAQGGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGGX000000000-CAQGGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGHC000000000-CAQGHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGHS000000000-CAQGHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGHV000000000-CAQGHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGHY000000000-CAQGHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGIB000000000-CAQGIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGIM000000000-CAQGIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGIR000000000-CAQGIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGIX000000000-CAQGJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGJC000000000-CAQGJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGJG000000000-CAQGJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGJL000000000-CAQGJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGJO000000000-CAQGJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGJX000000000-CAQGKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGKC000000000-CAQGKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGKG000000000-CAQGKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGKK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGKR000000000-CAQGKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGLD000000000-CAQGLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGLJ000000000-CAQGLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGLU000000000-CAQGLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGLY000000000-CAQGLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGMK000000000-CAQGML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGMO000000000-CAQGMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGMU000000000-CAQGMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGMY000000000-CAQGND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGNK000000000-CAQGNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGNO000000000-CAQGNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGNU000000000-CAQGNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGOD000000000-CAQGOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGOM000000000-CAQGON999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGOQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGOU000000000-CAQGOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGPD000000000-CAQGPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGPJ000000000-CAQGPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGPQ000000000-CAQGPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGPU000000000-CAQGPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGPX000000000-CAQGPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGQJ000000000-CAQGQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGQN000000000-CAQGQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGQU000000000-CAQGQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGRA000000000-CAQGRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGRH000000000-CAQGRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGRK000000000-CAQGRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGRU000000000-CAQGRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGRX000000000-CAQGRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGSA000000000-CAQGSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGSG000000000-CAQGSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGSM000000000-CAQGSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGSS000000000-CAQGSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGSZ000000000-CAQGTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGTI000000000-CAQGTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGTN000000000-CAQGTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGTT000000000-CAQGTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGTX000000000-CAQGUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGUC000000000-CAQGUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGUH000000000-CAQGUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGUL000000000-CAQGUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGUQ000000000-CAQGUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGVJ000000000-CAQGVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGVO000000000-CAQGVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGVS000000000-CAQGVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGVX000000000-CAQGVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGWB000000000-CAQGWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGWK000000000-CAQGWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGWR000000000-CAQGWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGWZ000000000-CAQGXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGXG000000000-CAQGXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGXK000000000-CAQGXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQGXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGXW000000000-CAQGXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGXZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGYC000000000-CAQGYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGYG000000000-CAQGYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGYK000000000-CAQGYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGYO000000000-CAQGYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGYV000000000-CAQGYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGZF000000000-CAQGZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGZL000000000-CAQGZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQGZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQGZQ000000000-CAQGZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGZW000000000-CAQGZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHAA000000000-CAQHAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHAL000000000-CAQHAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHAQ000000000-CAQHAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHBD000000000-CAQHBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHBG000000000-CAQHBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHBO000000000-CAQHBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHBS000000000-CAQHBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHBY000000000-CAQHCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHCC000000000-CAQHCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHCK000000000-CAQHCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHCP000000000-CAQHCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHDA000000000-CAQHDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHDE000000000-CAQHDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHDL000000000-CAQHDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHDP000000000-CAQHDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHDU000000000-CAQHDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHDY000000000-CAQHDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHEB000000000-CAQHEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHEI000000000-CAQHEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHEN000000000-CAQHEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHEQ000000000-CAQHES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHFC000000000-CAQHFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHFK000000000-CAQHFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHFP000000000-CAQHFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHFW000000000-CAQHGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHGE000000000-CAQHGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHGO000000000-CAQHGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHGT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHGV000000000-CAQHGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHHB000000000-CAQHHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHHF000000000-CAQHHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHHL000000000-CAQHHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHHO000000000-CAQHHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHHU000000000-CAQHHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHIC000000000-CAQHID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHIG000000000-CAQHII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHIN000000000-CAQHIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHIS000000000-CAQHIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHIV000000000-CAQHJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHJF000000000-CAQHJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHJO000000000-CAQHJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHJR000000000-CAQHJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHKC000000000-CAQHKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHKI000000000-CAQHKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHKO000000000-CAQHKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHKS000000000-CAQHKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHKX000000000-CAQHLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHLN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHLP000000000-CAQHLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHMD000000000-CAQHMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHMO000000000-CAQHMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHMY000000000-CAQHMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHNC000000000-CAQHNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHNQ000000000-CAQHNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHNW000000000-CAQHNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHOG000000000-CAQHOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHOK000000000-CAQHON999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHOR000000000-CAQHOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHPH000000000-CAQHPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHPK000000000-CAQHPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHPW000000000-CAQHQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHQE000000000-CAQHQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHQV000000000-CAQHQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHQZ000000000-CAQHRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHRT000000000-CAQHRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHSI000000000-CAQHSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHSM000000000-CAQHSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHSR000000000-CAQHSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHSX000000000-CAQHSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHUB000000000-CAQHUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHUG000000000-CAQHUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHUL000000000-CAQHUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHUW000000000-CAQHUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHVA000000000-CAQHVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHVF000000000-CAQHVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHVI000000000-CAQHVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHVO000000000-CAQHVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHVR000000000-CAQHVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHVX000000000-CAQHVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHWG000000000-CAQHWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHWN000000000-CAQHWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHWU000000000-CAQHWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHXA000000000-CAQHXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHXI000000000-CAQHXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQHXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHXW000000000-CAQHYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHYF000000000-CAQHYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHYI000000000-CAQHYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHYO000000000-CAQHYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHYX000000000-CAQHYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQHZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQHZD000000000-CAQHZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHZH000000000-CAQHZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHZM000000000-CAQHZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHZS000000000-CAQHZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHZW000000000-CAQHZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIAC000000000-CAQIAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIAH000000000-CAQIAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIAP000000000-CAQIAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIAW000000000-CAQIBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIBH000000000-CAQIBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIBR000000000-CAQIBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQICB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQICD000000000-CAQICH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQICM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQICP000000000-CAQICQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQICS000000000-CAQICU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQICX000000000-CAQICY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIDA000000000-CAQIDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIDE000000000-CAQIDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIDH000000000-CAQIDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIDN000000000-CAQIDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIDQ000000000-CAQIDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIDU000000000-CAQIDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIEA000000000-CAQIEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIEK000000000-CAQIEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIEU000000000-CAQIEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIFA000000000-CAQIFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIFF000000000-CAQIFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIFJ000000000-CAQIFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIFU000000000-CAQIFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIFY000000000-CAQIFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIGD000000000-CAQIGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIGP000000000-CAQIGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIHE000000000-CAQIHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIHK000000000-CAQIHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIHS000000000-CAQIHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIHW000000000-CAQIHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIIF000000000-CAQIIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIIJ000000000-CAQIIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIIU000000000-CAQIIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIJC000000000-CAQIJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIJI000000000-CAQIJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIJT000000000-CAQIJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIKJ000000000-CAQIKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIKO000000000-CAQIKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIKT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIKV000000000-CAQIKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIKZ000000000-CAQILA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQILC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQILE000000000-CAQILH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQILJ000000000-CAQILK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQILM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQILO000000000-CAQILP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQILR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQILT000000000-CAQILU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQILX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIMA000000000-CAQIMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIMG000000000-CAQIMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIMK000000000-CAQIML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIMO000000000-CAQIMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIMR000000000-CAQIMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIMV000000000-CAQIMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIMZ000000000-CAQINA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQINC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQINE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQINI000000000-CAQINK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQINN000000000-CAQINO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQINR000000000-CAQINS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQINV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQINX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIOB000000000-CAQIOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIOH000000000-CAQIOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQION+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIOP000000000-CAQIOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIOX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIOZ000000000-CAQIPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIPE000000000-CAQIPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIPJ000000000-CAQIPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIPO000000000-CAQIPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIPU000000000-CAQIPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIPY000000000-CAQIPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIQD000000000-CAQIQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIQG000000000-CAQIQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIQL000000000-CAQIQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIQR000000000-CAQIQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIQV000000000-CAQIQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIRD000000000-CAQIRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIRH000000000-CAQIRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIRR000000000-CAQIRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIRY000000000-CAQISA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQISC000000000-CAQISD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQISH000000000-CAQISI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQISL000000000-CAQISM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQISQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIST000000000-CAQISW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQISY000000000-CAQITA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQITD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQITG000000000-CAQITL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQITP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQITU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQITX000000000-CAQITY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIUC000000000-CAQIUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIUN000000000-CAQIUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIUX000000000-CAQIVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIVO000000000-CAQIVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIVW000000000-CAQIVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIVZ000000000-CAQIWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIWE000000000-CAQIWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIWM000000000-CAQIWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIWV000000000-CAQIWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIWZ000000000-CAQIXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIXI000000000-CAQIXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIXN000000000-CAQIXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIXR000000000-CAQIXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIXY000000000-CAQIYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIYC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIYE000000000-CAQIYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIYK000000000-CAQIYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIYX000000000-CAQIYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIZH000000000-CAQIZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQIZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIZT000000000-CAQIZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQIZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQIZY000000000-CAQJAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJAJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJAM000000000-CAQJAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJAV000000000-CAQJBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJBC000000000-CAQJBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJBF000000000-CAQJBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJBK000000000-CAQJBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJBR000000000-CAQJBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJBV000000000-CAQJCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJCG000000000-CAQJCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJCL000000000-CAQJCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJCR000000000-CAQJCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJCW000000000-CAQJCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJDC000000000-CAQJDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJDJ000000000-CAQJDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJDM000000000-CAQJDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJDX000000000-CAQJDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJEE000000000-CAQJEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJEI000000000-CAQJEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJEY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJFH000000000-CAQJFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJFM000000000-CAQJFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJGB000000000-CAQJGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJGN000000000-CAQJGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJGU000000000-CAQJGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJGY000000000-CAQJGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJHB000000000-CAQJHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJHG000000000-CAQJHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJHM000000000-CAQJHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJHR000000000-CAQJHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJHZ000000000-CAQJIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJIF000000000-CAQJIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJIJ000000000-CAQJIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJIQ000000000-CAQJIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJIT000000000-CAQJIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJIW000000000-CAQJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJJK000000000-CAQJJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJJP000000000-CAQJJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJJS000000000-CAQJJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJKL000000000-CAQJKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJKS000000000-CAQJKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJKZ000000000-CAQJLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJLD000000000-CAQJLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJLK000000000-CAQJLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJLZ000000000-CAQJMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJMD000000000-CAQJME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJMG000000000-CAQJMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJML000000000-CAQJMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJMV000000000-CAQJMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJNB000000000-CAQJNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJNP000000000-CAQJNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJNS000000000-CAQJNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJOB000000000-CAQJOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJOE000000000-CAQJOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJOI000000000-CAQJOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJOP000000000-CAQJOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJOV000000000-CAQJOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJOZ000000000-CAQJPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJPF000000000-CAQJPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJPL000000000-CAQJPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJPO000000000-CAQJPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJPT000000000-CAQJPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJQB000000000-CAQJQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJQQ000000000-CAQJQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJQX000000000-CAQJRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJRH000000000-CAQJRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJSS000000000-CAQJST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJSX000000000-CAQJTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJTD000000000-CAQJTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJTM000000000-CAQJTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJTW000000000-CAQJTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJUA000000000-CAQJUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJUK000000000-CAQJUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJUW000000000-CAQJUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJVG000000000-CAQJVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJVK000000000-CAQJVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJVT000000000-CAQJVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJWA000000000-CAQJWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJWU000000000-CAQJWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJWY000000000-CAQJWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJXC000000000-CAQJXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJXO000000000-CAQJXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJXX000000000-CAQJXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJYB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJYE000000000-CAQJYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJYQ000000000-CAQJYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJYX000000000-CAQJYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJZC000000000-CAQJZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQJZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJZP000000000-CAQJZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJZS000000000-CAQKAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKAH000000000-CAQKAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKAL000000000-CAQKAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKAV000000000-CAQKAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKBE000000000-CAQKBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKBI000000000-CAQKBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKBL000000000-CAQKBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKBT000000000-CAQKBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKBY000000000-CAQKCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKCM000000000-CAQKCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKDI000000000-CAQKDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKDL000000000-CAQKDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKDR000000000-CAQKDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKDX000000000-CAQKDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKED000000000-CAQKEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKEP000000000-CAQKEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKET000000000-CAQKEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKEY000000000-CAQKEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKFF000000000-CAQKFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKFI000000000-CAQKFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKFP000000000-CAQKFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKFT000000000-CAQKFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKFW000000000-CAQKFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKGD000000000-CAQKGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKGL000000000-CAQKGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKGR000000000-CAQKGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKHF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKHM000000000-CAQKHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKHU000000000-CAQKHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKIA000000000-CAQKIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKIG000000000-CAQKIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKIO000000000-CAQKIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKIT000000000-CAQKIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKJA000000000-CAQKJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKJY000000000-CAQKJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKKC000000000-CAQKKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKKO000000000-CAQKKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKKS000000000-CAQKKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKKW000000000-CAQKKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKLE000000000-CAQKLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKLH000000000-CAQKLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKLT000000000-CAQKLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKMA000000000-CAQKMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKMF000000000-CAQKMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKMS000000000-CAQKMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKMZ000000000-CAQKNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKND000000000-CAQKNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKNH000000000-CAQKNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKNM000000000-CAQKNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKNW000000000-CAQKNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKOJ000000000-CAQKOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKOO000000000-CAQKOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKOX000000000-CAQKPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKPC000000000-CAQKPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKPF000000000-CAQKPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKPW000000000-CAQKPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKQB000000000-CAQKQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKQH000000000-CAQKQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKQL000000000-CAQKQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKQQ000000000-CAQKQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKRB000000000-CAQKRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKRF000000000-CAQKRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKRU000000000-CAQKRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKRZ000000000-CAQKSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKSS000000000-CAQKSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKSY000000000-CAQKTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKTG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKTI000000000-CAQKTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKTT000000000-CAQKTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKTY000000000-CAQKTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKUE000000000-CAQKUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKUK000000000-CAQKUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKUN000000000-CAQKUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKUS000000000-CAQKUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKUX000000000-CAQKUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKVG000000000-CAQKVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKVJ000000000-CAQKVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKVR000000000-CAQKVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKVX000000000-CAQKVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKWB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKWI000000000-CAQKWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKWN000000000-CAQKWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKWQ000000000-CAQKWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKWV000000000-CAQKWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKWY000000000-CAQKWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKXE000000000-CAQKXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKXI000000000-CAQKXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKXL000000000-CAQKXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKXO000000000-CAQKXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKXT000000000-CAQKXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKXY000000000-CAQKYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKYC000000000-CAQKYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKYG000000000-CAQKYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKYL000000000-CAQKYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKZE000000000-CAQKZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKZL000000000-CAQKZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKZQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQKZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLAE000000000-CAQLAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLAK000000000-CAQLAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLAQ000000000-CAQLAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLBC000000000-CAQLBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLBF000000000-CAQLBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLBJ000000000-CAQLBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLBO000000000-CAQLBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLCJ000000000-CAQLCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLCR000000000-CAQLCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLCW000000000-CAQLCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLDA000000000-CAQLDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLDD000000000-CAQLDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLDN000000000-CAQLDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLDV000000000-CAQLDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLEB000000000-CAQLEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLEG000000000-CAQLEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLEJ000000000-CAQLEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLEW000000000-CAQLEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLFH000000000-CAQLFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLFN000000000-CAQLFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLFZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLGG000000000-CAQLGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLGO000000000-CAQLGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLGT000000000-CAQLGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLGY000000000-CAQLGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLHD000000000-CAQLHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLHJ000000000-CAQLHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLHM000000000-CAQLHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLHS000000000-CAQLHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLHW000000000-CAQLHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLIA000000000-CAQLIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLII000000000-CAQLIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLIM000000000-CAQLIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLIS000000000-CAQLIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLJH000000000-CAQLJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLJP000000000-CAQLJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLJX000000000-CAQLJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLKB000000000-CAQLKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLKR000000000-CAQLKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLKV000000000-CAQLKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLKZ000000000-CAQLLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLLE000000000-CAQLLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLLO000000000-CAQLLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLLV000000000-CAQLLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLLY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLMC000000000-CAQLMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLMI000000000-CAQLMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLMP000000000-CAQLMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLMS000000000-CAQLMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLMY000000000-CAQLMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLNB000000000-CAQLNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLNE000000000-CAQLNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLNI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLNN000000000-CAQLNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLOA000000000-CAQLOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLOT000000000-CAQLOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLOZ000000000-CAQLPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLPF000000000-CAQLPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLPL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLPO000000000-CAQLPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLPS000000000-CAQLPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLQA000000000-CAQLQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLQJ000000000-CAQLQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLQU000000000-CAQLQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLRB000000000-CAQLRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLRG000000000-CAQLRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLRO000000000-CAQLRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLRW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLSB000000000-CAQLSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLSI000000000-CAQLSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLSL000000000-CAQLSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLSQ000000000-CAQLSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLSU000000000-CAQLSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLTE000000000-CAQLTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLTH000000000-CAQLTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLTQ000000000-CAQLTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLTU000000000-CAQLUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLUH000000000-CAQLUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLUM000000000-CAQLUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLUR000000000-CAQLUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLUX000000000-CAQLVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLVJ000000000-CAQLVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLVS000000000-CAQLVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLVY000000000-CAQLWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLWD000000000-CAQLWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLWI000000000-CAQLWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLXL000000000-CAQLXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLXS000000000-CAQLYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLYC000000000-CAQLYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLYH000000000-CAQLYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLYL000000000-CAQLYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLYR000000000-CAQLYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQLYZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLZC000000000-CAQLZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQLZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQLZL000000000-CAQLZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLZP000000000-CAQLZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLZW000000000-CAQMAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMAD000000000-CAQMAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMAG000000000-CAQMAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMAK000000000-CAQMAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMAO000000000-CAQMAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMAR000000000-CAQMAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMAZ000000000-CAQMBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMBE000000000-CAQMBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMBK000000000-CAQMBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMBP000000000-CAQMBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMBU000000000-CAQMBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMBX000000000-CAQMCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMCD000000000-CAQMCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMCG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMCI000000000-CAQMCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMCL000000000-CAQMCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMCO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMCT000000000-CAQMCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMCX000000000-CAQMCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMDD000000000-CAQMDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMDN000000000-CAQMDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMDS000000000-CAQMDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMDY000000000-CAQMED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMEH000000000-CAQMEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMEQ000000000-CAQMER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMEX000000000-CAQMEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMFA000000000-CAQMFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMFD000000000-CAQMFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMFI000000000-CAQMFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMFQ000000000-CAQMFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMFY000000000-CAQMFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMGD000000000-CAQMGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMGT000000000-CAQMGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMHD000000000-CAQMHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMHU000000000-CAQMHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMHY000000000-CAQMHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMIM000000000-CAQMIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMIS000000000-CAQMIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMJD000000000-CAQMJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMJL000000000-CAQMJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMJQ000000000-CAQMKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMKE000000000-CAQMKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMKH000000000-CAQMKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMKM000000000-CAQMKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMKS000000000-CAQMKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMLA000000000-CAQMLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMLD000000000-CAQMLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMLM000000000-CAQMLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMLQ000000000-CAQMLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMLV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMLX000000000-CAQMMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMMH000000000-CAQMMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMMO000000000-CAQMMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMMU000000000-CAQMMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMMX000000000-CAQMNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMNI000000000-CAQMNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMNN000000000-CAQMNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMNR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMNU000000000-CAQMNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMOH000000000-CAQMOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMOM000000000-CAQMOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMOU000000000-CAQMOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMPF000000000-CAQMPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMPK000000000-CAQMPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMPS000000000-CAQMPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMQC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMQE000000000-CAQMQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMQL000000000-CAQMQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMQP000000000-CAQMQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMRC000000000-CAQMRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMRN000000000-CAQMRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMRR000000000-CAQMRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMRZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMSB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMSD000000000-CAQMSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMSI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMSN000000000-CAQMSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMTF000000000-CAQMTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMTI000000000-CAQMTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMTS000000000-CAQMTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMUE000000000-CAQMUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMUN000000000-CAQMUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMUV000000000-CAQMUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMUZ000000000-CAQMVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMVK000000000-CAQMVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMVN000000000-CAQMVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMVR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMVY000000000-CAQMWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMWC000000000-CAQMWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMWJ000000000-CAQMWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMWR000000000-CAQMWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMXA000000000-CAQMXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMXQ000000000-CAQMXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMYA000000000-CAQMYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMYG000000000-CAQMYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMYR000000000-CAQMYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMYW000000000-CAQMYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMZE000000000-CAQMZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQMZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQMZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQMZX000000000-CAQMZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNAA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNAN000000000-CAQNAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNAV000000000-CAQNAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNBA000000000-CAQNBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNBG000000000-CAQNBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNBL000000000-CAQNBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNBT000000000-CAQNBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNCA000000000-CAQNCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCD000000000-CAQNCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCG000000000-CAQNCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCN000000000-CAQNCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNCU000000000-CAQNCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNDA000000000-CAQNDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNDE000000000-CAQNDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNDH000000000-CAQNDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNDR000000000-CAQNDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNDX000000000-CAQNEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNEJ000000000-CAQNEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNES000000000-CAQNEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNEW000000000-CAQNFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNFD000000000-CAQNFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNFG000000000-CAQNFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNFK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNFM000000000-CAQNFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNFW000000000-CAQNGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNGD000000000-CAQNGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNGH000000000-CAQNGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNGK000000000-CAQNGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNGN000000000-CAQNGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNGR000000000-CAQNGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNHD000000000-CAQNHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNHJ000000000-CAQNHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNHM000000000-CAQNHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNHU000000000-CAQNHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNIH000000000-CAQNII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNIL000000000-CAQNIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNJJ000000000-CAQNJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNJO000000000-CAQNJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNJR000000000-CAQNJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNKF000000000-CAQNKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNKI000000000-CAQNKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNKM000000000-CAQNKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNKP000000000-CAQNKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNKW000000000-CAQNKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNLA000000000-CAQNLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNLG000000000-CAQNLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNLO000000000-CAQNLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNLR000000000-CAQNLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNLW000000000-CAQNMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNMG000000000-CAQNMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNMR000000000-CAQNMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNMW000000000-CAQNMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNNB000000000-CAQNNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNNG000000000-CAQNNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNOB000000000-CAQNOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNOI000000000-CAQNOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNOL000000000-CAQNOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNOR000000000-CAQNOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNOU000000000-CAQNOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNPI000000000-CAQNPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNPP000000000-CAQNPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNPT000000000-CAQNPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNQC000000000-CAQNQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNQH000000000-CAQNQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNRC000000000-CAQNRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNRG000000000-CAQNRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNRL000000000-CAQNRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNRR000000000-CAQNRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNRX000000000-CAQNSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNSC000000000-CAQNSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNSL000000000-CAQNSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNSQ000000000-CAQNSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNST000000000-CAQNSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNTB000000000-CAQNTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNTN000000000-CAQNTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNTS000000000-CAQNTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNTZ000000000-CAQNUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNUC000000000-CAQNUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNUG000000000-CAQNUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNUJ000000000-CAQNUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNUN000000000-CAQNUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNUT000000000-CAQNUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNUZ000000000-CAQNVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVF000000000-CAQNVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVL000000000-CAQNVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVQ000000000-CAQNVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVT000000000-CAQNVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNVX000000000-CAQNVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNWC000000000-CAQNWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNWI000000000-CAQNWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNWM000000000-CAQNWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNWS000000000-CAQNWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNWX000000000-CAQNWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNXD000000000-CAQNXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNXL000000000-CAQNXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNXP000000000-CAQNXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNYD000000000-CAQNYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNYN000000000-CAQNYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQNYT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNYW000000000-CAQNYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNZG000000000-CAQNZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNZM000000000-CAQNZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNZP000000000-CAQNZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNZV000000000-CAQNZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOAB000000000-CAQOAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOAN000000000-CAQOAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOAR000000000-CAQOAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOAU000000000-CAQOAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOBD000000000-CAQOBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOBH000000000-CAQOBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOBO000000000-CAQOBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOCC000000000-CAQOCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOCK000000000-CAQOCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOCR000000000-CAQOCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOCX000000000-CAQOCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQODA000000000-CAQODC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQODE000000000-CAQODH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQODK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQODP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQODR000000000-CAQODT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQODV000000000-CAQODX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQODZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOEJ000000000-CAQOEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOEP000000000-CAQOEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOET000000000-CAQOFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOFC000000000-CAQOFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOFI000000000-CAQOFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOFL000000000-CAQOFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOFP000000000-CAQOFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOFW000000000-CAQOFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOFZ000000000-CAQOGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOGF000000000-CAQOGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOGS000000000-CAQOGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOGW000000000-CAQOGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOGZ000000000-CAQOHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOHE000000000-CAQOHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOHK000000000-CAQOHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOHT000000000-CAQOHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOIE000000000-CAQOII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOIK000000000-CAQOIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOIN000000000-CAQOIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOIV000000000-CAQOIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOJB000000000-CAQOJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOJH000000000-CAQOJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOJL000000000-CAQOJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOJT000000000-CAQOJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOJY000000000-CAQOKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOKF000000000-CAQOKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOKJ000000000-CAQOKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOKQ000000000-CAQOKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOKV000000000-CAQOKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOKZ000000000-CAQOLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOLD000000000-CAQOLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOLH000000000-CAQOLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOLL000000000-CAQOLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOLQ000000000-CAQOLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOMB000000000-CAQOMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOMM000000000-CAQOMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOMX000000000-CAQOMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQONE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQONG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQONP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQONS000000000-CAQONX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOOC000000000-CAQOOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOOG000000000-CAQOOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOOP000000000-CAQOOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOOS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOOW000000000-CAQOOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOPG000000000-CAQOPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOPM000000000-CAQOPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOPS000000000-CAQOPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOPV000000000-CAQOQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOQF000000000-CAQOQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOQM000000000-CAQOQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOQS000000000-CAQOQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOQX000000000-CAQOQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQORB000000000-CAQORE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQORG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQORI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQORK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQORM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQORQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQORS000000000-CAQORT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQORV000000000-CAQORY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOSF000000000-CAQOSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOSM000000000-CAQOSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOTC000000000-CAQOTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOTF000000000-CAQOTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOTR000000000-CAQOTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOUA000000000-CAQOUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOUE000000000-CAQOUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOUJ000000000-CAQOUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOUP000000000-CAQOUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOVB000000000-CAQOVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOVK000000000-CAQOVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOVU000000000-CAQOWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOWT000000000-CAQOWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOWY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQOXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOXE000000000-CAQOXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOXJ000000000-CAQOXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOXQ000000000-CAQOXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOXW000000000-CAQOXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOYB000000000-CAQOYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOYG000000000-CAQOYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOYK000000000-CAQOYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOYW000000000-CAQOZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOZF000000000-CAQOZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOZL000000000-CAQOZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOZO000000000-CAQOZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOZR000000000-CAQOZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQOZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQOZY000000000-CAQOZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPAE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPAG000000000-CAQPAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPAO000000000-CAQPAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPAU000000000-CAQPAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPBA000000000-CAQPBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPBG000000000-CAQPBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPBQ000000000-CAQPBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPBW000000000-CAQPBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPCC000000000-CAQPCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPCI000000000-CAQPCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPCL000000000-CAQPCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPCU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPCX000000000-CAQPDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPDF000000000-CAQPDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPDJ000000000-CAQPDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPDQ000000000-CAQPDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPDT000000000-CAQPDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPDY000000000-CAQPDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPEB000000000-CAQPEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPEL000000000-CAQPEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPEQ000000000-CAQPER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPEU000000000-CAQPEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPEY000000000-CAQPFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPFH000000000-CAQPFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPFN000000000-CAQPFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPFR000000000-CAQPFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPFU000000000-CAQPFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPGA000000000-CAQPGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPGI000000000-CAQPGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPGO000000000-CAQPGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPGR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPGU000000000-CAQPGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPHB000000000-CAQPHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPHN000000000-CAQPHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPHR000000000-CAQPHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPHY000000000-CAQPIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPIE000000000-CAQPIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPIQ000000000-CAQPIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPJD000000000-CAQPJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPJP000000000-CAQPJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPJT000000000-CAQPKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPKF000000000-CAQPKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPKK000000000-CAQPKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPKN000000000-CAQPKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPKQ000000000-CAQPKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPKX000000000-CAQPLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPLI000000000-CAQPLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPLL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPLT000000000-CAQPLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPLZ000000000-CAQPMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPMH000000000-CAQPMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPML000000000-CAQPMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPMO000000000-CAQPMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPMS000000000-CAQPMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPNH000000000-CAQPNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPNX000000000-CAQPNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPOF000000000-CAQPOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPOK000000000-CAQPOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPOO000000000-CAQPOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPOS000000000-CAQPOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPPA000000000-CAQPPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPPK000000000-CAQPPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPPS000000000-CAQPPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPPW000000000-CAQPPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPPZ000000000-CAQPQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPQG000000000-CAQPQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPQJ000000000-CAQPQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPQO000000000-CAQPQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPQZ000000000-CAQPRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPRD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPRH000000000-CAQPRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPRN000000000-CAQPRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPRQ000000000-CAQPRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPRU000000000-CAQPRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPRY000000000-CAQPSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPSG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPSI000000000-CAQPSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPSO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPSR000000000-CAQPSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPSZ000000000-CAQPTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPTC000000000-CAQPTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPTH000000000-CAQPTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPTQ000000000-CAQPTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPTT000000000-CAQPTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPTY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPUD000000000-CAQPUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPUL000000000-CAQPUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPUT000000000-CAQPUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPUX000000000-CAQPUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPVD000000000-CAQPVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPVJ000000000-CAQPVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPVP000000000-CAQPVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPVV000000000-CAQPVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPVZ000000000-CAQPWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPWH000000000-CAQPWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPWT000000000-CAQPWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPWZ000000000-CAQPXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPXD000000000-CAQPXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPXN000000000-CAQPXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPYA000000000-CAQPYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPYL000000000-CAQPYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPYY000000000-CAQPYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQPZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPZF000000000-CAQPZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPZI000000000-CAQPZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQPZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQPZO000000000-CAQPZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPZV000000000-CAQPZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQAK000000000-CAQQAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQAO000000000-CAQQAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQAR000000000-CAQQAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQAX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQBC000000000-CAQQBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQBM000000000-CAQQBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQBR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQBV000000000-CAQQBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQCE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQCG000000000-CAQQCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQCN000000000-CAQQCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQCR000000000-CAQQCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQDB000000000-CAQQDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQDE000000000-CAQQDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQDI000000000-CAQQDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQDP000000000-CAQQDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQDV000000000-CAQQDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQEB000000000-CAQQEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQEE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQEP000000000-CAQQES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQFB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQFK000000000-CAQQFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQFS000000000-CAQQFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQGB000000000-CAQQGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQGL000000000-CAQQGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQGR000000000-CAQQGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQGW000000000-CAQQHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQHE000000000-CAQQHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQHM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQHP000000000-CAQQHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQHS000000000-CAQQHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQHW000000000-CAQQHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQIA000000000-CAQQID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQIF000000000-CAQQIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQIO000000000-CAQQIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQIU000000000-CAQQIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQIY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQJC000000000-CAQQJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQJG000000000-CAQQJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQJN000000000-CAQQJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQJT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQJY000000000-CAQQJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQKD000000000-CAQQKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQKN000000000-CAQQKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQKY000000000-CAQQLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQLH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQLL000000000-CAQQLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQLU000000000-CAQQLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQLX000000000-CAQQMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQMI000000000-CAQQMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQMT000000000-CAQQMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQMX000000000-CAQQNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQNG000000000-CAQQNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQNO000000000-CAQQNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQNR000000000-CAQQNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQNW000000000-CAQQNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQOA000000000-CAQQOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQOI000000000-CAQQOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQOM000000000-CAQQON999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQOP000000000-CAQQOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQOW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQPC000000000-CAQQPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQPH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQPJ000000000-CAQQPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQPS000000000-CAQQPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQPV000000000-CAQQPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQPZ000000000-CAQQQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQQQ000000000-CAQQQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQQZ000000000-CAQQRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRC000000000-CAQQRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRI000000000-CAQQRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRL000000000-CAQQRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRO000000000-CAQQRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRR000000000-CAQQRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRV000000000-CAQQRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQRZ000000000-CAQQSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQSH000000000-CAQQSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQSO000000000-CAQQSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQSV000000000-CAQQSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQTI000000000-CAQQTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQTS000000000-CAQQTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQUE000000000-CAQQUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQUP000000000-CAQQUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQVE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQVJ000000000-CAQQVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQVP000000000-CAQQVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQVW000000000-CAQQVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQWB000000000-CAQQWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQWF000000000-CAQQWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQWM000000000-CAQQWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQWR000000000-CAQQWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQWV000000000-CAQQXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQXF000000000-CAQQXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQQXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQXV000000000-CAQQXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQYA000000000-CAQQYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQYF000000000-CAQQYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQQYK000000000-CAQQYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQYO000000000-CAQQYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQZC000000000-CAQQZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQZO000000000-CAQQZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQZT000000000-CAQQZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQQZZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRAM000000000-CAQRAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRBG000000000-CAQRBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRBJ000000000-CAQRBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRBP000000000-CAQRBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRCA000000000-CAQRCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRCJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRCM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRCS000000000-CAQRCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRCX000000000-CAQRDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRDG000000000-CAQRDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRDK000000000-CAQRDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRDN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRDS000000000-CAQRDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQREB000000000-CAQREG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQREK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQREM000000000-CAQREN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQREP000000000-CAQRES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQREY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRFA000000000-CAQRFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRFE000000000-CAQRFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRFJ000000000-CAQRFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRFU000000000-CAQRFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRFZ000000000-CAQRGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRGD000000000-CAQRGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRGJ000000000-CAQRGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRGQ000000000-CAQRGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRGW000000000-CAQRGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRHG000000000-CAQRHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRHM000000000-CAQRHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRHT000000000-CAQRHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRIC000000000-CAQRIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRIJ000000000-CAQRIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRIM000000000-CAQRIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRIS000000000-CAQRIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRIW000000000-CAQRIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRJB000000000-CAQRJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRJF000000000-CAQRJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRJN000000000-CAQRJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRJT000000000-CAQRJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRKA000000000-CAQRKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRKK000000000-CAQRKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRKU000000000-CAQRKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRLA000000000-CAQRLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRLE000000000-CAQRLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRLL000000000-CAQRLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRLQ000000000-CAQRLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRLX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRLZ000000000-CAQRMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRMG000000000-CAQRMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRMJ000000000-CAQRML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRMN000000000-CAQRMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRMW000000000-CAQRND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRNG000000000-CAQRNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRNJ000000000-CAQRNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRNO000000000-CAQRNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRNR000000000-CAQRNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRNU000000000-CAQRNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQROB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQROD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQROF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQROH000000000-CAQROJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQROL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRON000000000-CAQROP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQROR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQROW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQROY000000000-CAQRPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRPJ000000000-CAQRPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRPS000000000-CAQRPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRPY000000000-CAQRPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRQB000000000-CAQRQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRQF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRQH000000000-CAQRQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRQQ000000000-CAQRQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRRB000000000-CAQRRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRRE000000000-CAQRRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRRP000000000-CAQRRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRRU000000000-CAQRRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRRZ000000000-CAQRSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRSC000000000-CAQRSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRSI000000000-CAQRSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRSQ000000000-CAQRSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRSY000000000-CAQRTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRTD000000000-CAQRTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRTH000000000-CAQRTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRTN000000000-CAQRTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRTT000000000-CAQRTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRTX000000000-CAQRTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRUB000000000-CAQRUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRUF000000000-CAQRUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRUS000000000-CAQRUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRUV000000000-CAQRUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRUY000000000-CAQRVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRVG000000000-CAQRVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRVK000000000-CAQRVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRVW000000000-CAQRVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRWB000000000-CAQRWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRWK000000000-CAQRWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRWR000000000-CAQRWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRWV000000000-CAQRWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRXF000000000-CAQRXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRXM000000000-CAQRXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRXP000000000-CAQRXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRXV000000000-CAQRXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRYB000000000-CAQRYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRYI000000000-CAQRYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRYM000000000-CAQRYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRYT000000000-CAQRYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRYY000000000-CAQRYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRZG000000000-CAQRZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRZK000000000-CAQRZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQRZN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQRZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQRZW000000000-CAQSAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSAJ000000000-CAQSAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSAS000000000-CAQSAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSBA000000000-CAQSBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSBH000000000-CAQSBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSBL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSBO000000000-CAQSBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSBX000000000-CAQSCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSCD000000000-CAQSCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSCH000000000-CAQSCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSCS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSCV000000000-CAQSCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSDH000000000-CAQSDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSDQ000000000-CAQSDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSEA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSEC000000000-CAQSEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSEK000000000-CAQSEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSEQ000000000-CAQSER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSEZ000000000-CAQSFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSFK000000000-CAQSFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSFU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSFZ000000000-CAQSGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSGD000000000-CAQSGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSGI000000000-CAQSGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSGO000000000-CAQSGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSHB000000000-CAQSHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSHI000000000-CAQSHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSHS000000000-CAQSIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSIE000000000-CAQSIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSIO000000000-CAQSIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSIS000000000-CAQSIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSIV000000000-CAQSJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSJE000000000-CAQSJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSJK000000000-CAQSJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSJN000000000-CAQSJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSJT000000000-CAQSJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSJX000000000-CAQSJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSKA000000000-CAQSKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSKE000000000-CAQSKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSKL000000000-CAQSKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSKW000000000-CAQSKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSLA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSLC000000000-CAQSLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSLF000000000-CAQSLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSLL000000000-CAQSLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSLX000000000-CAQSLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSMD000000000-CAQSMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSMI000000000-CAQSMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSML000000000-CAQSMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSMS000000000-CAQSMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSMY000000000-CAQSMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSNB000000000-CAQSND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSNF000000000-CAQSNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSNI000000000-CAQSNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSNQ000000000-CAQSNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSNT000000000-CAQSNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSOA000000000-CAQSOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSOP000000000-CAQSOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSOS000000000-CAQSOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSOV000000000-CAQSOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSPB000000000-CAQSPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSPQ000000000-CAQSPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSPX000000000-CAQSPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSQA000000000-CAQSQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSQU000000000-CAQSRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSRM000000000-CAQSRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSRX000000000-CAQSSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSSM000000000-CAQSSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSSR000000000-CAQSSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSTF000000000-CAQSTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSTJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSTL000000000-CAQSTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSTP000000000-CAQSTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSTT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSTV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSUA000000000-CAQSUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSUE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSUH000000000-CAQSUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSUY000000000-CAQSUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSVB000000000-CAQSVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSVI000000000-CAQSVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSVM000000000-CAQSVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSVQ000000000-CAQSVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSVV000000000-CAQSVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSVZ000000000-CAQSWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSWC000000000-CAQSWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSWS000000000-CAQSWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSWV000000000-CAQSWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSXG000000000-CAQSXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSXL000000000-CAQSXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSXZ000000000-CAQSYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSYD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSYH000000000-CAQSYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQSYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQSZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQSZD000000000-CAQSZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSZI000000000-CAQSZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSZQ000000000-CAQTAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTAH000000000-CAQTAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTAO000000000-CAQTAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTAY000000000-CAQTAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTBD000000000-CAQTBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTBL000000000-CAQTBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTBO000000000-CAQTBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTBW000000000-CAQTBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTCG000000000-CAQTCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTCK000000000-CAQTCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTCO000000000-CAQTCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTCX000000000-CAQTDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTDD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTDO000000000-CAQTDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTDR000000000-CAQTDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTEB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTEF000000000-CAQTEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTEM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTEO000000000-CAQTER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTEV000000000-CAQTEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTFE000000000-CAQTFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTFO000000000-CAQTFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTFT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTFZ000000000-CAQTGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTGE000000000-CAQTGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTGN000000000-CAQTGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTGR000000000-CAQTGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTGW000000000-CAQTGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTHE000000000-CAQTHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTHL000000000-CAQTHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTHP000000000-CAQTHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTHU000000000-CAQTHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTID000000000-CAQTIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTIK000000000-CAQTIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTIQ000000000-CAQTIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTIY000000000-CAQTJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTJD000000000-CAQTJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTJG000000000-CAQTJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTJN000000000-CAQTJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTJQ000000000-CAQTJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTKD000000000-CAQTKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTKI000000000-CAQTKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTKN000000000-CAQTKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTKU000000000-CAQTKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTKY000000000-CAQTKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTLC000000000-CAQTLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTLI000000000-CAQTLO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTMB000000000-CAQTMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTMH000000000-CAQTMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTMP000000000-CAQTMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTMS000000000-CAQTMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTMV000000000-CAQTMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTMY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTNA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTNG000000000-CAQTNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTNN000000000-CAQTNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTNS000000000-CAQTNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTNW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTNY000000000-CAQTNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTOJ000000000-CAQTOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTOV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTPE000000000-CAQTPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTPJ000000000-CAQTPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTPN000000000-CAQTPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTPT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTPV000000000-CAQTPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTPZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTQB000000000-CAQTQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTQN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTQT000000000-CAQTQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTQW000000000-CAQTQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTRF000000000-CAQTRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTRJ000000000-CAQTRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTRN000000000-CAQTRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTRU000000000-CAQTRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTRY000000000-CAQTRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTSC000000000-CAQTSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTSH000000000-CAQTSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTSM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTSO000000000-CAQTSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTTD000000000-CAQTTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTTG000000000-CAQTTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTTR000000000-CAQTTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTTW000000000-CAQTTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTTZ000000000-CAQTUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTUD000000000-CAQTUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTUL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTUS000000000-CAQTUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTVK000000000-CAQTVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTVN000000000-CAQTVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTVX000000000-CAQTWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTWF000000000-CAQTWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTWN000000000-CAQTWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTXB000000000-CAQTXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTXG000000000-CAQTXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTXL000000000-CAQTXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTXP000000000-CAQTXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTXT000000000-CAQTXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTXX000000000-CAQTXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTYB000000000-CAQTYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTYO000000000-CAQTYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTYT000000000-CAQTYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQTZD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQTZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQTZV000000000-CAQTZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTZY000000000-CAQTZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUAC000000000-CAQUAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUAF000000000-CAQUAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUAI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUAN000000000-CAQUAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUAQ000000000-CAQUAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUAV000000000-CAQUAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUAZ000000000-CAQUBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUBF000000000-CAQUBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUBI000000000-CAQUBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUBU000000000-CAQUBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUCB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUCH000000000-CAQUCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUCQ000000000-CAQUCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUCW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUCY000000000-CAQUDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUDF000000000-CAQUDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUDK000000000-CAQUDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUEA000000000-CAQUEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUEP000000000-CAQUER999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUEY000000000-CAQUFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUFF000000000-CAQUFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUFU000000000-CAQUFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUFY000000000-CAQUFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUGD000000000-CAQUGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUGI000000000-CAQUGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUGP000000000-CAQUGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUGU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUGW000000000-CAQUGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUHN000000000-CAQUHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUHR000000000-CAQUHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUHV000000000-CAQUHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUHY000000000-CAQUHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUIM000000000-CAQUIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUIQ000000000-CAQUIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUIT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUIV000000000-CAQUIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUIZ000000000-CAQUJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUJK000000000-CAQUJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUJU000000000-CAQUJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUJY000000000-CAQUJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUKE000000000-CAQUKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUKJ000000000-CAQUKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUKP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUKR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUKU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUKX000000000-CAQUKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQULA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQULC000000000-CAQULE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQULH000000000-CAQULI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQULK000000000-CAQULL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQULO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQULR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQULT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQULV000000000-CAQULW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQULY000000000-CAQUMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUMG000000000-CAQUMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUMK000000000-CAQUMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUMU000000000-CAQUMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUND000000000-CAQUNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUNL000000000-CAQUNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUNU000000000-CAQUNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUNX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUOF000000000-CAQUOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUOI000000000-CAQUOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUON000000000-CAQUOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUOT000000000-CAQUOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUOX000000000-CAQUOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUPA000000000-CAQUPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUPK000000000-CAQUPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUPO000000000-CAQUPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUPU000000000-CAQUQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUQG000000000-CAQUQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUQL000000000-CAQUQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUQT000000000-CAQUQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUQX000000000-CAQURF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQURH000000000-CAQURK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQURM000000000-CAQURN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQURP000000000-CAQURU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQURW000000000-CAQURZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUSC000000000-CAQUSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUSM000000000-CAQUSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUSQ000000000-CAQUSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUSZ000000000-CAQUTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUTE000000000-CAQUTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUTK000000000-CAQUTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUTP000000000-CAQUTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUTU000000000-CAQUTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUUA000000000-CAQUUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUUL000000000-CAQUUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUUQ000000000-CAQUUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUUU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUUZ000000000-CAQUVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUVE000000000-CAQUVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUVP000000000-CAQUVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUVS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUVU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUVZ000000000-CAQUWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUWF000000000-CAQUWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUWJ000000000-CAQUWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUWM000000000-CAQUWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUXB000000000-CAQUXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUXO000000000-CAQUXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUXS000000000-CAQUXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUXY000000000-CAQUYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUYC000000000-CAQUYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUYF000000000-CAQUYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUYI000000000-CAQUYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUYO000000000-CAQUYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQUYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUYY000000000-CAQUZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUZC000000000-CAQUZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUZK000000000-CAQUZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUZO000000000-CAQUZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUZR000000000-CAQUZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQUZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQUZY000000000-CAQVAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVAH000000000-CAQVAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVAQ000000000-CAQVAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVAU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVAW000000000-CAQVBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVBL000000000-CAQVBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVBR000000000-CAQVBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVBV000000000-CAQVBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVCA000000000-CAQVCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVCH000000000-CAQVCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVCQ000000000-CAQVCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVCX000000000-CAQVDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVDC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVDH000000000-CAQVDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVDL000000000-CAQVDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVDT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVDY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVEA000000000-CAQVEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVEL000000000-CAQVEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVFE000000000-CAQVFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVFU000000000-CAQVFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVGA000000000-CAQVGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVGK000000000-CAQVGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVGR000000000-CAQVGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVGW000000000-CAQVGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVHA000000000-CAQVHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVHJ000000000-CAQVHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVHS000000000-CAQVHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVHV000000000-CAQVHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVIC000000000-CAQVID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVIF000000000-CAQVIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVIO000000000-CAQVIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVIW000000000-CAQVIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVIZ000000000-CAQVJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVJC000000000-CAQVJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVJK000000000-CAQVJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVJO000000000-CAQVJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVJW000000000-CAQVJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVKB000000000-CAQVKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVKK000000000-CAQVKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVKQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVKS000000000-CAQVKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVKX000000000-CAQVKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVLA000000000-CAQVLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVLE000000000-CAQVLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVLL000000000-CAQVLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVLW000000000-CAQVLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVMI000000000-CAQVML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVMS000000000-CAQVMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVMW000000000-CAQVMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVNL000000000-CAQVNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVNO000000000-CAQVNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVOA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVOC000000000-CAQVOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVOH000000000-CAQVOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVOK000000000-CAQVOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVOZ000000000-CAQVPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVPF000000000-CAQVPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVPI000000000-CAQVPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVPL000000000-CAQVPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVPP000000000-CAQVPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVPY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVQB000000000-CAQVQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVQH000000000-CAQVQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVQV000000000-CAQVQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVQZ000000000-CAQVRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVRG000000000-CAQVRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVRR000000000-CAQVRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVRU000000000-CAQVRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVRZ000000000-CAQVSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVSC000000000-CAQVSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVSL000000000-CAQVSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVSQ000000000-CAQVSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVST000000000-CAQVSV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVSX000000000-CAQVSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVTE000000000-CAQVTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVTK000000000-CAQVTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVTT000000000-CAQVTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVTX000000000-CAQVTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVUB000000000-CAQVUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVUF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVUH000000000-CAQVUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVUN000000000-CAQVUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVUQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVUT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVUV000000000-CAQVUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVVC000000000-CAQVVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVVK000000000-CAQVVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVVS000000000-CAQVVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVWA000000000-CAQVWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVWK000000000-CAQVWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVWR000000000-CAQVWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVWW000000000-CAQVXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVXD000000000-CAQVXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVXJ000000000-CAQVXL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVXN000000000-CAQVXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVXX000000000-CAQVXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVYE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQVYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVYK000000000-CAQVYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVYO000000000-CAQVYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVYS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVYU000000000-CAQVYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVYZ000000000-CAQVZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVZG000000000-CAQVZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVZN000000000-CAQVZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVZQ000000000-CAQVZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVZT000000000-CAQVZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVZZ000000000-CAQWAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWAD000000000-CAQWAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWAM000000000-CAQWAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWAV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWAX000000000-CAQWAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWBC000000000-CAQWBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWBL000000000-CAQWBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWCE000000000-CAQWCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWCH000000000-CAQWCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWCK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWCR000000000-CAQWCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWCV000000000-CAQWDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWDE000000000-CAQWDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWDL000000000-CAQWDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWDP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWED000000000-CAQWEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWEL000000000-CAQWEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWEQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWEW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWEY000000000-CAQWEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWFD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWFI000000000-CAQWFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWFM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWFO000000000-CAQWFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWFS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWFW000000000-CAQWFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWGA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWGD000000000-CAQWGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWGJ000000000-CAQWGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWGQ000000000-CAQWGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWGU000000000-CAQWGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWHJ000000000-CAQWHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWHM000000000-CAQWHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWHU000000000-CAQWHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWHX000000000-CAQWHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWIE000000000-CAQWII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWIK000000000-CAQWIL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWIP000000000-CAQWIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWJD000000000-CAQWJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWJJ000000000-CAQWJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWJT000000000-CAQWJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWJY000000000-CAQWKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWKD000000000-CAQWKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWKT000000000-CAQWKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWKX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWLB000000000-CAQWLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWLE000000000-CAQWLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWLL000000000-CAQWLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWLP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWLS000000000-CAQWLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWLY000000000-CAQWMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWMG000000000-CAQWMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWML000000000-CAQWMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWMR000000000-CAQWMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWMZ000000000-CAQWNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWND000000000-CAQWNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWNK000000000-CAQWNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWNU000000000-CAQWNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWNX000000000-CAQWNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWOB000000000-CAQWOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWOG000000000-CAQWOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWOK000000000-CAQWOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWON+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWOP000000000-CAQWOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWPE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWPG000000000-CAQWPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWPJ000000000-CAQWPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWPN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWPP000000000-CAQWPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWPT000000000-CAQWPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWPW000000000-CAQWPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWQI000000000-CAQWQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWQL000000000-CAQWQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWQP000000000-CAQWQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWQZ000000000-CAQWRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWRC000000000-CAQWRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWRK000000000-CAQWRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWRT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWRW000000000-CAQWRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWSB000000000-CAQWSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWSG000000000-CAQWSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWSL000000000-CAQWSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWSR000000000-CAQWSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWSU000000000-CAQWSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWSY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWTA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWTF000000000-CAQWTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWTL000000000-CAQWTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWTU000000000-CAQWTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWTX000000000-CAQWUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWUI000000000-CAQWUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWUM000000000-CAQWUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWUR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWUX000000000-CAQWVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWVE000000000-CAQWVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWVK000000000-CAQWVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWVP000000000-CAQWVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWVT000000000-CAQWVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWVY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWWE000000000-CAQWWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWWO000000000-CAQWWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWWW000000000-CAQWWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWXD000000000-CAQWXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWXV000000000-CAQWXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWYA000000000-CAQWYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWYG000000000-CAQWYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWYM000000000-CAQWYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWYR000000000-CAQWYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWYW000000000-CAQWYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQWZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQWZK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQWZN000000000-CAQWZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXAD000000000-CAQXAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXAH000000000-CAQXAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXAK000000000-CAQXAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXAT000000000-CAQXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXAX000000000-CAQXAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXBB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXBD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXBH000000000-CAQXBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXBL000000000-CAQXBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXBS000000000-CAQXBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXCE000000000-CAQXCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXCJ000000000-CAQXCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXCM000000000-CAQXCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXCT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXCW000000000-CAQXCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXCZ000000000-CAQXDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXDE000000000-CAQXDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXDI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXDL000000000-CAQXDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXDW000000000-CAQXDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEB000000000-CAQXED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEG000000000-CAQXEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEK000000000-CAQXEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEN000000000-CAQXES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEU000000000-CAQXEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEZ000000000-CAQXFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXFC000000000-CAQXFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXFG000000000-CAQXFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXFO000000000-CAQXFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXFS000000000-CAQXFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXGA000000000-CAQXGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXGH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXGK000000000-CAQXGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXGQ000000000-CAQXGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXGY000000000-CAQXGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXHE000000000-CAQXHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXHK000000000-CAQXHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXHO000000000-CAQXHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXHV000000000-CAQXHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXHY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXIF000000000-CAQXIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXIM000000000-CAQXIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXIT000000000-CAQXIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXJC000000000-CAQXJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXJM000000000-CAQXJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXJU000000000-CAQXKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXKD000000000-CAQXKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXKK000000000-CAQXKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXKQ000000000-CAQXKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXKX000000000-CAQXKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXLF000000000-CAQXLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXLM000000000-CAQXLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXLS000000000-CAQXLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXMB000000000-CAQXMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXMM000000000-CAQXMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXMR000000000-CAQXMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXMX000000000-CAQXMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXNC000000000-CAQXNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXNK000000000-CAQXNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXNO000000000-CAQXNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXNT000000000-CAQXNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXNW000000000-CAQXOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXOE000000000-CAQXOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXOH000000000-CAQXOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXON000000000-CAQXOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXOS000000000-CAQXOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXOV000000000-CAQXOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXPC000000000-CAQXPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXPH000000000-CAQXPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXPR000000000-CAQXPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXPZ000000000-CAQXQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXQD000000000-CAQXQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXQL000000000-CAQXQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXQP000000000-CAQXQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXQZ000000000-CAQXRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXRE000000000-CAQXRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXRH000000000-CAQXRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXRK000000000-CAQXRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXRP000000000-CAQXRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXRU000000000-CAQXRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXRX000000000-CAQXSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXSG000000000-CAQXSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXSJ000000000-CAQXSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXSR000000000-CAQXST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXTL000000000-CAQXTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXTR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXTT000000000-CAQXTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXUC000000000-CAQXUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXUG000000000-CAQXUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXUM000000000-CAQXUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXUU000000000-CAQXUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXVF000000000-CAQXVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXVN000000000-CAQXVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXVR000000000-CAQXVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXVX000000000-CAQXVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXWF000000000-CAQXWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXWN000000000-CAQXWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXWU000000000-CAQXWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXXC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXXG000000000-CAQXXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXXR000000000-CAQXXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXXV000000000-CAQXYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXYC000000000-CAQXYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXYF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQXYW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXYZ000000000-CAQXZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXZE000000000-CAQXZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXZI000000000-CAQXZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXZL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXZN000000000-CAQXZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQXZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQXZX000000000-CAQYAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYAF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYAJ000000000-CAQYAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAN000000000-CAQYAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAT000000000-CAQYAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAW000000000-CAQYAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYBC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYBN000000000-CAQYBO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYBQ000000000-CAQYBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYBX000000000-CAQYBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYCM000000000-CAQYCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYCT000000000-CAQYCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYDC000000000-CAQYDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYDF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYDH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYDJ000000000-CAQYDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYDR000000000-CAQYDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYDU000000000-CAQYDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYEC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYEE000000000-CAQYEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYEN000000000-CAQYEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYEV000000000-CAQYEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYEZ000000000-CAQYFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYFG000000000-CAQYFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYFL000000000-CAQYFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYFS000000000-CAQYFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYFY000000000-CAQYGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYGD000000000-CAQYGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYGU000000000-CAQYGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYHA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYHC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYHE000000000-CAQYHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYHI000000000-CAQYHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYHL000000000-CAQYHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYHS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYHU000000000-CAQYHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYIB000000000-CAQYIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYIN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYIW000000000-CAQYIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYIZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYJB000000000-CAQYJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYJG000000000-CAQYJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYJK000000000-CAQYJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYJR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYJW000000000-CAQYKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYKE000000000-CAQYKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYKJ000000000-CAQYKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYKP000000000-CAQYKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYKX000000000-CAQYKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYLG000000000-CAQYLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYLK000000000-CAQYLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYLR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYLW000000000-CAQYLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYMA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYME000000000-CAQYMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYML000000000-CAQYMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYMQ000000000-CAQYMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYMW000000000-CAQYMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYMZ000000000-CAQYNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYNL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYNP000000000-CAQYNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYNS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYNU000000000-CAQYNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYOM000000000-CAQYOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYOR000000000-CAQYOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYOU000000000-CAQYOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYPC000000000-CAQYPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYPJ000000000-CAQYPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYPU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYPY000000000-CAQYPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYQC000000000-CAQYQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYQF000000000-CAQYQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYQK000000000-CAQYQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYQW000000000-CAQYRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYRD000000000-CAQYRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYRH000000000-CAQYRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYRL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYRU000000000-CAQYRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYRX000000000-CAQYSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYSJ000000000-CAQYSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYTC000000000-CAQYTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYTG000000000-CAQYTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYTK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYTM000000000-CAQYTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYTS000000000-CAQYTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYUC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYUG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYUJ000000000-CAQYUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYUN000000000-CAQYUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYUQ000000000-CAQYUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYUY000000000-CAQYUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYVD000000000-CAQYVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYVO000000000-CAQYVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYVR000000000-CAQYVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYWA000000000-CAQYWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQYWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYWQ000000000-CAQYWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYWX000000000-CAQYXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYXH000000000-CAQYXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYXQ000000000-CAQYXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYXU000000000-CAQYXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYYE000000000-CAQYYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYYL000000000-CAQYYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYYT000000000-CAQYYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYZA000000000-CAQYZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYZN000000000-CAQYZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYZR000000000-CAQYZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQYZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQYZZ000000000-CAQZAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZAE000000000-CAQZAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZAJ000000000-CAQZAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZAM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZAT000000000-CAQZAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZBK000000000-CAQZBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZBV000000000-CAQZBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZCB000000000-CAQZCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZCK000000000-CAQZCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZCP000000000-CAQZCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZCU000000000-CAQZCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZDE000000000-CAQZDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZDI000000000-CAQZDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZDO000000000-CAQZDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZDR000000000-CAQZDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZDX000000000-CAQZEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZED+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZEF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZEH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZEL000000000-CAQZEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZER000000000-CAQZET999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZEZ000000000-CAQZFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZFE000000000-CAQZFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZFI000000000-CAQZFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZFM000000000-CAQZFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZFS000000000-CAQZFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZFX000000000-CAQZFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZGC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZGE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZGG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZGJ000000000-CAQZGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZGQ000000000-CAQZGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZGV000000000-CAQZGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZHB000000000-CAQZHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZHI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZHK000000000-CAQZHM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZHP000000000-CAQZHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZHT000000000-CAQZHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZHW000000000-CAQZIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZIE000000000-CAQZIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZIJ000000000-CAQZIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZIQ000000000-CAQZIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZJH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZJP000000000-CAQZJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZJS000000000-CAQZJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZJZ000000000-CAQZKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZKL000000000-CAQZKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZKQ000000000-CAQZKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZKW000000000-CAQZKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZLK000000000-CAQZLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZLP000000000-CAQZLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZLU000000000-CAQZLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZLX000000000-CAQZLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZME000000000-CAQZMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZML000000000-CAQZMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZMT000000000-CAQZMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZMX000000000-CAQZMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZNA000000000-CAQZND999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZNN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZNP000000000-CAQZNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZNV000000000-CAQZNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZOE000000000-CAQZOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZOI000000000-CAQZOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZOP000000000-CAQZOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZOX000000000-CAQZOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZPD000000000-CAQZPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZPK000000000-CAQZPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZPS000000000-CAQZPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZPW000000000-CAQZPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZQG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZQM000000000-CAQZQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZQZ000000000-CAQZRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZRF000000000-CAQZRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZRJ000000000-CAQZRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZRV000000000-CAQZRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZRZ000000000-CAQZSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZSH000000000-CAQZSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZSP000000000-CAQZSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZST000000000-CAQZSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZSX000000000-CAQZTD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZTS000000000-CAQZTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZTV000000000-CAQZTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZTY000000000-CAQZTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZUB000000000-CAQZUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZUI000000000-CAQZUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZUM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAQZUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZUR000000000-CAQZUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZVA000000000-CAQZVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZVF000000000-CAQZVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZVO000000000-CAQZVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZVY000000000-CAQZWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZWJ000000000-CAQZWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZWS000000000-CAQZWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZWZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZXB000000000-CAQZXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZXI000000000-CAQZXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZXP000000000-CAQZXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZXY000000000-CAQZXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZYC000000000-CAQZYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZYF000000000-CAQZYG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZYO000000000-CAQZYP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZYR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZYT000000000-CAQZYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZYX000000000-CAQZYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQZZB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQZZE000000000-CAQZZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZZI000000000-CAQZZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZZO000000000-CAQZZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZZU000000000-CAQZZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAAD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAAG000000000-CARAAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAAM000000000-CARAAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAAS000000000-CARAAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAAZ000000000-CARABB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARABD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARABF000000000-CARABG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARABM000000000-CARABN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARABQ000000000-CARABR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARABT000000000-CARABW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARABZ000000000-CARACA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARACC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARACE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARACI000000000-CARACJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARACM000000000-CARACR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARACT000000000-CARACV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARACX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARADH000000000-CARADM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARADO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARADW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARADZ000000000-CARAEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAEE000000000-CARAEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAEM000000000-CARAEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAES000000000-CARAEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAEW000000000-CARAEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAFD000000000-CARAFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAFJ000000000-CARAFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAFP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAFW000000000-CARAGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAGJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAGL000000000-CARAGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAGO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAGQ000000000-CARAGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAHG000000000-CARAHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAHK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAHO000000000-CARAHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAHR000000000-CARAHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAHW000000000-CARAHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAII000000000-CARAIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAIO000000000-CARAIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAIX000000000-CARAIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAJA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAJC000000000-CARAJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAJG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAJJ000000000-CARAJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAJU000000000-CARAJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAKA000000000-CARAKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAKD000000000-CARAKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAKH000000000-CARAKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAKN000000000-CARAKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAKT000000000-CARAKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAKZ000000000-CARALB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARALE000000000-CARALK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARALM000000000-CARALQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARALS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARALU000000000-CARALW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARALZ000000000-CARAMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAMC000000000-CARAMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAMJ000000000-CARAML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAMO000000000-CARAMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAMU000000000-CARAMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARANC000000000-CARAND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARANH000000000-CARANL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARANO000000000-CARANS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARANU000000000-CARANX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAOR000000000-CARAOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAOW000000000-CARAOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAPA000000000-CARAPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAPF000000000-CARAPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAPJ000000000-CARAPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAPS000000000-CARAPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAPZ000000000-CARAQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAQI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAQK000000000-CARAQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAQS000000000-CARAQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARARB000000000-CARARF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARARI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARARK000000000-CARARN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARARQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARARW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARARY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARASA000000000-CARASB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARASD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARASI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARASM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARASO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARASQ000000000-CARASR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARASV000000000-CARASX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARASZ000000000-CARATB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARATD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARATF000000000-CARATH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARATO000000000-CARATQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARATS000000000-CARATT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARATV000000000-CARATY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAUA000000000-CARAUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAUU000000000-CARAUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAVA000000000-CARAVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAVI000000000-CARAVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAVP000000000-CARAVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAVS000000000-CARAVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAVV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAWB000000000-CARAWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAWL000000000-CARAWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAWX000000000-CARAWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAXD000000000-CARAXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAXM000000000-CARAXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAYA000000000-CARAYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAYI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARAYU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARAYX000000000-CARAZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAZF000000000-CARAZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAZO000000000-CARAZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARAZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBAA000000000-CARBAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBAD000000000-CARBAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBAH000000000-CARBAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBAN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBAQ000000000-CARBAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBAY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBBB000000000-CARBBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBBJ000000000-CARBBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBBO000000000-CARBBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBBS000000000-CARBBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBBV000000000-CARBBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBCC000000000-CARBCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBCF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBCI000000000-CARBCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBCQ000000000-CARBCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBDC000000000-CARBDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBDF000000000-CARBDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBDQ000000000-CARBDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBDY000000000-CARBEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBEG000000000-CARBEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBEN000000000-CARBEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBER000000000-CARBES999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBEU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBFD000000000-CARBFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBFH000000000-CARBFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBFO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBFQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBFT000000000-CARBFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBGB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBGI000000000-CARBGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBGO000000000-CARBGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBGS000000000-CARBGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBGX000000000-CARBGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBHD000000000-CARBHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBHL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBHR000000000-CARBHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBIA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBIC000000000-CARBIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBIJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBIL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBIO000000000-CARBIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBIR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBIV000000000-CARBIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBJA000000000-CARBJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBJF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBKG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBKK000000000-CARBKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBKN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBKS000000000-CARBLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBLF000000000-CARBLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBLV000000000-CARBLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBLY000000000-CARBMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBMJ000000000-CARBMM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBMT000000000-CARBMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBNG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBNL000000000-CARBNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBNU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBNZ000000000-CARBOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBOK000000000-CARBOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBON000000000-CARBOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBOW000000000-CARBOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBOZ000000000-CARBPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBPE000000000-CARBPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBPH000000000-CARBPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBPM000000000-CARBPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBPS000000000-CARBPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBPX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBQO000000000-CARBQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBQT000000000-CARBQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBQX000000000-CARBQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBRC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBRE000000000-CARBRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBRH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBRN000000000-CARBRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBSE000000000-CARBSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBSL000000000-CARBSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBST+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBSX000000000-CARBSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBTG000000000-CARBTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBTV000000000-CARBTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBTZ000000000-CARBUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBUF000000000-CARBUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBUK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBUN000000000-CARBUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBUU000000000-CARBUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBVB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBVD000000000-CARBVF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBVH000000000-CARBVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBVN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBVP000000000-CARBVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBVX000000000-CARBVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBWA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBWC000000000-CARBWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBWI000000000-CARBWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBWO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBWQ000000000-CARBWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBWW000000000-CARBWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBXH000000000-CARBXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBXS000000000-CARBXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBXW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBXZ000000000-CARBYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYC000000000-CARBYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYF000000000-CARBYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYM000000000-CARBYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYV000000000-CARBZA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBZC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARBZI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBZK000000000-CARBZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBZV000000000-CARBZX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCAA000000000-CARCAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCAG000000000-CARCAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCAQ000000000-CARCAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCAY000000000-CARCAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCBB000000000-CARCBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCBL000000000-CARCBO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCCB000000000-CARCCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCCK000000000-CARCCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCCN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCCS000000000-CARCCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCDB000000000-CARCDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCDF000000000-CARCDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCDK000000000-CARCDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCDO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCDU000000000-CARCDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCEF000000000-CARCEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCEL000000000-CARCEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCES000000000-CARCEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCEW000000000-CARCEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCFC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCFG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCFL000000000-CARCFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCFT000000000-CARCFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCFX000000000-CARCFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCGA000000000-CARCGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCGD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCGF000000000-CARCGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCGL000000000-CARCGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCGV000000000-CARCGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCHQ000000000-CARCHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCHX000000000-CARCIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCIE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCII+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCIK000000000-CARCIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCIP000000000-CARCIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCIU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCIY000000000-CARCJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCJC000000000-CARCJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCJG000000000-CARCJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCJK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCJM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCJQ000000000-CARCJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCJU000000000-CARCJV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCKC000000000-CARCKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCKF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCKQ000000000-CARCKR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCKT000000000-CARCKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCLA000000000-CARCLF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCLI000000000-CARCLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCLP000000000-CARCLS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCLU000000000-CARCLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCMB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCMG000000000-CARCMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCMK000000000-CARCMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCMR000000000-CARCMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCMV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCMX000000000-CARCNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCNC000000000-CARCND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCNG000000000-CARCNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCNL000000000-CARCNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCNP000000000-CARCNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCNT000000000-CARCNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCNX000000000-CARCOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCOH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCOK000000000-CARCOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCON000000000-CARCOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCOR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCOV000000000-CARCOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCOZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCPB000000000-CARCPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCPN000000000-CARCPP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCPS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCPU000000000-CARCPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCPY000000000-CARCQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCQC000000000-CARCQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCQF000000000-CARCQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCQO000000000-CARCQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCQT000000000-CARCQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCRD000000000-CARCRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCRO000000000-CARCRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCRU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCRY000000000-CARCSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCSD000000000-CARCSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCSG000000000-CARCSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCSV000000000-CARCSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCSY000000000-CARCTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCTC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCTE000000000-CARCTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCTI000000000-CARCTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCTM000000000-CARCTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCTX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCTZ000000000-CARCUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCUD000000000-CARCUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCUH000000000-CARCUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCUL000000000-CARCUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCUS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCUU000000000-CARCUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCUX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCVB000000000-CARCVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCVE000000000-CARCVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCVI000000000-CARCVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCVO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCVQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCVT000000000-CARCVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCVX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCWC000000000-CARCWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCWF000000000-CARCWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCWN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCWP000000000-CARCWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCWV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCWY000000000-CARCWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCXC000000000-CARCXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCXI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCXO000000000-CARCXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCXT000000000-CARCXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCXZ000000000-CARCYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCYC000000000-CARCYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCYN000000000-CARCYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCYV000000000-CARCYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCYY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCZA000000000-CARCZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCZD000000000-CARCZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCZG000000000-CARCZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCZK000000000-CARCZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARCZP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARCZX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARCZZ000000000-CARDAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDAC000000000-CARDAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDAI000000000-CARDAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDAM000000000-CARDAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDAT000000000-CARDAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDAZ000000000-CARDBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDBC000000000-CARDBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDBH000000000-CARDBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDBW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDCC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDCE000000000-CARDCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDCJ000000000-CARDCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDCP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDCS000000000-CARDCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDCX000000000-CARDDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDDF000000000-CARDDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDDN000000000-CARDDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDDR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDDW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDDZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDED000000000-CARDEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDEI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDEK000000000-CARDEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDEO000000000-CARDEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDEU000000000-CARDEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDEX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDFC000000000-CARDFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDFI000000000-CARDFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDFN000000000-CARDFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDFT000000000-CARDFW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDFZ000000000-CARDGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDGD000000000-CARDGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDGI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDGO000000000-CARDGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDGV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDHF000000000-CARDHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDHN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDHP000000000-CARDHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDHS000000000-CARDHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDHW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDHZ000000000-CARDIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDID000000000-CARDIF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDII000000000-CARDIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDIL000000000-CARDIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDIO000000000-CARDIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDJA000000000-CARDJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDJG000000000-CARDJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDJK000000000-CARDJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDJR000000000-CARDJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDKA000000000-CARDKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDKF000000000-CARDKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDKL000000000-CARDKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDKO000000000-CARDKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDKZ000000000-CARDLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDLC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDLG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDLI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDLK000000000-CARDLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDLP000000000-CARDLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDLW000000000-CARDMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDMF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDMH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDMM000000000-CARDMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDMQ000000000-CARDMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDMY000000000-CARDNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDND+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDNH000000000-CARDNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDNM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDNO000000000-CARDNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDNU000000000-CARDNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDOC000000000-CARDOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDOH000000000-CARDOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDOK000000000-CARDOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDOP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDOW000000000-CARDPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDPD000000000-CARDPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDPI000000000-CARDPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDPO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDPQ000000000-CARDPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDPV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDQA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDQF000000000-CARDQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDQK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDQO000000000-CARDQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDRD000000000-CARDRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDRJ000000000-CARDRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDRV000000000-CARDRX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDSB000000000-CARDSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDSH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDSM000000000-CARDSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDSP000000000-CARDSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDSS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDSV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDSY000000000-CARDSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDTB000000000-CARDTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDTI000000000-CARDTJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDTL000000000-CARDTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDTW000000000-CARDUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDUD000000000-CARDUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDUJ000000000-CARDUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDUR000000000-CARDUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDUW000000000-CARDUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDVF000000000-CARDVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDVL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDVO000000000-CARDVP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDVT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDVV000000000-CARDVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDWC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDWE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDWG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDWL000000000-CARDWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDWS000000000-CARDWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDWV000000000-CARDWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDXA000000000-CARDXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDXF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDXU000000000-CARDXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDYD000000000-CARDYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDYQ000000000-CARDYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARDYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARDZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARDZP000000000-CARDZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDZV000000000-CARDZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREAD000000000-CAREAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREAH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREAK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREAP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREAU000000000-CAREAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREBF000000000-CAREBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREBN000000000-CAREBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREBW000000000-CAREBY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARECC000000000-CARECE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARECG000000000-CARECN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARECR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARECT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARECV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARECX000000000-CARECY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREDB000000000-CAREDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREDE000000000-CAREDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREDL000000000-CAREDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREDU000000000-CAREDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREDZ000000000-CAREED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREEI000000000-CAREEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREEL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREEN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREEP000000000-CAREEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREES+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREEV000000000-CAREEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREEZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREFD000000000-CAREFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREFI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREFK000000000-CAREFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREFN000000000-CAREFO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREFQ000000000-CAREFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREFY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREGC000000000-CAREGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREGF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREGH000000000-CAREGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREGK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREGQ000000000-CAREGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREGW000000000-CAREGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREGZ000000000-CAREHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREHK000000000-CAREHL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREHN000000000-CAREHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREHR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREHT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREHX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREIC000000000-CAREID999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREIL000000000-CAREIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREIQ000000000-CAREIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREIV000000000-CAREJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREJD000000000-CAREJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREJG000000000-CAREJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREJL000000000-CAREJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREJO000000000-CAREJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREJY000000000-CAREKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREKD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREKI000000000-CAREKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREKO000000000-CAREKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREKS000000000-CAREKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREKY000000000-CAREKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELF000000000-CARELG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELJ000000000-CARELK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELM000000000-CARELO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELR000000000-CARELS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELW000000000-CAREMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREMF000000000-CAREMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREMK000000000-CAREMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREMS000000000-CAREMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARENC000000000-CARENE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARENI000000000-CARENK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARENN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARENQ000000000-CARENR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARENT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARENW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARENY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREOA000000000-CAREOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREOJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREOL000000000-CAREOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREOR000000000-CAREOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREOY000000000-CAREOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREPB000000000-CAREPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREPG000000000-CAREPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREPR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREPV000000000-CAREPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREQA000000000-CAREQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREQF000000000-CAREQH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREQL000000000-CAREQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREQR000000000-CAREQS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARERB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARERD000000000-CARERE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARERG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARERJ000000000-CARERM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARERP000000000-CARERS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARERV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARERZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARESB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARESJ000000000-CARESK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARESO000000000-CARESQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREST000000000-CARESV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARESX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARETA000000000-CARETD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARETG000000000-CARETH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARETJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARETL000000000-CARETM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARETO000000000-CARETR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARETU000000000-CARETY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREUA000000000-CAREUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREUD000000000-CAREUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREUO000000000-CAREUR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREUU000000000-CAREUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREUZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREVF000000000-CAREVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREVI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREVL000000000-CAREVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREVP000000000-CAREVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREVZ000000000-CAREWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREWG000000000-CAREWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREWK000000000-CAREWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREWP000000000-CAREWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREWT000000000-CAREWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREWW000000000-CAREWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREWZ000000000-CAREXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREXE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREXG000000000-CAREXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREXX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREYF000000000-CAREYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREYL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREYR000000000-CAREYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAREYX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREZB000000000-CAREZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREZG000000000-CAREZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREZK000000000-CAREZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREZR000000000-CAREZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAREZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAREZW000000000-CAREZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFAC000000000-CARFAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFAI000000000-CARFAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFAM000000000-CARFAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFAR000000000-CARFAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFAX000000000-CARFAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFBA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFBD000000000-CARFBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFBL000000000-CARFBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFBP000000000-CARFBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFBS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFBU000000000-CARFCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFCD000000000-CARFCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFCO000000000-CARFCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFCW000000000-CARFCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFDB000000000-CARFDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFDJ000000000-CARFDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFDO000000000-CARFDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFDV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFDX000000000-CARFDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEA000000000-CARFEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEE000000000-CARFEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEM000000000-CARFEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFER000000000-CARFES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEV000000000-CARFEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFEZ000000000-CARFFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFFD000000000-CARFFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFFI000000000-CARFFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFFN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFFU000000000-CARFFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFFZ000000000-CARFGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFGF000000000-CARFGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFGP000000000-CARFGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFGT000000000-CARFGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFGW000000000-CARFGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFHB000000000-CARFHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFHE000000000-CARFHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFHL000000000-CARFHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFHQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFHT000000000-CARFHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFHZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFIB000000000-CARFIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFII000000000-CARFIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFIO000000000-CARFIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFIT000000000-CARFIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFIW000000000-CARFIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFIZ000000000-CARFJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFJH000000000-CARFJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFJK000000000-CARFJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFJO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFJR000000000-CARFJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFJX000000000-CARFKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFKE000000000-CARFKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFKJ000000000-CARFKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFKS000000000-CARFKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFKY000000000-CARFLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFLD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFLH000000000-CARFLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFLK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFLM000000000-CARFLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFLQ000000000-CARFLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFLU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFLX000000000-CARFLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFMA000000000-CARFMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFME000000000-CARFMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFMJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFMO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFMS000000000-CARFMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFMZ000000000-CARFND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFNF000000000-CARFNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFNK000000000-CARFNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFNQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFNS000000000-CARFNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFNW000000000-CARFNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFOA000000000-CARFOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFOI000000000-CARFOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFOQ000000000-CARFOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFOW000000000-CARFOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFOZ000000000-CARFPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFPC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFPF000000000-CARFPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFPM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFPT000000000-CARFPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFPY000000000-CARFQC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFQE000000000-CARFQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFQI000000000-CARFQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFQL000000000-CARFQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFQP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFQR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFQT000000000-CARFQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFRA000000000-CARFRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFRF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFRH000000000-CARFRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFRP000000000-CARFRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFRS000000000-CARFRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFRX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFRZ000000000-CARFSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFSD000000000-CARFSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFSG000000000-CARFSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFSN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFSQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFSS000000000-CARFST999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFSV000000000-CARFSZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFTB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFTE000000000-CARFTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFTS000000000-CARFTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFTV000000000-CARFUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFUC000000000-CARFUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFUF000000000-CARFUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFUK000000000-CARFUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFUQ000000000-CARFUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFUU000000000-CARFUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFVB000000000-CARFVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFVE000000000-CARFVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFVL000000000-CARFVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFVP000000000-CARFVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFVW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFVY000000000-CARFVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFWD000000000-CARFWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFWH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFWJ000000000-CARFWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFWP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFWR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFWT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFWV000000000-CARFWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFXB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFXF000000000-CARFXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFXL000000000-CARFXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFXV000000000-CARFXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFXZ000000000-CARFYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFYJ000000000-CARFYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFYP000000000-CARFYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFYV000000000-CARFYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFZB000000000-CARFZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFZG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFZI000000000-CARFZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARFZS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARFZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARFZW000000000-CARGAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGAG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGAI000000000-CARGAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGAL000000000-CARGAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGAP000000000-CARGAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGAV000000000-CARGAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGBA000000000-CARGBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGBD000000000-CARGBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGBP000000000-CARGBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGBV000000000-CARGBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGCA000000000-CARGCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGCJ000000000-CARGCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGCM000000000-CARGCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGCP000000000-CARGCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGDB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARGDD000000000-CARGDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARGDJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARGDN+9 embl_tpa_wgs_nuc",
    ": 000000000-9